/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterTrigger;
import de.independit.scheduler.server.parser.ManipTrigger;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import java.util.Vector;

public class CreateTrigger
extends ManipTrigger {
    public static final String __version = "@(#) $Id: CreateTrigger.java,v 2.30.2.2 2013/03/15 15:00:56 ronald Exp $";
    protected String name;
    protected WithItem objType;
    protected WithHash with;
    protected Integer objectType;
    protected Vector objpath;
    protected Vector resourcepath;
    protected boolean replace;
    protected Long fireId = null;
    protected SDMSSchedulingEntity triggerJob;
    protected int oType;

    public CreateTrigger(String string, WithItem withItem, WithHash withHash, Boolean bl) {
        this.name = string;
        this.objType = withItem;
        this.with = withHash;
        this.replace = bl;
    }

    private void checkJobWith(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable<Long> comparable;
        Object object;
        this.oType = 0;
        this.objpath = (Vector)this.objType.value;
        this.objectType = this.oType;
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, this.objpath, null);
        this.fireId = sDMSSchedulingEntity.getId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity2 = null;
        SDMSSchedulingEntity sDMSSchedulingEntity3 = null;
        this.active = this.with.containsKey("ACTIVE") ? (Boolean)this.with.get("ACTIVE") : Boolean.TRUE;
        this.mainSeId = null;
        this.parentSeId = null;
        if (this.with.containsKey("MAIN") && this.with.get("MAIN") != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109081515", "Main Scheduling Entity option is only valid for Object Monitor Triggers"));
        }
        if (this.with.containsKey("PARENT") && this.with.get("PARENT") != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109081536", "Parent Scheduling Entity option is only valid for Object Monitor Triggers"));
        }
        if (this.with.containsKey("RERUN")) {
            if (this.with.containsKey("SUBMIT")) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108190857", "Submit and Rerun cannot be specified both"));
            }
            this.action = SDMSConstants.TR_RERUN;
            this.iaction = 1;
        } else {
            this.action = SDMSConstants.TR_SUBMIT;
            this.iaction = 0;
        }
        this.folderpath = (Vector)this.with.get("SUBMIT");
        if (this.folderpath != null && this.iaction == 0) {
            this.triggerJob = SDMSSchedulingEntityTable.get(systemEnvironment, this.folderpath, null);
            this.seId = this.triggerJob.getId(systemEnvironment);
            this.action = SDMSConstants.TR_SUBMIT;
            this.iaction = 0;
        } else if (this.folderpath == null && this.iaction == 1) {
            this.seId = this.fireId;
            this.triggerJob = sDMSSchedulingEntity;
        } else {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206210034", "Either Submit or Rerun is mandatory"));
        }
        this.isInverse = (Boolean)this.with.get("INVERSE");
        if (this.isInverse == null) {
            this.isInverse = Boolean.FALSE;
        }
        if (this.isInverse.booleanValue()) {
            object = sDMSSchedulingEntity;
            sDMSSchedulingEntity = this.triggerJob;
            this.triggerJob = object;
            comparable = this.fireId;
            this.fireId = this.seId;
            this.seId = comparable;
        }
        if (this.with.containsKey("MAIN") && (object = (Vector)this.with.get("MAIN")) != null) {
            sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.get(systemEnvironment, (Vector)object, null);
        }
        if (this.with.containsKey("PARENT") && (object = (Vector)this.with.get("PARENT")) != null) {
            sDMSSchedulingEntity3 = SDMSSchedulingEntityTable.get(systemEnvironment, (Vector)object, null);
        }
        if (this.iaction == 1 && sDMSSchedulingEntity.getType(systemEnvironment) != 1) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108111239", "Rerun triggers are valid for jobs only"));
        }
        this.isMaster = (Boolean)this.with.get("MASTER");
        if (this.isMaster == null) {
            this.isMaster = Boolean.FALSE;
        }
        this.triggertype = (Integer)this.with.get("TRIGGERTYPE");
        if (this.triggertype != null) {
            int n = this.triggertype;
            if (sDMSSchedulingEntity.getType(systemEnvironment) == 3 && n != 3 && !this.isMaster.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209201514", "Triggertype must be after final for non-master triggers on milestones"));
            }
            if (!(n != 5 && n != 6 || this.with.containsKey("CHECK"))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03407281037", "Asynchroneous triggers must define a check interval"));
            }
            if (this.action == 1 && n != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108091435", "Triggertype must be immediate local in case of rerun triggers"));
            }
        } else if (this.action == 1) {
            this.triggertype = SDMSConstants.TR_IMMEDIATE_LOCAL;
        } else {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206211424", "Triggertype must be specified"));
        }
        if (this.isMaster.booleanValue()) {
            if (this.iaction == 1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108091437", "Master option not valid for rerun triggers"));
            }
            if (sDMSSchedulingEntity2 == null && !this.triggerJob.getMasterSubmittable(systemEnvironment).booleanValue() || sDMSSchedulingEntity2 != null && !sDMSSchedulingEntity2.getMasterSubmittable(systemEnvironment).booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03301280208", "Master trigger defined for non master submittable job"));
            }
            if (!this.with.containsKey("GROUP")) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402180658", "Group clause is mandatory for master triggers"));
            }
            String string = (String)this.with.get("GROUP");
            comparable = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string), SDMSConstants.lZERO)).getId(systemEnvironment);
            if (sDMSSchedulingEntity2 != null) {
                sDMSSchedulingEntity2.checkSubmitForGroup(systemEnvironment, (Long)comparable);
            } else {
                this.triggerJob.checkSubmitForGroup(systemEnvironment, (Long)comparable);
            }
        } else if (this.with.containsKey("GROUP")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402180929", "Group clause is not allowed for child or rerun triggers"));
        }
        this.isSuspend = (Boolean)this.with.get("SUSPEND");
        if (this.isSuspend == null) {
            this.isSuspend = Boolean.FALSE;
        }
        if (this.isInverse.booleanValue()) {
            if (!this.isMaster.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03506231011", "Master option mandatory in case of inverse Triggers"));
            }
            if (this.iaction == 1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03506231304", "Inverse option invalid in case of rerun Triggers"));
            }
        }
        this.resumeObj = this.with.get("RESUME");
        if (!this.isSuspend.booleanValue() && this.resumeObj != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108091752", "Resume clause without suspend clause doesn't make sense"));
        }
        this.analyzeResumeObj(systemEnvironment);
        this.isWarnOnLimit = (Boolean)this.with.get("WARN");
        if (this.isWarnOnLimit == null) {
            this.isWarnOnLimit = Boolean.FALSE;
        }
        this.limitState = null;
        String string = (String)this.with.get("LIMIT");
        if (string != null) {
            try {
                comparable = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, string);
                this.limitState = ((SDMSProxy)comparable).getId(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03509181230", "Specified exit state " + string + " not found"));
            }
            comparable = sDMSSchedulingEntity.getEspId(systemEnvironment);
            try {
                SDMSExitState sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(comparable, this.limitState));
            }
            catch (NotFoundException notFoundException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03310101437", "Specified exit state " + string + " not found in exit state profile"));
            }
        }
        this.maxRetry = (Integer)this.with.get("SUBMITCOUNT");
        if (this.maxRetry == null) {
            this.maxRetry = SDMSConstants.iONE;
        }
        this.rscstate = null;
        this.state = (Vector)this.with.get("STATUS");
        if (this.with.containsKey("RSCSTATUS")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206210046", "Only job states are allowed for job triggers"));
        }
        this.condition = this.with.containsKey("CONDITION") ? (String)this.with.get("CONDITION") : null;
        if (this.with.containsKey("CHECK")) {
            this.check = (WithHash)this.with.get("CHECK");
            if (this.condition == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03407271556", "Asynchroneous triggers are only valid in combination with a condition"));
            }
            if (this.triggertype != 5 && this.triggertype != 6) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03407271557", "Check periods are only valid for asynchroneous triggers"));
            }
            this.checkAmount = (Integer)this.check.get("MULT");
            this.checkBase = (Integer)this.check.get("INTERVAL");
        } else {
            this.checkAmount = null;
            this.checkBase = null;
        }
    }

    private void checkResourceCommonWith(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource) throws SDMSException {
        if (sDMSNamedResource.getUsage(systemEnvironment) != 4) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206250058", "Trigger can only be defined for synchronizing resources"));
        }
        this.objectType = this.oType;
        this.active = this.with.containsKey("ACTIVE") ? (Boolean)this.with.get("ACTIVE") : Boolean.TRUE;
        this.mainSeId = null;
        this.parentSeId = null;
        if (this.with.containsKey("MAIN") && this.with.get("MAIN") != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109081537", "Main Scheduling Entity option is only valid for Object Monitor Triggers"));
        }
        if (this.with.containsKey("PARENT") && this.with.get("PARENT") != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109081538", "Parent Scheduling Entity option is only valid for Object Monitor Triggers"));
        }
        this.action = SDMSConstants.TR_SUBMIT;
        this.iaction = 0;
        this.folderpath = (Vector)this.with.get("SUBMIT");
        if (this.folderpath == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206210035", "Submit is mandatory"));
        }
        this.triggerJob = SDMSSchedulingEntityTable.get(systemEnvironment, this.folderpath, null);
        this.seId = this.triggerJob.getId(systemEnvironment);
        this.triggertype = (Integer)this.with.get("TRIGGERTYPE");
        if (this.triggertype != null) {
            if (this.triggertype != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206210043", "Triggertype must be Immediate local for resource triggers"));
            }
        } else {
            this.triggertype = SDMSConstants.TR_IMMEDIATE_LOCAL;
        }
        this.isMaster = (Boolean)this.with.get("MASTER");
        if (this.isMaster != null) {
            if (!this.isMaster.booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206210044", "Only master submits allowed for resource triggers"));
            }
        } else {
            this.isMaster = Boolean.TRUE;
        }
        if (!this.triggerJob.getMasterSubmittable(systemEnvironment).booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03104261631", "Master trigger defined for non master submittable job"));
        }
        if (!this.with.containsKey("GROUP")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03602082122", "Group clause is mandatory for resource triggers"));
        }
        this.isSuspend = (Boolean)this.with.get("SUSPEND");
        if (this.isSuspend == null) {
            this.isSuspend = Boolean.FALSE;
        }
        this.resumeObj = this.with.get("RESUME");
        if (!this.isSuspend.booleanValue() && this.resumeObj != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108091753", "Resume clause without suspend clause doesn't make sense"));
        }
        this.analyzeResumeObj(systemEnvironment);
        this.maxRetry = (Integer)this.with.get("SUBMITCOUNT");
        if (this.maxRetry != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206210045", "Retry Count not allowed for resource triggers"));
        }
        this.maxRetry = SDMSConstants.iZERO;
        this.isWarnOnLimit = Boolean.FALSE;
        this.state = null;
        this.rscstate = (Vector)this.with.get("RSCSTATUS");
        if (this.with.containsKey("STATUS") && this.with.get("STATUS") != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206210047", "Only resource states are allowed for resource triggers"));
        }
        this.condition = this.with.containsKey("CONDITION") ? (String)this.with.get("CONDITION") : null;
        if (this.with.containsKey("CHECK")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03407271555", "Asynchroneous triggers are only valid for jobs"));
        }
        this.check = null;
        this.isInverse = (Boolean)this.with.get("INVERSE");
        if (this.isInverse != null && this.isInverse.booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "036231306", "Inverse option is invalid for resource triggers"));
        }
    }

    private void checkResourceWith(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        this.oType = 1;
        this.objpath = (Vector)this.objType.value;
        this.resourcepath = (Vector)this.objpath.remove(this.objpath.size() - 1);
        try {
            l = SDMSScopeTable.pathToId(systemEnvironment, this.objpath);
        }
        catch (NotFoundException notFoundException) {
            try {
                l = SDMSFolderTable.pathToId(systemEnvironment, this.objpath);
            }
            catch (NotFoundException notFoundException2) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03205061329", "Triggers for job resources aren't supported"));
            }
        }
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.resourcepath);
        Long l2 = sDMSNamedResource.getId(systemEnvironment);
        this.fireId = SDMSResourceTable.idx_nrId_scopeId_getUnique(systemEnvironment, new SDMSKey(l2, l)).getId(systemEnvironment);
        this.checkResourceCommonWith(systemEnvironment, sDMSNamedResource);
    }

    private void checkNamedResourceWith(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        this.oType = 2;
        this.resourcepath = this.objpath = (Vector)this.objType.value;
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.resourcepath);
        this.fireId = l = sDMSNamedResource.getId(systemEnvironment);
        this.checkResourceCommonWith(systemEnvironment, sDMSNamedResource);
    }

    private void checkWith(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.objType.key.equals("JOB")) {
            this.checkJobWith(systemEnvironment);
        } else if (this.objType.key.equals("OBJECT")) {
            systemEnvironment.checkFeatureAvailability("OBJECTMONITOR_TRIGGER");
        } else {
            systemEnvironment.checkFeatureAvailability("RESOURCE_TRIGGER");
            if (this.objType.key.equals("RESOURCE")) {
                this.checkResourceWith(systemEnvironment);
            } else {
                this.checkNamedResourceWith(systemEnvironment);
            }
        }
        if (this.triggertype != null) {
            int n = this.triggertype;
            if (n == 5 || n == 6) {
                systemEnvironment.checkFeatureAvailability("ASYNC_TRIGGERS");
            }
            if (n != 2 && n != 0 && n != 1) {
                systemEnvironment.checkFeatureAvailability("EXTENDED_TRIGGERS");
            }
        }
        if (this.condition != null && !this.condition.equals("")) {
            systemEnvironment.checkFeatureAvailability("EXTENDED_TRIGGERS");
        }
    }

    private void checkAndCreateParameters(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        WithHash withHash = (WithHash)this.with.get("PARAMETERS");
        if (withHash == null) {
            return;
        }
        for (String string : withHash.keySet()) {
            String string2 = (String)withHash.get(string);
            string2 = sDMSTrigger.checkParameterExpressionSyntax(systemEnvironment, string2);
            try {
                SDMSTriggerParameterTable.table.create(systemEnvironment, string, string2, sDMSTrigger.getId(systemEnvironment));
            }
            catch (DuplicateKeyException duplicateKeyException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03801311320", "Ambiguous parameter definition for parameter $1", string));
            }
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSTrigger sDMSTrigger;
        Object object;
        this.checkWith(systemEnvironment);
        Long l = null;
        if (this.isMaster.booleanValue() && (object = (String)this.with.get("GROUP")) != null) {
            l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, SDMSConstants.lZERO)).getId(systemEnvironment);
        }
        if (this.replace) {
            int n;
            object = this.isInverse != false ? SDMSTriggerTable.idx_seId_name.getVector(systemEnvironment, new SDMSKey(this.fireId, (Comparable)((Object)this.name))) : SDMSTriggerTable.idx_fireId_name.getVector(systemEnvironment, new SDMSKey(this.fireId, (Comparable)((Object)this.name)));
            for (n = 0; n < ((Vector)object).size() && !(sDMSTrigger = (SDMSTrigger)((Vector)object).get(n)).getIsInverse(systemEnvironment).equals(this.isInverse); ++n) {
            }
            if (n < ((Vector)object).size()) {
                Long l2 = this.fireId;
                if (((Boolean)this.with.get("INVERSE")).booleanValue()) {
                    l2 = this.seId;
                }
                AlterTrigger alterTrigger = new AlterTrigger(this.name, l2, this.objectType, this.with, Boolean.FALSE);
                alterTrigger.setEnv(this.env);
                alterTrigger.go(systemEnvironment);
                this.result = alterTrigger.result;
                return;
            }
        }
        if (!this.triggerJob.checkPrivileges(systemEnvironment, 0x100000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131550", "Submit privilege on $1 missing", this.triggerJob.pathString(systemEnvironment)));
        }
        sDMSTrigger = SDMSTriggerTable.table.create(systemEnvironment, this.name, this.fireId, this.objectType, this.seId, this.mainSeId, this.parentSeId, this.active, this.isInverse, this.action, this.triggertype, this.isMaster, this.isSuspend, this.isCreate, this.isChange, this.isDelete, this.isGroup, this.resumeAt, this.resumeIn, this.resumeBase, this.isWarnOnLimit, this.limitState, this.maxRetry, l, this.condition, this.checkAmount, this.checkBase);
        this.checkUniqueness(systemEnvironment, this.name, this.fireId, this.seId, this.isInverse);
        sDMSTrigger.checkConditionSyntax(systemEnvironment);
        if (this.with.containsKey("PARAMETERS")) {
            this.checkAndCreateParameters(systemEnvironment, sDMSTrigger);
        }
        Long l3 = sDMSTrigger.getId(systemEnvironment);
        if (sDMSTrigger.getObjectType(systemEnvironment) == 0) {
            if (this.state != null) {
                for (int i = 0; i < this.state.size(); ++i) {
                    String string = (String)this.state.get(i);
                    Long l4 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment);
                    SDMSTriggerStateTable.table.create(systemEnvironment, l3, null, l4);
                }
            }
            if (this.triggertype != 3 && this.iaction != 1) {
                SDMSSchedulingHierarchyTable.checkHierarchyCycles(systemEnvironment, this.fireId);
            }
        } else if (sDMSTrigger.getObjectType(systemEnvironment) != 3 && this.rscstate != null) {
            for (int i = 0; i < this.rscstate.size(); ++i) {
                WithItem withItem = (WithItem)this.rscstate.get(i);
                Long l5 = withItem.key != null ? SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, withItem.key).getId(systemEnvironment) : null;
                Long l6 = withItem.value != null ? SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, withItem.value).getId(systemEnvironment) : null;
                SDMSTriggerStateTable.table.create(systemEnvironment, l3, l5, l6);
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03206191306", "Trigger created"));
    }
}

