/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;

public class DropComment
extends Node {
    public static final String __version = "@(#) $Id: DropComment.java,v 2.2.14.1 2013/03/14 10:24:28 ronald Exp $";
    private int type;
    private ObjectURL obj;
    private boolean noerr;

    public DropComment(ObjectURL objectURL, Boolean bl) {
        this.obj = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Object var2_2 = null;
        this.obj.resolve(systemEnvironment);
        if (0 == SDMSObjectCommentTable.dropComment(systemEnvironment, this.obj.objId)) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130113", "No Comment dropped"));
                return;
            }
            throw new NotFoundException(new SDMSMessage(systemEnvironment, "03510121546", "No comment found for object $1", this.obj.toString()));
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03209240935", "Comment dropped"));
    }
}

