/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import java.util.HashSet;
import java.util.Vector;

public class DropFolder
extends Node {
    public static final String __version = "@(#) $Id: DropFolder.java,v 2.7.14.1 2013/03/14 10:24:29 ronald Exp $";
    private ObjectURL url;
    private Vector urlVector;
    private boolean cascade;
    private boolean force;
    private boolean noerr;

    public DropFolder(Vector vector, Boolean bl, Boolean bl2, Boolean bl3) {
        this.urlVector = vector;
        this.cascade = bl;
        this.force = bl2;
        this.noerr = bl3;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        Long l;
        SDMSFolder sDMSFolder;
        int n;
        HashSet<Long> hashSet = new HashSet<Long>();
        for (n = 0; n < this.urlVector.size(); ++n) {
            this.url = (ObjectURL)this.urlVector.get(n);
            if (this.url.objType.equals(6)) {
                if (!this.cascade && !this.force) continue;
                try {
                    sDMSFolder = (SDMSFolder)this.url.resolve(systemEnvironment);
                    l = sDMSFolder.getParentId(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    if (this.noerr) continue;
                    throw notFoundException;
                }
                if (l == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03704102211", "Folder SYSTEM cannot be dropped"));
                }
                sDMSFolder.collectSeIds(systemEnvironment, hashSet, null);
                continue;
            }
            try {
                comparable = (SDMSSchedulingEntity)this.url.resolve(systemEnvironment);
                hashSet.add(comparable.getId(systemEnvironment));
                continue;
            }
            catch (NotFoundException notFoundException) {
                if (this.noerr) continue;
                throw notFoundException;
            }
        }
        SDMSSchedulingEntity.delete(systemEnvironment, hashSet, this.force);
        for (n = 0; n < this.urlVector.size(); ++n) {
            this.url = (ObjectURL)this.urlVector.get(n);
            if (!this.url.objType.equals(6)) continue;
            try {
                sDMSFolder = (SDMSFolder)this.url.resolve(systemEnvironment);
                l = sDMSFolder.getParentId(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                if (this.noerr) continue;
                throw notFoundException;
            }
            comparable = sDMSFolder.getId(systemEnvironment);
            if (this.cascade || this.force) {
                sDMSFolder.deleteCascade(systemEnvironment, null);
                continue;
            }
            sDMSFolder.delete(systemEnvironment);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112230", "Folder(s) dropped"));
    }
}

