/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcher;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherTable;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import java.util.Vector;

public class DropInterval
extends Node {
    public static final String __version = "@(#) $Id: DropInterval.java,v 2.3.4.1 2013/03/14 10:24:30 ronald Exp $";
    private final ObjectURL obj;
    private final boolean noerr;

    public DropInterval(ObjectURL objectURL, Boolean bl) {
        this.obj = objectURL;
        this.noerr = bl;
    }

    private String getReferringNames(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        boolean bl;
        int n = 5;
        boolean bl2 = bl = n < vector.size();
        if (vector.size() < n) {
            n = vector.size();
        }
        Object object = " ";
        String string = "";
        for (int i = 0; i < n; ++i) {
            Object e = vector.get(i);
            if (e instanceof SDMSInterval) {
                var9_9 = (SDMSInterval)e;
                var10_10 = ((SDMSIntervalProxyGeneric)var9_9).getSeId(systemEnvironment);
                var11_11 = "";
                if (var10_10 != null && var10_10 != 0L) {
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, var10_10);
                    var11_11 = " of " + sDMSSchedulingEntity.pathString(systemEnvironment);
                }
                object = (String)object + string + ((SDMSIntervalProxyGeneric)var9_9).getName(systemEnvironment) + "(" + var9_9.getId(systemEnvironment) + ")" + (String)var11_11;
            } else if (e instanceof SDMSSchedule) {
                var9_9 = (SDMSSchedule)e;
                object = (String)object + string + ((SDMSScheduleProxyGeneric)var9_9).getName(systemEnvironment) + "(" + var9_9.getId(systemEnvironment) + ")";
            } else if (e instanceof SDMSSchedulingHierarchy) {
                var9_9 = (SDMSSchedulingHierarchy)e;
                var10_10 = ((SDMSSchedulingHierarchyProxyGeneric)var9_9).getSeParentId(systemEnvironment);
                if (var10_10 != null) {
                    var11_11 = SDMSSchedulingEntityTable.getObject(systemEnvironment, var10_10);
                    object = (String)object + string + ((SDMSSchedulingEntity)var11_11).pathString(systemEnvironment);
                }
            } else if (e instanceof SDMSIntervalDispatcher) {
                var9_9 = (SDMSIntervalDispatcher)e;
                object = (String)object + string + ((SDMSIntervalDispatcherProxyGeneric)var9_9).getName(systemEnvironment) + "(" + var9_9.getId(systemEnvironment) + ")";
            }
            string = ",";
        }
        if (bl) {
            object = (String)object + " and others";
        }
        return object;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        block11: {
            try {
                Vector vector;
                SDMSInterval sDMSInterval = (SDMSInterval)this.obj.resolve(systemEnvironment);
                Long l = this.obj.objId;
                if (SDMSIntervalTable.idx_embeddedIntervalId.containsKey(systemEnvironment, l)) {
                    Vector vector2 = SDMSIntervalTable.idx_embeddedIntervalId.getVector(systemEnvironment, l);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04209111937", "Interval in use by Interval(s)" + this.getReferringNames(systemEnvironment, vector2)));
                }
                if (SDMSScheduleTable.idx_intId.containsKey(systemEnvironment, l)) {
                    Vector vector3 = SDMSScheduleTable.idx_intId.getVector(systemEnvironment, l);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207191907", "Interval in use by Schedule(s)" + this.getReferringNames(systemEnvironment, vector3)));
                }
                if (SDMSIntervalHierarchyTable.idx_childId.containsKey(systemEnvironment, l)) {
                    vector = SDMSIntervalHierarchyTable.idx_childId.getVector(systemEnvironment, l);
                    for (int i = 0; i < vector.size(); ++i) {
                        SDMSIntervalHierarchy sDMSIntervalHierarchy = (SDMSIntervalHierarchy)vector.get(i);
                        Long l2 = sDMSIntervalHierarchy.getParentId(systemEnvironment);
                        try {
                            SDMSInterval sDMSInterval2 = SDMSIntervalTable.getObject(systemEnvironment, l2);
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04209112049", "Interval in use by Interval " + sDMSInterval2.getName(systemEnvironment)));
                        }
                        catch (NotFoundException notFoundException) {
                            sDMSIntervalHierarchy.delete(systemEnvironment);
                            continue;
                        }
                    }
                }
                if (SDMSSchedulingHierarchyTable.idx_intId.containsKey(systemEnvironment, l)) {
                    vector = SDMSSchedulingHierarchyTable.idx_intId.getVector(systemEnvironment, l);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04811061006", "Interval in use by SchedulingHierarchy(s)" + this.getReferringNames(systemEnvironment, vector)));
                }
                if (SDMSIntervalDispatcherTable.idx_selectIntId.containsKey(systemEnvironment, l)) {
                    vector = SDMSIntervalDispatcherTable.idx_selectIntId.getVector(systemEnvironment, l);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910070933", "Interval in use as select interval by Dispatcher(s)" + this.getReferringNames(systemEnvironment, vector)));
                }
                if (SDMSIntervalDispatcherTable.idx_filterIntId.containsKey(systemEnvironment, l)) {
                    vector = SDMSIntervalDispatcherTable.idx_filterIntId.getVector(systemEnvironment, l);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910070934", "Interval in use as filter by Dispatcher(s)" + this.getReferringNames(systemEnvironment, vector)));
                }
                IntervalUtil.killFilter(systemEnvironment, l);
                IntervalUtil.killEmbedded(systemEnvironment, l);
                IntervalUtil.killSelections(systemEnvironment, l);
                IntervalUtil.killDispatcher(systemEnvironment, l);
                sDMSInterval.delete(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                if (this.noerr) break block11;
                throw notFoundException;
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207181908", "Interval dropped"));
    }
}

