/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceState;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import java.util.Vector;

public class DropRsp
extends Node {
    public static final String __version = "@(#) $Id: DropRsp.java,v 2.1.14.1 2013/03/14 10:24:31 ronald Exp $";
    private String name;
    private boolean noerr;

    public DropRsp(String string, Boolean bl) {
        this.name = string;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSResourceStateProfile sDMSResourceStateProfile;
        try {
            sDMSResourceStateProfile = SDMSResourceStateProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122338", "No Resource State Profile dropped"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSResourceStateProfile.getId(systemEnvironment);
        Vector vector = SDMSNamedResourceTable.idx_rspId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201212212", "Resource State Profile is profile for Named Resource $1", ((SDMSNamedResource)vector.elementAt(0)).getName(systemEnvironment)));
        }
        vector = SDMSResourceStateTable.idx_rspId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceState sDMSResourceState = (SDMSResourceState)vector.get(i);
            sDMSResourceState.delete(systemEnvironment);
        }
        sDMSResourceStateProfile.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201230009", "Resource State Profile dropped"));
    }
}

