/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.CreateInterval;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcher;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherTable;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalSelection;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.util.DateTime;
import de.independit.scheduler.server.util.PathVector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Pattern;

public class IntervalUtil {
    public static final String __version = "@(#) $Id: IntervalUtil.java,v 2.4.2.1 2013/03/14 10:24:34 ronald Exp $";
    public static final int IGNORED_NOTHING = 0;
    public static final int IGNORED_UPPER_RANGE = 1;
    public static final int IGNORED_SECONDS = 2;
    private static final Pattern ID_NAME = Pattern.compile("^S\\d+_.+$");
    private static final Pattern ID_QUOTED_NAME = Pattern.compile("^'S\\d+_.+'$");
    private static final Pattern ID_PATH = Pattern.compile("^S\\d+$");
    private static final Pattern ID_REPLACE = Pattern.compile("\\d+");
    private static final Integer ivalType = SDMSConstants.IV_INTERVAL;
    private static final Integer dispType = SDMSConstants.IV_INTERVAL_DISPATCHER;

    public static final boolean matchesIdName(String string) {
        return ID_NAME.matcher(string).matches();
    }

    public static final boolean matchesQuotedIdName(String string) {
        return ID_QUOTED_NAME.matcher(string).matches();
    }

    public static final boolean matchesIdPath(Vector vector) {
        if (vector.size() <= 1) {
            return false;
        }
        String string = (String)vector.get(1);
        return ID_PATH.matcher(string).matches();
    }

    static final Long getCheckedSeId(SystemEnvironment systemEnvironment, WithItem withItem) throws SDMSException {
        Long l;
        if (withItem == null) {
            return null;
        }
        if (withItem.key == null) {
            l = (Long)withItem.value;
        } else {
            Vector vector = (Vector)((Object)withItem.key);
            String string = (String)withItem.value;
            Long l2 = SDMSFolderTable.pathToId(systemEnvironment, vector);
            SDMSKey sDMSKey = new SDMSKey(l2, (Comparable)((Object)string));
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.idx_folderId_name_getUnique(systemEnvironment, sDMSKey);
            l = sDMSSchedulingEntity.getId(systemEnvironment);
        }
        if (l != 0L) {
            try {
                SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
            }
            catch (NotFoundException notFoundException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04410300037", "No Batch or Job with id $1 exists", l));
            }
        }
        return l;
    }

    static final String mapIdName(String string, Long l) {
        return l != null && IntervalUtil.matchesIdName(string) ? ID_REPLACE.matcher(string).replaceFirst(l.toString()) : string;
    }

    static final String mapIdPath(String string, Long l) {
        return l != null && ID_PATH.matcher(string).matches() ? ID_REPLACE.matcher(string).replaceFirst(l.toString()) : string;
    }

    static final Vector mapIdPath(Vector vector, Long l) {
        if (l == null || !IntervalUtil.matchesIdPath(vector)) {
            return vector;
        }
        String string = (String)vector.get(1);
        String string2 = ID_REPLACE.matcher(string).replaceFirst(l.toString());
        if (string2.equals(string)) {
            return vector;
        }
        PathVector pathVector = new PathVector((Collection)vector);
        pathVector.set(1, string2);
        return pathVector;
    }

    public static final Integer getMultiplier(SystemEnvironment systemEnvironment, WithHash withHash) throws SDMSException {
        Integer n = (Integer)withHash.get("MULT");
        if (n == null) {
            return SDMSConstants.iONE;
        }
        if (n <= 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207191659", "multiplier must be greater than 0"));
        }
        return n;
    }

    public static final boolean getDateTime(SystemEnvironment systemEnvironment, DateTime dateTime, WithHash withHash, String string) throws SDMSException {
        boolean bl = false;
        DateTime dateTime2 = (DateTime)withHash.get(string);
        if (dateTime2.year == -1) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04210011547", string + " must contain a year"));
        }
        if (dateTime2.suppressSeconds()) {
            bl = true;
        }
        dateTime.set(dateTime2);
        return bl;
    }

    public static final void killDispatcher(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSIntervalDispatcherTable.idx_intId.getVector(systemEnvironment, l);
        for (SDMSIntervalDispatcher sDMSIntervalDispatcher : vector) {
            sDMSIntervalDispatcher.delete(systemEnvironment);
        }
    }

    public static final void createDispatcher(SystemEnvironment systemEnvironment, Long l, WithHash withHash, int n) throws SDMSException {
        SDMSInterval sDMSInterval = null;
        Vector vector = (Vector)withHash.get("DISPATCH");
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CreateInterval createInterval;
            Vector vector2 = (Vector)vector.get(i);
            String string = (String)vector2.get(0);
            Boolean bl = (Boolean)vector2.get(1);
            Vector vector3 = (Vector)vector2.get(2);
            Object e = vector3.get(0);
            Object e2 = vector3.get(1);
            Boolean bl2 = (Boolean)vector3.get(2);
            SDMSIntervalDispatcher sDMSIntervalDispatcher = SDMSIntervalDispatcherTable.table.create(systemEnvironment, l, i, string, null, null, bl2, bl);
            Long l2 = sDMSIntervalDispatcher.getId(systemEnvironment);
            if (e != null) {
                if (e instanceof String) {
                    sDMSInterval = (SDMSInterval)SDMSIntervalTable.idx_name_objId.getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)e)), null));
                    if ((sDMSInterval.getPrivileges(systemEnvironment).toLong() & 0x10000000L) != 0x10000000L) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03308181538", "Insufficient privileges to use Interval " + e.toString()));
                    }
                } else {
                    createInterval = (CreateInterval)e;
                    createInterval.setEnv(systemEnvironment.cEnv);
                    createInterval.go(systemEnvironment, n);
                    sDMSInterval = createInterval.getIval();
                    sDMSInterval.setObjId(systemEnvironment, l2);
                    sDMSInterval.setObjType(systemEnvironment, dispType);
                }
                sDMSIntervalDispatcher.setSelectIntId(systemEnvironment, sDMSInterval.getId(systemEnvironment));
            }
            if (e2 == null) continue;
            if (e2 instanceof String) {
                sDMSInterval = (SDMSInterval)SDMSIntervalTable.idx_name_objId.getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)e2)), null));
                if ((sDMSInterval.getPrivileges(systemEnvironment).toLong() & 0x10000000L) != 0x10000000L) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03308181539", "Insufficient privileges to use Interval " + e.toString()));
                }
            } else {
                createInterval = (CreateInterval)e2;
                createInterval.setEnv(systemEnvironment.cEnv);
                createInterval.go(systemEnvironment, n);
                sDMSInterval = createInterval.getIval();
                sDMSInterval.setObjId(systemEnvironment, l2);
                sDMSInterval.setObjType(systemEnvironment, dispType);
            }
            sDMSIntervalDispatcher.setFilterIntId(systemEnvironment, sDMSInterval.getId(systemEnvironment));
        }
    }

    public static final void killFilter(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSIntervalHierarchyTable.idx_parentId.getVector(systemEnvironment, l);
        for (SDMSIntervalHierarchy sDMSIntervalHierarchy : vector) {
            Long l2 = sDMSIntervalHierarchy.getChildId(systemEnvironment);
            SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l2);
            Long l3 = sDMSInterval.getObjId(systemEnvironment);
            if (l.equals(l3)) {
                sDMSInterval.delete(systemEnvironment);
            }
            sDMSIntervalHierarchy.delete(systemEnvironment);
        }
    }

    public static final void killEmbedded(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l);
        Long l2 = sDMSInterval.getEmbeddedIntervalId(systemEnvironment);
        if (l2 == null) {
            return;
        }
        SDMSInterval sDMSInterval2 = SDMSIntervalTable.getObject(systemEnvironment, l2);
        Long l3 = sDMSInterval2.getObjId(systemEnvironment);
        if (l.equals(l3)) {
            sDMSInterval2.delete(systemEnvironment);
        }
    }

    public static final boolean createFilter(SystemEnvironment systemEnvironment, Long l, WithHash withHash, int n) throws SDMSException {
        return IntervalUtil.createFilter(systemEnvironment, l, withHash, null, n);
    }

    public static final boolean createFilter(SystemEnvironment systemEnvironment, Long l, WithHash withHash, Long l2, int n) throws SDMSException {
        Vector vector = (Vector)withHash.get("FILTER");
        if (vector == null) {
            return false;
        }
        HashSet<Long> hashSet = new HashSet<Long>(vector.size());
        boolean bl = false;
        for (Object e : vector) {
            Long l3;
            SDMSInterval sDMSInterval;
            Object object;
            if (e instanceof String) {
                object = (String)e;
                if (l2 != null) {
                    object = IntervalUtil.mapIdName((String)object, l2);
                }
                try {
                    sDMSInterval = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)object, l));
                }
                catch (NotFoundException notFoundException) {
                    sDMSInterval = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)object, null));
                }
                l3 = sDMSInterval.getId(systemEnvironment);
                if (l3.equals(l)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04209270132", "interval cannot filter itself"));
                }
                if (hashSet.contains(l3)) {
                    bl = true;
                    continue;
                }
                hashSet.add(l3);
                SDMSIntervalHierarchyTable.table.create(systemEnvironment, l3, l);
                continue;
            }
            object = (CreateInterval)e;
            ((Node)object).setEnv(systemEnvironment.cEnv);
            ((CreateInterval)object).go(systemEnvironment, n);
            sDMSInterval = ((CreateInterval)object).getIval();
            l3 = ((CreateInterval)object).getIvalId();
            sDMSInterval.setObjId(systemEnvironment, l);
            sDMSInterval.setObjType(systemEnvironment, ivalType);
            hashSet.add(l3);
            SDMSIntervalHierarchyTable.table.create(systemEnvironment, l3, l);
        }
        return bl;
    }

    public static final void killSelections(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSIntervalSelectionTable.idx_intId.getVector(systemEnvironment, l);
        for (SDMSIntervalSelection sDMSIntervalSelection : vector) {
            sDMSIntervalSelection.delete(systemEnvironment);
        }
    }

    public static final int createSelections(SystemEnvironment systemEnvironment, Long l, WithHash withHash) throws SDMSException {
        Vector vector = (Vector)withHash.get("SELECTION");
        if (vector == null) {
            return 0;
        }
        int n = 0;
        for (WithItem withItem : vector) {
            Integer n2 = null;
            Long l2 = null;
            Long l3 = null;
            if (withItem.key.equals("NUM")) {
                n2 = (Integer)withItem.value;
                if (n2 == 0) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207262333", "selection must not be 0"));
                }
            } else if (withItem.key.equals("RANGE")) {
                DateTime dateTime;
                WithHash withHash2 = (WithHash)withItem.value;
                DateTime dateTime2 = (DateTime)withHash2.get("FROM");
                if (dateTime2.second != -1) {
                    n = Math.max(n, 2);
                }
                if ((dateTime = (DateTime)withHash2.get("TO")) == null) {
                    dateTime = new DateTime(dateTime2);
                } else if (dateTime2.year == -1 != (dateTime.year == -1) || dateTime2.month == -1 != (dateTime.month == -1) || dateTime2.week == -1 != (dateTime.week == -1) || dateTime2.day == -1 != (dateTime.day == -1) || dateTime2.hour == -1 != (dateTime.hour == -1) || dateTime2.minute == -1 != (dateTime.minute == -1) || dateTime2.second == -1 != (dateTime.second == -1)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04210221611", "both limits must have the same type"));
                }
                if (dateTime.second != -1) {
                    n = Math.max(n, 2);
                }
                dateTime2.suppressSeconds();
                dateTime2.fixToMinDate();
                dateTime.suppressSeconds();
                dateTime.fixToMaxDate();
                long l4 = dateTime2.compareTo(dateTime);
                if (l4 == 0L && withHash2.get("TO") != null) {
                    n = Math.max(n, 1);
                }
                l2 = dateTime2.toLong();
                l3 = l4 == 0L ? null : dateTime.toLong();
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207181833", "unknown selection type " + String.valueOf(withItem.key)));
            }
            SDMSIntervalSelectionTable.table.create(systemEnvironment, l, n2, l2, l3);
        }
        return n;
    }

    private IntervalUtil() {
    }
}

