/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantProxyGeneric;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.PathVector;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class ListGrant
extends Node {
    public static final String __version = "@(#) $Id: ListGrant.java,v 2.14.2.3 2013/06/18 09:49:33 ronald Exp $";
    private final ObjectURL url;
    private final String groupName;
    private SDMSGroup group;
    private SDMSProxy obj;
    private final boolean objectGrants;

    public ListGrant(ObjectURL objectURL) {
        this.objectGrants = true;
        this.url = objectURL;
        this.groupName = null;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public ListGrant(String string) {
        this.objectGrants = false;
        this.url = null;
        this.groupName = string;
        this.txMode = 1;
        this.auditFlag = false;
    }

    private void go_grantsForObject(SystemEnvironment systemEnvironment) throws SDMSException {
        AbstractCollection abstractCollection;
        SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("GROUP");
        vector.add("PRIVS");
        vector.add("INHERITED_PRIVS");
        vector.add("EFFECTIVE_PRIVS");
        vector.add("ORIGIN");
        vector.add("OWNER");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03302111221", "List of Grants"), vector);
        long l = 0L;
        SDMSProxy sDMSProxy = this.obj.getParent(systemEnvironment);
        if (sDMSProxy != null) {
            l = this.obj.getInheritPrivs(systemEnvironment);
            abstractCollection = new Vector();
            ((Vector)abstractCollection).add(this.obj.getId(systemEnvironment));
            ((Vector)abstractCollection).add("");
            sDMSPrivilege.setPriv(systemEnvironment, l);
            ((Vector)abstractCollection).add(sDMSPrivilege.toString());
            ((Vector)abstractCollection).add("");
            ((Vector)abstractCollection).add("");
            ((Vector)abstractCollection).add(null);
            ((Vector)abstractCollection).add(null);
            sDMSOutputContainer.addData(systemEnvironment, (Vector)abstractCollection);
        }
        abstractCollection = new HashSet();
        long l2 = this.obj.getPrivilegeMask();
        SDMSProxy sDMSProxy2 = this.obj;
        while (sDMSProxy2 != null) {
            Long l3 = sDMSProxy2.getOwnerId(systemEnvironment);
            if (l3 != null && !l3.equals(SDMSObject.adminGId)) {
                ((HashSet)abstractCollection).add(l3);
            }
            Serializable serializable = SDMSGrantTable.idx_objectId.getVector(systemEnvironment, sDMSProxy2.getId(systemEnvironment));
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                SDMSGrant sDMSGrant = (SDMSGrant)((Vector)serializable).get(i);
                long l4 = sDMSGrant.getPrivs(systemEnvironment);
                if ((l4 & l2) == 0L) continue;
                ((HashSet)abstractCollection).add(sDMSGrant.getGId(systemEnvironment));
            }
            if ((l2 &= l) == 0L) {
                sDMSProxy2 = null;
                continue;
            }
            if ((sDMSProxy2 = sDMSProxy2.getParent(systemEnvironment)) == null) continue;
            l = sDMSProxy2.getInheritPrivs(systemEnvironment);
        }
        for (Serializable serializable : abstractCollection) {
            l = this.obj.getInheritPrivs(systemEnvironment);
            l2 = this.obj.getPrivilegeMask();
            sDMSProxy2 = this.obj;
            SDMSProxy sDMSProxy3 = null;
            long l5 = -1L;
            while (sDMSProxy2 != null) {
                long l6;
                Object object;
                Long l7 = null;
                Long l8 = sDMSProxy2.getOwnerId(systemEnvironment);
                Vector<Serializable> vector2 = new Vector<Serializable>();
                vector2.add(serializable);
                long l9 = 0L;
                l9 = l5 == -1L ? sDMSProxy2.getPrivilegesForGroups(systemEnvironment, vector2).toLong() : l5;
                sDMSProxy3 = sDMSProxy2.getParent(systemEnvironment);
                l5 = sDMSProxy3 != null ? sDMSProxy3.getPrivilegesForGroups(systemEnvironment, vector2).toLong() : 0L;
                try {
                    object = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(sDMSProxy2.getId(systemEnvironment), (Comparable)((Object)serializable)));
                    l7 = ((SDMSProxy)object).getId(systemEnvironment);
                    l6 = ((SDMSGrantProxyGeneric)object).getPrivs(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    l7 = sDMSProxy2.getId(systemEnvironment);
                    l6 = 0L;
                }
                if (sDMSProxy2 != this.obj) {
                    l6 &= l2;
                }
                if ((l9 & l2) != 0L && (sDMSProxy2 == this.obj || l8 != null && l8.equals(serializable) || l6 != 0L)) {
                    Object object2;
                    object = new Vector();
                    ((Vector)object).add(l7);
                    SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, (Long)serializable);
                    ((Vector)object).add(sDMSGroup.getName(systemEnvironment));
                    if (l8 != null && l8.equals(serializable) && sDMSProxy2 != this.obj) {
                        sDMSPrivilege.setPriv(systemEnvironment, l2);
                    } else {
                        sDMSPrivilege.setPriv(systemEnvironment, l6);
                    }
                    ((Vector)object).add(sDMSPrivilege.toString());
                    if (l8 != null && l8.equals(serializable)) {
                        ((Vector)object).add("");
                    } else {
                        sDMSPrivilege.setPriv(systemEnvironment, l5 & l2 & l9);
                        ((Vector)object).add(sDMSPrivilege.toString());
                    }
                    sDMSPrivilege.setPriv(systemEnvironment, l9);
                    ((Vector)object).add(sDMSPrivilege.toString());
                    String string = null;
                    if (sDMSProxy2 != this.obj && (object2 = sDMSProxy2.pathVector(systemEnvironment)) != null) {
                        string = ((PathVector)object2).toString();
                    }
                    ((Vector)object).add(string);
                    object2 = null;
                    if (l8 != null) {
                        sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l8);
                        object2 = sDMSGroup.getName(systemEnvironment);
                    }
                    ((Vector)object).add(object2);
                    sDMSOutputContainer.addData(systemEnvironment, (Vector)object);
                }
                if ((l2 = l8 != null && l8.equals(serializable) ? 0L : l2 & l & (l6 ^ 0xFFFFFFFFFFFFFFFFL) & l9) == 0L) {
                    sDMSProxy2 = null;
                    continue;
                }
                sDMSProxy2 = sDMSProxy3;
                if (sDMSProxy2 == null) continue;
                l = sDMSProxy2.getInheritPrivs(systemEnvironment);
            }
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1, 5));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03402110100", "$1 Grant(s) found", sDMSOutputContainer.lines));
    }

    private SDMSProxy resolveById(SystemEnvironment systemEnvironment, Integer n, Long l) throws SDMSException {
        SDMSProxy sDMSProxy = null;
        try {
            switch (n) {
                case 1: {
                    sDMSProxy = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l);
                    break;
                }
                case 18: {
                    sDMSProxy = SDMSEventTable.getObject(systemEnvironment, l);
                    break;
                }
                case 2: {
                    sDMSProxy = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l);
                    break;
                }
                case 3: {
                    sDMSProxy = SDMSExitStateProfileTable.getObject(systemEnvironment, l);
                    break;
                }
                case 4: {
                    sDMSProxy = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l);
                    break;
                }
                case 5: {
                    sDMSProxy = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l);
                    break;
                }
                case 6: 
                case 9: {
                    try {
                        sDMSProxy = SDMSFolderTable.getObject(systemEnvironment, l);
                        n = SDMSConstants.OC_FOLDER;
                    }
                    catch (NotFoundException notFoundException) {
                        sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
                        n = SDMSConstants.OC_JOB_DEFINITION;
                    }
                    break;
                }
                case 7: {
                    sDMSProxy = SDMSFootprintTable.getObject(systemEnvironment, l);
                    break;
                }
                case 21: {
                    sDMSProxy = SDMSGroupTable.getObject(systemEnvironment, l);
                    break;
                }
                case 19: {
                    sDMSProxy = SDMSIntervalTable.getObject(systemEnvironment, l);
                    break;
                }
                case 17: {
                    sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                    break;
                }
                case 10: {
                    sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, l);
                    break;
                }
                case 23: {
                    sDMSProxy = SDMSParameterDefinitionTable.getObject(systemEnvironment, l);
                    break;
                }
                case 11: {
                    sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, l);
                    break;
                }
                case 13: {
                    sDMSProxy = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l);
                    break;
                }
                case 14: {
                    sDMSProxy = SDMSResourceStateProfileTable.getObject(systemEnvironment, l);
                    break;
                }
                case 12: {
                    sDMSProxy = SDMSResourceStateMappingProfileTable.getObject(systemEnvironment, l);
                    break;
                }
                case 20: {
                    sDMSProxy = SDMSScheduleTable.getObject(systemEnvironment, l);
                    break;
                }
                case 22: {
                    sDMSProxy = SDMSScheduledEventTable.getObject(systemEnvironment, l);
                    break;
                }
                case 15: {
                    sDMSProxy = SDMSScopeTable.getObject(systemEnvironment, l);
                    break;
                }
                case 16: {
                    sDMSProxy = SDMSTriggerTable.getObject(systemEnvironment, l);
                    break;
                }
                case 8: {
                    sDMSProxy = SDMSUserTable.getObject(systemEnvironment, l);
                    break;
                }
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return sDMSProxy;
    }

    private void go_grantsForGroup(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
        Vector vector = SDMSGrantTable.idx_gId.getVector(systemEnvironment, this.group.getId(systemEnvironment));
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector2 = new Vector<String>();
        vector2.add("ID");
        vector2.add("TYPE");
        vector2.add("SUBTYPE");
        vector2.add("NAME");
        vector2.add("PRIVS");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03302111222", "List of Grants"), vector2);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant = (SDMSGrant)vector.get(i);
            SDMSProxy sDMSProxy = this.resolveById(systemEnvironment, sDMSGrant.getObjectType(systemEnvironment), sDMSGrant.getObjectId(systemEnvironment));
            long l = sDMSGrant.getPrivs(systemEnvironment);
            if (sDMSProxy == null) {
                for (int j = 0; j < SDMSPrivilege.MANAGE_PRIVS.length; ++j) {
                    if ((SDMSPrivilege.MANAGE_PRIVS[j] & l) == 0L) continue;
                    Vector<Object> vector3 = new Vector<Object>();
                    vector3.add(sDMSGrant.getId(systemEnvironment));
                    if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x400000000L) {
                        vector3.add("user");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x210000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x800000000L) {
                        vector3.add("group");
                        sDMSPrivilege.setPriv(systemEnvironment, 12867015449L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x1000000000L) {
                        vector3.add("exit state definition");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x210000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x2000000000L) {
                        vector3.add("exit state profile");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x210000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x4000000000L) {
                        vector3.add("exit state mapping");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x210000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x8000000000L) {
                        vector3.add("exit state translation");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x210000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x10000000000L) {
                        vector3.add("resource state definition");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x210000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x20000000000L) {
                        vector3.add("resource state profile");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x210000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x40000000000L) {
                        vector3.add("resource state mapping");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x210000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x80000000000L) {
                        vector3.add("footprint");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x210000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x100000000000L) {
                        vector3.add("environment");
                        sDMSPrivilege.setPriv(systemEnvironment, 0x211000111L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x200000000000L) {
                        vector3.add("system");
                        sDMSPrivilege.setPriv(systemEnvironment, 0L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x400000000000L) {
                        vector3.add("select");
                        sDMSPrivilege.setPriv(systemEnvironment, 0L);
                    } else if (SDMSPrivilege.MANAGE_PRIVS[j] == 0x1000000000000L) {
                        vector3.add("watch type");
                        sDMSPrivilege.setPriv(systemEnvironment, 0L);
                    } else {
                        vector3.add("Unknown System Privilege");
                        sDMSPrivilege.setPriv(systemEnvironment, 0L);
                    }
                    vector3.add("");
                    vector3.add("");
                    vector3.add(sDMSPrivilege.toString());
                    sDMSOutputContainer.addData(systemEnvironment, vector3);
                }
                continue;
            }
            Vector<Object> vector4 = new Vector<Object>();
            vector4.add(sDMSGrant.getId(systemEnvironment));
            vector4.add(sDMSGrant.getObjectTypeAsString(systemEnvironment));
            vector4.add(sDMSProxy.getSubtypeName(systemEnvironment));
            vector4.add(sDMSProxy.getURLName(systemEnvironment));
            sDMSPrivilege.setPriv(systemEnvironment, l);
            vector4.add(sDMSPrivilege.toString());
            sDMSOutputContainer.addData(systemEnvironment, vector4);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03402110101", "$1 Grant(s) found", sDMSOutputContainer.lines));
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.objectGrants) {
            this.obj = this.url.resolve(systemEnvironment);
            if (!this.obj.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131446", "Insufficient Privileges"));
            }
            this.go_grantsForObject(systemEnvironment);
        } else {
            this.group = SDMSGroupTable.idx_name_getUnique(systemEnvironment, this.groupName);
            if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId) && !systemEnvironment.cEnv.gid().contains(this.group.getId(systemEnvironment))) {
                Iterator iterator = systemEnvironment.cEnv.gid().iterator();
                SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
                while (iterator.hasNext()) {
                    Long l = (Long)iterator.next();
                    try {
                        SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(SDMSConstants.lZERO, l));
                        sDMSPrivilege.addPriv(systemEnvironment, sDMSGrant.getPrivs(systemEnvironment));
                    }
                    catch (NotFoundException notFoundException) {}
                }
                if (!sDMSPrivilege.can(0x800000000L)) {
                    throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03102241232", "Insufficient privileges"));
                }
            }
            this.go_grantsForGroup(systemEnvironment);
        }
    }
}

