/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupProxyGeneric;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObjectCommentProxyGeneric;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerParameter;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerState;
import de.independit.scheduler.server.repository.SDMSTriggerStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class ListTrigger
extends Node {
    public static final String __version = "@(#) $Id: ListTrigger.java,v 2.22.4.3 2013/06/18 09:49:34 ronald Exp $";
    private String name;
    private Vector path;
    private WithItem fireObj;
    private boolean reverse;
    private int maxCount;

    public ListTrigger(Vector vector, boolean bl, Integer n) {
        this.fireObj = null;
        if (vector != null) {
            this.name = (String)vector.remove(vector.size() - 1);
            this.path = vector;
        } else {
            this.name = null;
            this.path = null;
        }
        this.txMode = 1;
        this.reverse = bl;
        this.auditFlag = false;
        this.maxCount = n;
    }

    public ListTrigger(WithItem withItem, Integer n) {
        this.name = null;
        this.path = null;
        this.fireObj = withItem;
        this.txMode = 1;
        this.maxCount = n;
    }

    private Long getFireId(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = null;
        if (this.fireObj.key.equals("JOB")) {
            Vector vector = (Vector)this.fireObj.value;
            String string = (String)vector.remove(vector.size() - 1);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, vector, string);
            if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03407230019", "Insufficient privileges"));
            }
            l = sDMSSchedulingEntity.getId(systemEnvironment);
        } else if (this.fireObj.key.equals("RESOURCE")) {
            Long l2;
            Vector vector = (Vector)this.fireObj.value;
            Vector vector2 = (Vector)vector.remove(vector.size() - 1);
            try {
                l2 = SDMSScopeTable.pathToId(systemEnvironment, vector);
            }
            catch (NotFoundException notFoundException) {
                l2 = SDMSFolderTable.pathToId(systemEnvironment, vector);
            }
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, vector2);
            Long l3 = sDMSNamedResource.getId(systemEnvironment);
            SDMSResource sDMSResource = SDMSResourceTable.idx_nrId_scopeId_getUnique(systemEnvironment, new SDMSKey(l3, l2));
            if (!sDMSResource.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03407230021", "Insufficient privileges"));
            }
            l = sDMSResource.getId(systemEnvironment);
        } else if (this.fireObj.key.equals("NAMED_RESOURCE")) {
            Vector vector = (Vector)this.fireObj.value;
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, vector);
            if (!sDMSNamedResource.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03407230018", "Insufficient privileges"));
            }
            l = sDMSNamedResource.getId(systemEnvironment);
        }
        return l;
    }

    private String quote(String string) {
        String string2 = string.replace("\\", "\\\\");
        string2 = string2.replace("'", "\\'");
        return string2;
    }

    private String renderParameters(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        StringBuffer stringBuffer = new StringBuffer();
        Long l = sDMSTrigger.getId(systemEnvironment);
        String string = "";
        Vector vector = SDMSTriggerParameterTable.idx_triggerId.getSortedVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSTriggerParameter sDMSTriggerParameter = (SDMSTriggerParameter)vector.get(i);
            String string2 = sDMSTriggerParameter.getName(systemEnvironment);
            String string3 = sDMSTriggerParameter.getExpression(systemEnvironment);
            stringBuffer.append(string);
            stringBuffer.append("'");
            stringBuffer.append(string2);
            stringBuffer.append("'='");
            stringBuffer.append(this.quote(string3));
            stringBuffer.append("'");
            string = ",";
        }
        return stringBuffer.toString();
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Iterator iterator;
        SDMSOutputContainer sDMSOutputContainer = null;
        if (this.name != null) {
            var8_3 = SDMSSchedulingEntityTable.get(systemEnvironment, this.path, this.name);
            if (!((SDMSSchedulingEntityProxyGeneric)var8_3).checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131651", "Insufficient privileges"));
            }
            if (this.reverse) {
                var6_5 = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, ((SDMSProxy)var8_3).getId(systemEnvironment));
                iterator = var6_5.iterator();
            } else {
                var6_5 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, ((SDMSProxy)var8_3).getId(systemEnvironment));
                iterator = var6_5.iterator();
            }
        } else if (this.fireObj != null) {
            var8_3 = this.getFireId(systemEnvironment);
            var6_5 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, var8_3);
            iterator = var6_5.iterator();
        } else {
            iterator = SDMSTriggerTable.table.iterator(systemEnvironment);
        }
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OBJECT_TYPE");
        vector.add("OBJECT_SUBTYPE");
        vector.add("OBJECT_NAME");
        vector.add("ACTIVE");
        vector.add("ACTION");
        vector.add("STATES");
        vector.add("SUBMIT_TYPE");
        vector.add("SUBMIT_NAME");
        vector.add("SUBMIT_SE_OWNER");
        vector.add("SUBMIT_PRIVS");
        vector.add("MAIN_TYPE");
        vector.add("MAIN_NAME");
        vector.add("MAIN_SE_OWNER");
        vector.add("MAIN_PRIVS");
        vector.add("PARENT_TYPE");
        vector.add("PARENT_NAME");
        vector.add("PARENT_SE_OWNER");
        vector.add("PARENT_PRIVS");
        vector.add("TRIGGER_TYPE");
        vector.add("MASTER");
        vector.add("IS_INVERSE");
        vector.add("SUBMIT_OWNER");
        vector.add("IS_CREATE");
        vector.add("IS_CHANGE");
        vector.add("IS_DELETE");
        vector.add("IS_GROUP");
        vector.add("MAX_RETRY");
        vector.add("SUSPEND");
        vector.add("RESUME_AT");
        vector.add("RESUME_IN");
        vector.add("RESUME_BASE");
        vector.add("WARN");
        vector.add("LIMIT_STATE");
        vector.add("CONDITION");
        vector.add("CHECK_AMOUNT");
        vector.add("CHECK_BASE");
        vector.add("PARAMETERS");
        vector.add("PRIVS");
        vector.add("TAG");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03206200023", "List of Triggers"), vector);
        int n = 0;
        boolean bl = false;
        block17: while (iterator.hasNext()) {
            SDMSProxy sDMSProxy;
            Long l;
            Long l2;
            Comparable<Long> comparable;
            Object object;
            SDMSProxy sDMSProxy2;
            SDMSTrigger sDMSTrigger = (SDMSTrigger)iterator.next();
            if (sDMSTrigger.getAction(systemEnvironment) == 1) {
                bl = true;
            } else if (this.maxCount != 0 && n >= this.maxCount) {
                if (!bl) continue;
                break;
            }
            ++n;
            SDMSSchedulingEntity sDMSSchedulingEntity = null;
            SDMSNamedResource sDMSNamedResource = null;
            SDMSResource sDMSResource = null;
            SDMSResource sDMSResource2 = null;
            SDMSNamedResource sDMSNamedResource2 = null;
            Long l3 = sDMSTrigger.getFireId(systemEnvironment);
            int n2 = sDMSTrigger.getObjectType(systemEnvironment);
            switch (n2) {
                case 0: {
                    sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3);
                    if (sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x10000000L)) break;
                    continue block17;
                }
                case 2: {
                    sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l3);
                    if (sDMSNamedResource.checkPrivileges(systemEnvironment, 0x10000000L)) break;
                    continue block17;
                }
                case 1: {
                    sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l3);
                    if (sDMSResource.checkPrivileges(systemEnvironment, 0x10000000L)) break;
                    continue block17;
                }
            }
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(sDMSTrigger.getId(systemEnvironment));
            vector2.add(sDMSTrigger.getName(systemEnvironment));
            vector2.add(sDMSTrigger.getObjectTypeAsString(systemEnvironment));
            switch (n2) {
                case 0: {
                    vector2.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
                    break;
                }
                case 2: {
                    vector2.add(sDMSNamedResource.getUsageAsString(systemEnvironment));
                    break;
                }
                case 1: {
                    sDMSResource2 = SDMSResourceTable.getObject(systemEnvironment, l3);
                    sDMSNamedResource2 = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResource2.getNrId(systemEnvironment));
                    vector2.add(sDMSNamedResource2.getUsageAsString(systemEnvironment));
                }
            }
            switch (n2) {
                case 0: {
                    vector2.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
                    break;
                }
                case 2: {
                    vector2.add(sDMSNamedResource.pathVector(systemEnvironment));
                    break;
                }
                case 1: {
                    vector2.add(sDMSResource.getURLName(systemEnvironment));
                }
            }
            vector2.add(sDMSTrigger.getIsActive(systemEnvironment));
            vector2.add(sDMSTrigger.getActionAsString(systemEnvironment));
            Vector vector3 = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, sDMSTrigger.getId(systemEnvironment));
            Iterator iterator2 = vector3.iterator();
            String string = "";
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator2.hasNext()) {
                sDMSProxy2 = (SDMSTriggerState)iterator2.next();
                object = "";
                if (n2 == 1 || n2 == 2) {
                    comparable = ((SDMSTriggerStateProxyGeneric)sDMSProxy2).getFromStateId(systemEnvironment);
                    if (comparable != null) {
                        object = (String)object + SDMSResourceStateDefinitionTable.getObject(systemEnvironment, (Long)comparable).getName(systemEnvironment);
                    }
                    object = (String)object + ":";
                    l2 = ((SDMSTriggerStateProxyGeneric)sDMSProxy2).getToStateId(systemEnvironment);
                    if (l2 != null) {
                        object = (String)object + SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l2).getName(systemEnvironment);
                    }
                } else {
                    comparable = ((SDMSTriggerStateProxyGeneric)sDMSProxy2).getToStateId(systemEnvironment);
                    if (comparable != null) {
                        object = (String)object + SDMSExitStateDefinitionTable.getObject(systemEnvironment, (Long)comparable).getName(systemEnvironment);
                    }
                }
                stringBuffer.append(string);
                stringBuffer.append((String)object);
                string = ",";
            }
            vector2.add(new String(stringBuffer));
            sDMSProxy2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSTrigger.getSeId(systemEnvironment));
            vector2.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getTypeAsString(systemEnvironment));
            vector2.add(((SDMSSchedulingEntity)sDMSProxy2).pathVector(systemEnvironment));
            object = ((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getOwnerId(systemEnvironment);
            comparable = SDMSGroupTable.getObject(systemEnvironment, (Long)object);
            vector2.add(((SDMSGroupProxyGeneric)comparable).getName(systemEnvironment));
            vector2.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getPrivileges(systemEnvironment).toString());
            l2 = sDMSTrigger.getMainSeId(systemEnvironment);
            if (l2 == null) {
                vector2.add(null);
                vector2.add(null);
                vector2.add(null);
                vector2.add(null);
            } else {
                sDMSProxy2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2);
                vector2.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getTypeAsString(systemEnvironment));
                vector2.add(((SDMSSchedulingEntity)sDMSProxy2).pathVector(systemEnvironment));
                object = ((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getOwnerId(systemEnvironment);
                comparable = SDMSGroupTable.getObject(systemEnvironment, (Long)object);
                vector2.add(((SDMSGroupProxyGeneric)comparable).getName(systemEnvironment));
                vector2.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getPrivileges(systemEnvironment).toString());
            }
            Long l4 = sDMSTrigger.getParentSeId(systemEnvironment);
            if (l4 == null) {
                vector2.add(null);
                vector2.add(null);
                vector2.add(null);
                vector2.add(null);
            } else {
                sDMSProxy2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l4);
                vector2.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getTypeAsString(systemEnvironment));
                vector2.add(((SDMSSchedulingEntity)sDMSProxy2).pathVector(systemEnvironment));
                object = ((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getOwnerId(systemEnvironment);
                comparable = SDMSGroupTable.getObject(systemEnvironment, (Long)object);
                vector2.add(((SDMSGroupProxyGeneric)comparable).getName(systemEnvironment));
                vector2.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getPrivileges(systemEnvironment).toString());
            }
            vector2.add(sDMSTrigger.getTypeAsString(systemEnvironment));
            vector2.add(sDMSTrigger.getIsMaster(systemEnvironment));
            vector2.add(sDMSTrigger.getIsInverse(systemEnvironment));
            if (sDMSTrigger.getIsMaster(systemEnvironment).booleanValue()) {
                l = sDMSTrigger.getSubmitOwnerId(systemEnvironment);
                comparable = SDMSGroupTable.getObject(systemEnvironment, l);
                vector2.add(((SDMSGroupProxyGeneric)comparable).getName(systemEnvironment));
            } else {
                vector2.add(null);
            }
            vector2.add(sDMSTrigger.getIsCreate(systemEnvironment));
            vector2.add(sDMSTrigger.getIsChange(systemEnvironment));
            vector2.add(sDMSTrigger.getIsDelete(systemEnvironment));
            vector2.add(sDMSTrigger.getIsGroup(systemEnvironment));
            vector2.add(sDMSTrigger.getMaxRetry(systemEnvironment));
            vector2.add(sDMSTrigger.getIsSuspend(systemEnvironment));
            vector2.add(sDMSTrigger.getResumeAt(systemEnvironment));
            vector2.add(sDMSTrigger.getResumeIn(systemEnvironment));
            vector2.add(sDMSTrigger.getResumeBaseAsString(systemEnvironment));
            vector2.add(sDMSTrigger.getIsWarnOnLimit(systemEnvironment));
            l = sDMSTrigger.getLimitState(systemEnvironment);
            if (l == null) {
                vector2.add(null);
            } else {
                sDMSProxy = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l);
                vector2.add(((SDMSExitStateDefinitionProxyGeneric)sDMSProxy).getName(systemEnvironment));
            }
            vector2.add(sDMSTrigger.getCondition(systemEnvironment));
            vector2.add(sDMSTrigger.getCheckAmount(systemEnvironment));
            vector2.add(sDMSTrigger.getCheckBaseAsString(systemEnvironment));
            vector2.add(this.renderParameters(systemEnvironment, sDMSTrigger));
            vector2.add(sDMSTrigger.getPrivileges(systemEnvironment).toString());
            try {
                sDMSProxy = SDMSObjectCommentTable.idx_objectId_getFirst(systemEnvironment, sDMSTrigger.getId(systemEnvironment));
                vector2.add(((SDMSObjectCommentProxyGeneric)sDMSProxy).getTag(systemEnvironment));
                vector2.add(((SDMSObjectCommentProxyGeneric)sDMSProxy).getDescription(systemEnvironment));
                vector2.add(((SDMSObjectCommentProxyGeneric)sDMSProxy).getInfoTypeAsString(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                vector2.add(null);
                vector2.add(null);
                vector2.add(null);
            }
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2, 1));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03206191305", "$1 Trigger(s) found", sDMSOutputContainer.lines));
    }
}

