/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSDependencyInstance;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueue;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSSystemMessage;
import de.independit.scheduler.server.repository.SDMSSystemMessageTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Date;
import java.util.Vector;

public abstract class ManipJob
extends Node {
    protected String message;
    protected WithHash with = null;
    protected Long jobId = null;
    protected Boolean clone = null;
    protected String execPid = null;
    protected String extPid = null;
    protected Integer status = null;
    protected String exitState = null;
    protected Boolean exitStateForce = null;
    protected String ts = null;
    protected Integer exitCode = null;
    protected String errText = null;
    protected Boolean suspend = null;
    protected Boolean adminSuspend = null;
    protected Boolean localSuspend = null;
    protected Object resumeObj = null;
    protected boolean noResume = false;
    protected String runProgram = null;
    protected String rerunProgram = null;
    protected Boolean rerun = null;
    protected Integer rerunSeq = null;
    protected Boolean kill = null;
    protected boolean killRecursive = false;
    protected Boolean cancel = null;
    protected Boolean disable = null;
    protected Long tsLong = null;
    protected Vector depsToIgnore = null;
    protected Integer priority = null;
    protected Integer nicevalue = null;
    protected Integer renice = null;
    protected String comment = null;
    protected Vector resToIgnore = null;
    protected Vector nrsToIgnore = null;
    protected Boolean clearWarning = null;
    protected String warning = null;

    protected SDMSSystemMessage createSystemMessage(SystemEnvironment systemEnvironment, int n, Long l, Long l2, int n2, boolean bl, Long l3, String string, Long l4, Boolean bl2, Long l5, String string2) throws SDMSException {
        return this.createSystemMessage(systemEnvironment, n, l, l2, n2, bl, l3, string, l4, bl2, l5, null, string2);
    }

    protected SDMSSystemMessage createSystemMessage(SystemEnvironment systemEnvironment, int n, Long l, Long l2, int n2, boolean bl, Long l3, String string, Long l4, Boolean bl2, Long l5, String string2, String string3) throws SDMSException {
        SDMSSystemMessage sDMSSystemMessage = SDMSSystemMessageTable.table.create(systemEnvironment, n, l, l2, n2, bl, l3, new Date().getTime(), string, l4, bl2, l5, string2 == null ? string3 : string2);
        String string4 = "Approval ID = " + sDMSSystemMessage.getId(systemEnvironment) + "; " + string3;
        return sDMSSystemMessage;
    }

    protected void evalSuspend(SystemEnvironment systemEnvironment, Long l, Long l2, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        boolean bl;
        boolean bl2;
        long l3 = System.currentTimeMillis();
        if (l != null) {
            bl2 = (l & 2L) != 0L;
            bl = (l & 4L) != 0L;
        } else {
            bl2 = false;
            bl = false;
        }
        Object object = null;
        if (l2 != null) {
            object = l2 < 0L ? Long.valueOf(l3 - l2) : (l2 == 0L ? null : l2);
        }
        if (l != null && (l & 1L) == 1L) {
            if (object == null || (Long)object > l3) {
                this.performSuspend(systemEnvironment, sDMSSubmittedEntity, true, bl2, bl, (Long)object);
            }
        } else {
            this.performSuspend(systemEnvironment, sDMSSubmittedEntity, false, bl2, bl, (Long)object);
        }
    }

    protected void setStateAndFields(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Integer n) throws SDMSException {
        sDMSSubmittedEntity.setState(systemEnvironment, n);
        if (this.with.containsKey("ERROR_TEXT")) {
            sDMSSubmittedEntity.setErrorMsg(systemEnvironment, this.errText);
        }
        if (this.with.containsKey("EXEC_PID")) {
            sDMSSubmittedEntity.setPid(systemEnvironment, this.execPid);
        }
        if (this.with.containsKey("EXT_PID")) {
            sDMSSubmittedEntity.setExtPid(systemEnvironment, this.extPid);
        }
    }

    protected void delFromQueue(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        try {
            SDMSRunnableQueue sDMSRunnableQueue = SDMSRunnableQueueTable.idx_smeId_scopeId_getUniqueForUpdate(systemEnvironment, new SDMSKey(sDMSSubmittedEntity.getId(systemEnvironment), systemEnvironment.cEnv.uid()));
            sDMSRunnableQueue.delete(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    protected void delFromQueue(SystemEnvironment systemEnvironment, SDMSKillJob sDMSKillJob) throws SDMSException {
        try {
            SDMSRunnableQueue sDMSRunnableQueue = SDMSRunnableQueueTable.idx_smeId_scopeId_getUnique(systemEnvironment, new SDMSKey(sDMSKillJob.getId(systemEnvironment), systemEnvironment.cEnv.uid()));
            sDMSRunnableQueue.delete(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    protected void changeState(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, boolean bl, Integer n) throws SDMSException {
        switch (n) {
            case 6: {
                this.setStateAndFields(systemEnvironment, sDMSSubmittedEntity, n);
                if (this.tsLong != null) {
                    sDMSSubmittedEntity.setStartTs(systemEnvironment, this.tsLong);
                }
                this.delFromQueue(systemEnvironment, sDMSSubmittedEntity);
                break;
            }
            case 7: {
                int n2 = sDMSSubmittedEntity.getState(systemEnvironment);
                this.setStateAndFields(systemEnvironment, sDMSSubmittedEntity, n);
                if (n2 != 6 && this.tsLong != null) {
                    sDMSSubmittedEntity.setStartTs(systemEnvironment, this.tsLong);
                }
                this.delFromQueue(systemEnvironment, sDMSSubmittedEntity);
                break;
            }
            case 11: {
                if (this.exitCode == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03212102041", "you cannot finish a job without an exit code"));
                }
                sDMSSubmittedEntity.finishJob(systemEnvironment, this.exitCode, this.errText, this.tsLong);
                int n3 = sDMSSubmittedEntity.getState(systemEnvironment);
                if (n3 != 11 && n3 != 12) break;
                this.delFromQueue(systemEnvironment, sDMSSubmittedEntity);
                break;
            }
            case 13: {
                this.setStateAndFields(systemEnvironment, sDMSSubmittedEntity, n);
                break;
            }
            case 14: {
                sDMSSubmittedEntity.releaseResources(systemEnvironment, n);
                this.setStateAndFields(systemEnvironment, sDMSSubmittedEntity, n);
                break;
            }
            case 15: {
                sDMSSubmittedEntity.releaseResources(systemEnvironment, n);
                sDMSSubmittedEntity.setToError(systemEnvironment, this.errText);
                break;
            }
            default: {
                if (!bl) break;
                sDMSSubmittedEntity.setState(systemEnvironment, n);
            }
        }
    }

    protected void setExitState(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, long l, Long l2, Boolean bl) throws SDMSException {
        SDMSExitState sDMSExitState;
        Long l3;
        boolean bl2;
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        this.exitState = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2, l).getName(systemEnvironment);
        this.jobId = sDMSSubmittedEntity.getId(systemEnvironment);
        Long l4 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l).getEspId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
        int n = sDMSSubmittedEntity.getState(systemEnvironment);
        if (sDMSSchedulingEntity.getType(systemEnvironment) != 1) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03403091701", "You can only change the exit state of a job, $1 is a $2", sDMSSchedulingEntity.pathString(systemEnvironment), sDMSSchedulingEntity.getTypeAsString(systemEnvironment)));
        }
        boolean bl3 = bl2 = sDMSSubmittedEntity.getIsSuspended(systemEnvironment) != 0;
        if (n != 11 && n != 14 && n != 15 && (n != 8 || sDMSSubmittedEntity.getJobEsdId(systemEnvironment) == null) && (n != 9 || sDMSSubmittedEntity.getJobEsdId(systemEnvironment) == null) && !bl2 || n == 15 && !sDMSSubmittedEntity.getJobIsRestartable(systemEnvironment).booleanValue() || bl2 && (n == 5 || n == 6 || n == 7 || n == 8 && sDMSSubmittedEntity.getJobEsdId(systemEnvironment) == null || n == 9 && sDMSSubmittedEntity.getJobEsdId(systemEnvironment) == null || n == 13)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207082043", "you can only set a state for a (broken) finished  or a suspended not active job"));
        }
        if (n != 14 && n != 15) {
            try {
                l3 = sDMSSubmittedEntity.getJobEsdId(systemEnvironment);
                if (l3 != null) {
                    sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l4, l3), l);
                    if (sDMSSubmittedEntity.getJobIsFinal(systemEnvironment).booleanValue()) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207082044", "you can only set a state for a job in a nonfinal state"));
                    }
                    String string = SDMSExitStateDefinitionTable.getObject(systemEnvironment, sDMSSubmittedEntity.getJobEsdId(systemEnvironment), l).getName(systemEnvironment);
                }
                String string = "N/A";
            }
            catch (NotFoundException notFoundException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03207082059", "Actual exit state is not part of the profile"));
            }
        } else {
            String string = "N/A";
        }
        try {
            sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l4, l2), l);
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207051918", "Exit State $1 is not part of the profile", this.exitState));
        }
        if (!bl.booleanValue()) {
            SDMSExitStateProfile sDMSExitStateProfile;
            l3 = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
            if (l3 == null && (l3 = (sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l4, l)).getDefaultEsmpId(systemEnvironment)) == null) {
                SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, "03403090928", "Couldn't determine the exit state mapping for job definition $1", sDMSSchedulingEntity.pathString(systemEnvironment));
                SDMSThread.doTrace(systemEnvironment.cEnv, sDMSMessage.toString(), -1);
                throw new CommonErrorException(sDMSMessage);
            }
            if (!SDMSExitStateMappingTable.idx_esmpId_esdId.containsKey(systemEnvironment, new SDMSKey(l3, l2), l)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03403090958", "A mapping to exit state $1 doesn't exist, use force if you really want this", this.exitState));
            }
        }
        sDMSSubmittedEntity.changeState(systemEnvironment, l2, sDMSExitState, sDMSSubmittedEntity.getExitCode(systemEnvironment), this.errText, null, false);
    }

    void performReject(SystemEnvironment systemEnvironment, SDMSSystemMessage sDMSSystemMessage, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
    }

    SDMSSubmittedEntity performClone(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        if (sDMSSubmittedEntity.getIsReplaced(systemEnvironment).booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03910311420", "Cannot clone an already replaced job or batch"));
        }
        SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getParentId(systemEnvironment));
        String string = "C_" + systemEnvironment.tx.txId;
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        Long l2 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        SDMSSubmittedEntity sDMSSubmittedEntity3 = sDMSSubmittedEntity2.submitChild(systemEnvironment, null, SDMSConstants.SME_SUSPEND, null, l2, string, l, null, true);
        if (sDMSSubmittedEntity3.getIsDisabled(systemEnvironment).booleanValue()) {
            sDMSSubmittedEntity3.disable(systemEnvironment, Boolean.FALSE);
        }
        return sDMSSubmittedEntity3;
    }

    void performCancel(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        sDMSSubmittedEntity.cancel(systemEnvironment);
    }

    void performRerun(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Boolean bl) throws SDMSException {
        if (bl.booleanValue()) {
            sDMSSubmittedEntity.rerunRecursive(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment), this.message == null ? this.comment : this.message, true);
        } else {
            sDMSSubmittedEntity.rerun(systemEnvironment);
        }
    }

    void performDisable(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Boolean bl) throws SDMSException {
        sDMSSubmittedEntity.disable(systemEnvironment, bl);
    }

    void performSetState(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Long l, Boolean bl) throws SDMSException {
        this.setExitState(systemEnvironment, sDMSSubmittedEntity, sDMSSubmittedEntity.getSeVersion(systemEnvironment), l, bl);
    }

    void performIgnDep(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Long l, Boolean bl) throws SDMSException {
        SDMSDependencyInstance sDMSDependencyInstance = SDMSDependencyInstanceTable.getObject(systemEnvironment, l);
        sDMSDependencyInstance.setIgnore(systemEnvironment, bl != false ? 2 : 1, sDMSSubmittedEntity.getId(systemEnvironment), this.message);
    }

    void performIgnRss(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Long l) throws SDMSException {
        SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l);
        SDMSResourceAllocation sDMSResourceAllocation = null;
        boolean bl = false;
        Vector vector = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(sDMSSubmittedEntity.getId(systemEnvironment), sDMSResource.getNrId(systemEnvironment)));
        for (int i = 0; i < vector.size(); ++i) {
            sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(i);
            if (!sDMSResourceAllocation.getRId(systemEnvironment).equals(l)) continue;
            bl = true;
            break;
        }
        if (bl) {
            sDMSResourceAllocation.ignore(systemEnvironment);
        }
    }

    void performSuspend(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Boolean bl, boolean bl2, boolean bl3, Long l) throws SDMSException {
        if (bl != null) {
            if (bl.booleanValue()) {
                sDMSSubmittedEntity.suspend(systemEnvironment, bl2, bl3);
                SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSSubmittedEntity, 6);
            } else if (l == null) {
                sDMSSubmittedEntity.resume(systemEnvironment, bl3);
                SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSSubmittedEntity, 7);
            }
        }
        if (l != null) {
            sDMSSubmittedEntity.setResumeTs(systemEnvironment, l);
        }
    }

    void performClrWarn(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
    }

    void performSetWarn(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
    }

    void performPriority(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Boolean bl, Integer n) throws SDMSException {
        if (bl.booleanValue()) {
            sDMSSubmittedEntity.renice(systemEnvironment, (int)n, null, this.message);
        } else {
            sDMSSubmittedEntity.setPriority(systemEnvironment, (int)n);
        }
    }

    void performModParm(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, String string, String string2) throws SDMSException {
        sDMSSubmittedEntity.setVariableValue(systemEnvironment, string, string2);
    }

    void performKill(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        sDMSSubmittedEntity.kill(systemEnvironment, this.killRecursive);
    }

    void performSetJobState(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        this.changeState(systemEnvironment, sDMSSubmittedEntity, true, this.status);
    }

    @Override
    public abstract void go(SystemEnvironment var1) throws SDMSException;
}

