/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import java.util.Vector;

public class MultiCommand
extends Node {
    public static final String __version = "@(#) $Id: MultiCommand.java,v 2.4.2.1 2013/03/14 10:24:41 ronald Exp $";
    private Vector cmdlist;
    private int last = -1;
    private boolean commit;

    public MultiCommand(Vector vector, boolean bl) {
        this.cmdlist = vector;
        this.cmdtype = 7;
        this.commit = bl;
    }

    @Override
    public String getName() {
        String string = "Multicommand (" + this.last + "/" + this.cmdlist.size() + ")";
        return string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        this.last = 0;
        while (this.last < this.cmdlist.size()) {
            systemEnvironment.tx.beginSubTransaction(systemEnvironment);
            Node node = (Node)this.cmdlist.get(this.last);
            if (!(this.env.isUser() ? (node.cmdtype & 1) != 0 : (this.env.isJobServer() ? (node.cmdtype & 2) != 0 : (node.cmdtype & 4) != 0))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304101137", "Illegal commandtype within multicommand"));
            }
            node.env = this.env;
            try {
                node.go(systemEnvironment);
            }
            catch (SDMSException sDMSException) {
                SDMSMessage sDMSMessage = sDMSException.toSDMSMessage();
                sDMSMessage.setMessage("Error in Statement " + (this.last + 1) + " (" + node.getName() + ") : " + sDMSMessage.getMessage());
                sDMSException.setMessage(sDMSMessage);
                throw sDMSException;
            }
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            ++this.last;
        }
        if (!this.commit) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03704251206", "Abort by user request (Rollback option specified)"));
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204041823", "$1 Command(s) processed", this.cmdlist.size()));
    }
}

