/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeConfig;
import de.independit.scheduler.server.repository.SDMSScopeConfigEnvMapping;
import de.independit.scheduler.server.repository.SDMSScopeConfigEnvMappingProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScopeConfigEnvMappingTable;
import de.independit.scheduler.server.repository.SDMSScopeConfigProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScopeConfigTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;

public class ScopeConfig {
    public static final String __version = "@(#) $Id: ScopeConfig.java,v 2.9.8.1 2013/03/14 10:24:47 ronald Exp $";
    public static final String PREFIX_SCOPEID = ".";
    public static final String PREFIX_ANCEST_VALUE = ";";
    public static final String PREFIX_ANCEST_SCOPE = ":";
    private static final HashSet ADMIN_GID = new HashSet();

    public static final boolean isInternalEntry(String string) {
        return string.startsWith(PREFIX_SCOPEID) || string.startsWith(PREFIX_ANCEST_VALUE) || string.startsWith(PREFIX_ANCEST_SCOPE);
    }

    public static final void create(SystemEnvironment systemEnvironment, Long l, WithHash withHash) throws SDMSException {
        if (withHash == null) {
            return;
        }
        Vector vector = new Vector(withHash.keySet());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            Object v = withHash.get(string);
            if (v == null) continue;
            try {
                if (string.equals("ENV")) {
                    ScopeConfig.createEnvMappings(systemEnvironment, l, (WithHash)v);
                    continue;
                }
                ScopeConfig.createConfig(systemEnvironment, l, string, (String)v);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04307151709", "invalid CONFIG: " + string));
            }
        }
    }

    private static final void createConfig(SystemEnvironment systemEnvironment, Long l, String string, String string2) throws SDMSException {
        String string3 = "=" + string2;
        SDMSScopeConfigTable.table.create(systemEnvironment, string, string3, l);
    }

    private static final void createEnvMappings(SystemEnvironment systemEnvironment, Long l, WithHash withHash) throws SDMSException {
        Vector vector = new Vector(withHash.keySet());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            String string2 = "=" + (String)withHash.get(string);
            SDMSScopeConfigEnvMappingTable.table.create(systemEnvironment, string, string2, l);
        }
    }

    public static final void kill(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        Long l = sDMSScope.getId(systemEnvironment);
        ScopeConfig.killConfig(systemEnvironment, l);
        ScopeConfig.killEnvMappings(systemEnvironment, l);
        ScopeConfig.markAltered(systemEnvironment, sDMSScope);
    }

    private static final void killConfig(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSScopeConfigTable.idx_sId.getVector(systemEnvironment, l);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSScopeConfig sDMSScopeConfig = (SDMSScopeConfig)vector.get(i);
            sDMSScopeConfig.delete(systemEnvironment);
        }
    }

    private static final void killEnvMappings(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSScopeConfigEnvMappingTable.idx_sId.getVector(systemEnvironment, l);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSScopeConfigEnvMapping sDMSScopeConfigEnvMapping = (SDMSScopeConfigEnvMapping)vector.get(i);
            sDMSScopeConfigEnvMapping.delete(systemEnvironment);
        }
    }

    public static final void copy(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSProxy sDMSProxy;
        int n;
        Vector vector = SDMSScopeConfigTable.idx_sId.getVector(systemEnvironment, l);
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            sDMSProxy = (SDMSScopeConfig)vector.get(n);
            SDMSScopeConfigTable.table.create(systemEnvironment, ((SDMSScopeConfigProxyGeneric)sDMSProxy).getKey(systemEnvironment), ((SDMSScopeConfigProxyGeneric)sDMSProxy).getValue(systemEnvironment), l2);
        }
        vector = SDMSScopeConfigEnvMappingTable.idx_sId.getVector(systemEnvironment, l);
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            sDMSProxy = (SDMSScopeConfigEnvMapping)vector.get(n);
            SDMSScopeConfigEnvMappingTable.table.create(systemEnvironment, ((SDMSScopeConfigEnvMappingProxyGeneric)sDMSProxy).getKey(systemEnvironment), ((SDMSScopeConfigEnvMappingProxyGeneric)sDMSProxy).getValue(systemEnvironment), l2);
        }
        ScopeConfig.markAltered(systemEnvironment, SDMSScopeTable.getObject(systemEnvironment, l2));
    }

    public static final void markAltered(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        Vector vector = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, sDMSScope.getId(systemEnvironment));
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ScopeConfig.markAltered(systemEnvironment, (SDMSScope)vector.get(i));
        }
        if (sDMSScope.getType(systemEnvironment) == 2) {
            try {
                systemEnvironment.cEnv.pushGid(systemEnvironment, ADMIN_GID);
                sDMSScope.setHasAlteredConfig(systemEnvironment, Boolean.TRUE);
                systemEnvironment.cEnv.popGid(systemEnvironment);
            }
            catch (Throwable throwable) {
                systemEnvironment.cEnv.popGid(systemEnvironment);
                throw throwable;
            }
        }
    }

    public static final void alter(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, WithHash withHash) throws SDMSException {
        if (withHash == null) {
            ScopeConfig.kill(systemEnvironment, sDMSScope);
        } else {
            Long l = sDMSScope.getId(systemEnvironment);
            Vector vector = new Vector(withHash.keySet());
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)vector.get(i);
                Object v = withHash.get(string);
                try {
                    SDMSScopeConfig sDMSScopeConfig;
                    if (string.equals("ENV")) {
                        ScopeConfig.killEnvMappings(systemEnvironment, l);
                        if (v == null) continue;
                        ScopeConfig.createEnvMappings(systemEnvironment, l, (WithHash)v);
                        continue;
                    }
                    if (string.startsWith("NAME_PATTERN_") && v != null) {
                        try {
                            ((String)v).matches((String)v);
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw new CommonErrorException(String.valueOf(new SDMSMessage(systemEnvironment, "03910051735", "invalid regular expression : '" + (String)v)) + "' for rule " + string);
                        }
                    }
                    try {
                        sDMSScopeConfig = (SDMSScopeConfig)SDMSScopeConfigTable.idx_scopeId_key.getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
                    }
                    catch (NotFoundException notFoundException) {
                        sDMSScopeConfig = null;
                    }
                    String string2 = null;
                    if (v != null) {
                        string2 = "=" + (String)v;
                    }
                    if (string2 == null && sDMSScopeConfig == null || string2 != null && sDMSScopeConfig != null && string2.equals(sDMSScopeConfig.getValue(systemEnvironment))) continue;
                    if (string.equals("JOBFILEPREFIX")) {
                        Vector vector2 = ScopeConfig.collectJobserver(systemEnvironment, sDMSScope);
                        for (int j = 0; j < vector2.size(); ++j) {
                            SDMSScope sDMSScope2 = (SDMSScope)vector2.get(j);
                            Long l2 = sDMSScope2.getId(systemEnvironment);
                            Vector vector3 = SDMSSubmittedEntityTable.idx_scopeId.getVector(systemEnvironment, l2);
                            for (int k = 0; k < vector3.size(); ++k) {
                                SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)vector3.get(k);
                                int n2 = sDMSSubmittedEntity.getState(systemEnvironment);
                                if (n2 != 5 && n2 != 6 && n2 != 7 && n2 != 13 && n2 != 8 && n2 != 9) continue;
                                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03703151451", "The job file prefix cannot be altered as long as there are running jobs"));
                            }
                        }
                    }
                    if (v != null) {
                        if (sDMSScopeConfig != null) {
                            sDMSScopeConfig.setValue(systemEnvironment, string2);
                            continue;
                        }
                        SDMSScopeConfigTable.table.create(systemEnvironment, string, string2, l);
                        continue;
                    }
                    if (sDMSScopeConfig == null) continue;
                    sDMSScopeConfig.delete(systemEnvironment);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04307151738", "invalid CONFIG: " + string));
                }
            }
        }
        ScopeConfig.markAltered(systemEnvironment, sDMSScope);
    }

    private static Vector collectJobserver(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        Vector<SDMSScope> vector = new Vector<SDMSScope>();
        if (sDMSScope.getType(systemEnvironment) == 2) {
            vector.add(sDMSScope);
        } else {
            Vector vector2 = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, sDMSScope.getId(systemEnvironment));
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addAll(ScopeConfig.collectJobserver(systemEnvironment, (SDMSScope)vector2.get(i)));
            }
        }
        return vector;
    }

    public static final String getItem(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, String string) throws SDMSException {
        return ScopeConfig.getItem(systemEnvironment, sDMSScope, string, true);
    }

    public static final String getItem(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, String string, boolean bl) throws SDMSException {
        if (string == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        ScopeConfig.collect(systemEnvironment, sDMSScope, hashMap, null, null, bl);
        return (String)hashMap.get(string);
    }

    public static final SDMSOutputContainer get(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        return ScopeConfig.get(systemEnvironment, sDMSScope, true);
    }

    public static final SDMSOutputContainer get(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, boolean bl) throws SDMSException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap hashMap2 = new HashMap();
        HashSet hashSet = new HashSet();
        hashMap.put("REPOUSER", ScopeConfig.quotedPath(systemEnvironment, sDMSScope.getId(systemEnvironment)));
        String string = sDMSScope.getPasswd(systemEnvironment);
        if (string != null) {
            hashMap.put("REPOPASS", string);
        }
        ScopeConfig.collect(systemEnvironment, sDMSScope, hashMap, hashMap2, hashSet, bl);
        Vector<String> vector = new Vector<String>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector vector3 = new Vector(hashMap.keySet());
        int n = vector3.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector3.get(i);
            vector.add(string2);
            vector2.add(hashMap.get(string2));
        }
        if (!hashMap2.isEmpty()) {
            vector.add("ENV");
            vector2.add(hashMap2);
        }
        if (!hashSet.isEmpty()) {
            vector.add("DYNAMIC");
            vector2.add(hashSet);
        }
        return new SDMSOutputContainer(systemEnvironment, "Jobserver Config", vector, vector2);
    }

    private static final String quotedPath(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
        Object object = Dump.quotedName(l, sDMSScope.getName(systemEnvironment));
        Long l2 = sDMSScope.getParentId(systemEnvironment);
        if (l2 != null) {
            object = ScopeConfig.quotedPath(systemEnvironment, l2) + PREFIX_SCOPEID + (String)object;
        }
        return object;
    }

    private static final void collect(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, HashMap hashMap, HashMap hashMap2, HashSet hashSet, boolean bl) throws SDMSException {
        String string;
        String string2;
        SDMSProxy sDMSProxy;
        int n;
        int n2;
        Vector vector;
        Comparable comparable;
        Long l = sDMSScope.getParentId(systemEnvironment);
        if (l != null) {
            comparable = SDMSScopeTable.getObject(systemEnvironment, l);
            ScopeConfig.collect(systemEnvironment, comparable, hashMap, hashMap2, hashSet, bl);
        }
        comparable = sDMSScope.getId(systemEnvironment);
        if (hashMap != null) {
            vector = SDMSScopeConfigTable.idx_sId.getVectorForUpdate(systemEnvironment, comparable);
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                sDMSProxy = (SDMSScopeConfig)vector.get(n);
                string2 = ((SDMSScopeConfigProxyGeneric)sDMSProxy).getKey(systemEnvironment);
                string = ((SDMSScopeConfigProxyGeneric)sDMSProxy).getValue(systemEnvironment).substring(1);
                if (bl && (string2.equals("TRUSTSTOREPASSWORD") || string2.equals("KEYSTOREPASSWORD"))) {
                    string = "";
                    if (hashMap.containsKey(string2)) {
                        hashMap.put(PREFIX_ANCEST_VALUE + string2, string);
                        hashMap.put(PREFIX_ANCEST_SCOPE + string2, hashMap.get(PREFIX_SCOPEID + string2));
                    }
                } else if (hashMap.containsKey(string2)) {
                    hashMap.put(PREFIX_ANCEST_VALUE + string2, hashMap.get(string2));
                    hashMap.put(PREFIX_ANCEST_SCOPE + string2, hashMap.get(PREFIX_SCOPEID + string2));
                }
                hashMap.put(string2, string);
                hashMap.put(PREFIX_SCOPEID + string2, comparable);
            }
        }
        if (hashMap2 != null) {
            vector = SDMSScopeConfigEnvMappingTable.idx_sId.getVector(systemEnvironment, comparable);
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                sDMSProxy = (SDMSScopeConfigEnvMapping)vector.get(n);
                string2 = ((SDMSScopeConfigEnvMappingProxyGeneric)sDMSProxy).getKey(systemEnvironment);
                string = ((SDMSScopeConfigEnvMappingProxyGeneric)sDMSProxy).getValue(systemEnvironment).substring(1);
                if (hashMap2.containsKey(string2)) {
                    hashMap2.put(PREFIX_ANCEST_VALUE + string2, hashMap2.get(string2));
                    hashMap2.put(PREFIX_ANCEST_SCOPE + string2, hashMap2.get(PREFIX_SCOPEID + string2));
                }
                hashMap2.put(string2, string);
                hashMap2.put(PREFIX_SCOPEID + string2, comparable);
            }
        }
        if (hashSet != null) {
            vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, comparable);
            n2 = vector.size();
            block6: for (n = 0; n < n2; ++n) {
                sDMSProxy = (SDMSParameterDefinition)vector.get(n);
                string2 = ((SDMSParameterDefinitionProxyGeneric)sDMSProxy).getName(systemEnvironment);
                switch (((SDMSParameterDefinitionProxyGeneric)sDMSProxy).getType(systemEnvironment)) {
                    case 80: {
                        hashSet.add(string2);
                        continue block6;
                    }
                    case 81: {
                        continue block6;
                    }
                    default: {
                        if (!hashSet.contains(string2)) continue block6;
                        hashSet.remove(string2);
                    }
                }
            }
        }
    }

    private ScopeConfig() {
    }

    static {
        ADMIN_GID.add(SDMSObject.adminGId);
    }
}

