/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.Formatter;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.util.MasterReservationInfo;
import de.independit.scheduler.server.util.PathVector;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

class SsResourceScopeFormatter
implements Formatter {
    private static final String ALLOCATED = "ALLOCATED";
    private static final String RESERVED = "RESERVED";
    private static final String IGNORE = "IGNORE";
    private static final String BLOCKED = "BLOCKED";
    private static final String AVAILABLE = "AVAILABLE";
    SDMSSubmittedEntity sme;
    SDMSSchedulingEntity se;
    Long seId;
    Long smeId;
    long actVersion;

    public SsResourceScopeFormatter(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        this.sme = sDMSSubmittedEntity;
        this.initialize(systemEnvironment);
    }

    private void initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        this.actVersion = this.sme.getSeVersion(systemEnvironment);
        this.se = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.sme.getSeId(systemEnvironment), this.actVersion);
        this.seId = this.se.getId(systemEnvironment);
        this.smeId = this.sme.getId(systemEnvironment);
    }

    @Override
    public Vector fillHeadInfo() {
        Vector<String> vector = new Vector<String>();
        vector.add("SCOPE_ID");
        vector.add("SCOPE_NAME");
        vector.add("SCOPE_TYPE");
        vector.add("SCOPE_PRIVS");
        vector.add("RESOURCE_ID");
        vector.add("RESOURCE_NAME");
        vector.add("RESOURCE_USAGE");
        vector.add("RESOURCE_OWNER");
        vector.add("RESOURCE_PRIVS");
        vector.add("RESOURCE_STATE");
        vector.add("RESOURCE_TIMESTAMP");
        vector.add("REQUESTABLE_AMOUNT");
        vector.add("TOTAL_AMOUNT");
        vector.add("FREE_AMOUNT");
        vector.add("REQUESTED_AMOUNT");
        vector.add("REQUESTED_LOCKMODE");
        vector.add("REQUESTED_STATES");
        vector.add("RESERVED_AMOUNT");
        vector.add("ALLOCATED_AMOUNT");
        vector.add("ALLOCATED_LOCKMODE");
        vector.add(IGNORE);
        vector.add("STICKY");
        vector.add("STICKY_NAME");
        vector.add("STICKY_PARENT");
        vector.add("STICKY_PARENT_TYPE");
        vector.add("ONLINE");
        vector.add("ALLOCATE_STATE");
        vector.add("EXPIRE");
        vector.add("EXPIRE_SIGN");
        vector.add("IGNORE_ON_RERUN");
        vector.add("DEFINITION");
        return vector;
    }

    @Override
    public Vector fillVector(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, HashSet hashSet) throws SDMSException {
        if (sDMSProxy instanceof SDMSScope) {
            return this.fillVector(systemEnvironment, (SDMSScope)sDMSProxy);
        }
        return this.fillVector(systemEnvironment, (SDMSResource)sDMSProxy);
    }

    private Vector fillVector(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        Vector<Object> vector = new Vector<Object>();
        Long l = sDMSScope.getId(systemEnvironment);
        PathVector pathVector = sDMSScope.pathVector(systemEnvironment);
        vector.add(l);
        vector.add(pathVector);
        vector.add(sDMSScope.getTypeAsString(systemEnvironment));
        vector.add(sDMSScope.getPrivileges(systemEnvironment).toString());
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(Boolean.FALSE);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(sDMSScope.isConnected(systemEnvironment));
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(pathVector);
        return vector;
    }

    private Vector fillVector(SystemEnvironment systemEnvironment, SDMSResource sDMSResource) throws SDMSException {
        Date date;
        SDMSProxy sDMSProxy;
        Vector<Object> vector = new Vector<Object>();
        Long l = sDMSResource.getScopeId(systemEnvironment);
        SDMSScope sDMSScope = null;
        SDMSFolder sDMSFolder = null;
        SDMSSchedulingEntity sDMSSchedulingEntity = null;
        try {
            sDMSProxy = sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
        }
        catch (NotFoundException notFoundException) {
            sDMSScope = SDMSScopeTable.idx_parentId_name_getUnique(systemEnvironment, new SDMSKey(null, (Comparable)((Object)"GLOBAL")));
            try {
                sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l);
                sDMSProxy = sDMSFolder;
            }
            catch (NotFoundException notFoundException2) {
                SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                sDMSProxy = sDMSSchedulingEntity;
            }
        }
        PathVector pathVector = sDMSScope.pathVector(systemEnvironment);
        Long l2 = sDMSResource.getNrId(systemEnvironment);
        Long l3 = sDMSResource.getId(systemEnvironment);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l2);
        Long l4 = sDMSResource.getRsdId(systemEnvironment);
        SDMSResourceStateDefinition sDMSResourceStateDefinition = null;
        SDMSResourceRequirementProxyGeneric sDMSResourceRequirementProxyGeneric = null;
        if (l4 != null) {
            sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l4);
        }
        vector.add(l);
        vector.add(pathVector);
        if (sDMSProxy instanceof SDMSScope) {
            vector.add(sDMSScope.getTypeAsString(systemEnvironment));
        } else if (sDMSProxy instanceof SDMSFolder) {
            vector.add("FOLDER");
        } else {
            vector.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
        }
        vector.add(sDMSScope.getPrivileges(systemEnvironment).toString());
        vector.add(l3);
        vector.add(sDMSNamedResource.pathVector(systemEnvironment));
        vector.add(sDMSNamedResource.getUsageAsString(systemEnvironment));
        vector.add(SDMSGroupTable.getObject(systemEnvironment, sDMSResource.getOwnerId(systemEnvironment)).getName(systemEnvironment));
        vector.add(sDMSResource.getPrivileges(systemEnvironment).toString());
        vector.add(sDMSResourceStateDefinition == null ? null : sDMSResourceStateDefinition.getName(systemEnvironment));
        Long l5 = sDMSResource.getRsdTime(systemEnvironment);
        if (l5 != null && sDMSNamedResource.getUsage(systemEnvironment) == 4 && sDMSNamedResource.getRspId(systemEnvironment) != null) {
            long l6 = l5;
            date = new Date();
            date.setTime(l6);
            vector.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector.add(null);
        }
        Integer n = sDMSResource.getRequestableAmount(systemEnvironment);
        vector.add(n == null ? "INFINITE" : n);
        n = sDMSResource.getAmount(systemEnvironment);
        vector.add(n == null ? "INFINITE" : n);
        n = sDMSResource.getFreeAmount(systemEnvironment);
        vector.add(n == null ? "INFINITE" : n);
        try {
            switch (sDMSNamedResource.getUsage(systemEnvironment)) {
                case 1: {
                    sDMSResourceRequirementProxyGeneric = null;
                    break;
                }
                case 2: {
                    try {
                        sDMSResourceRequirementProxyGeneric = SDMSResourceRequirementTable.idx_seId_nrId_getUnique(systemEnvironment, new SDMSKey(this.seId, l2), this.actVersion);
                    }
                    catch (NotFoundException notFoundException) {
                        sDMSResourceRequirementProxyGeneric = SDMSResourceRequirementTable.idx_seId_nrId_getUnique(systemEnvironment, new SDMSKey(this.se.getFpId(systemEnvironment), l2), this.actVersion);
                    }
                    break;
                }
                case 4: {
                    sDMSResourceRequirementProxyGeneric = SDMSResourceRequirementTable.idx_seId_nrId_getUnique(systemEnvironment, new SDMSKey(this.seId, l2), this.actVersion);
                }
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (sDMSResourceRequirementProxyGeneric == null) {
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(Boolean.FALSE);
            vector.add(Boolean.FALSE);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(sDMSResource.getIsOnline(systemEnvironment));
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(pathVector);
        } else {
            Object object;
            SDMSResourceAllocation sDMSResourceAllocation;
            SDMSProxy sDMSProxy2;
            vector.add(sDMSResourceRequirementProxyGeneric.getAmount(systemEnvironment));
            vector.add(sDMSResourceRequirementProxyGeneric.getLockmodeAsString(systemEnvironment));
            Vector vector2 = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, sDMSResourceRequirementProxyGeneric.getId(systemEnvironment));
            Object object2 = new String();
            String string = "";
            int n2 = vector2.size();
            for (int i = 0; i < n2; ++i) {
                sDMSProxy2 = (SDMSResourceReqStates)vector2.get(i);
                object2 = (String)object2 + string + SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSProxy2.getRsdId(systemEnvironment)).getName(systemEnvironment);
                string = ",";
            }
            vector.add(object2);
            try {
                sDMSResourceAllocation = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(this.smeId, l3, (Comparable)((Object)sDMSResourceRequirementProxyGeneric.getStickyName(systemEnvironment))));
                if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 4) {
                    vector.add(SDMSConstants.iZERO);
                    vector.add(sDMSResourceAllocation.getAmount(systemEnvironment));
                    vector.add(sDMSResourceAllocation.getLockmodeAsString(systemEnvironment));
                } else if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 2) {
                    vector.add(sDMSResourceAllocation.getAmount(systemEnvironment));
                    vector.add(SDMSConstants.iZERO);
                    vector.add(sDMSResourceAllocation.getLockmodeAsString(systemEnvironment));
                } else {
                    vector.add(SDMSConstants.iZERO);
                    vector.add(SDMSConstants.iZERO);
                    vector.add(null);
                }
            }
            catch (NotFoundException notFoundException) {
                try {
                    sDMSResourceAllocation = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(Long.valueOf(-this.smeId.longValue()), l3, (Comparable)((Object)sDMSResourceRequirementProxyGeneric.getStickyName(systemEnvironment))));
                    vector.add(sDMSResourceAllocation.getAmount(systemEnvironment));
                    vector.add(SDMSConstants.iZERO);
                    vector.add(sDMSResourceAllocation.getLockmodeAsString(systemEnvironment));
                }
                catch (NotFoundException notFoundException3) {
                    sDMSResourceAllocation = null;
                    vector.add(null);
                    vector.add(null);
                    vector.add(null);
                }
            }
            vector.add(Boolean.FALSE);
            vector.add(sDMSResourceRequirementProxyGeneric.getIsSticky(systemEnvironment));
            vector.add(sDMSResourceRequirementProxyGeneric.getStickyName(systemEnvironment));
            sDMSProxy2 = null;
            if (sDMSResourceAllocation == null) {
                Long l7 = sDMSResourceRequirementProxyGeneric.getStickyParent(systemEnvironment);
                vector.add(l7);
                if (l7 != null) {
                    sDMSProxy2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l7, this.actVersion);
                }
            } else {
                Long l8 = sDMSResourceAllocation.getStickyParent(systemEnvironment);
                vector.add(l8);
                if (l8 != null) {
                    object = SDMSSubmittedEntityTable.getObject(systemEnvironment, l8);
                    sDMSProxy2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSSubmittedEntityProxyGeneric)object).getSeId(systemEnvironment), this.actVersion);
                }
            }
            if (sDMSProxy2 != null) {
                vector.add(((SDMSSchedulingEntityProxyGeneric)sDMSProxy2).getTypeAsString(systemEnvironment));
            } else {
                vector.add(null);
            }
            vector.add(sDMSResource.getIsOnline(systemEnvironment));
            if (sDMSResourceAllocation != null) {
                if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 4) {
                    vector.add(ALLOCATED);
                } else if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 2) {
                    vector.add(RESERVED);
                } else if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 5) {
                    vector.add(IGNORE);
                } else if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 3) {
                    vector.add(ALLOCATED);
                } else if (sDMSResource.checkAllocate(systemEnvironment, (SDMSResourceRequirement)sDMSResourceRequirementProxyGeneric, this.sme, sDMSResourceAllocation) == 0) {
                    if (SystemEnvironment.sched.isBlocked(systemEnvironment, this.smeId, sDMSResource.getId(systemEnvironment))) {
                        vector.add(BLOCKED);
                    } else if (sDMSResourceAllocation.getIsSticky(systemEnvironment).booleanValue()) {
                        object = SystemEnvironment.sched.checkMasterReservation(systemEnvironment, this.sme, (SDMSResourceRequirement)sDMSResourceRequirementProxyGeneric, sDMSResourceAllocation.getStickyParent(systemEnvironment), sDMSResource);
                        if (((MasterReservationInfo)object).canAllocate) {
                            vector.add(AVAILABLE);
                        } else {
                            vector.add(BLOCKED);
                        }
                    } else {
                        vector.add(AVAILABLE);
                    }
                } else {
                    vector.add(BLOCKED);
                }
            } else if (sDMSResource.checkAllocate(systemEnvironment, (SDMSResourceRequirement)sDMSResourceRequirementProxyGeneric, this.sme, sDMSResourceAllocation) == 0) {
                vector.add(AVAILABLE);
            } else {
                vector.add(BLOCKED);
            }
            object = sDMSResourceRequirementProxyGeneric.getExpiredBase(systemEnvironment);
            if (object != null) {
                if (sDMSNamedResource.getRspId(systemEnvironment) != null) {
                    String string2;
                    long l9;
                    long l10 = sDMSResourceRequirementProxyGeneric.getExpiredAmount(systemEnvironment).longValue();
                    switch ((Integer)object) {
                        case 0: {
                            l10 *= 60000L;
                            break;
                        }
                        case 1: {
                            l10 *= 3600000L;
                            break;
                        }
                        case 2: {
                            l10 *= 86400000L;
                            break;
                        }
                        case 3: {
                            l10 *= 604800000L;
                            break;
                        }
                        case 4: {
                            l10 *= 2592000000L;
                            break;
                        }
                        case 5: {
                            l10 *= 31536000000L;
                        }
                    }
                    date = new Date();
                    if (l10 == 0L) {
                        l9 = this.sme.getSyncTs(systemEnvironment);
                        string2 = "+";
                    } else if (l10 > 0L) {
                        l9 = date.getTime() - l10;
                        string2 = "+";
                    } else {
                        l9 = date.getTime() + l10;
                        string2 = "-";
                    }
                    date.setTime(l9);
                    vector.add(systemEnvironment.systemDateFormat.format(date));
                    vector.add(string2);
                    vector.add(sDMSResourceRequirementProxyGeneric.getIgnoreOnRerun(systemEnvironment));
                } else {
                    vector.add(null);
                    vector.add(null);
                    vector.add(null);
                }
            } else {
                vector.add(null);
                vector.add(null);
                vector.add(null);
            }
            if (sDMSProxy instanceof SDMSScope) {
                vector.add(pathVector);
            } else if (sDMSProxy instanceof SDMSFolder) {
                vector.add(sDMSFolder.pathVector(systemEnvironment));
            } else {
                vector.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
            }
        }
        return vector;
    }
}

