/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventProxyGeneric;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SeNameFilter
extends Filter {
    public static final String __version = "@(#) $Id: SeNameFilter.java,v 2.6.2.1 2013/03/14 10:25:16 ronald Exp $";
    String seName;
    Pattern pattern;

    public SeNameFilter(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.seName = string;
        boolean bl = true;
        boolean bl2 = false;
        if (string.contains("*") || string.contains("+") || string.contains("[") || string.contains("]") || string.contains(")")) {
            if (string.contains("%")) {
                bl = false;
            } else {
                try {
                    this.pattern = Pattern.compile(this.seName);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03310071127", "Error in regular expression"));
                }
                return;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '[') {
                bl2 = true;
            }
            if (!bl2) {
                if (c == '_' && bl) {
                    stringBuffer2.append('.');
                    continue;
                }
                if (c == '%') {
                    stringBuffer2.append(".*");
                    continue;
                }
                if (c == '\\' && (var4_9 = i + 1) < stringBuffer.length()) {
                    var6_11 = stringBuffer.charAt(var4_9);
                    if (var6_11 == '_' || var6_11 == '%') {
                        i = var4_9;
                        c = var6_11;
                    } else if (var6_11 == '\\' || var6_11 == '[') {
                        i = var4_9;
                        stringBuffer2.append(c);
                        c = var6_11;
                    }
                }
            } else {
                if (c == ']') {
                    bl2 = false;
                }
                if (c == '\\' && (var4_9 = i + 1) < stringBuffer.length() && ((var6_11 = stringBuffer.charAt(var4_9)) == '\\' || var6_11 == ']')) {
                    i = var4_9;
                    stringBuffer2.append(c);
                    c = var6_11;
                }
            }
            stringBuffer2.append(c);
        }
        this.seName = new String(stringBuffer2);
        try {
            this.pattern = Pattern.compile(this.seName);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03310071126", "Error in regular expression"));
        }
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        String string = null;
        Long l = sDMSProxy.getId(systemEnvironment);
        if (systemEnvironment.tx.txData.containsKey("SE_NAMEFILTER_CACHE")) {
            var9_5 = (SeNameFilterCache)systemEnvironment.tx.txData.get("SE_NAMEFILTER_CACHE");
            if (!var9_5.id.equals(l)) {
                var9_5.id = l;
                var9_5.name = null;
            } else {
                string = var9_5.name;
            }
        } else {
            var9_5 = new SeNameFilterCache(this);
            var9_5.id = l;
            systemEnvironment.tx.txData.put("SE_NAMEFILTER_CACHE", var9_5);
        }
        try {
            Object object;
            if (string == null) {
                string = "";
                if (sDMSProxy instanceof SDMSSubmittedEntity) {
                    SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
                    long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l2);
                    string = sDMSSchedulingEntity.pathString(systemEnvironment, l2);
                } else if (sDMSProxy instanceof SDMSSchedulingEntity) {
                    SDMSSchedulingEntity sDMSSchedulingEntity = (SDMSSchedulingEntity)sDMSProxy;
                    long l3 = systemEnvironment.tx.versionId;
                    string = sDMSSchedulingEntity.pathString(systemEnvironment, l3);
                } else if (sDMSProxy instanceof SDMSFolder) {
                    SDMSFolder sDMSFolder = (SDMSFolder)sDMSProxy;
                    long l4 = systemEnvironment.tx.versionId;
                    string = sDMSFolder.pathString(systemEnvironment, l4);
                } else if (sDMSProxy instanceof SDMSCalendar) {
                    object = SDMSScheduledEventTable.getObject(systemEnvironment, ((SDMSCalendar)sDMSProxy).getScevId(systemEnvironment));
                    SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, ((SDMSScheduledEventProxyGeneric)object).getEvtId(systemEnvironment));
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSEvent.getSeId(systemEnvironment));
                    long l5 = systemEnvironment.tx.versionId;
                    string = sDMSSchedulingEntity.pathString(systemEnvironment, l5);
                } else if (sDMSProxy instanceof SDMSScheduledEvent) {
                    object = SDMSEventTable.getObject(systemEnvironment, ((SDMSScheduledEvent)sDMSProxy).getEvtId(systemEnvironment));
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSEventProxyGeneric)object).getSeId(systemEnvironment));
                    long l6 = systemEnvironment.tx.versionId;
                    string = sDMSSchedulingEntity.pathString(systemEnvironment, l6);
                }
                var9_5.name = string;
            }
            object = this.pattern.matcher(string);
            return ((Matcher)object).matches();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SeNameFilter)) {
            return false;
        }
        SeNameFilter seNameFilter = (SeNameFilter)object;
        return this.seName.equals(seNameFilter.seName);
    }

    class SeNameFilterCache {
        protected Long id = null;
        protected String name = null;

        SeNameFilterCache(SeNameFilter seNameFilter) {
        }
    }
}

