/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.triggerexpr;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.triggerexpr.ParseObject;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class ExprParser {
    private int stop = 0;
    private SDMSSubmittedEntity sme = null;
    private SDMSSubmittedEntity requiredSme = null;
    private SDMSResource r = null;
    private SDMSTrigger t = null;
    private SDMSTriggerQueue tq = null;
    private SystemEnvironment sysEnv = null;
    private SDMSScope evalScope = null;
    public boolean checkOnly = false;
    private static boolean debug = SystemEnvironment.traceExpressions;
    public static final String S_TIMES_CHECKED = "TIMES_CHECKED";
    public static final String S_TIMES_FIRED = "TIMES_FIRED";
    private static final String emptyString = "";
    private static Integer I_PLUS = 278;
    private static Integer I_MINUS = 276;
    private static Integer I_TIMES = 279;
    private static Integer I_DIV = 275;
    private static Integer I_MOD = 277;
    private static Integer I_GT = 268;
    private static Integer I_GE = 269;
    private static Integer I_LT = 270;
    private static Integer I_LE = 271;
    private static Integer I_EQ = 267;
    private static Integer I_NE = 272;
    private static Integer I_MATCHES = 273;
    private static Integer I_NOMATCH = 274;
    public static final int STRING = 257;
    public static final int IDENTIFIER = 258;
    public static final int PARAMETER = 259;
    public static final int JPARAMETER = 260;
    public static final int RPARAMETER = 261;
    public static final int TPARAMETER = 262;
    public static final int RSPARAMETER = 263;
    public static final int DSPARAMETER = 264;
    public static final int NUMBER = 265;
    public static final int BOOLEAN = 266;
    public static final int EQ = 267;
    public static final int GT = 268;
    public static final int GE = 269;
    public static final int LT = 270;
    public static final int LE = 271;
    public static final int NE = 272;
    public static final int MATCHES = 273;
    public static final int NOMATCH = 274;
    public static final int DIV = 275;
    public static final int MINUS = 276;
    public static final int MOD = 277;
    public static final int PLUS = 278;
    public static final int TIMES = 279;
    public static final int ABS = 280;
    public static final int AND = 281;
    public static final int DATE = 282;
    public static final int FIELD = 283;
    public static final int INT = 284;
    public static final int LOWERCASE = 285;
    public static final int NOT = 286;
    public static final int NVL = 287;
    public static final int OR = 288;
    public static final int ROUND = 289;
    public static final int SUBSTR = 290;
    public static final int STR = 291;
    public static final int TRIM = 292;
    public static final int UPPERCASE = 293;
    public static final int yyErrorCode = 256;
    protected static final int yyFinal = 25;
    protected static short[] yyLhs;
    protected static short[] yyLen;
    protected static short[] yyDefRed;
    protected static short[] yyDgoto;
    protected static short[] yySindex;
    protected static short[] yyRindex;
    protected static short[] yyGindex;
    protected static short[] yyTable;
    protected static short[] yyCheck;
    protected static String[] yyNames;
    protected int yyMax;

    public ExprParser() {
        if (yyLhs == null) {
            try {
                InputStream inputStream;
                Class<?> clazz = this.getClass();
                String string = clazz.getPackage().getName().replace('.', '/') + "/parser.tables";
                try {
                    inputStream = clazz.getResourceAsStream("/" + string);
                }
                catch (Exception exception) {
                    inputStream = clazz.getResourceAsStream(string);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                yyLhs = ExprParser.loadShort(bufferedReader);
                yyLen = ExprParser.loadShort(bufferedReader);
                yyDefRed = ExprParser.loadShort(bufferedReader);
                yyDgoto = ExprParser.loadShort(bufferedReader);
                yySindex = ExprParser.loadShort(bufferedReader);
                yyRindex = ExprParser.loadShort(bufferedReader);
                yyGindex = ExprParser.loadShort(bufferedReader);
                yyTable = ExprParser.loadShort(bufferedReader);
                yyCheck = ExprParser.loadShort(bufferedReader);
                StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                stringTokenizer.nextToken();
                yyNames = new String[Integer.parseInt(stringTokenizer.nextToken())];
                int n = Integer.parseInt(stringTokenizer.nextToken());
                for (int i = 0; i < n; ++i) {
                    stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    ExprParser.yyNames[n2] = stringTokenizer.nextToken("\n").substring(1);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                throw new Error("cannot load parser tables [" + String.valueOf(exception) + "]");
            }
        }
    }

    protected static short[] loadShort(BufferedReader bufferedReader) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
        stringTokenizer.nextToken();
        short[] sArray = new short[Integer.parseInt(stringTokenizer.nextToken())];
        for (int i = 0; i < sArray.length; i += 10) {
            stringTokenizer = new StringTokenizer(bufferedReader.readLine(), ", \t\r\n");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                sArray[i + n] = Short.valueOf(stringTokenizer.nextToken());
                ++n;
            }
        }
        return sArray;
    }

    public void yyerror(String string) {
        this.yyerror(string, null);
    }

    public void yyerror(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            System.err.print(string + ", expecting");
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.print(" " + stringArray[i]);
            }
            System.err.println();
        } else {
            System.err.println(string);
        }
    }

    protected String[] yyExpecting(int n) {
        int n2;
        int n3 = 0;
        boolean[] blArray = new boolean[yyNames.length];
        int n4 = yySindex[n];
        if (n4 != 0) {
            int n5 = n2 = n4 < 0 ? -n4 : 0;
            while (n2 < yyNames.length && n4 + n2 < yyTable.length) {
                if (yyCheck[n4 + n2] == n2 && !blArray[n2] && yyNames[n2] != null) {
                    ++n3;
                    blArray[n2] = true;
                }
                ++n2;
            }
        }
        if ((n4 = yyRindex[n]) != 0) {
            int n6 = n2 = n4 < 0 ? -n4 : 0;
            while (n2 < yyNames.length && n4 + n2 < yyTable.length) {
                if (yyCheck[n4 + n2] == n2 && !blArray[n2] && yyNames[n2] != null) {
                    ++n3;
                    blArray[n2] = true;
                }
                ++n2;
            }
        }
        String[] stringArray = new String[n3];
        n2 = 0;
        n4 = 0;
        while (n4 < n3) {
            if (blArray[n2]) {
                stringArray[n4++] = yyNames[n2];
            }
            ++n2;
        }
        return stringArray;
    }

    public Object yyparse(yyInput yyInput2, Object object) throws IOException, yyException, SDMSException {
        return this.yyparse(yyInput2);
    }

    protected Object yyDefault(Object object) {
        return object;
    }

    /*
     * Exception decompiling
     */
    public Object yyparse(yyInput var1_1) throws IOException, yyException, SDMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ParseObject field(ParseObject parseObject) {
        return parseObject;
    }

    private void debuginfo(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    private ParseObject resolve(String string, int n) throws SDMSException {
        if (this.checkOnly) {
            return new ParseObject(emptyString);
        }
        String string2 = emptyString;
        switch (n) {
            case 260: {
                string2 = this.sme.getVariableValue(this.sysEnv, string, false, "LIBERAL", true, this.evalScope, true);
                break;
            }
            case 261: {
                if (this.r == null) break;
                string2 = this.r.getVariableValue(this.sysEnv, string, true);
                break;
            }
            case 262: {
                string2 = this.resolveTriggerVariable(string);
                if (string2 != null) break;
                string2 = emptyString;
                break;
            }
            case 263: {
                if (this.requiredSme != null) {
                    string2 = this.requiredSme.getVariableValue(this.sysEnv, string, false, "LIBERAL", true, this.evalScope, true);
                    break;
                }
                string2 = this.sme.getVariableValue(this.sysEnv, string, false, "LIBERAL", true, this.evalScope, true);
                break;
            }
            case 264: {
                string2 = this.sme.getVariableValue(this.sysEnv, string, false, "LIBERAL", true, this.evalScope, true);
                break;
            }
            case 259: {
                string2 = this.resolveTriggerVariable(string);
                if (string2 != null) {
                    return new ParseObject(string2);
                }
                string2 = this.sme != null ? this.sme.getVariableValue(this.sysEnv, string, false, "LIBERAL", true, this.evalScope, true) : (this.requiredSme != null ? this.requiredSme.getVariableValue(this.sysEnv, string, false, "LIBERAL", true, this.evalScope, true) : (this.r != null ? this.r.getVariableValue(this.sysEnv, string, true) : emptyString));
            }
        }
        this.debuginfo(string + " -> " + string2.toString());
        return new ParseObject(string2);
    }

    public void set(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSubmittedEntity sDMSSubmittedEntity2, SDMSResource sDMSResource, SDMSTrigger sDMSTrigger, SDMSTriggerQueue sDMSTriggerQueue, SDMSScope sDMSScope) {
        this.sysEnv = systemEnvironment;
        this.sme = sDMSSubmittedEntity;
        this.requiredSme = sDMSSubmittedEntity2;
        this.r = sDMSResource;
        this.t = sDMSTrigger;
        this.tq = sDMSTriggerQueue;
        this.evalScope = sDMSScope;
    }

    public String resolveTriggerVariable(String string) {
        if (this.tq == null) {
            return null;
        }
        try {
            if (string.equals(S_TIMES_CHECKED)) {
                return this.tq.getTimesChecked(this.sysEnv).toString();
            }
            if (string.equals(S_TIMES_FIRED)) {
                return this.tq.getTimesTriggered(this.sysEnv).toString();
            }
        }
        catch (SDMSException sDMSException) {
            // empty catch block
        }
        return null;
    }

    public static interface yyInput {
        public boolean advance() throws IOException, SDMSException;

        public int token();

        public Object value();
    }

    public static class yyException
    extends Exception {
        public yyException(String string) {
            super(string);
        }
    }
}

