/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSDependencyDefinitionGeneric
extends SDMSObject
implements Cloneable {
    public static final int IGNORE = 1;
    public static final int UH_IGNORE = 1;
    public static final int ERROR = 2;
    public static final int UH_ERROR = 2;
    public static final int SUSPEND = 3;
    public static final int UH_SUSPEND = 3;
    public static final int DEFER = 4;
    public static final int DEFER_IGNORE = 5;
    public static final int ALL_FINAL = 1;
    public static final int JOB_FINAL = 2;
    public static final int FINAL = 0;
    public static final int ALL_REACHABLE = 1;
    public static final int UNREACHABLE = 2;
    public static final int DEFAULT = 3;
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final int BOTH = 2;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final int nr_id = 1;
    public static final int nr_seDependentId = 2;
    public static final int nr_seRequiredId = 3;
    public static final int nr_name = 4;
    public static final int nr_unresolvedHandling = 5;
    public static final int nr_mode = 6;
    public static final int nr_stateSelection = 7;
    public static final int nr_condition = 8;
    public static final int nr_resolveMode = 9;
    public static final int nr_expiredAmount = 10;
    public static final int nr_expiredBase = 11;
    public static final int nr_selectCondition = 12;
    public static final int nr_creatorUId = 13;
    public static final int nr_createTs = 14;
    public static final int nr_changerUId = 15;
    public static final int nr_changeTs = 16;
    public static String tableName = "DEPENDENCY_DEFINITION";
    protected Long seDependentId;
    protected Long seRequiredId;
    protected String name;
    protected Integer unresolvedHandling;
    protected Integer mode;
    protected Integer stateSelection;
    protected String condition;
    protected Integer resolveMode;
    protected Integer expiredAmount;
    protected Integer expiredBase;
    protected String selectCondition;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSDependencyDefinitionGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Integer n, Integer n2, Integer n3, String string2, Integer n4, Integer n5, Integer n6, String string3, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSDependencyDefinitionTableGeneric.table);
        this.seDependentId = l;
        this.seRequiredId = l2;
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(DependencyDefinition) Length of $1 exceeds maximum length $2", "name", "64"));
        }
        this.name = string;
        this.unresolvedHandling = n;
        this.mode = n2;
        this.stateSelection = n3;
        if (string2 != null && string2.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(DependencyDefinition) Length of $1 exceeds maximum length $2", "condition", "1024"));
        }
        this.condition = string2;
        this.resolveMode = n4;
        this.expiredAmount = n5;
        this.expiredBase = n6;
        if (string3 != null && string3.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(DependencyDefinition) Length of $1 exceeds maximum length $2", "selectCondition", "1024"));
        }
        this.selectCondition = string3;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getSeDependentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seDependentId;
    }

    public void setSeDependentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seDependentId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
            }
            SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
            sDMSDependencyDefinitionGeneric.seDependentId = l;
            sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 9L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSeRequiredId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seRequiredId;
    }

    public void setSeRequiredId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seRequiredId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
            }
            SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
            sDMSDependencyDefinitionGeneric.seRequiredId = l;
            sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 10L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.name)) {
            return;
        }
        if (string == null && this.name == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
            }
            SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(DependencyDefinition) Length of $1 exceeds maximum length $2", "name", "64"));
            }
            sDMSDependencyDefinitionGeneric.name = string;
            sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getUnresolvedHandling(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.unresolvedHandling;
    }

    public String getUnresolvedHandlingAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getUnresolvedHandling(systemEnvironment);
        switch (n) {
            case 1: {
                return "IGNORE";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "SUSPEND";
            }
            case 4: {
                return "DEFER";
            }
            case 5: {
                return "DEFER_IGNORE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown DependencyDefinition.unresolvedHandling: $1", this.getUnresolvedHandling(systemEnvironment)));
    }

    public void setUnresolvedHandling(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.unresolvedHandling.equals(n)) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.unresolvedHandling = n;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public Integer getMode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.mode;
    }

    public String getModeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getMode(systemEnvironment);
        switch (n) {
            case 1: {
                return "ALL_FINAL";
            }
            case 2: {
                return "JOB_FINAL";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown DependencyDefinition.mode: $1", this.getMode(systemEnvironment)));
    }

    public void setMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.mode.equals(n)) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.mode = n;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public Integer getStateSelection(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.stateSelection;
    }

    public String getStateSelectionAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getStateSelection(systemEnvironment);
        switch (n) {
            case 0: {
                return "FINAL";
            }
            case 1: {
                return "ALL_REACHABLE";
            }
            case 2: {
                return "UNREACHABLE";
            }
            case 3: {
                return "DEFAULT";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown DependencyDefinition.stateSelection: $1", this.getStateSelection(systemEnvironment)));
    }

    public void setStateSelection(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.stateSelection.equals(n)) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.stateSelection = n;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public String getCondition(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.condition;
    }

    public void setCondition(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.condition)) {
            return;
        }
        if (string == null && this.condition == null) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(DependencyDefinition) Length of $1 exceeds maximum length $2", "condition", "1024"));
        }
        sDMSDependencyDefinitionGeneric.condition = string;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public Integer getResolveMode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resolveMode;
    }

    public String getResolveModeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getResolveMode(systemEnvironment);
        switch (n) {
            case 0: {
                return "INTERNAL";
            }
            case 1: {
                return "EXTERNAL";
            }
            case 2: {
                return "BOTH";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown DependencyDefinition.resolveMode: $1", this.getResolveMode(systemEnvironment)));
    }

    public void setResolveMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.resolveMode.equals(n)) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.resolveMode = n;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public Integer getExpiredAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.expiredAmount;
    }

    public void setExpiredAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.expiredAmount)) {
            return;
        }
        if (n == null && this.expiredAmount == null) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.expiredAmount = n;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public Integer getExpiredBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.expiredBase;
    }

    public String getExpiredBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getExpiredBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown DependencyDefinition.expiredBase: $1", this.getExpiredBase(systemEnvironment)));
    }

    public void setExpiredBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.expiredBase)) {
            return;
        }
        if (n == null && this.expiredBase == null) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.expiredBase = n;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public String getSelectCondition(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.selectCondition;
    }

    public void setSelectCondition(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.selectCondition)) {
            return;
        }
        if (string == null && this.selectCondition == null) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(DependencyDefinition) Length of $1 exceeds maximum length $2", "selectCondition", "1024"));
        }
        sDMSDependencyDefinitionGeneric.selectCondition = string;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.creatorUId = l;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyDefinition) Change of system object not allowed"));
        }
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.createTs = l;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.changerUId = l;
        sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric = this;
        if (sDMSDependencyDefinitionGeneric.versions.o_v == null || sDMSDependencyDefinitionGeneric.versions.o_v.size() == 0 || sDMSDependencyDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyDefinitionGeneric.changeTs = l;
        sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSDependencyDefinitionGeneric != this) {
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric, 0L);
        }
    }

    public SDMSDependencyDefinitionGeneric set_SeDependentIdSeRequiredId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSDependencyDefinitionGeneric sDMSDependencyDefinitionGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(DependencyDefinition) Change of system object not allowed"));
            }
            sDMSDependencyDefinitionGeneric = (SDMSDependencyDefinitionGeneric)this.change(systemEnvironment);
            sDMSDependencyDefinitionGeneric.seDependentId = l;
            sDMSDependencyDefinitionGeneric.seRequiredId = l2;
            sDMSDependencyDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyDefinitionGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyDefinitionGeneric.versions.table.index(systemEnvironment, sDMSDependencyDefinitionGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSDependencyDefinitionGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSDependencyDefinition(this);
    }

    protected SDMSDependencyDefinitionGeneric(Long l, Long l2, Long l3, String string, Integer n, Integer n2, Integer n3, String string2, Integer n4, Integer n5, Integer n6, String string3, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.seDependentId = l2;
        this.seRequiredId = l3;
        this.name = string;
        this.unresolvedHandling = n;
        this.mode = n2;
        this.stateSelection = n3;
        this.condition = string2;
        this.resolveMode = n4;
        this.expiredAmount = n5;
        this.expiredBase = n6;
        this.selectCondition = string3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = SystemEnvironment.SQUOTE;
                String string2 = SystemEnvironment.EQUOTE;
                object = "INSERT INTO " + string + "DEPENDENCY_DEFINITION" + string2 + " (ID, " + string + "SE_DEPENDENT_ID" + string2 + ", " + string + "SE_REQUIRED_ID" + string2 + ", " + string + "NAME" + string2 + ", " + string + "UNRESOLVED_HANDLING" + string2 + ", " + string + "DMODE" + string2 + ", " + string + "STATE_SELECTION" + string2 + ", " + string + "CONDITION" + string2 + ", " + string + "RESOLVE_MODE" + string2 + ", " + string + "EXPIRED_AMOUNT" + string2 + ", " + string + "EXPIRED_BASE" + string2 + ", " + string + "SELECT_CONDITION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSDependencyDefinitionGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "DependencyDefinition: $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.seDependentId);
            preparedStatement.setLong(3, this.seRequiredId);
            if (this.name == null) {
                preparedStatement.setNull(4, 12);
            } else {
                preparedStatement.setString(4, this.name);
            }
            preparedStatement.setInt(5, this.unresolvedHandling);
            preparedStatement.setInt(6, this.mode);
            preparedStatement.setInt(7, this.stateSelection);
            if (this.condition == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.condition);
            }
            preparedStatement.setInt(9, this.resolveMode);
            if (this.expiredAmount == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.expiredAmount);
            }
            if (this.expiredBase == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.expiredBase);
            }
            if (this.selectCondition == null) {
                preparedStatement.setNull(12, 12);
            } else {
                preparedStatement.setString(12, this.selectCondition);
            }
            preparedStatement.setLong(13, this.creatorUId);
            preparedStatement.setLong(14, this.createTs);
            preparedStatement.setLong(15, this.changerUId);
            preparedStatement.setLong(16, this.changeTs);
            preparedStatement.setLong(17, systemEnvironment.tx.versionId);
            preparedStatement.setLong(18, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "DependencyDefinition: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string.startsWith("PostgreSQL");
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                object = "UPDATE " + string2 + "DEPENDENCY_DEFINITION" + string3 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSDependencyDefinitionGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "DependencyDefinition : $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "DependencyDefinition: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkUnresolvedHandling(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkMode(Integer n) {
        switch (n) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkStateSelection(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkResolveMode(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkExpiredBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : DependencyDefinition", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "seDependentId : " + this.seDependentId, 2);
        SDMSThread.doTrace(null, "seRequiredId : " + this.seRequiredId, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "unresolvedHandling : " + this.unresolvedHandling, 2);
        SDMSThread.doTrace(null, "mode : " + this.mode, 2);
        SDMSThread.doTrace(null, "stateSelection : " + this.stateSelection, 2);
        SDMSThread.doTrace(null, "condition : " + this.condition, 2);
        SDMSThread.doTrace(null, "resolveMode : " + this.resolveMode, 2);
        SDMSThread.doTrace(null, "expiredAmount : " + this.expiredAmount, 2);
        SDMSThread.doTrace(null, "expiredBase : " + this.expiredBase, 2);
        SDMSThread.doTrace(null, "selectCondition : " + this.selectCondition, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "seDependentId      : " + this.seDependentId + "\n" + string + "seRequiredId       : " + this.seRequiredId + "\n" + string + "name               : " + this.name + "\n" + string + "unresolvedHandling : " + this.unresolvedHandling + "\n" + string + "mode               : " + this.mode + "\n" + string + "stateSelection     : " + this.stateSelection + "\n" + string + "condition          : " + this.condition + "\n" + string + "resolveMode        : " + this.resolveMode + "\n" + string + "expiredAmount      : " + this.expiredAmount + "\n" + string + "expiredBase        : " + this.expiredBase + "\n" + string + "selectCondition    : " + this.selectCondition + "\n" + string + "creatorUId         : " + this.creatorUId + "\n" + string + "createTs           : " + this.createTs + "\n" + string + "changerUId         : " + this.changerUId + "\n" + string + "changeTs           : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

