/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSDependencyInstance;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSDependencyInstanceTableGeneric
extends SDMSTable {
    public static final String tableName = "DEPENDENCY_INSTANCE";
    public static SDMSDependencyInstanceTable table = null;
    public static final String[] columnNames = new String[]{"ID", "DD_ID", "DEPENDENT_ID", "DEPENDENT_ID_ORIG", "DEPENDENCY_OPERATION", "REQUIRED_ID", "REQUIRED_SE_ID", "STATE", "IGNORE", "DI_ID_ORIG", "SE_VERSION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_ddId;
    public static SDMSIndex idx_dependentId;
    public static SDMSIndex idx_requiredId;
    public static SDMSIndex idx_requiredSeId;
    public static SDMSIndex idx_diIdOrig;
    public static SDMSIndex idx_ddId_dependentId_RequiredId;
    public static SDMSIndex idx_dependentId_RequiredId_state;

    public SDMSDependencyInstanceTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "DependencyInstance"));
        }
        table = (SDMSDependencyInstanceTable)this;
        table = (SDMSDependencyInstanceTable)this;
        this.isVersioned = false;
        idx_ddId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ddId");
        idx_dependentId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "dependentId");
        idx_requiredId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "requiredId");
        idx_requiredSeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "requiredSeId");
        idx_diIdOrig = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "diIdOrig");
        idx_ddId_dependentId_RequiredId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "ddId_dependentId_RequiredId");
        idx_dependentId_RequiredId_state = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "dependentId_RequiredId_state");
    }

    public SDMSDependencyInstance create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Long l4, Long l5, Integer n2, Integer n3, Long l6, Long l7) throws SDMSException {
        SDMSDependencyInstance sDMSDependencyInstance;
        Long l8 = systemEnvironment.cEnv.uid();
        Long l9 = systemEnvironment.txTime();
        Long l10 = systemEnvironment.cEnv.uid();
        Long l11 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "DependencyInstance"));
        }
        this.validate(systemEnvironment, l, l2, l3, n, l4, l5, n2, n3, l6, l7, l8, l9, l10, l11);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = new SDMSDependencyInstanceGeneric(systemEnvironment, l, l2, l3, n, l4, l5, n2, n3, l6, l7, l8, l9, l10, l11);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSDependencyInstanceGeneric.versions, true);
            table.put(systemEnvironment, sDMSDependencyInstanceGeneric.id, sDMSDependencyInstanceGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSDependencyInstance = (SDMSDependencyInstance)sDMSDependencyInstanceGeneric.toProxy(systemEnvironment);
            sDMSDependencyInstance.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSDependencyInstance sDMSDependencyInstance2 = (SDMSDependencyInstance)sDMSDependencyInstanceGeneric.toProxy(systemEnvironment);
            sDMSDependencyInstance2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSDependencyInstance)) {
            throw new AccessViolationException(sDMSDependencyInstance.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSDependencyInstance.touchMaster(systemEnvironment);
        return sDMSDependencyInstance;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSDependencyInstance sDMSDependencyInstance) throws SDMSException {
        return sDMSDependencyInstance.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Long l4, Long l5, Integer n2, Integer n3, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11) throws SDMSException {
        if (!SDMSDependencyInstanceGeneric.checkDependencyOperation(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "DependencyInstance: $1 $2", "dependencyOperation", n));
        }
        if (!SDMSDependencyInstanceGeneric.checkState(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "DependencyInstance: $1 $2", "state", n2));
        }
        if (!SDMSDependencyInstanceGeneric.checkIgnore(n3)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "DependencyInstance: $1 $2", "ignore", n3));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Integer n;
        Integer n2;
        Long l9;
        Long l10;
        Integer n3;
        Long l11;
        Long l12;
        Long l13;
        Long l14;
        try {
            l14 = resultSet.getLong(1);
            l13 = resultSet.getLong(2);
            l12 = resultSet.getLong(3);
            l11 = resultSet.getLong(4);
            n3 = resultSet.getInt(5);
            l10 = resultSet.getLong(6);
            l9 = resultSet.getLong(7);
            if (resultSet.wasNull()) {
                l9 = null;
            }
            n2 = resultSet.getInt(8);
            n = resultSet.getInt(9);
            l8 = resultSet.getLong(10);
            l7 = resultSet.getLong(11);
            l6 = resultSet.getLong(12);
            l5 = resultSet.getLong(13);
            l4 = resultSet.getLong(14);
            l3 = resultSet.getLong(15);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "DependencyInstance: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSDependencyInstanceGeneric(l14, l13, l12, l11, n3, l10, l9, n2, n, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "DD_ID" + string2 + ", " + string + "DEPENDENT_ID" + string2 + ", " + string + "DEPENDENT_ID_ORIG" + string2 + ", " + string + "DEPENDENCY_OPERATION" + string2 + ", " + string + "REQUIRED_ID" + string2 + ", " + string + "REQUIRED_SE_ID" + string2 + ", " + string + "STATE" + string2 + ", " + string + "IGNORE" + string2 + ", " + string + "DI_ID_ORIG" + string2 + ", " + string + "SE_VERSION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + "  FROM " + string + this.tableName() + string2 + ",        SME2LOAD  WHERE " + string + this.tableName() + string2 + ".DEPENDENT_ID = SME2LOAD.ID");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_ddId.check(((SDMSDependencyInstanceGeneric)sDMSObject).ddId, sDMSObject);
        object = (String)object + "idx_ddId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_dependentId.check(((SDMSDependencyInstanceGeneric)sDMSObject).dependentId, sDMSObject);
        object = (String)object + "idx_dependentId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_requiredId.check(((SDMSDependencyInstanceGeneric)sDMSObject).requiredId, sDMSObject);
        object = (String)object + "idx_requiredId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_requiredSeId.check(((SDMSDependencyInstanceGeneric)sDMSObject).requiredSeId, sDMSObject);
        object = (String)object + "idx_requiredSeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_diIdOrig.check(((SDMSDependencyInstanceGeneric)sDMSObject).diIdOrig, sDMSObject);
        object = (String)object + "idx_diIdOrig: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).ddId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).dependentId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).requiredId);
        bl = idx_ddId_dependentId_RequiredId.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_ddId_dependentId_RequiredId: " + (bl ? "ok" : "missing") + "\n";
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).dependentId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).requiredId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).state);
        bl = idx_dependentId_RequiredId_state.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_dependentId_RequiredId_state: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_ddId.put(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).ddId, sDMSObject, (1L & l) != 0L);
        idx_dependentId.put(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).dependentId, sDMSObject, (2L & l) != 0L);
        idx_requiredId.put(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).requiredId, sDMSObject, (4L & l) != 0L);
        idx_requiredSeId.put(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).requiredSeId, sDMSObject, (8L & l) != 0L);
        idx_diIdOrig.put(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).diIdOrig, sDMSObject, (0x10L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).ddId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).dependentId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).requiredId);
        idx_ddId_dependentId_RequiredId.put(systemEnvironment, sDMSKey, sDMSObject, (0x20L & l) != 0L);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).dependentId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).requiredId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).state);
        idx_dependentId_RequiredId_state.put(systemEnvironment, sDMSKey, sDMSObject, (0x40L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_ddId.remove(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).ddId, sDMSObject);
        idx_dependentId.remove(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).dependentId, sDMSObject);
        idx_requiredId.remove(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).requiredId, sDMSObject);
        idx_requiredSeId.remove(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).requiredSeId, sDMSObject);
        idx_diIdOrig.remove(systemEnvironment, ((SDMSDependencyInstanceGeneric)sDMSObject).diIdOrig, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).ddId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).dependentId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).requiredId);
        idx_ddId_dependentId_RequiredId.remove(systemEnvironment, sDMSKey, sDMSObject);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).dependentId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).requiredId);
        sDMSKey.add(((SDMSDependencyInstanceGeneric)sDMSObject).state);
        idx_dependentId_RequiredId_state.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSDependencyInstance getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSDependencyInstance)table.get(systemEnvironment, l);
    }

    public static SDMSDependencyInstance getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSDependencyInstance)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSDependencyInstance getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSDependencyInstance)table.get(systemEnvironment, l, l2);
    }

    public static SDMSDependencyInstance idx_ddId_dependentId_RequiredId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSDependencyInstance)idx_ddId_dependentId_RequiredId.getUnique(systemEnvironment, object);
    }

    public static SDMSDependencyInstance idx_ddId_dependentId_RequiredId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSDependencyInstance)idx_ddId_dependentId_RequiredId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSDependencyInstance idx_ddId_dependentId_RequiredId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSDependencyInstance)idx_ddId_dependentId_RequiredId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

