/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSEventProxyGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class SDMSEvent
extends SDMSEventProxyGeneric
implements SDMSOwnedObject {
    public static final String __version = "SDMSEvent $Revision: 2.4.6.1 $ / @(#) $Id: SDMSEvent.java,v 2.4.6.1 2013/03/14 10:25:18 ronald Exp $";

    protected SDMSEvent(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getSeId(systemEnvironment);
        String string = null;
        if (l != null) {
            string = SDMSSchedulingEntityTable.getObject(systemEnvironment, l).pathString(systemEnvironment);
        }
        return this.getName(systemEnvironment) + (String)(string == null ? "" : " (" + string + ")");
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "event " + this.getURLName(systemEnvironment);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSScheduledEventTable.idx_evtId.getVector(systemEnvironment, l);
        if (vector.size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03710161540", "Cannot drop, scheduled events present"));
        }
        super.delete(systemEnvironment);
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Vector vector2;
        Long l2 = this.getSeId(systemEnvironment);
        if (l2 == null) {
            long l3 = super.getPrivileges(systemEnvironment, l, bl, vector);
            return l3 & l;
        }
        if (vector == null) {
            vector2 = new Vector();
            if (systemEnvironment.cEnv.isUser()) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
        } else {
            vector2 = vector;
        }
        long l4 = 0L;
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2);
        long l5 = sDMSSchedulingEntity.getPrivileges(systemEnvironment, 0x10100000L, false, vector2);
        if ((l5 & 0x100000L) == 0x100000L) {
            Long l6 = this.getOwnerId(systemEnvironment);
            l4 = vector2.contains(l6) || vector2.contains(SDMSObject.adminGId) ? l : 0x10000000L;
        } else if ((l5 & 0x10000000L) == 0x10000000L) {
            l4 |= 0x10000000L;
        }
        l4 = this.addImplicitPrivs(l4) & l;
        return l4;
    }
}

