/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSEventParameter;
import de.independit.scheduler.server.repository.SDMSEventParameterGeneric;
import de.independit.scheduler.server.repository.SDMSEventParameterTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSEventParameterTableGeneric
extends SDMSTable {
    public static final String tableName = "EVENT_PARAMETER";
    public static SDMSEventParameterTable table = null;
    public static final String[] columnNames = new String[]{"ID", "KEY", "VALUE", "EVT_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_evtId;
    public static SDMSIndex idx_eventId_key;

    public SDMSEventParameterTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "EventParameter"));
        }
        table = (SDMSEventParameterTable)this;
        table = (SDMSEventParameterTable)this;
        this.isVersioned = false;
        idx_evtId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "evtId");
        idx_eventId_key = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "eventId_key");
    }

    public SDMSEventParameter create(SystemEnvironment systemEnvironment, String string, String string2, Long l) throws SDMSException {
        SDMSEventParameter sDMSEventParameter;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "EventParameter"));
        }
        this.validate(systemEnvironment, string, string2, l, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSEventParameterGeneric sDMSEventParameterGeneric = new SDMSEventParameterGeneric(systemEnvironment, string, string2, l, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSEventParameterGeneric.versions, true);
            table.put(systemEnvironment, sDMSEventParameterGeneric.id, sDMSEventParameterGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSEventParameter = (SDMSEventParameter)sDMSEventParameterGeneric.toProxy(systemEnvironment);
            sDMSEventParameter.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSEventParameter sDMSEventParameter2 = (SDMSEventParameter)sDMSEventParameterGeneric.toProxy(systemEnvironment);
            sDMSEventParameter2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSEventParameter)) {
            throw new AccessViolationException(sDMSEventParameter.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSEventParameter.touchMaster(systemEnvironment);
        return sDMSEventParameter;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSEventParameter sDMSEventParameter) throws SDMSException {
        return sDMSEventParameter.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, String string2, Long l, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        String string;
        String string2;
        Long l8;
        try {
            l8 = resultSet.getLong(1);
            string2 = resultSet.getString(2);
            string = resultSet.getString(3);
            l7 = resultSet.getLong(4);
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "EventParameter: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSEventParameterGeneric(l8, string2, string, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "KEY" + string2 + ", " + string + "VALUE" + string2 + ", " + string + "EVT_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2);
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_evtId.check(((SDMSEventParameterGeneric)sDMSObject).evtId, sDMSObject);
        object = (String)object + "idx_evtId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSEventParameterGeneric)sDMSObject).evtId);
        sDMSKey.add((Comparable)((Object)((SDMSEventParameterGeneric)sDMSObject).key));
        bl = idx_eventId_key.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_eventId_key: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_evtId.put(systemEnvironment, ((SDMSEventParameterGeneric)sDMSObject).evtId, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSEventParameterGeneric)sDMSObject).evtId);
        sDMSKey.add((Comparable)((Object)((SDMSEventParameterGeneric)sDMSObject).key));
        idx_eventId_key.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_evtId.remove(systemEnvironment, ((SDMSEventParameterGeneric)sDMSObject).evtId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSEventParameterGeneric)sDMSObject).evtId);
        sDMSKey.add((Comparable)((Object)((SDMSEventParameterGeneric)sDMSObject).key));
        idx_eventId_key.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSEventParameter getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSEventParameter)table.get(systemEnvironment, l);
    }

    public static SDMSEventParameter getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSEventParameter)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSEventParameter getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSEventParameter)table.get(systemEnvironment, l, l2);
    }

    public static SDMSEventParameter idx_eventId_key_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSEventParameter)idx_eventId_key.getUnique(systemEnvironment, object);
    }

    public static SDMSEventParameter idx_eventId_key_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSEventParameter)idx_eventId_key.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSEventParameter idx_eventId_key_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSEventParameter)idx_eventId_key.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

