/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslation;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSExitStateTranslationProxyGeneric
extends SDMSProxy {
    public static final long privilegeMask = 0x10000111L;
    private static SDMSTable[] masterTables = null;

    protected SDMSExitStateTranslationProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSExitStateTranslation getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSExitStateTranslationTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSExitStateTranslation(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSExitStateTranslation)sDMSProxy;
    }

    public Long getEstpId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSExitStateTranslationGeneric)this.object).getEstpId(systemEnvironment);
    }

    public void setEstpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).setEstpId(systemEnvironment, l);
    }

    public Long getFromEsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSExitStateTranslationGeneric)this.object).getFromEsdId(systemEnvironment);
    }

    public void setFromEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).setFromEsdId(systemEnvironment, l);
    }

    public Long getToEsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSExitStateTranslationGeneric)this.object).getToEsdId(systemEnvironment);
    }

    public void setToEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).setToEsdId(systemEnvironment, l);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSExitStateTranslationGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSExitStateTranslationGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSExitStateTranslationGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSExitStateTranslation setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSExitStateTranslation)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSExitStateTranslationGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSExitStateTranslation setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSExitStateTranslation)this;
    }

    public SDMSExitStateTranslation set_EstpIdFromEsdId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSExitStateTranslationGeneric)this.object).set_EstpIdFromEsdId(systemEnvironment, l, l2);
        return (SDMSExitStateTranslation)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        bl = false;
        Long l2 = this.getEstpId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l2).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        bl = false;
        Long l3 = this.getFromEsdId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSExitStateDefinitionTable.getObject(systemEnvironment, l3).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.touchMaster(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l, long l2) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null, l2) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x10000111L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l2 = 0L;
        l2 = l;
        return l2;
    }

    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null, l));
    }

    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector, l));
    }

    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l3 = 0L;
        l3 = l;
        return l3;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing ExitStateTranslation $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSExitStateTranslationGeneric)this.object).print();
    }
}

