/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSExitStateTranslation;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSExitStateTranslationTableGeneric
extends SDMSTable {
    public static final String tableName = "EXIT_STATE_TRANSLATION";
    public static SDMSExitStateTranslationTable table = null;
    public static final String[] columnNames = new String[]{"ID", "ESTP_ID", "FROM_ESD_ID", "TO_ESD_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_estpId;
    public static SDMSIndex idx_fromEsdId;
    public static SDMSIndex idx_toEsdId;
    public static SDMSIndex idx_estpId_fromEsdId;

    public SDMSExitStateTranslationTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ExitStateTranslation"));
        }
        table = (SDMSExitStateTranslationTable)this;
        table = (SDMSExitStateTranslationTable)this;
        this.isVersioned = true;
        idx_estpId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "estpId");
        idx_fromEsdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "fromEsdId");
        idx_toEsdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "toEsdId");
        idx_estpId_fromEsdId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "estpId_fromEsdId");
    }

    public SDMSExitStateTranslation create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3) throws SDMSException {
        SDMSExitStateTranslation sDMSExitStateTranslation;
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ExitStateTranslation"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, l6, l7);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSExitStateTranslationGeneric sDMSExitStateTranslationGeneric = new SDMSExitStateTranslationGeneric(systemEnvironment, l, l2, l3, l4, l5, l6, l7);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSExitStateTranslationGeneric.versions, true);
            table.put(systemEnvironment, sDMSExitStateTranslationGeneric.id, sDMSExitStateTranslationGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSExitStateTranslation = (SDMSExitStateTranslation)sDMSExitStateTranslationGeneric.toProxy(systemEnvironment);
            sDMSExitStateTranslation.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSExitStateTranslation sDMSExitStateTranslation2 = (SDMSExitStateTranslation)sDMSExitStateTranslationGeneric.toProxy(systemEnvironment);
            sDMSExitStateTranslation2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSExitStateTranslation)) {
            throw new AccessViolationException(sDMSExitStateTranslation.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSExitStateTranslation.touchMaster(systemEnvironment);
        return sDMSExitStateTranslation;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSExitStateTranslation sDMSExitStateTranslation) throws SDMSException {
        return sDMSExitStateTranslation.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        Long l10;
        try {
            l10 = resultSet.getLong(1);
            l9 = resultSet.getLong(2);
            l8 = resultSet.getLong(3);
            l7 = resultSet.getLong(4);
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = resultSet.getLong(9);
            l = resultSet.getLong(10);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ExitStateTranslation: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSExitStateTranslationGeneric(l10, l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "ESTP_ID" + string2 + ", " + string + "FROM_ESD_ID" + string2 + ", " + string + "TO_ESD_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion));
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_estpId.check(((SDMSExitStateTranslationGeneric)sDMSObject).estpId, sDMSObject);
        object = (String)object + "idx_estpId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_fromEsdId.check(((SDMSExitStateTranslationGeneric)sDMSObject).fromEsdId, sDMSObject);
        object = (String)object + "idx_fromEsdId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_toEsdId.check(((SDMSExitStateTranslationGeneric)sDMSObject).toEsdId, sDMSObject);
        object = (String)object + "idx_toEsdId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSExitStateTranslationGeneric)sDMSObject).estpId);
        sDMSKey.add(((SDMSExitStateTranslationGeneric)sDMSObject).fromEsdId);
        bl = idx_estpId_fromEsdId.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_estpId_fromEsdId: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_estpId.put(systemEnvironment, ((SDMSExitStateTranslationGeneric)sDMSObject).estpId, sDMSObject, (1L & l) != 0L);
        idx_fromEsdId.put(systemEnvironment, ((SDMSExitStateTranslationGeneric)sDMSObject).fromEsdId, sDMSObject, (2L & l) != 0L);
        idx_toEsdId.put(systemEnvironment, ((SDMSExitStateTranslationGeneric)sDMSObject).toEsdId, sDMSObject, (4L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSExitStateTranslationGeneric)sDMSObject).estpId);
        sDMSKey.add(((SDMSExitStateTranslationGeneric)sDMSObject).fromEsdId);
        idx_estpId_fromEsdId.put(systemEnvironment, sDMSKey, sDMSObject, (8L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_estpId.remove(systemEnvironment, ((SDMSExitStateTranslationGeneric)sDMSObject).estpId, sDMSObject);
        idx_fromEsdId.remove(systemEnvironment, ((SDMSExitStateTranslationGeneric)sDMSObject).fromEsdId, sDMSObject);
        idx_toEsdId.remove(systemEnvironment, ((SDMSExitStateTranslationGeneric)sDMSObject).toEsdId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSExitStateTranslationGeneric)sDMSObject).estpId);
        sDMSKey.add(((SDMSExitStateTranslationGeneric)sDMSObject).fromEsdId);
        idx_estpId_fromEsdId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSExitStateTranslation getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExitStateTranslation)table.get(systemEnvironment, l);
    }

    public static SDMSExitStateTranslation getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExitStateTranslation)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSExitStateTranslation getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSExitStateTranslation)table.get(systemEnvironment, l, l2);
    }

    public static SDMSExitStateTranslation idx_estpId_fromEsdId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSExitStateTranslation)idx_estpId_fromEsdId.getUnique(systemEnvironment, object);
    }

    public static SDMSExitStateTranslation idx_estpId_fromEsdId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSExitStateTranslation)idx_estpId_fromEsdId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSExitStateTranslation idx_estpId_fromEsdId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSExitStateTranslation)idx_estpId_fromEsdId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

