/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSFolderGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_ownerId = 3;
    public static final int nr_envId = 4;
    public static final int nr_parentId = 5;
    public static final int nr_creatorUId = 6;
    public static final int nr_createTs = 7;
    public static final int nr_changerUId = 8;
    public static final int nr_changeTs = 9;
    public static final int nr_inheritPrivs = 10;
    public static String tableName = "FOLDER";
    protected String name;
    protected Long ownerId;
    protected Long envId;
    protected Long parentId;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    protected Long inheritPrivs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSFolderGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        super(systemEnvironment, SDMSFolderTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Folder) Length of $1 exceeds maximum length $2", "name", "64"));
        }
        this.name = string;
        this.ownerId = l;
        this.envId = l2;
        this.parentId = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.inheritPrivs = l8;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Folder) Change of system object not allowed"));
            }
            SDMSFolderGeneric sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Folder) Length of $1 exceeds maximum length $2", "name", "64"));
            }
            sDMSFolderGeneric.name = string;
            sDMSFolderGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSFolderGeneric.changeTs = systemEnvironment.txTime();
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            SDMSFolderGeneric sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
            sDMSFolderGeneric.ownerId = l;
            sDMSFolderGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSFolderGeneric.changeTs = systemEnvironment.txTime();
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getEnvId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.envId;
    }

    public void setEnvId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.envId)) {
            return;
        }
        if (l == null && this.envId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Folder) Change of system object not allowed"));
            }
            SDMSFolderGeneric sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
            sDMSFolderGeneric.envId = l;
            sDMSFolderGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSFolderGeneric.changeTs = systemEnvironment.txTime();
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.parentId;
    }

    public void setParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.parentId)) {
            return;
        }
        if (l == null && this.parentId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Folder) Change of system object not allowed"));
            }
            SDMSFolderGeneric sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
            sDMSFolderGeneric.parentId = l;
            sDMSFolderGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSFolderGeneric.changeTs = systemEnvironment.txTime();
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric, 12L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSFolderGeneric sDMSFolderGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Folder) Change of system object not allowed"));
        }
        if (sDMSFolderGeneric.versions.o_v == null || sDMSFolderGeneric.versions.o_v.size() == 0 || sDMSFolderGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
        }
        sDMSFolderGeneric.creatorUId = l;
        sDMSFolderGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSFolderGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSFolderGeneric != this) {
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSFolderGeneric sDMSFolderGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Folder) Change of system object not allowed"));
        }
        if (sDMSFolderGeneric.versions.o_v == null || sDMSFolderGeneric.versions.o_v.size() == 0 || sDMSFolderGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
        }
        sDMSFolderGeneric.createTs = l;
        sDMSFolderGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSFolderGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSFolderGeneric != this) {
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSFolderGeneric sDMSFolderGeneric = this;
        if (sDMSFolderGeneric.versions.o_v == null || sDMSFolderGeneric.versions.o_v.size() == 0 || sDMSFolderGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
        }
        sDMSFolderGeneric.changerUId = l;
        sDMSFolderGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSFolderGeneric != this) {
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSFolderGeneric sDMSFolderGeneric = this;
        if (sDMSFolderGeneric.versions.o_v == null || sDMSFolderGeneric.versions.o_v.size() == 0 || sDMSFolderGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
        }
        sDMSFolderGeneric.changeTs = l;
        sDMSFolderGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSFolderGeneric != this) {
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric, 0L);
        }
    }

    public Long getInheritPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.inheritPrivs;
    }

    public void setInheritPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.inheritPrivs.equals(l)) {
            return;
        }
        SDMSFolderGeneric sDMSFolderGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Folder) Change of system object not allowed"));
        }
        if (sDMSFolderGeneric.versions.o_v == null || sDMSFolderGeneric.versions.o_v.size() == 0 || sDMSFolderGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
        }
        sDMSFolderGeneric.inheritPrivs = l;
        sDMSFolderGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSFolderGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSFolderGeneric != this) {
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric, 0L);
        }
    }

    public SDMSFolderGeneric set_ParentIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSFolderGeneric sDMSFolderGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Folder) Change of system object not allowed"));
            }
            sDMSFolderGeneric = (SDMSFolderGeneric)this.change(systemEnvironment);
            sDMSFolderGeneric.parentId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(Folder) Length of $1 exceeds maximum length $2", "inheritPrivs", "64"));
            }
            sDMSFolderGeneric.name = string;
            sDMSFolderGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSFolderGeneric.changeTs = systemEnvironment.txTime();
            sDMSFolderGeneric.versions.table.index(systemEnvironment, sDMSFolderGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSFolderGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSFolder(this);
    }

    protected SDMSFolderGeneric(Long l, String string, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8, Long l9, long l10, long l11) {
        this.id = l;
        this.name = string;
        this.ownerId = l2;
        this.envId = l3;
        this.parentId = l4;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
        this.inheritPrivs = l9;
        this.validFrom = l10;
        this.validTo = l11;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = SystemEnvironment.SQUOTE;
                String string2 = SystemEnvironment.EQUOTE;
                object = "INSERT INTO " + string + "FOLDER" + string2 + " (ID, " + string + "NAME" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "ENV_ID" + string2 + ", " + string + "PARENT_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", " + string + "INHERIT_PRIVS" + string2 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSFolderGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Folder: $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.ownerId);
            if (this.envId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.envId);
            }
            if (this.parentId == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.parentId);
            }
            preparedStatement.setLong(6, this.creatorUId);
            preparedStatement.setLong(7, this.createTs);
            preparedStatement.setLong(8, this.changerUId);
            preparedStatement.setLong(9, this.changeTs);
            preparedStatement.setLong(10, this.inheritPrivs);
            preparedStatement.setLong(11, systemEnvironment.tx.versionId);
            preparedStatement.setLong(12, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Folder: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string.startsWith("PostgreSQL");
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                object = "UPDATE " + string2 + "FOLDER" + string3 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSFolderGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "Folder : $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "Folder: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Folder", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "envId : " + this.envId, 2);
        SDMSThread.doTrace(null, "parentId : " + this.parentId, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "inheritPrivs : " + this.inheritPrivs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name         : " + this.name + "\n" + string + "ownerId      : " + this.ownerId + "\n" + string + "envId        : " + this.envId + "\n" + string + "parentId     : " + this.parentId + "\n" + string + "creatorUId   : " + this.creatorUId + "\n" + string + "createTs     : " + this.createTs + "\n" + string + "changerUId   : " + this.changerUId + "\n" + string + "changeTs     : " + this.changeTs + "\n" + string + "inheritPrivs : " + this.inheritPrivs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

