/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSFootprintGeneric;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSFootprintTableGeneric
extends SDMSTable {
    public static final String tableName = "FOOTPRINT";
    public static SDMSFootprintTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;

    public SDMSFootprintTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Footprint"));
        }
        table = (SDMSFootprintTable)this;
        table = (SDMSFootprintTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name");
    }

    public SDMSFootprint create(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSFootprint sDMSFootprint;
        Long l = systemEnvironment.cEnv.uid();
        Long l2 = systemEnvironment.txTime();
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Footprint"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, l4);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSFootprintGeneric sDMSFootprintGeneric = new SDMSFootprintGeneric(systemEnvironment, string, l, l2, l3, l4);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSFootprintGeneric.versions, true);
            table.put(systemEnvironment, sDMSFootprintGeneric.id, sDMSFootprintGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSFootprint = (SDMSFootprint)sDMSFootprintGeneric.toProxy(systemEnvironment);
            sDMSFootprint.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSFootprint sDMSFootprint2 = (SDMSFootprint)sDMSFootprintGeneric.toProxy(systemEnvironment);
            sDMSFootprint2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSFootprint)) {
            throw new AccessViolationException(sDMSFootprint.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSFootprint;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSFootprint sDMSFootprint) throws SDMSException {
        return sDMSFootprint.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Long l7;
        try {
            l7 = resultSet.getLong(1);
            string = resultSet.getString(2);
            l6 = resultSet.getLong(3);
            l5 = resultSet.getLong(4);
            l4 = resultSet.getLong(5);
            l3 = resultSet.getLong(6);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Footprint: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSFootprintGeneric(l7, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2);
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_name.check(((SDMSFootprintGeneric)sDMSObject).name, sDMSObject);
        object = (String)object + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSFootprintGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSFootprintGeneric)sDMSObject).name, sDMSObject);
    }

    public static SDMSFootprint getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSFootprint)table.get(systemEnvironment, l);
    }

    public static SDMSFootprint getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSFootprint)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSFootprint getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSFootprint)table.get(systemEnvironment, l, l2);
    }

    public static SDMSFootprint idx_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSFootprint)idx_name.getUnique(systemEnvironment, object);
    }

    public static SDMSFootprint idx_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSFootprint)idx_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSFootprint idx_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSFootprint)idx_name.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

