/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantGeneric;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSGrantProxyGeneric
extends SDMSProxy {
    public static final int SYSTEM = 0;
    public static final int SELECT = 99;
    public static final int ENVIRONMENT = 1;
    public static final int EVENT = 18;
    public static final int FOLDER = 6;
    public static final int INTERVAL = 19;
    public static final int JOB = 17;
    public static final int JOB_DEFINITION = 9;
    public static final int NAMED_RESOURCE = 10;
    public static final int SCHEDULE = 20;
    public static final int SCHEDULED_EVENT = 22;
    public static final int SCOPE = 15;
    public static final int GROUP = 21;
    public static final int RESOURCE = 11;
    public static final int EXIT_STATE_DEFINITION = 2;
    public static final int EXIT_STATE_PROFILE = 3;
    public static final int EXIT_STATE_MAPPING = 4;
    public static final int EXIT_STATE_TRANSLATION = 5;
    public static final int RESOURCE_STATE_DEFINITION = 13;
    public static final int RESOURCE_STATE_PROFILE = 14;
    public static final int RESOURCE_STATE_MAPPING = 12;
    public static final int FOOTPRINT = 7;
    public static final int USER = 8;
    public static final int OBJECT_MONITOR = 30;
    public static final int NICE_PROFILE = 31;
    public static final int WATCH_TYPE = 29;
    public static final Boolean GRANT = Boolean.TRUE;
    public static final Boolean REVOKE = Boolean.FALSE;
    public static final long privilegeMask = 0x10000111L;
    private static SDMSTable[] masterTables = null;

    protected SDMSGrantProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSGrant getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSGrantTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSGrant(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSGrant)sDMSProxy;
    }

    public Long getObjectId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getObjectId(systemEnvironment);
    }

    public void setObjectId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setObjectId(systemEnvironment, l);
    }

    public Long getGId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getGId(systemEnvironment);
    }

    public void setGId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setGId(systemEnvironment, l);
    }

    public Integer getObjectType(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getObjectType(systemEnvironment);
    }

    public String getObjectTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getObjectTypeAsString(systemEnvironment);
    }

    public void setObjectType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setObjectType(systemEnvironment, n);
    }

    public Long getPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getPrivs(systemEnvironment);
    }

    public void setPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setPrivs(systemEnvironment, l);
    }

    public Long getDeleteVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getDeleteVersion(systemEnvironment);
    }

    public void setDeleteVersion(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setDeleteVersion(systemEnvironment, l);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSGrant setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSGrant)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSGrantGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSGrant setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSGrant)this;
    }

    public SDMSGrant set_ObjectIdGId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSGrantGeneric)this.object).set_ObjectIdGId(systemEnvironment, l, l2);
        return (SDMSGrant)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add(this.getObjectId(systemEnvironment));
        bl = false;
        Long l2 = this.getGId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSGroupTable.getObject(systemEnvironment, l2).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.touchMaster(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x10000111L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2;
        SDMSProxy sDMSProxy;
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l3 = 0L;
        l3 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EVENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOLDER");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "GROUPS");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "INTERVALL");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_ENVIRONMENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESSOURCE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULED_EVENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCOPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SUBMITTED_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l3;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing Grant $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSGrantGeneric)this.object).print();
    }
}

