/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.repository.BlockState;
import de.independit.scheduler.server.repository.DispatchRule;
import de.independit.scheduler.server.repository.GntdCache;
import de.independit.scheduler.server.repository.IntervalReference;
import de.independit.scheduler.server.repository.ReferenceUsage;
import de.independit.scheduler.server.repository.RefererType;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcher;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherTable;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalSelection;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.gntd;
import de.independit.scheduler.server.util.DateTime;
import de.independit.scheduler.server.util.Here;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class SDMSInterval
extends SDMSIntervalProxyGeneric
implements SDMSOwnedObject {
    public static final int UNINITIALIZED = -1;
    public static final int N_A = 0;
    public static final boolean FILTER = true;
    public static final boolean DRIVER = false;
    protected static final String HT = "    ";
    private static boolean debug = true;
    private Vector filter = null;
    private SDMSInterval embedFilter = null;
    private GntdCache gntdCache = null;
    private GntdCache fltrCache = null;
    private Vector selectedBlocksPos = null;
    private Vector selectedBlocksNeg = null;
    private Vector selectedRanges = null;
    private boolean isInverse = false;
    private boolean rangeSelected = false;
    private boolean posSelected = false;
    private boolean negSelected = false;
    private int fifoLength = 1;
    private int selBlPos;
    private int selBlNeg;
    private int baseMultiplier = -1;
    private int durationMultiplier = 1;
    private int gcBaseInterval = 0;
    private int gcDurationInterval = 0;
    private long maxBaseLength = 0L;
    private boolean isInfinite = false;
    private SDMSInterval embeddedInterval = null;
    private Vector<DispatchRule> dispatchRules = null;
    private long startTime = 0L;
    private long endTime = Long.MAX_VALUE;
    private BlockState blockState = new BlockState();
    GregorianCalendar prevCeilGc = null;
    GregorianCalendar ceilGc = null;
    GregorianCalendar floorGc = null;
    GregorianCalendar nextFloorGc = null;

    private void debugmsg(SystemEnvironment systemEnvironment, int n, String string) throws SDMSException {
        if (!debug) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            System.out.print(HT);
        }
        System.out.println(this.getName(systemEnvironment) + "/" + this.getId(systemEnvironment) + " : " + Here.atc() + string);
    }

    protected SDMSInterval(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    protected void initProxy(SDMSObject sDMSObject) {
        super.initProxy(sDMSObject);
        this.filter = null;
        this.embedFilter = null;
        this.gntdCache = null;
        this.fltrCache = null;
        this.selectedBlocksPos = null;
        this.selectedBlocksNeg = null;
        this.selectedRanges = null;
        this.isInverse = false;
        this.rangeSelected = false;
        this.posSelected = false;
        this.negSelected = false;
        this.fifoLength = 1;
        this.selBlPos = 0;
        this.selBlNeg = 0;
        this.baseMultiplier = -1;
        this.durationMultiplier = 1;
        this.gcBaseInterval = 0;
        this.gcDurationInterval = 0;
        this.maxBaseLength = 0L;
        this.isInfinite = false;
        this.embeddedInterval = null;
        this.dispatchRules = null;
        this.startTime = 0L;
        this.endTime = Long.MAX_VALUE;
        this.blockState = new BlockState();
        this.prevCeilGc = null;
        this.ceilGc = null;
        this.floorGc = null;
        this.nextFloorGc = null;
    }

    private void initialize(SystemEnvironment systemEnvironment, TimeZone timeZone, int n) throws SDMSException {
        this.gntdCache = new GntdCache();
        this.fltrCache = new GntdCache();
        Vector vector = SDMSIntervalHierarchyTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
        this.filter = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            SDMSIntervalHierarchy sDMSIntervalHierarchy = (SDMSIntervalHierarchy)vector.get(i);
            this.filter.add(SDMSIntervalTable.getObject(systemEnvironment, sDMSIntervalHierarchy.getChildId(systemEnvironment)));
        }
        this.initSelection(systemEnvironment, n + 1);
        this.initBaseAndDuration(systemEnvironment, n + 1);
        this.initLimits(systemEnvironment, timeZone);
        this.initEmbeddedInterval(systemEnvironment, timeZone, n + 1);
        this.initDispatcher(systemEnvironment);
    }

    private void restoreState(gntd gntd2) {
        this.blockState.copyFrom(gntd2.bs);
        this.selBlPos = gntd2.selBlPos;
        this.selBlNeg = gntd2.selBlNeg;
        this.prevCeilGc = gntd2.prevCeilGc == null ? null : (GregorianCalendar)gntd2.prevCeilGc.clone();
        this.ceilGc = gntd2.ceilGc == null ? null : (GregorianCalendar)gntd2.ceilGc.clone();
        this.floorGc = gntd2.floorGc == null ? null : (GregorianCalendar)gntd2.floorGc.clone();
        this.nextFloorGc = gntd2.nextFloorGc == null ? null : (GregorianCalendar)gntd2.nextFloorGc.clone();
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getSeId(systemEnvironment);
        String string = null;
        if (l != null && l != 0L) {
            string = SDMSSchedulingEntityTable.getObject(systemEnvironment, l).pathString(systemEnvironment);
        }
        return this.getName(systemEnvironment) + (String)(string == null ? "" : " (" + string + ")");
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "interval " + this.getURLName(systemEnvironment);
    }

    public long getHorizon(SystemEnvironment systemEnvironment, TimeZone timeZone) throws SDMSException {
        int n = 1;
        switch (SystemEnvironment.timerHorizon.unit()) {
            case 5: {
                n = 1;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 1: {
                n = 11;
                break;
            }
            case 0: {
                n = 12;
            }
        }
        GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.add(n, SystemEnvironment.timerHorizon.mult());
        return gregorianCalendar.getTimeInMillis();
    }

    public Long getNextTriggerDate(SystemEnvironment systemEnvironment, Long l, long l2, TimeZone timeZone, boolean bl) throws SDMSException {
        return this.getNextTriggerDate(systemEnvironment, l, l2, timeZone, bl, 0);
    }

    public Long getNextTriggerDate(SystemEnvironment systemEnvironment, Long l, long l2, TimeZone timeZone, boolean bl, int n) throws SDMSException {
        gntd gntd2;
        if (this.filter == null) {
            this.initialize(systemEnvironment, timeZone, n + 1);
        }
        if ((gntd2 = this.gntdCache.get(l, l2, timeZone)) != null) {
            this.restoreState(gntd2);
            return gntd2.retVal;
        }
        if (l == null) {
            return null;
        }
        long l3 = l;
        if (this.startTime > l3) {
            l3 = this.startTime;
        }
        if (l2 == 0L) {
            l2 = this.getHorizon(systemEnvironment, timeZone);
        }
        if (this.dispatchRules != null) {
            Long l4 = this.getNextDispatchTriggerDate(systemEnvironment, l3, l2, timeZone, bl, n + 1);
            this.gntdCache.add(new gntd(l, l2, timeZone, this.blockState, l4, this.selBlPos, this.selBlNeg, this.prevCeilGc, this.ceilGc, this.floorGc, this.nextFloorGc, bl));
            return l4;
        }
        if (!this.seek(systemEnvironment, l3, l2, timeZone, bl, n + 1)) {
            this.gntdCache.add(new gntd(l, l2, timeZone, this.blockState, null, this.selBlPos, this.selBlNeg, this.prevCeilGc, this.ceilGc, this.floorGc, this.nextFloorGc, bl));
            return null;
        }
        if (this.blockState.blockStart < l3 && !bl) {
            if (this.blockState.blockEnd == Long.MAX_VALUE) {
                this.gntdCache.add(new gntd(l, l2, timeZone, this.blockState, null, this.selBlPos, this.selBlNeg, this.prevCeilGc, this.ceilGc, this.floorGc, this.nextFloorGc, bl));
                return null;
            }
            if (!this.seek(systemEnvironment, this.blockState.blockEnd + 1L, l2, timeZone, bl, n + 1)) {
                this.gntdCache.add(new gntd(l, l2, timeZone, this.blockState, null, this.selBlPos, this.selBlNeg, this.prevCeilGc, this.ceilGc, this.floorGc, this.nextFloorGc, bl));
                return null;
            }
        }
        this.gntdCache.add(new gntd(l, l2, timeZone, this.blockState, this.blockState.blockStart, this.selBlPos, this.selBlNeg, this.prevCeilGc, this.ceilGc, this.floorGc, this.nextFloorGc, bl));
        return this.blockState.blockStart;
    }

    public Long getCurrentBlockEnd(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.blockState.blockEnd;
    }

    /*
     * Unable to fully structure code
     */
    private Long getNextDispatchTriggerDate(SystemEnvironment var1_1, long var2_2, long var4_3, TimeZone var6_4, boolean var7_5, int var8_6) throws SDMSException {
        var9_7 = this.dispatchRules.size();
        if (var2_2 < this.startTime) {
            var2_2 = this.startTime;
        }
        var10_8 = new Long[var9_7];
        var11_9 = 0x7FFFFFFFFFFFFFFFL;
        var13_10 = 0x7FFFFFFF;
        for (var14_11 = 0; var14_11 < var9_7; ++var14_11) {
            var15_12 = this.dispatchRules.get(var14_11);
            if (var15_12.isActive) {
                var16_13 = var15_12.fltInterval != null ? var15_12.fltInterval.getNextTriggerDate(var1_1, var2_2, var4_3, var6_4, var7_5, var8_6 + 1) : Long.valueOf(var2_2);
                if (var13_10 == 0x7FFFFFFF || var16_13 != null && var16_13 < var10_8[var13_10]) {
                    var13_10 = var14_11;
                }
            } else {
                var16_13 = null;
            }
            var10_8[var14_11] = var16_13 == null ? 0x7FFFFFFFFFFFFFFFL : (var16_13 < var2_2 ? var2_2 : var16_13);
        }
        block1: while (true) {
            if (var13_10 == 0x7FFFFFFF || var10_8[var13_10] > var4_3) {
                return null;
            }
            var14_11 = 0;
            while (true) {
                if (var14_11 > var13_10) continue block1;
                var15_12 = this.dispatchRules.get(var14_11);
                var16_13 = var15_12.selInterval != null ? Long.valueOf(var15_12.selInterval.filter(var1_1, var10_8[var13_10], var4_3, var6_4, var8_6 + 1)) : var10_8[var13_10];
                if (var16_13 <= var10_8[var13_10]) {
                    if (var14_11 == var13_10) {
                        var17_14 = this.dispatchRules.get((int)var13_10).fltInterval;
                        if (var17_14 != null) {
                            this.blockState.copyFrom(var17_14.blockState);
                            for (var18_18 = 0; var18_18 < var9_7; ++var18_18) {
                                if (var10_8[var18_18] <= var10_8[var13_10] || var10_8[var18_18] >= this.blockState.blockEnd) continue;
                                this.blockState.blockEnd = var10_8[var18_18] - 1L;
                            }
                        }
                        return var10_8[var13_10];
                    }
                    var17_15 = this.dispatchRules.get(var13_10);
                    var18_17 = 0L;
                    if (var17_15.fltInterval != null) {
                        var18_17 = var17_15.fltInterval.getNextTriggerDate(var1_1, var10_8[var13_10] + 1L, var4_3, var6_4, var7_5, var8_6 + 1);
                        if (var18_17 == null) {
                            var18_17 = 0x7FFFFFFFFFFFFFFFL;
                        }
                        var10_8[var13_10] = var18_17;
                    }
                    var19_19 = 0;
                    while (true) {
                        if (var19_19 >= var9_7) continue block1;
                        if (var10_8[var19_19] < var18_17) {
                            var13_10 = var19_19;
                            var18_17 = var10_8[var19_19];
                        }
                        ++var19_19;
                    }
                }
                if (var14_11 == var13_10) {
                    if (var15_12.fltInterval != null) {
                        var16_13 = var15_12.fltInterval.getNextTriggerDate(var1_1, var15_12.fltInterval.blockState.blockEnd + 1L, var4_3, var6_4, var7_5, var8_6 + 1);
                        if (var16_13 == null) {
                            var16_13 = 0x7FFFFFFFFFFFFFFFL;
                        }
                        var10_8[var13_10] = var16_13;
                    }
                    var17_16 = 0;
                    while (true) {
                        if (var17_16 < var9_7) ** break;
                        continue block1;
                        if (var10_8[var17_16] < var16_13) {
                            var13_10 = var17_16;
                            var16_13 = var10_8[var17_16];
                        }
                        ++var17_16;
                    }
                }
                ++var14_11;
            }
            break;
        }
    }

    private boolean advanceBlock(SystemEnvironment systemEnvironment, long l, TimeZone timeZone, boolean bl, int n) throws SDMSException {
        if (Thread.currentThread().isInterrupted()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02205091100", "Thread Interrupted"));
        }
        if (this.blockState.blockEnd == Long.MAX_VALUE) {
            return false;
        }
        if (this.isInfinite) {
            if (this.blockState.baseEnd <= this.blockState.blockEnd) {
                return false;
            }
            long l2 = 0L;
            l2 = this.blockState.blockEnd + 1L;
            return this.getNextRange(systemEnvironment, l2, timeZone, n + 1) && this.blockState.blockStart < this.endTime && this.blockState.blockStart < l;
        }
        GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
        gregorianCalendar.setTimeZone(timeZone);
        long l3 = Long.MAX_VALUE;
        if (this.embeddedInterval != null) {
            long l4 = this.blockState.blockEnd;
            if (l4 < Long.MAX_VALUE) {
                ++l4;
            }
            Long l5 = null;
            if (bl) {
                l3 = this.embeddedInterval.filter(systemEnvironment, l4, this.blockState.baseEnd > l ? this.blockState.baseEnd : l, timeZone, n + 1);
                if (l3 > l4) {
                    this.blockState.blockStart = l3;
                    l5 = this.embeddedInterval.getNextTriggerDate(systemEnvironment, this.blockState.blockStart, this.blockState.baseEnd > l ? this.blockState.baseEnd : l, timeZone, false, n + 1);
                    this.blockState.blockEnd = l5 == null ? this.blockState.baseEnd : this.embeddedInterval.blockState.blockEnd;
                } else {
                    this.blockState.blockStart = l4;
                    this.blockState.blockEnd = this.embeddedInterval.blockState.blockEnd;
                }
                l5 = this.blockState.blockEnd;
            } else if (this.embeddedInterval.getNextTriggerDate(systemEnvironment, l4, this.blockState.baseEnd > l ? this.blockState.baseEnd : l, timeZone, false, n + 1) == null) {
                return false;
            }
            if (!bl) {
                this.blockState.blockStart = this.embeddedInterval.blockState.blockStart;
                this.blockState.blockEnd = this.embeddedInterval.blockState.blockEnd;
            }
            if (this.blockState.blockStart > this.blockState.baseEnd) {
                this.blockState.baseStart = this.sync(systemEnvironment, this.blockState.blockStart, timeZone);
                gregorianCalendar.setTimeInMillis(this.blockState.baseStart);
                gregorianCalendar.add(this.gcBaseInterval, this.baseMultiplier);
                this.blockState.baseEnd = gregorianCalendar.getTimeInMillis() - 1L;
                this.blockState.blockIdx = 0;
                if (this.blockState.blockEnd < this.blockState.blockStart) {
                    this.blockState.blockEnd = l5;
                }
            }
        } else {
            this.blockState.blockStart = this.blockState.blockEnd + 1L;
            gregorianCalendar.setTimeInMillis(this.blockState.blockStart);
            gregorianCalendar.add(this.gcDurationInterval, this.durationMultiplier);
            this.blockState.blockEnd = gregorianCalendar.getTimeInMillis() - 1L;
            if (this.blockState.blockStart > this.blockState.baseEnd) {
                this.blockState.baseStart = this.blockState.baseEnd + 1L;
                gregorianCalendar.setTimeInMillis(this.blockState.baseStart);
                gregorianCalendar.add(this.gcBaseInterval, this.baseMultiplier);
                this.blockState.baseEnd = gregorianCalendar.getTimeInMillis() - 1L;
                this.blockState.blockIdx = 0;
            }
        }
        if (this.blockState.blockEnd > this.blockState.baseEnd) {
            if (this.embeddedInterval != null || this.gcDurationInterval != 3) {
                this.blockState.blockEnd = this.blockState.baseEnd;
            } else {
                while (this.blockState.blockEnd > this.blockState.baseEnd) {
                    gregorianCalendar.add(this.gcDurationInterval, -1);
                    this.blockState.blockEnd = gregorianCalendar.getTimeInMillis() - 1L;
                }
                gregorianCalendar.setTimeInMillis(this.blockState.baseEnd + 1L);
                if ((gregorianCalendar.get(7) - gregorianCalendar.getFirstDayOfWeek() + 7) % 7 + 1 > gregorianCalendar.getMinimalDaysInFirstWeek()) {
                    gregorianCalendar.setTimeInMillis(this.blockState.blockEnd + 1L);
                    gregorianCalendar.add(this.gcDurationInterval, 1);
                    this.blockState.blockEnd = gregorianCalendar.getTimeInMillis() - 1L;
                } else if (this.blockState.blockStart == this.blockState.blockEnd + 1L) {
                    this.blockState.blockStart = this.blockState.blockEnd + 1L;
                    gregorianCalendar.setTimeInMillis(this.blockState.blockStart);
                    gregorianCalendar.add(this.gcDurationInterval, this.durationMultiplier);
                    this.blockState.blockEnd = gregorianCalendar.getTimeInMillis() - 1L;
                    this.blockState.baseStart = this.blockState.baseEnd + 1L;
                    gregorianCalendar.setTimeInMillis(this.blockState.baseStart);
                    gregorianCalendar.add(this.gcBaseInterval, this.baseMultiplier);
                    this.blockState.baseEnd = gregorianCalendar.getTimeInMillis() - 1L;
                    this.blockState.blockIdx = 0;
                }
            }
        }
        ++this.blockState.blockIdx;
        return this.blockState.blockStart < this.endTime;
    }

    private boolean seekBlock(SystemEnvironment systemEnvironment, long l, long l2, TimeZone timeZone, boolean bl, int n) throws SDMSException {
        if (this.startTime > l) {
            l = this.startTime;
        }
        if (l < this.blockState.baseStart || l > this.blockState.baseEnd || this.blockState.baseStart == -1L) {
            this.blockState.clear();
            this.blockState.baseStart = this.sync(systemEnvironment, l, timeZone);
        }
        GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.setTimeInMillis(this.blockState.baseStart);
        if (this.blockState.baseEnd == -1L) {
            if (this.isInfinite) {
                this.blockState.baseEnd = this.endTime;
            } else {
                gregorianCalendar.add(this.gcBaseInterval, this.baseMultiplier);
                this.blockState.baseEnd = gregorianCalendar.getTimeInMillis() - 1L;
                gregorianCalendar.setTimeInMillis(this.blockState.baseStart);
            }
        }
        if (!this.isInfinite) {
            if (this.embeddedInterval == null && this.gcDurationInterval == 3) {
                boolean bl2 = false;
                if ((gregorianCalendar.get(7) - gregorianCalendar.getFirstDayOfWeek() + 7) % 7 + 1 <= gregorianCalendar.getMinimalDaysInFirstWeek()) {
                    bl2 = true;
                }
                this.determineBoundary(systemEnvironment, gregorianCalendar, this.blockState.baseStart, this.durationMultiplier, this.gcDurationInterval);
                if (bl2) {
                    while (gregorianCalendar.getTimeInMillis() > this.blockState.baseStart) {
                        gregorianCalendar.add(this.gcDurationInterval, -1);
                    }
                } else {
                    while (gregorianCalendar.getTimeInMillis() < this.blockState.baseStart) {
                        gregorianCalendar.add(this.gcDurationInterval, 1);
                    }
                }
            }
            if (this.embeddedInterval == null) {
                this.blockState.blockStart = gregorianCalendar.getTimeInMillis();
                gregorianCalendar.add(this.gcDurationInterval, this.durationMultiplier);
                this.blockState.blockEnd = gregorianCalendar.getTimeInMillis() - 1L;
            } else {
                if (bl) {
                    long l3 = this.embeddedInterval.filter(systemEnvironment, this.blockState.baseStart, this.blockState.baseEnd > l2 ? this.blockState.baseEnd : l2, timeZone, n + 1);
                } else if (this.embeddedInterval.getNextTriggerDate(systemEnvironment, this.blockState.baseStart, this.blockState.baseEnd > l2 ? this.blockState.baseEnd : l2, timeZone, false, n + 1) == null) {
                    return false;
                }
                this.blockState.blockStart = this.embeddedInterval.blockState.blockStart;
                this.blockState.blockEnd = this.embeddedInterval.blockState.blockEnd;
                if (this.blockState.blockStart > this.blockState.baseEnd) {
                    this.blockState.baseStart = this.sync(systemEnvironment, this.blockState.blockStart, timeZone);
                    gregorianCalendar.setTimeInMillis(this.blockState.baseStart);
                    gregorianCalendar.add(this.gcBaseInterval, this.baseMultiplier);
                    this.blockState.baseEnd = gregorianCalendar.getTimeInMillis() - 1L;
                }
                if (this.blockState.blockEnd > this.blockState.baseEnd) {
                    this.blockState.blockEnd = this.blockState.baseEnd;
                }
            }
            this.blockState.blockIdx = 1;
        } else {
            this.blockState.blockStart = this.blockState.baseStart;
            this.blockState.blockEnd = this.getStartingPoint(systemEnvironment, l, timeZone, n + 1);
            if (!this.advanceBlock(systemEnvironment, l2, timeZone, bl, n + 1)) {
                return false;
            }
        }
        while (this.blockState.blockEnd <= l && this.blockState.blockStart < this.endTime && this.blockState.blockStart < l2) {
            if (this.advanceBlock(systemEnvironment, l2, timeZone, bl, n + 1)) continue;
            return false;
        }
        return this.blockState.blockStart < this.endTime;
    }

    private boolean seek(SystemEnvironment systemEnvironment, long l, long l2, TimeZone timeZone, boolean bl, int n) throws SDMSException {
        if (this.filter == null) {
            this.initialize(systemEnvironment, timeZone, n + 1);
        }
        int n2 = this.filter.size();
        while (true) {
            long l3;
            long l4 = Long.MAX_VALUE;
            if (!this.seekLocal(systemEnvironment, l, l2, timeZone, bl, n + 1)) {
                return false;
            }
            if (n2 == 0 && this.embeddedInterval == null) {
                return true;
            }
            long l5 = bl ? (l < this.blockState.blockStart ? this.blockState.blockStart : l) : this.blockState.blockStart;
            long l6 = this.blockState.blockEnd;
            if (this.embeddedInterval != null) {
                l3 = this.embeddedInterval.filter(systemEnvironment, l5, l2, timeZone, n + 1);
                if (l6 > this.embeddedInterval.blockState.blockEnd) {
                    l6 = this.embeddedInterval.blockState.blockEnd;
                }
            } else {
                l3 = l5;
            }
            if (l3 <= l5 && l3 != Long.MAX_VALUE) {
                if (n2 == 0) {
                    if (bl) {
                        this.blockState.blockStart = l5;
                        this.blockState.blockEnd = l6;
                    }
                    return true;
                }
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    SDMSInterval sDMSInterval = (SDMSInterval)this.filter.get(i);
                    l3 = sDMSInterval.filter(systemEnvironment, l5, l2, timeZone, n + 1);
                    if (l3 == Long.MAX_VALUE) continue;
                    if (l3 <= l5) {
                        if (bl) {
                            this.blockState.blockStart = l5;
                            this.blockState.blockEnd = sDMSInterval.blockState.blockEnd;
                        }
                        if (this.blockState.blockEnd > l6) {
                            this.blockState.blockEnd = l6;
                        }
                        l6 = this.blockState.blockEnd;
                        bl2 = true;
                    }
                    if (l4 <= l3) continue;
                    l4 = l3;
                }
                if (bl2) {
                    return true;
                }
            } else if (l4 > l3) {
                l4 = l3;
            }
            if (l4 == Long.MAX_VALUE || !bl && this.blockState.blockEnd == Long.MAX_VALUE) {
                return false;
            }
            if (bl) {
                l = l4;
                continue;
            }
            l = this.blockState.blockEnd >= l4 ? this.blockState.blockEnd + 1L : l4;
        }
    }

    public long filter(SystemEnvironment systemEnvironment, long l, long l2, TimeZone timeZone, int n) throws SDMSException {
        Long l3;
        gntd gntd2;
        if (this.filter == null) {
            this.initialize(systemEnvironment, timeZone, n + 1);
        }
        if ((gntd2 = this.fltrCache.get(l3 = Long.valueOf(l), l2, timeZone)) != null) {
            this.restoreState(gntd2);
            return gntd2.retVal;
        }
        if (this.dispatchRules != null) {
            long l4 = this.dispatchFilter(systemEnvironment, l, l2, timeZone, n + 1);
            this.fltrCache.add(new gntd(l3, l2, timeZone, this.blockState, l4, this.selBlPos, this.selBlNeg, this.prevCeilGc, this.ceilGc, this.floorGc, this.nextFloorGc, true));
            return l4;
        }
        if (!this.seek(systemEnvironment, l, l2, timeZone, true, n + 1)) {
            this.fltrCache.add(new gntd(l3, l2, timeZone, this.blockState, Long.MAX_VALUE, this.selBlPos, this.selBlNeg, this.prevCeilGc, this.ceilGc, this.floorGc, this.nextFloorGc, true));
            return Long.MAX_VALUE;
        }
        if (l < this.startTime && this.blockState.blockStart < this.startTime) {
            this.fltrCache.add(new gntd(l3, l2, timeZone, this.blockState, this.startTime, this.selBlPos, this.selBlNeg, this.prevCeilGc, this.ceilGc, this.floorGc, this.nextFloorGc, true));
            return this.startTime;
        }
        this.fltrCache.add(new gntd(l3, l2, timeZone, this.blockState, this.blockState.blockStart, this.selBlPos, this.selBlNeg, this.prevCeilGc, this.ceilGc, this.floorGc, this.nextFloorGc, true));
        return this.blockState.blockStart;
    }

    private long dispatchFilter(SystemEnvironment systemEnvironment, long l, long l2, TimeZone timeZone, int n) throws SDMSException {
        long l3;
        if (l < this.startTime) {
            return this.startTime;
        }
        long l4 = Long.MAX_VALUE;
        DispatchRule dispatchRule = null;
        long l5 = 0L;
        for (int i = 0; i < this.dispatchRules.size(); ++i) {
            DispatchRule dispatchRule2 = this.dispatchRules.get(i);
            if (dispatchRule2.selInterval != null) {
                l3 = dispatchRule2.selInterval.filter(systemEnvironment, l, l2, timeZone, n + 1);
                if (dispatchRule == null && l3 <= l) {
                    dispatchRule = dispatchRule2;
                    l5 = l4;
                    if (dispatchRule2.selInterval.blockState.blockEnd < l5) {
                        l5 = dispatchRule2.selInterval.blockState.blockEnd;
                    }
                }
                if (l3 >= l4) continue;
                l4 = l3;
                continue;
            }
            if (dispatchRule != null) break;
            dispatchRule = dispatchRule2;
            l5 = l4;
            l4 = l;
            break;
        }
        if (dispatchRule == null) {
            this.blockState.blockStart = l4;
        } else if (dispatchRule.isActive) {
            l3 = dispatchRule.fltInterval.filter(systemEnvironment, l, l2, timeZone, n + 1);
            this.blockState.copyFrom(dispatchRule.fltInterval.blockState);
            if (l3 <= l) {
                this.blockState.blockStart = l;
                if (this.blockState.blockEnd > l5) {
                    this.blockState.blockEnd = l5;
                }
            } else {
                this.blockState.blockStart = l3 <= l5 ? l3 : l5 + 1L;
            }
        } else {
            this.blockState.blockStart = l5 + 1L;
        }
        return this.blockState.blockStart;
    }

    private boolean checkSelection(SystemEnvironment systemEnvironment, int n, int n2, long l, TimeZone timeZone, int n3) throws SDMSException {
        if (!(this.posSelected || this.negSelected || this.rangeSelected)) {
            return true;
        }
        boolean bl = this.posSelected && this.indexCheckPos(systemEnvironment, n, n3 + 1) || this.negSelected && this.indexCheckNeg(systemEnvironment, n2, n3 + 1) || this.rangeSelected && this.rangeCheck(systemEnvironment, l, timeZone, n3 + 1);
        return bl ^ this.isInverse;
    }

    private boolean indexCheckPos(SystemEnvironment systemEnvironment, int n, int n2) throws SDMSException {
        if (!this.posSelected) {
            return true;
        }
        if (n <= 0) {
            return false;
        }
        while (this.selBlPos < this.selectedBlocksPos.size()) {
            int n3 = (Integer)this.selectedBlocksPos.get(this.selBlPos);
            if (n3 == n) {
                return true;
            }
            if (n3 > n) {
                return false;
            }
            ++this.selBlPos;
        }
        return false;
    }

    private boolean indexCheckNeg(SystemEnvironment systemEnvironment, int n, int n2) throws SDMSException {
        if (!this.negSelected) {
            return true;
        }
        if (n >= 0) {
            return false;
        }
        while (this.selBlNeg < this.selectedBlocksNeg.size()) {
            int n3 = (Integer)this.selectedBlocksNeg.get(this.selBlNeg);
            if (n3 == n) {
                return true;
            }
            if (n3 > n) {
                return false;
            }
            ++this.selBlNeg;
        }
        return false;
    }

    private boolean rangeCheck(SystemEnvironment systemEnvironment, long l, TimeZone timeZone, int n) throws SDMSException {
        if (!this.rangeSelected) {
            return true;
        }
        for (int i = 0; i < this.selectedRanges.size(); ++i) {
            long l2;
            DateTime[] dateTimeArray = (DateTime[])this.selectedRanges.get(i);
            long l3 = this.floor(dateTimeArray[0], l, timeZone);
            if (l3 > (l2 = this.ceil(dateTimeArray[1], l3, timeZone)) || this.floor(dateTimeArray[0], l2, timeZone) != l3 || l3 > l || l > l2) continue;
            return true;
        }
        return false;
    }

    private boolean getNextRange(SystemEnvironment systemEnvironment, long l, TimeZone timeZone, int n) throws SDMSException {
        if (!this.rangeSelected) {
            if (l == this.blockState.blockStart) {
                this.blockState.blockEnd = this.blockState.baseEnd;
                return true;
            }
            return false;
        }
        if (!this.isInverse) {
            BlockState blockState = this.getNextPositiveRange(systemEnvironment, l, timeZone);
            if (blockState == null) {
                return false;
            }
            this.blockState.copyFrom(blockState);
            return true;
        }
        BlockState blockState = new BlockState(this.blockState);
        BlockState blockState2 = this.getNextPositiveRange(systemEnvironment, blockState.blockEnd + 1L, timeZone);
        if (blockState2 == null) {
            if (blockState.blockEnd + 1L == l) {
                this.blockState.blockStart = l;
                this.blockState.blockEnd = this.endTime;
                return true;
            }
            return false;
        }
        while (blockState2.blockStart < l || blockState.blockEnd + 1L < l || blockState.blockEnd + 1L == blockState2.blockStart) {
            blockState = blockState2;
            if (blockState.blockEnd + 1L > l) {
                l = blockState.blockEnd + 1L;
            }
            if ((blockState2 = this.getNextPositiveRange(systemEnvironment, blockState.blockEnd, timeZone)) != null) continue;
            if (blockState.blockEnd + 1L == l) {
                this.blockState.blockStart = l;
                this.blockState.blockEnd = this.endTime;
                return true;
            }
            return false;
        }
        this.blockState.blockStart = blockState.blockEnd + 1L;
        this.blockState.blockEnd = blockState2.blockStart - 1L;
        return true;
    }

    private long getStartingPoint(SystemEnvironment systemEnvironment, long l, TimeZone timeZone, int n) throws SDMSException {
        long l2 = this.startTime;
        long l3 = -1L;
        for (int i = 0; i < this.selectedRanges.size(); ++i) {
            long l4;
            DateTime[] dateTimeArray = (DateTime[])this.selectedRanges.get(i);
            long l5 = this.floor(dateTimeArray[0], l, timeZone);
            if (l5 > (l4 = this.ceil(dateTimeArray[1], l5, timeZone))) {
                l5 = Long.MAX_VALUE;
            }
            if ((l5 = this.floor(dateTimeArray[0], l4, timeZone)) <= l && l <= l4) {
                if (l2 >= l5) continue;
                l2 = l5;
                continue;
            }
            if (l5 > l) {
                l4 = this.prevCeil(dateTimeArray[1], dateTimeArray[0], l4, timeZone);
            }
            if (l4 <= l3 || l4 >= l) continue;
            l3 = l4;
        }
        return l2 >= l3 ? l2 - 1L : l3;
    }

    private BlockState getNextPositiveRange(SystemEnvironment systemEnvironment, long l, TimeZone timeZone) throws SDMSException {
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = 0L;
        long l5 = 0L;
        BlockState blockState = new BlockState(this.blockState);
        for (int i = 0; i < this.selectedRanges.size(); ++i) {
            long l6;
            DateTime[] dateTimeArray = (DateTime[])this.selectedRanges.get(i);
            long l7 = this.floor(dateTimeArray[0], l, timeZone);
            if (l7 > (l6 = this.ceil(dateTimeArray[1], l7, timeZone))) continue;
            l7 = this.floor(dateTimeArray[0], l6, timeZone);
            if (l7 < l) {
                if (l <= l6 && l5 < l6) {
                    l5 = l6;
                }
                l7 = (l7 = this.nextFloor(dateTimeArray[0], l7, timeZone)) > (l6 = this.ceil(dateTimeArray[1], l7, timeZone)) ? Long.MAX_VALUE : this.floor(dateTimeArray[0], l6, timeZone);
            }
            if (l7 >= l) {
                if (l2 > l7) {
                    l3 = l2;
                    l2 = l7;
                    l4 = 0L;
                } else if (l3 > l7 && l7 != l2) {
                    l3 = l7;
                }
            }
            if (l7 != l2 || l4 >= l6) continue;
            l4 = l6;
        }
        if (l2 == Long.MAX_VALUE) {
            return null;
        }
        blockState.blockStart = l2;
        blockState.blockEnd = l3 - 1L;
        if (l5 < l4) {
            l5 = l4;
        }
        if (l5 < blockState.blockEnd) {
            blockState.blockEnd = l5;
        }
        return blockState;
    }

    private boolean seekLocal(SystemEnvironment systemEnvironment, long l, long l2, TimeZone timeZone, boolean bl, int n) throws SDMSException {
        long l3;
        BlockState blockState;
        int n2;
        int n3;
        long l4 = 0L;
        long l5 = Long.MAX_VALUE;
        if (!this.seekBlock(systemEnvironment, l, l2, timeZone, bl, n + 1)) {
            return false;
        }
        Vector<Object> vector = new Vector<Object>();
        int n4 = -1;
        do {
            if (l4 < this.blockState.baseStart) {
                n3 = vector.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    blockState = (BlockState)vector.get(n2);
                    l3 = blockState.blockStart;
                    if (!this.checkSelection(systemEnvironment, n4 + n2, n2 - n3, l3, timeZone, n + 1)) continue;
                    this.blockState.copyFrom(blockState);
                    return true;
                }
                this.resetPositions();
                vector.clear();
                n4 = this.blockState.blockIdx;
                l4 = this.blockState.baseStart;
                l5 = this.blockState.baseEnd;
            }
            vector.addElement(this.blockState.clone());
            if (vector.size() <= this.fifoLength) continue;
            BlockState blockState2 = (BlockState)vector.remove(0);
            long l6 = blockState2.blockStart;
            if (l6 > l2) {
                return false;
            }
            if (this.checkSelection(systemEnvironment, n4, 0, l6, timeZone, n + 1)) {
                this.blockState.copyFrom(blockState2);
                return true;
            }
            ++n4;
        } while (this.advanceBlock(systemEnvironment, l2, timeZone, bl, n + 1) && this.blockState.blockStart <= l2);
        n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            blockState = (BlockState)vector.get(n2);
            l3 = blockState.blockStart;
            if (!this.checkSelection(systemEnvironment, n4 + n2, n2 - n3, l3, timeZone, n + 1)) continue;
            this.blockState.copyFrom(blockState);
            return true;
        }
        return false;
    }

    private long sync(SystemEnvironment systemEnvironment, long l, TimeZone timeZone) throws SDMSException {
        GregorianCalendar gregorianCalendar = null;
        if (!this.isInfinite) {
            Long l2 = this.getSyncTime(systemEnvironment);
            gregorianCalendar = this.localGcFromGMT(systemEnvironment, l2, timeZone);
            this.determineBoundary(systemEnvironment, gregorianCalendar, l, this.baseMultiplier, this.gcBaseInterval);
            return gregorianCalendar.getTimeInMillis();
        }
        return this.startTime;
    }

    private void truncToUnit(SystemEnvironment systemEnvironment, GregorianCalendar gregorianCalendar, int n) throws SDMSException {
        switch (n) {
            case 1: {
                gregorianCalendar.set(2, 0);
            }
            case 2: {
                gregorianCalendar.set(5, 1);
            }
            case 5: {
                gregorianCalendar.set(11, 0);
            }
            case 11: {
                gregorianCalendar.set(12, 0);
            }
            case 12: {
                break;
            }
            case 3: {
                gregorianCalendar.set(7, 2);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
            }
        }
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        gregorianCalendar.getTimeInMillis();
    }

    private void determineBoundary(SystemEnvironment systemEnvironment, GregorianCalendar gregorianCalendar, long l, int n, int n2) throws SDMSException {
        this.truncToUnit(systemEnvironment, gregorianCalendar, n2);
        long l2 = gregorianCalendar.getTimeInMillis();
        long l3 = l - l2;
        int n3 = (int)(l3 / this.maxBaseLength);
        if ((n3 /= n) != 0) {
            gregorianCalendar.add(n2, n3 * n);
        }
        l2 = gregorianCalendar.getTimeInMillis();
        while (l2 < l) {
            if (l2 < 0L) {
                l2 = Long.MAX_VALUE;
                gregorianCalendar.setTimeInMillis(l2);
                return;
            }
            gregorianCalendar.add(n2, n);
            l2 = gregorianCalendar.getTimeInMillis();
        }
        while (l2 > l) {
            gregorianCalendar.add(n2, -n);
            l2 = gregorianCalendar.getTimeInMillis();
        }
    }

    private void resetPositions() {
        this.selBlPos = 0;
        this.selBlNeg = 0;
    }

    private void initSelection(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        this.resetPositions();
        if (this.selectedBlocksPos != null) {
            return;
        }
        this.isInverse = this.getIsInverse(systemEnvironment);
        Vector vector = SDMSIntervalSelectionTable.idx_intId.getVector(systemEnvironment, this.getId(systemEnvironment));
        this.selectedBlocksPos = new Vector();
        this.selectedBlocksNeg = new Vector();
        this.selectedRanges = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            DateTime[] dateTimeArray;
            Serializable serializable;
            SDMSIntervalSelection sDMSIntervalSelection = (SDMSIntervalSelection)vector.get(i);
            Integer n2 = sDMSIntervalSelection.getValue(systemEnvironment);
            if (n2 != null) {
                int n3;
                int n4 = n2;
                serializable = n4 < 0 ? this.selectedBlocksNeg : this.selectedBlocksPos;
                for (n3 = 0; n3 < ((Vector)serializable).size() && (Integer)((Vector)serializable).get(n3) < n4; ++n3) {
                }
                if (n3 != ((Vector)serializable).size() && (Integer)((Vector)serializable).get(n3) == n4) continue;
                ((Vector)serializable).add(n3, n2);
                continue;
            }
            dateTimeArray = new DateTime[]{new DateTime(sDMSIntervalSelection.getPeriodFrom(systemEnvironment), false), (serializable = sDMSIntervalSelection.getPeriodTo(systemEnvironment)) == null ? dateTimeArray[0] : new DateTime((Long)serializable, false)};
            this.selectedRanges.add(dateTimeArray);
        }
        if (this.selectedBlocksNeg.size() > 0) {
            this.fifoLength = Math.abs((Integer)this.selectedBlocksNeg.elementAt(0));
            this.negSelected = true;
        }
        if (this.selectedBlocksPos.size() > 0) {
            this.posSelected = true;
        }
        if (this.selectedRanges.size() > 0) {
            this.rangeSelected = true;
        }
    }

    private void initBaseAndDuration(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        if (this.baseMultiplier != -1) {
            return;
        }
        Integer n2 = this.getBaseInterval(systemEnvironment);
        if (n2 != null) {
            int n3 = n2;
            Integer n4 = this.getBaseIntervalMultiplier(systemEnvironment);
            this.baseMultiplier = n4;
            switch (n3) {
                case 5: {
                    this.gcBaseInterval = 1;
                    break;
                }
                case 4: {
                    this.gcBaseInterval = 2;
                    break;
                }
                case 3: {
                    this.gcBaseInterval = 3;
                    break;
                }
                case 2: {
                    this.gcBaseInterval = 5;
                    break;
                }
                case 1: {
                    this.gcBaseInterval = 11;
                    break;
                }
                case 0: {
                    this.gcBaseInterval = 12;
                }
            }
        } else {
            this.baseMultiplier = 0;
        }
        Integer n5 = this.getDuration(systemEnvironment);
        if (n5 != null) {
            int n6 = n5;
            Integer n7 = this.getDurationMultiplier(systemEnvironment);
            this.durationMultiplier = n7;
            switch (n6) {
                case 5: {
                    this.gcDurationInterval = 1;
                    break;
                }
                case 4: {
                    this.gcDurationInterval = 2;
                    break;
                }
                case 3: {
                    this.gcDurationInterval = 3;
                    break;
                }
                case 2: {
                    this.gcDurationInterval = 5;
                    break;
                }
                case 1: {
                    this.gcDurationInterval = 11;
                    break;
                }
                case 0: {
                    this.gcDurationInterval = 12;
                }
            }
        } else {
            this.durationMultiplier = 0;
        }
        if (this.durationMultiplier == 0 && this.baseMultiplier == 0) {
            this.isInfinite = true;
        } else {
            if (this.durationMultiplier == 0) {
                this.durationMultiplier = this.baseMultiplier;
                this.gcDurationInterval = this.gcBaseInterval;
            }
            if (this.baseMultiplier == 0) {
                this.baseMultiplier = this.durationMultiplier;
                this.gcBaseInterval = this.gcDurationInterval;
            }
            switch (this.gcBaseInterval) {
                case 1: {
                    this.maxBaseLength = 31622400000L;
                    break;
                }
                case 2: {
                    this.maxBaseLength = 2682000000L;
                    break;
                }
                case 3: {
                    this.maxBaseLength = 608400000L;
                    break;
                }
                case 5: {
                    this.maxBaseLength = 90000000L;
                    break;
                }
                case 11: {
                    this.maxBaseLength = 3600000L;
                    break;
                }
                case 12: {
                    this.maxBaseLength = 60000L;
                }
            }
        }
    }

    private void initLimits(SystemEnvironment systemEnvironment, TimeZone timeZone) throws SDMSException {
        Long l;
        Long l2 = this.getStartTime(systemEnvironment);
        if (l2 != null) {
            this.startTime = this.localGcFromGMT(systemEnvironment, l2, timeZone).getTimeInMillis();
        }
        if ((l = this.getEndTime(systemEnvironment)) != null) {
            this.endTime = this.localGcFromGMT(systemEnvironment, l, timeZone).getTimeInMillis() - 1L;
        }
    }

    private void initEmbeddedInterval(SystemEnvironment systemEnvironment, TimeZone timeZone, int n) throws SDMSException {
        Long l = this.getEmbeddedIntervalId(systemEnvironment);
        if (l != null) {
            SDMSInterval sDMSInterval;
            this.embeddedInterval = sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l);
            this.embedFilter = null;
        }
    }

    private void initDispatcher(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSIntervalDispatcherTable.idx_intId.getSortedVector(systemEnvironment, this.getId(systemEnvironment));
        if (vector.size() != 0) {
            this.dispatchRules = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                DispatchRule dispatchRule = new DispatchRule(systemEnvironment, (SDMSIntervalDispatcher)vector.get(i));
                if (dispatchRule.isEnabled) {
                    this.dispatchRules.add(dispatchRule);
                }
                if (dispatchRule.selInterval != null) {
                    continue;
                }
                break;
            }
        } else {
            this.dispatchRules = null;
        }
    }

    private GregorianCalendar localGcFromGMT(SystemEnvironment systemEnvironment, Long l, TimeZone timeZone) throws SDMSException {
        long l2 = new DateTime(l, false).getTimeInMillis();
        GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
        gregorianCalendar.setTimeInMillis(l2);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.set(n, n2, n3, n4, n5);
        gregorianCalendar.getTimeInMillis();
        return gregorianCalendar;
    }

    private long floor(DateTime dateTime, long l, TimeZone timeZone) {
        if (l == Long.MAX_VALUE) {
            return l;
        }
        if (this.floorGc == null) {
            this.floorGc = SystemEnvironment.newGregorianCalendar();
        }
        GregorianCalendar gregorianCalendar = this.floorGc;
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.setTimeInMillis(l);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        if (dateTime.year != -1) {
            gregorianCalendar.set(1, dateTime.year);
        }
        if (dateTime.week != -1) {
            gregorianCalendar.set(3, dateTime.week);
            gregorianCalendar.set(7, 2);
            gregorianCalendar.set(11, 0);
            gregorianCalendar.set(12, 0);
        } else {
            if (dateTime.minute == -1) {
                gregorianCalendar.set(12, 0);
                if (dateTime.hour == -1) {
                    gregorianCalendar.set(11, 0);
                    if (dateTime.day == -1) {
                        gregorianCalendar.set(5, 1);
                        if (dateTime.month == -1) {
                            gregorianCalendar.set(2, 0);
                        }
                    }
                }
            }
            if (dateTime.month != -1) {
                if (dateTime.day != -1) {
                    gregorianCalendar.set(5, 1);
                }
                gregorianCalendar.set(2, dateTime.month - 1);
            }
            if (dateTime.day != -1) {
                if (dateTime.day < 29) {
                    gregorianCalendar.set(5, dateTime.day);
                } else {
                    gregorianCalendar.set(5, 1);
                    gregorianCalendar.getTimeInMillis();
                    while (gregorianCalendar.getActualMaximum(5) < dateTime.day) {
                        if (dateTime.month == -1) {
                            gregorianCalendar.add(2, -1);
                        } else {
                            gregorianCalendar.add(1, -1);
                        }
                        gregorianCalendar.getTimeInMillis();
                    }
                    gregorianCalendar.set(5, dateTime.day);
                }
            }
            if (dateTime.hour != -1) {
                gregorianCalendar.set(11, dateTime.hour);
            }
            if (dateTime.minute != -1) {
                gregorianCalendar.set(12, dateTime.minute);
            }
        }
        long l2 = gregorianCalendar.getTimeInMillis();
        if (l2 > l && dateTime.year == -1) {
            int n = 1;
            if (dateTime.week == -1 && dateTime.month == -1) {
                n = 2;
                if (dateTime.day == -1) {
                    n = 5;
                    if (dateTime.hour == -1) {
                        n = 11;
                    }
                }
            }
            while (l2 > l) {
                if (dateTime.week == -1 && dateTime.day >= 29) {
                    gregorianCalendar.set(5, 1);
                    do {
                        gregorianCalendar.add(n, -1);
                        gregorianCalendar.getTimeInMillis();
                    } while (gregorianCalendar.getActualMaximum(5) < dateTime.day);
                    gregorianCalendar.set(5, dateTime.day);
                } else if (dateTime.week < 53) {
                    gregorianCalendar.add(n, -1);
                } else {
                    gregorianCalendar.set(3, 1);
                    do {
                        gregorianCalendar.add(n, -1);
                        gregorianCalendar.getTimeInMillis();
                    } while (gregorianCalendar.getActualMaximum(3) < dateTime.week);
                    gregorianCalendar.set(3, dateTime.week);
                }
                l2 = gregorianCalendar.getTimeInMillis();
            }
        }
        return l2;
    }

    private long nextFloor(DateTime dateTime, long l, TimeZone timeZone) {
        if (l == Long.MAX_VALUE) {
            return l;
        }
        if (dateTime.year != -1) {
            return Long.MAX_VALUE;
        }
        if (this.nextFloorGc == null) {
            this.nextFloorGc = SystemEnvironment.newGregorianCalendar();
        }
        GregorianCalendar gregorianCalendar = this.nextFloorGc;
        gregorianCalendar.setTimeZone(timeZone);
        long l2 = this.floor(dateTime, l, timeZone);
        gregorianCalendar.setTimeInMillis(l2);
        int n = 1;
        boolean bl = true;
        int n2 = 1;
        if (dateTime.week == -1) {
            if (dateTime.month == -1) {
                n = 2;
                if (dateTime.day == -1) {
                    n = 11;
                    bl = false;
                    if (dateTime.hour == -1) {
                        n = 11;
                    } else {
                        n2 = 25;
                    }
                }
            }
            if (dateTime.day < 29) {
                bl = false;
            }
        } else if (dateTime.week < 53) {
            bl = false;
        }
        if (bl) {
            if (dateTime.day >= 29) {
                gregorianCalendar.set(5, 1);
                do {
                    gregorianCalendar.add(n, n2);
                    gregorianCalendar.getTimeInMillis();
                } while (gregorianCalendar.getActualMaximum(5) < dateTime.day);
                gregorianCalendar.set(5, dateTime.day);
            } else {
                gregorianCalendar.set(3, n2);
                do {
                    gregorianCalendar.add(n, 1);
                    gregorianCalendar.getTimeInMillis();
                } while (gregorianCalendar.getActualMaximum(3) < dateTime.week);
                gregorianCalendar.set(3, dateTime.week);
            }
        } else {
            gregorianCalendar.add(n, n2);
        }
        long l3 = gregorianCalendar.getTimeInMillis();
        l3 = this.floor(dateTime, l3, timeZone);
        return l3;
    }

    private long ceil(DateTime dateTime, long l, TimeZone timeZone) {
        if (l == Long.MAX_VALUE) {
            return l;
        }
        if (this.ceilGc == null) {
            this.ceilGc = SystemEnvironment.newGregorianCalendar();
        }
        GregorianCalendar gregorianCalendar = this.ceilGc;
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.setTimeInMillis(l);
        gregorianCalendar.set(13, 59);
        gregorianCalendar.set(14, 999);
        if (dateTime.year != -1) {
            gregorianCalendar.set(1, dateTime.year);
        }
        if (dateTime.week != -1) {
            gregorianCalendar.set(3, dateTime.week);
            gregorianCalendar.set(7, 1);
            gregorianCalendar.set(11, 23);
            gregorianCalendar.set(12, 59);
        } else {
            if (dateTime.minute == -1) {
                gregorianCalendar.set(12, 59);
                if (dateTime.hour == -1) {
                    gregorianCalendar.set(11, 23);
                    if (dateTime.day == -1) {
                        if (dateTime.month == -1) {
                            gregorianCalendar.set(2, 11);
                        } else {
                            gregorianCalendar.set(2, dateTime.month - 1);
                        }
                        gregorianCalendar.set(5, gregorianCalendar.getActualMaximum(5));
                    }
                }
            }
            if (dateTime.month != -1) {
                gregorianCalendar.set(5, 1);
                if (dateTime.day == -1) {
                    gregorianCalendar.getTimeInMillis();
                    gregorianCalendar.set(2, dateTime.month - 1);
                    gregorianCalendar.set(5, gregorianCalendar.getActualMaximum(5));
                } else {
                    gregorianCalendar.set(2, dateTime.month - 1);
                }
            }
            if (dateTime.day != -1) {
                if (dateTime.day < 29) {
                    gregorianCalendar.set(5, dateTime.day);
                } else {
                    gregorianCalendar.set(5, 1);
                    gregorianCalendar.getTimeInMillis();
                    while (gregorianCalendar.getActualMaximum(5) < dateTime.day) {
                        if (dateTime.month == -1) {
                            gregorianCalendar.add(2, 1);
                        } else {
                            gregorianCalendar.add(1, 1);
                        }
                        gregorianCalendar.getTimeInMillis();
                    }
                    gregorianCalendar.set(5, dateTime.day);
                }
            }
            if (dateTime.hour != -1) {
                gregorianCalendar.set(11, dateTime.hour);
            }
            if (dateTime.minute != -1) {
                gregorianCalendar.set(12, dateTime.minute);
            }
        }
        long l2 = gregorianCalendar.getTimeInMillis();
        if (l2 < l && dateTime.year == -1) {
            int n = 1;
            if (dateTime.week == -1 && dateTime.month == -1) {
                n = 2;
                if (dateTime.day == -1) {
                    n = 5;
                    if (dateTime.hour == -1) {
                        n = 11;
                    }
                }
            }
            while (l2 < l) {
                if (dateTime.week == -1 && dateTime.day >= 29) {
                    gregorianCalendar.set(5, 1);
                    do {
                        gregorianCalendar.add(n, 1);
                        gregorianCalendar.getTimeInMillis();
                    } while (gregorianCalendar.getActualMaximum(5) < dateTime.day);
                    gregorianCalendar.set(5, dateTime.day);
                } else if (dateTime.week < 53) {
                    gregorianCalendar.add(n, 1);
                } else {
                    gregorianCalendar.set(3, 1);
                    do {
                        gregorianCalendar.add(n, 1);
                        gregorianCalendar.getTimeInMillis();
                    } while (gregorianCalendar.getActualMaximum(3) < dateTime.week);
                    gregorianCalendar.set(3, dateTime.week);
                }
                l2 = gregorianCalendar.getTimeInMillis();
            }
        }
        return l2;
    }

    private long prevCeil(DateTime dateTime, DateTime dateTime2, long l, TimeZone timeZone) {
        if (dateTime2.year != -1) {
            return 0L;
        }
        if (l == Long.MAX_VALUE) {
            return l;
        }
        if (this.prevCeilGc == null) {
            this.prevCeilGc = SystemEnvironment.newGregorianCalendar();
        }
        GregorianCalendar gregorianCalendar = this.prevCeilGc;
        gregorianCalendar.setTimeZone(timeZone);
        long l2 = this.ceil(dateTime2, l, timeZone);
        gregorianCalendar.setTimeInMillis(l2);
        int n = 1;
        boolean bl = true;
        if (dateTime2.week == -1) {
            if (dateTime2.month == -1) {
                n = 2;
                if (dateTime2.day == -1) {
                    n = 5;
                    bl = false;
                    if (dateTime2.hour == -1) {
                        n = 11;
                    }
                }
            }
            if (dateTime2.day < 29) {
                bl = false;
            }
        } else if (dateTime2.week <= 52) {
            bl = false;
        }
        if (bl) {
            if (dateTime2.day >= 29) {
                gregorianCalendar.set(5, 1);
                do {
                    gregorianCalendar.add(n, -1);
                    gregorianCalendar.getTimeInMillis();
                } while (gregorianCalendar.getActualMaximum(5) < dateTime2.day);
                gregorianCalendar.set(5, dateTime2.day);
            } else {
                gregorianCalendar.set(3, 1);
                do {
                    gregorianCalendar.add(n, -1);
                    gregorianCalendar.getTimeInMillis();
                } while (gregorianCalendar.getActualMaximum(3) < dateTime2.week);
                gregorianCalendar.set(3, dateTime2.week);
            }
        } else {
            gregorianCalendar.add(n, -1);
        }
        long l3 = gregorianCalendar.getTimeInMillis();
        long l4 = this.floor(dateTime, l3, timeZone);
        if (l4 > l3) {
            return 0L;
        }
        l3 = this.ceil(dateTime2, l4, timeZone);
        return l3;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.deleteDependingObjects(systemEnvironment);
        super.delete(systemEnvironment);
    }

    public void deleteDependingObjects(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        Comparable comparable22;
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSIntervalTable.idx_objId.getVector(systemEnvironment, l);
        for (Comparable comparable22 : vector) {
            if (!l.equals(((SDMSIntervalProxyGeneric)comparable22).getObjId(systemEnvironment))) continue;
            try {
                comparable = ((SDMSProxy)comparable22).getId(systemEnvironment);
                IntervalUtil.killFilter(systemEnvironment, (Long)comparable);
                IntervalUtil.killSelections(systemEnvironment, (Long)comparable);
                IntervalUtil.killDispatcher(systemEnvironment, (Long)comparable);
                ((SDMSInterval)comparable22).delete(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {}
        }
        comparable22 = this.getEmbeddedIntervalId(systemEnvironment);
        if (comparable22 != null && l.equals(((SDMSIntervalProxyGeneric)(comparable = SDMSIntervalTable.getObject(systemEnvironment, (Long)comparable22))).getObjId(systemEnvironment))) {
            ((SDMSInterval)comparable).delete(systemEnvironment);
            this.setEmbeddedIntervalId(systemEnvironment, null);
        }
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity;
        long l2;
        Vector vector2;
        long l3 = 0L;
        Long l4 = this.getSeId(systemEnvironment);
        if (l4 == null || l4 == 0L) {
            l3 = super.getPrivileges(systemEnvironment, l, bl, vector);
            return (l3 | 0x10000000L) & l;
        }
        if (vector == null) {
            vector2 = new Vector();
            if (systemEnvironment.cEnv.isUser()) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
        } else {
            vector2 = vector;
        }
        if (((l2 = (sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l4)).getPrivileges(systemEnvironment, 0x10100000L, false, vector2)) & 0x100000L) == 0x100000L) {
            Long l5 = this.getOwnerId(systemEnvironment);
            l3 = vector2.contains(l5) || vector2.contains(SDMSObject.adminGId) ? l : 0x10000000L;
        } else if ((l2 & 0x10000000L) == 0x10000000L) {
            l3 |= 0x10000000L;
        }
        l3 = this.addImplicitPrivs(l3) & l;
        return l3;
    }

    public boolean isDependent(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getSeId(systemEnvironment) != null && this.getSeId(systemEnvironment) != 0L || this.getObjId(systemEnvironment) != null;
    }

    public Vector collectReferences(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        Vector vector = this.getReferences(systemEnvironment, n);
        this.traverseReferences(systemEnvironment, vector);
        return vector;
    }

    private Vector getReferences(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        Comparable<Long> comparable;
        Long l;
        Vector<IntervalReference> vector;
        SDMSProxy sDMSProxy;
        int n2;
        int n3 = 0;
        Long l2 = this.getId(systemEnvironment);
        Vector vector2 = new Vector();
        Vector vector3 = SDMSIntervalHierarchyTable.idx_childId.getVector(systemEnvironment, l2);
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            try {
                sDMSProxy = SDMSIntervalTable.getObject(systemEnvironment, ((SDMSIntervalHierarchy)vector3.get(n2)).getParentId(systemEnvironment));
                vector = new Vector<IntervalReference>();
                vector.add(new IntervalReference(RefererType.INTERVAL, ReferenceUsage.FILTER, sDMSProxy.getId(systemEnvironment), ((SDMSIntervalProxyGeneric)sDMSProxy).getName(systemEnvironment), ((SDMSInterval)sDMSProxy).isDependent(systemEnvironment)));
                vector2.add(vector);
                if (n <= 0 || ++n3 < n) continue;
                return vector2;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        vector3 = SDMSIntervalTable.idx_embeddedIntervalId.getVector(systemEnvironment, l2);
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            sDMSProxy = (SDMSInterval)vector3.get(n2);
            vector = new Vector();
            vector.add(new IntervalReference(RefererType.INTERVAL, ReferenceUsage.EMBEDD, sDMSProxy.getId(systemEnvironment), ((SDMSIntervalProxyGeneric)sDMSProxy).getName(systemEnvironment), ((SDMSInterval)sDMSProxy).isDependent(systemEnvironment)));
            vector2.add(vector);
            if (n <= 0 || ++n3 < n) continue;
            return vector2;
        }
        vector3 = SDMSIntervalDispatcherTable.idx_filterIntId.getVector(systemEnvironment, l2);
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            sDMSProxy = (SDMSIntervalDispatcher)vector3.get(n2);
            vector = new Vector();
            vector.add(new IntervalReference(RefererType.DISPATCHER, ReferenceUsage.DISPATCH_FILTER, sDMSProxy.getId(systemEnvironment), ((SDMSIntervalDispatcherProxyGeneric)sDMSProxy).getName(systemEnvironment), true));
            vector2.add(vector);
            if (n <= 0 || ++n3 < n) continue;
            return vector2;
        }
        vector3 = SDMSIntervalDispatcherTable.idx_selectIntId.getVector(systemEnvironment, l2);
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            sDMSProxy = (SDMSIntervalDispatcher)vector3.get(n2);
            vector = new Vector();
            vector.add(new IntervalReference(RefererType.DISPATCHER, ReferenceUsage.DISPATCH_SELECT, sDMSProxy.getId(systemEnvironment), ((SDMSIntervalDispatcherProxyGeneric)sDMSProxy).getName(systemEnvironment), true));
            vector2.add(vector);
            if (n <= 0 || ++n3 < n) continue;
            return vector2;
        }
        vector3 = SDMSSchedulingHierarchyTable.idx_intId.getVector(systemEnvironment, l2);
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            sDMSProxy = (SDMSSchedulingHierarchy)vector3.get(n2);
            l = ((SDMSSchedulingHierarchyProxyGeneric)sDMSProxy).getSeParentId(systemEnvironment);
            comparable = ((SDMSSchedulingHierarchyProxyGeneric)sDMSProxy).getSeChildId(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
            SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, comparable);
            IntervalReference intervalReference = new IntervalReference(RefererType.SCHEDULING_ENTITY, ReferenceUsage.CHILD_ENABLE, l, sDMSSchedulingEntity.pathString(systemEnvironment), false);
            intervalReference.seType = sDMSSchedulingEntity.getTypeAsString(systemEnvironment);
            intervalReference.childId = comparable;
            intervalReference.childName = sDMSSchedulingEntity2.pathString(systemEnvironment);
            intervalReference.childType = sDMSSchedulingEntity2.getTypeAsString(systemEnvironment);
            vector = new Vector();
            vector.add(intervalReference);
            vector2.add(vector);
            if (n <= 0 || ++n3 < n) continue;
            return vector2;
        }
        vector3 = SDMSScheduleTable.idx_intId.getVector(systemEnvironment, l2);
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            sDMSProxy = (SDMSSchedule)vector3.get(n2);
            l = ((SDMSScheduleProxyGeneric)sDMSProxy).getSeId(systemEnvironment);
            comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
            vector = new Vector();
            vector.add(new IntervalReference(RefererType.SCHEDULE, ReferenceUsage.INTERVAL, sDMSProxy.getId(systemEnvironment), ((SDMSScheduleProxyGeneric)sDMSProxy).getName(systemEnvironment), true));
            vector2.add(vector);
            if (n <= 0 || ++n3 < n) continue;
            return vector2;
        }
        return vector2;
    }

    private void traverseReferences(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        for (int i = 0; i < vector.size(); ++i) {
            this.traverseReference(systemEnvironment, (Vector)vector.get(i));
        }
    }

    private void traverseReference(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        IntervalReference intervalReference;
        IntervalReference intervalReference2 = (IntervalReference)vector.get(0);
        while (intervalReference2.isDependent && (intervalReference = this.getReferer(systemEnvironment, intervalReference2)) != null) {
            vector.add(intervalReference);
            intervalReference2 = intervalReference;
        }
    }

    private IntervalReference getReferer(SystemEnvironment systemEnvironment, IntervalReference intervalReference) throws SDMSException {
        IntervalReference intervalReference2 = null;
        switch (intervalReference.refererType) {
            case INTERVAL: {
                SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, intervalReference.refererId);
                Vector vector = sDMSInterval.collectReferences(systemEnvironment, 1);
                if (vector.size() <= 0) break;
                Vector vector2 = (Vector)vector.get(0);
                intervalReference2 = (IntervalReference)vector2.get(0);
                break;
            }
            case DISPATCHER: {
                SDMSIntervalDispatcher sDMSIntervalDispatcher = SDMSIntervalDispatcherTable.getObject(systemEnvironment, intervalReference.refererId);
                SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, sDMSIntervalDispatcher.getIntId(systemEnvironment));
                intervalReference2 = new IntervalReference(RefererType.INTERVAL, ReferenceUsage.DISPATCH, sDMSInterval.getId(systemEnvironment), sDMSInterval.getName(systemEnvironment), sDMSInterval.isDependent(systemEnvironment));
                break;
            }
            case SCHEDULING_ENTITY: {
                break;
            }
            case SCHEDULE: {
                SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, intervalReference.refererId);
                Long l = sDMSSchedule.getSeId(systemEnvironment);
                Long l2 = sDMSSchedule.getParentId(systemEnvironment);
                SDMSSchedule sDMSSchedule2 = SDMSScheduleTable.getObject(systemEnvironment, l2);
                if (sDMSSchedule2.getSeId(systemEnvironment) == l) {
                    intervalReference2 = new IntervalReference(RefererType.SCHEDULE, ReferenceUsage.SCHEDULE, sDMSSchedule2.getId(systemEnvironment), sDMSSchedule2.getName(systemEnvironment), true);
                    break;
                }
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
                intervalReference2 = new IntervalReference(RefererType.SCHEDULING_ENTITY, ReferenceUsage.SCHEDULE, l, sDMSSchedulingEntity.pathString(systemEnvironment), false);
                intervalReference2.seType = sDMSSchedulingEntity.getTypeAsString(systemEnvironment);
            }
        }
        return intervalReference2;
    }

    public String referenceUsageToString(ReferenceUsage referenceUsage) {
        switch (referenceUsage) {
            case FILTER: {
                return "FILTER";
            }
            case EMBEDD: {
                return "EMBEDD";
            }
            case DISPATCH: {
                return "DISPATCH";
            }
            case DISPATCH_SELECT: {
                return "DISPATCH_SELECT";
            }
            case DISPATCH_FILTER: {
                return "DISPATCH_FILTER";
            }
            case CHILD_ENABLE: {
                return "CHILD_ENABLE";
            }
            case INTERVAL: {
                return "INTERVAL";
            }
            case SCHEDULE: {
                return "SCHEDULE";
            }
        }
        return "Unknown Reference Type";
    }

    public String refererTypeToString(RefererType refererType) {
        switch (refererType) {
            case INTERVAL: {
                return "INTERVAL";
            }
            case SCHEDULING_ENTITY: {
                return "SCHEDULING_ENTITY";
            }
            case DISPATCHER: {
                return "DISPATCHER";
            }
            case SCHEDULE: {
                return "SCHEDULE";
            }
        }
        return "Unknown Referer Type";
    }
}

