/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import java.util.HashMap;
import java.util.Vector;

public class SDMSIntervalProxyGeneric
extends SDMSProxy {
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final long MINUTE_DUR = 60000L;
    public static final long HOUR_DUR = 3600000L;
    public static final long DAY_DUR = 86400000L;
    public static final long WEEK_DUR = 604800000L;
    public static final long MONTH_DUR = 2592000000L;
    public static final long YEAR_DUR = 31536000000L;
    public static final long MINUTE_DUR_M = 1L;
    public static final long HOUR_DUR_M = 60L;
    public static final long DAY_DUR_M = 1440L;
    public static final long WEEK_DUR_M = 10080L;
    public static final long MONTH_DUR_M = 43200L;
    public static final long YEAR_DUR_M = 525600L;
    public static final int SYSTEM = 0;
    public static final int SELECT = 99;
    public static final int DISTRIBUTION = 25;
    public static final int ENVIRONMENT = 1;
    public static final int EXIT_STATE_DEFINITION = 2;
    public static final int EXIT_STATE_PROFILE = 3;
    public static final int EXIT_STATE_MAPPING = 4;
    public static final int EXIT_STATE_TRANSLATION = 5;
    public static final int FOLDER = 6;
    public static final int FOOTPRINT = 7;
    public static final int USER = 8;
    public static final int JOB_DEFINITION = 9;
    public static final int NAMED_RESOURCE = 10;
    public static final int NICE_PROFILE = 31;
    public static final int PARAMETER = 23;
    public static final int POOL = 24;
    public static final int RESOURCE = 11;
    public static final int RESOURCE_STATE_MAPPING = 12;
    public static final int RESOURCE_STATE_DEFINITION = 13;
    public static final int RESOURCE_STATE_PROFILE = 14;
    public static final int SCOPE = 15;
    public static final int TRIGGER = 16;
    public static final int JOB = 17;
    public static final int EVENT = 18;
    public static final int INTERVAL = 19;
    public static final int SCHEDULE = 20;
    public static final int GROUP = 21;
    public static final int SCHEDULED_EVENT = 22;
    public static final int COMMENT = 26;
    public static final int GRANT = 27;
    public static final int RESOURCE_TEMPLATE = 28;
    public static final int WATCH_TYPE = 29;
    public static final int OBJECT_MONITOR = 30;
    public static final int INTERVAL_DISPATCHER = 88;
    public static final long MINUTE_MAX = 60000L;
    public static final long HOUR_MAX = 3600000L;
    public static final long DAY_MAX = 90000000L;
    public static final long WEEK_MAX = 608400000L;
    public static final long MONTH_MAX = 2682000000L;
    public static final long YEAR_MAX = 31622400000L;
    public static final long privilegeMask = 0x210000111L;
    public static final int name_size = 64;

    protected SDMSIntervalProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSInterval getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSIntervalTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSInterval(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSInterval)sDMSProxy;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getName(systemEnvironment);
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setName(systemEnvironment, string);
    }

    public static int getNameMaxLength() {
        return 64;
    }

    @Override
    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getOwnerId(systemEnvironment);
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setOwnerId(systemEnvironment, l);
    }

    public Long getStartTime(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getStartTime(systemEnvironment);
    }

    public void setStartTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setStartTime(systemEnvironment, l);
    }

    public Long getEndTime(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getEndTime(systemEnvironment);
    }

    public void setEndTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setEndTime(systemEnvironment, l);
    }

    public Long getDelay(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getDelay(systemEnvironment);
    }

    public void setDelay(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setDelay(systemEnvironment, l);
    }

    public Integer getBaseInterval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getBaseInterval(systemEnvironment);
    }

    public String getBaseIntervalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getBaseIntervalAsString(systemEnvironment);
    }

    public void setBaseInterval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setBaseInterval(systemEnvironment, n);
    }

    public Integer getBaseIntervalMultiplier(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getBaseIntervalMultiplier(systemEnvironment);
    }

    public void setBaseIntervalMultiplier(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setBaseIntervalMultiplier(systemEnvironment, n);
    }

    public Integer getDuration(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getDuration(systemEnvironment);
    }

    public String getDurationAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getDurationAsString(systemEnvironment);
    }

    public void setDuration(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setDuration(systemEnvironment, n);
    }

    public Integer getDurationMultiplier(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getDurationMultiplier(systemEnvironment);
    }

    public void setDurationMultiplier(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setDurationMultiplier(systemEnvironment, n);
    }

    public Long getSyncTime(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getSyncTime(systemEnvironment);
    }

    public void setSyncTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setSyncTime(systemEnvironment, l);
    }

    public Boolean getIsInverse(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getIsInverse(systemEnvironment);
    }

    public void setIsInverse(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setIsInverse(systemEnvironment, bl);
    }

    public Boolean getIsMerge(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getIsMerge(systemEnvironment);
    }

    public void setIsMerge(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setIsMerge(systemEnvironment, bl);
    }

    public Long getEmbeddedIntervalId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getEmbeddedIntervalId(systemEnvironment);
    }

    public void setEmbeddedIntervalId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setEmbeddedIntervalId(systemEnvironment, l);
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getSeId(systemEnvironment);
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setSeId(systemEnvironment, l);
    }

    public Long getObjId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getObjId(systemEnvironment);
    }

    public void setObjId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setObjId(systemEnvironment, l);
    }

    public Integer getObjType(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getObjType(systemEnvironment);
    }

    public String getObjTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getObjTypeAsString(systemEnvironment);
    }

    public void setObjType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setObjType(systemEnvironment, n);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSInterval setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSIntervalGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSInterval)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSIntervalGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSInterval setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSIntervalGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSInterval)this;
    }

    public SDMSInterval set_NameObjId(SystemEnvironment systemEnvironment, String string, Long l) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        ((SDMSIntervalGeneric)this.object).set_NameObjId(systemEnvironment, string, l);
        return (SDMSInterval)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)this.getName(systemEnvironment)));
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectCommentTable.dropComment(systemEnvironment, this.getId(systemEnvironment));
        Vector vector = SDMSGrantTable.idx_objectId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant = (SDMSGrant)vector.get(i);
            sDMSGrant.delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x210000111L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x210000111L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x210000111L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l2 = 0L;
        if (systemEnvironment.cEnv.isUser()) {
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                return l;
            }
            if (vector2.contains(this.getOwnerId(systemEnvironment)) && (l2 = l & 0xFFFFFFFFFFFFFFFBL) == l) {
                return l2;
            }
        }
        return l2;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing Interval $1", this.getName(systemEnvironment));
        return sDMSMessage;
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSIntervalGeneric)this.object).print();
    }
}

