/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSKillJobGeneric;
import de.independit.scheduler.server.repository.SDMSKillJobTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSKillJobTableGeneric
extends SDMSTable {
    public static final String tableName = "KILL_JOB";
    public static SDMSKillJobTable table = null;
    public static final String[] columnNames = new String[]{"ID", "SE_ID", "SE_VERSION", "SME_ID", "SCOPE_ID", "STATE", "EXIT_CODE", "COMMANDLINE", "LOGFILE", "ERRLOGFILE", "PID", "EXTPID", "ERROR_MSG", "RUNNABLE_TS", "START_TS", "FINSH_TS", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_seId;
    public static SDMSIndex idx_smeId;
    public static SDMSIndex idx_scopeId;
    public static SDMSIndex idx_state;

    public SDMSKillJobTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "KillJob"));
        }
        table = (SDMSKillJobTable)this;
        table = (SDMSKillJobTable)this;
        this.isVersioned = false;
        idx_seId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seId");
        idx_smeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "smeId");
        idx_scopeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "scopeId");
        idx_state = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "state");
    }

    public SDMSKillJob create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, String string, String string2, String string3, String string4, String string5, String string6, Long l5, Long l6, Long l7) throws SDMSException {
        SDMSKillJob sDMSKillJob;
        Long l8 = systemEnvironment.cEnv.uid();
        Long l9 = systemEnvironment.txTime();
        Long l10 = systemEnvironment.cEnv.uid();
        Long l11 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "KillJob"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, n, n2, string, string2, string3, string4, string5, string6, l5, l6, l7, l8, l9, l10, l11);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSKillJobGeneric sDMSKillJobGeneric = new SDMSKillJobGeneric(systemEnvironment, l, l2, l3, l4, n, n2, string, string2, string3, string4, string5, string6, l5, l6, l7, l8, l9, l10, l11);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSKillJobGeneric.versions, true);
            table.put(systemEnvironment, sDMSKillJobGeneric.id, sDMSKillJobGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSKillJob = (SDMSKillJob)sDMSKillJobGeneric.toProxy(systemEnvironment);
            sDMSKillJob.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSKillJob sDMSKillJob2 = (SDMSKillJob)sDMSKillJobGeneric.toProxy(systemEnvironment);
            sDMSKillJob2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSKillJob)) {
            throw new AccessViolationException(sDMSKillJob.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSKillJob.touchMaster(systemEnvironment);
        return sDMSKillJob;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSKillJob sDMSKillJob) throws SDMSException {
        return sDMSKillJob.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, String string, String string2, String string3, String string4, String string5, String string6, Long l5, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11) throws SDMSException {
        if (!SDMSKillJobGeneric.checkState(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "KillJob: $1 $2", "state", n));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Integer n;
        Integer n2;
        Long l10;
        Long l11;
        Long l12;
        Long l13;
        Long l14;
        try {
            l14 = resultSet.getLong(1);
            l13 = resultSet.getLong(2);
            l12 = resultSet.getLong(3);
            l11 = resultSet.getLong(4);
            l10 = resultSet.getLong(5);
            n2 = resultSet.getInt(6);
            n = resultSet.getInt(7);
            if (resultSet.wasNull()) {
                n = null;
            }
            string6 = resultSet.getString(8);
            if (resultSet.wasNull()) {
                string6 = null;
            }
            string5 = resultSet.getString(9);
            if (resultSet.wasNull()) {
                string5 = null;
            }
            string4 = resultSet.getString(10);
            if (resultSet.wasNull()) {
                string4 = null;
            }
            string3 = resultSet.getString(11);
            if (resultSet.wasNull()) {
                string3 = null;
            }
            string2 = resultSet.getString(12);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            string = resultSet.getString(13);
            if (resultSet.wasNull()) {
                string = null;
            }
            l9 = resultSet.getLong(14);
            if (resultSet.wasNull()) {
                l9 = null;
            }
            l8 = resultSet.getLong(15);
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = resultSet.getLong(16);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            l6 = resultSet.getLong(17);
            l5 = resultSet.getLong(18);
            l4 = resultSet.getLong(19);
            l3 = resultSet.getLong(20);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "KillJob: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSKillJobGeneric(l14, l13, l12, l11, l10, n2, n, string6, string5, string4, string3, string2, string, l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "SE_ID" + string2 + ", " + string + "SE_VERSION" + string2 + ", " + string + "SME_ID" + string2 + ", " + string + "SCOPE_ID" + string2 + ", " + string + "STATE" + string2 + ", " + string + "EXIT_CODE" + string2 + ", " + string + "COMMANDLINE" + string2 + ", " + string + "LOGFILE" + string2 + ", " + string + "ERRLOGFILE" + string2 + ", " + string + "PID" + string2 + ", " + string + "EXTPID" + string2 + ", " + string + "ERROR_MSG" + string2 + ", " + string + "RUNNABLE_TS" + string2 + ", " + string + "START_TS" + string2 + ", " + string + "FINSH_TS" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + "  FROM " + string + this.tableName() + string2 + " WHERE SE_VERSION >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' as DECIMAL)" : "" + systemEnvironment.lowestActiveVersion));
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_seId.check(((SDMSKillJobGeneric)sDMSObject).seId, sDMSObject);
        object = (String)object + "idx_seId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_smeId.check(((SDMSKillJobGeneric)sDMSObject).smeId, sDMSObject);
        object = (String)object + "idx_smeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_scopeId.check(((SDMSKillJobGeneric)sDMSObject).scopeId, sDMSObject);
        object = (String)object + "idx_scopeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_state.check(((SDMSKillJobGeneric)sDMSObject).state, sDMSObject);
        object = (String)object + "idx_state: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_seId.put(systemEnvironment, ((SDMSKillJobGeneric)sDMSObject).seId, sDMSObject, (1L & l) != 0L);
        idx_smeId.put(systemEnvironment, ((SDMSKillJobGeneric)sDMSObject).smeId, sDMSObject, (2L & l) != 0L);
        idx_scopeId.put(systemEnvironment, ((SDMSKillJobGeneric)sDMSObject).scopeId, sDMSObject, (4L & l) != 0L);
        idx_state.put(systemEnvironment, ((SDMSKillJobGeneric)sDMSObject).state, sDMSObject, (8L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_seId.remove(systemEnvironment, ((SDMSKillJobGeneric)sDMSObject).seId, sDMSObject);
        idx_smeId.remove(systemEnvironment, ((SDMSKillJobGeneric)sDMSObject).smeId, sDMSObject);
        idx_scopeId.remove(systemEnvironment, ((SDMSKillJobGeneric)sDMSObject).scopeId, sDMSObject);
        idx_state.remove(systemEnvironment, ((SDMSKillJobGeneric)sDMSObject).state, sDMSObject);
    }

    public static SDMSKillJob getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSKillJob)table.get(systemEnvironment, l);
    }

    public static SDMSKillJob getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSKillJob)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSKillJob getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSKillJob)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

