/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class SDMSNamedResourceTableGeneric
extends SDMSTable {
    public static final String tableName = "NAMED_RESOURCE";
    public static SDMSNamedResourceTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "OWNER_ID", "PARENT_ID", "USAGE", "RSP_ID", "FACTOR", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS", "INHERIT_PRIVS"};
    public static SDMSIndex idx_name;
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_parentId;
    public static SDMSIndex idx_rspId;
    public static SDMSIndex idx_parentId_name;

    public SDMSNamedResourceTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "NamedResource"));
        }
        table = (SDMSNamedResourceTable)this;
        table = (SDMSNamedResourceTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "name");
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_parentId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "parentId");
        idx_rspId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rspId");
        idx_parentId_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "parentId_name");
    }

    public SDMSNamedResource create(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, Long l3, Float f, Long l4) throws SDMSException {
        SDMSNamedResource sDMSNamedResource;
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "NamedResource"));
        }
        this.validate(systemEnvironment, string, l, l2, n, l3, f, l5, l6, l7, l8, l4);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSNamedResourceGeneric sDMSNamedResourceGeneric = new SDMSNamedResourceGeneric(systemEnvironment, string, l, l2, n, l3, f, l5, l6, l7, l8, l4);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSNamedResourceGeneric.versions, true);
            table.put(systemEnvironment, sDMSNamedResourceGeneric.id, sDMSNamedResourceGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSNamedResource = (SDMSNamedResource)sDMSNamedResourceGeneric.toProxy(systemEnvironment);
            sDMSNamedResource.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSNamedResource sDMSNamedResource2 = (SDMSNamedResource)sDMSNamedResourceGeneric.toProxy(systemEnvironment);
            sDMSNamedResource2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSNamedResource)) {
            throw new AccessViolationException(sDMSNamedResource.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSNamedResource;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource) throws SDMSException {
        Long l = sDMSNamedResource.getParentId(systemEnvironment);
        SDMSNamedResource sDMSNamedResource2 = SDMSNamedResourceTable.getObject(systemEnvironment, l);
        return sDMSNamedResource2.checkPrivileges(systemEnvironment, 2L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, Long l3, Float f, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        if (!SDMSNamedResourceGeneric.checkUsage(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "NamedResource: $1 $2", "usage", n));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Float f;
        Long l8;
        Integer n;
        Long l9;
        Long l10;
        String string;
        Long l11;
        try {
            l11 = resultSet.getLong(1);
            string = resultSet.getString(2);
            l10 = resultSet.getLong(3);
            l9 = resultSet.getLong(4);
            if (resultSet.wasNull()) {
                l9 = null;
            }
            n = resultSet.getInt(5);
            l8 = resultSet.getLong(6);
            if (resultSet.wasNull()) {
                l8 = null;
            }
            f = Float.valueOf(resultSet.getFloat(7));
            if (resultSet.wasNull()) {
                f = null;
            }
            l7 = resultSet.getLong(8);
            l6 = resultSet.getLong(9);
            l5 = resultSet.getLong(10);
            l4 = resultSet.getLong(11);
            l3 = resultSet.getLong(12);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "NamedResource: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSNamedResourceGeneric(l11, string, l10, l9, n, l8, f, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "PARENT_ID" + string2 + ", " + string + "USAGE" + string2 + ", " + string + "RSP_ID" + string2 + ", " + string + "FACTOR" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", " + string + "INHERIT_PRIVS" + string2 + " FROM " + string + this.tableName() + string2);
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_name.check(((SDMSNamedResourceGeneric)sDMSObject).name, sDMSObject);
        object = (String)object + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_ownerId.check(((SDMSNamedResourceGeneric)sDMSObject).ownerId, sDMSObject);
        object = (String)object + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_parentId.check(((SDMSNamedResourceGeneric)sDMSObject).parentId, sDMSObject);
        object = (String)object + "idx_parentId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_rspId.check(((SDMSNamedResourceGeneric)sDMSObject).rspId, sDMSObject);
        object = (String)object + "idx_rspId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSNamedResourceGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSNamedResourceGeneric)sDMSObject).name));
        bl = idx_parentId_name.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_parentId_name: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSNamedResourceGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
        idx_ownerId.put(systemEnvironment, ((SDMSNamedResourceGeneric)sDMSObject).ownerId, sDMSObject, (2L & l) != 0L);
        idx_parentId.put(systemEnvironment, ((SDMSNamedResourceGeneric)sDMSObject).parentId, sDMSObject, (4L & l) != 0L);
        idx_rspId.put(systemEnvironment, ((SDMSNamedResourceGeneric)sDMSObject).rspId, sDMSObject, (8L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSNamedResourceGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSNamedResourceGeneric)sDMSObject).name));
        idx_parentId_name.put(systemEnvironment, sDMSKey, sDMSObject, (0x10L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSNamedResourceGeneric)sDMSObject).name, sDMSObject);
        idx_ownerId.remove(systemEnvironment, ((SDMSNamedResourceGeneric)sDMSObject).ownerId, sDMSObject);
        idx_parentId.remove(systemEnvironment, ((SDMSNamedResourceGeneric)sDMSObject).parentId, sDMSObject);
        idx_rspId.remove(systemEnvironment, ((SDMSNamedResourceGeneric)sDMSObject).rspId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSNamedResourceGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSNamedResourceGeneric)sDMSObject).name));
        idx_parentId_name.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSNamedResource getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSNamedResource)table.get(systemEnvironment, l);
    }

    public static SDMSNamedResource getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSNamedResource)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSNamedResource getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSNamedResource)table.get(systemEnvironment, l, l2);
    }

    public static SDMSNamedResource idx_parentId_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSNamedResource)idx_parentId_name.getUnique(systemEnvironment, object);
    }

    public static SDMSNamedResource idx_parentId_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSNamedResource)idx_parentId_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSNamedResource idx_parentId_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSNamedResource)idx_parentId_name.getUnique(systemEnvironment, object, l);
    }

    public static Long pathToId(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return SDMSNamedResourceTableGeneric.getNamedResource(systemEnvironment, vector).getId(systemEnvironment);
    }

    public static Long pathToIdForUpdate(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return SDMSNamedResourceTableGeneric.getNamedResourceForUpdate(systemEnvironment, vector).getId(systemEnvironment);
    }

    public static SDMSNamedResource getNamedResource(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = null;
        SDMSNamedResource sDMSNamedResource = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSNamedResource = (SDMSNamedResource)SDMSNamedResourceTable.idx_parentId_name.getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
            l = sDMSNamedResource.getId(systemEnvironment);
        }
        return sDMSNamedResource;
    }

    public static SDMSNamedResource getNamedResourceForUpdate(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = null;
        SDMSNamedResource sDMSNamedResource = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSNamedResource = (SDMSNamedResource)SDMSNamedResourceTable.idx_parentId_name.getUniqueForUpdate(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
            l = sDMSNamedResource.getId(systemEnvironment);
        }
        return sDMSNamedResource;
    }

    public static Long pathToId(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return SDMSNamedResourceTableGeneric.getNamedResource(systemEnvironment, vector, l).getId(systemEnvironment);
    }

    public static SDMSNamedResource getNamedResource(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        Long l2 = null;
        SDMSNamedResource sDMSNamedResource = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSNamedResource = (SDMSNamedResource)SDMSNamedResourceTable.idx_parentId_name.getUnique(systemEnvironment, new SDMSKey(l2, (Comparable)((Object)string)), l);
            l2 = sDMSNamedResource.getId(systemEnvironment);
        }
        return sDMSNamedResource;
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

