/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.ResourceVariableResolver;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceVariable;
import de.independit.scheduler.server.repository.SDMSResourceVariableTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSSysResource;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.VariableResolver;
import de.independit.scheduler.server.util.Lockmode;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class SDMSResource
extends SDMSResourceProxyGeneric
implements SDMSSysResource,
SDMSOwnedObject {
    public static final String __version = "@(#) $Id: SDMSResource.java,v 2.50.2.5 2013/03/25 10:19:14 dieter Exp $";
    private static final VariableResolver RVR = new ResourceVariableResolver();
    private static final Object protectTraceInsert = new Object();
    private static PreparedStatement traceInsert = null;

    protected SDMSResource(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.getNrId(systemEnvironment));
        String string = sDMSNamedResource.getName(systemEnvironment);
        return string;
    }

    public SDMSResource getBase(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSResource sDMSResource = this;
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            while ((l = (sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l)).getLinkId(systemEnvironment)) != null) {
            }
        }
        return sDMSResource;
    }

    public Integer getUsage(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.getNrId(systemEnvironment));
        return sDMSNamedResource.getUsage(systemEnvironment);
    }

    @Override
    public String getTag(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getTag(systemEnvironment) : this.getBase(systemEnvironment).getTag(systemEnvironment);
    }

    @Override
    public Long getRsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getRsdId(systemEnvironment) : this.getBase(systemEnvironment).getRsdId(systemEnvironment);
    }

    @Override
    public Long getRsdTime(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getRsdTime(systemEnvironment) : this.getBase(systemEnvironment).getRsdTime(systemEnvironment);
    }

    @Override
    public void setRsdTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 == null) {
            super.setRsdTime(systemEnvironment, l);
        } else {
            this.getBase(systemEnvironment).setRsdTime(systemEnvironment, l);
        }
    }

    @Override
    public Integer getDefinedAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getDefinedAmount(systemEnvironment) : this.getBase(systemEnvironment).getDefinedAmount(systemEnvironment);
    }

    @Override
    public void setDefinedAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l == null) {
            super.setDefinedAmount(systemEnvironment, n);
        } else {
            this.getBase(systemEnvironment).setDefinedAmount(systemEnvironment, n);
        }
    }

    @Override
    public Integer getRequestableAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getRequestableAmount(systemEnvironment) : this.getBase(systemEnvironment).getRequestableAmount(systemEnvironment);
    }

    @Override
    public Integer getAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getAmount(systemEnvironment) : this.getBase(systemEnvironment).getAmount(systemEnvironment);
    }

    @Override
    public Integer getFreeAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getFreeAmount(systemEnvironment) : this.getBase(systemEnvironment).getFreeAmount(systemEnvironment);
    }

    @Override
    public Boolean getIsOnline(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getIsOnline(systemEnvironment) : this.getBase(systemEnvironment).getIsOnline(systemEnvironment);
    }

    @Override
    public void setIsOnline(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l == null) {
            super.setIsOnline(systemEnvironment, bl);
        } else {
            this.getBase(systemEnvironment).setIsOnline(systemEnvironment, bl);
        }
    }

    @Override
    public Long getLastEval(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getLastEval(systemEnvironment) : this.getBase(systemEnvironment).getLastEval(systemEnvironment);
    }

    @Override
    public void setLastEval(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 == null) {
            super.setLastEval(systemEnvironment, l);
        } else {
            this.getBase(systemEnvironment).setLastEval(systemEnvironment, l);
        }
    }

    @Override
    public Long getLastWrite(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        return l == null ? super.getLastWrite(systemEnvironment) : this.getBase(systemEnvironment).getLastWrite(systemEnvironment);
    }

    @Override
    public void setLastWrite(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 == null) {
            super.setLastWrite(systemEnvironment, l);
        } else {
            this.getBase(systemEnvironment).setLastWrite(systemEnvironment, l);
        }
    }

    @Override
    public Integer getTotalFreeAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getFreeAmount(systemEnvironment);
    }

    public int checkAllocate(SystemEnvironment systemEnvironment, SDMSResourceRequirement sDMSResourceRequirement, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSResourceAllocation sDMSResourceAllocation) throws SDMSException {
        SDMSResource sDMSResource = this.getBase(systemEnvironment);
        return sDMSResource.checkAllocate(systemEnvironment, sDMSResourceRequirement, sDMSSubmittedEntity, sDMSResourceAllocation, 0, new Lockmode());
    }

    public int checkAllocate(SystemEnvironment systemEnvironment, SDMSResourceRequirement sDMSResourceRequirement, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSResourceAllocation sDMSResourceAllocation, int n, Lockmode lockmode) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            return this.getBase(systemEnvironment).checkAllocate(systemEnvironment, sDMSResourceRequirement, sDMSSubmittedEntity, sDMSResourceAllocation, n, lockmode);
        }
        int n2 = 0;
        if (!this.getIsOnline(systemEnvironment).booleanValue()) {
            return 16;
        }
        Long l2 = sDMSResourceAllocation != null ? sDMSResourceAllocation.getStickyParent(systemEnvironment) : null;
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.getNrId(systemEnvironment));
        int n3 = sDMSNamedResource.getUsage(systemEnvironment);
        if (n3 == 1) {
            return 0;
        }
        if (n3 == 4) {
            if (!this.syncCheckState(systemEnvironment, sDMSResourceRequirement)) {
                return 4;
            }
            if (!this.syncCheckExpired(systemEnvironment, sDMSResourceRequirement, sDMSNamedResource, sDMSSubmittedEntity)) {
                return 8;
            }
            if (!this.checkAmount(systemEnvironment, sDMSResourceRequirement, l2, n)) {
                n2 |= 2;
            }
            if (!this.syncCheckLockmode(systemEnvironment, sDMSResourceRequirement, l2, lockmode)) {
                n2 |= 1;
            }
        } else {
            float f = 1.0f;
            int n4 = sDMSResourceRequirement.getAmount(systemEnvironment);
            int n5 = (int)Math.ceil((float)n4 * f);
            if (!this.checkAmount(systemEnvironment, n5, n4, n)) {
                n2 |= 2;
            }
        }
        return n2;
    }

    public boolean checkAmount(SystemEnvironment systemEnvironment, SDMSResourceRequirement sDMSResourceRequirement, Long l, int n) throws SDMSException {
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 != null) {
            return this.getBase(systemEnvironment).checkAmount(systemEnvironment, sDMSResourceRequirement, l, n);
        }
        Integer n2 = sDMSResourceRequirement.getAmount(systemEnvironment);
        Integer n3 = this.getFreeAmount(systemEnvironment);
        Integer n4 = this.getRequestableAmount(systemEnvironment);
        if (n2 == null || n2 == 0) {
            return true;
        }
        int n5 = n2;
        if (n4 != null && n4 < n5) {
            return false;
        }
        if (n3 == null) {
            return true;
        }
        int n6 = n3 - n;
        float f = 1.0f;
        int n7 = (int)Math.ceil((float)n5 * f);
        if (n7 > n6 && sDMSResourceRequirement.getIsSticky(systemEnvironment).booleanValue()) {
            try {
                Long l3 = -l.longValue();
                SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)SDMSResourceAllocationTable.idx_smeId_rId_stickyName.getUnique(systemEnvironment, new SDMSKey(l3, this.getId(systemEnvironment), (Comparable)((Object)sDMSResourceRequirement.getStickyName(systemEnvironment))));
                if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 6) {
                    return false;
                }
                int n8 = Math.max(sDMSResourceAllocation.getAmount(systemEnvironment), 0) + Math.max(n6, 0);
                return n8 >= n7;
            }
            catch (NotFoundException notFoundException) {
                return false;
            }
        }
        return true;
    }

    public boolean checkAmount(SystemEnvironment systemEnvironment, int n, int n2, int n3) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            return this.getBase(systemEnvironment).checkAmount(systemEnvironment, n, n2, n3);
        }
        Integer n4 = this.getFreeAmount(systemEnvironment);
        Integer n5 = this.getRequestableAmount(systemEnvironment);
        if (n5 != null && n5 < n2) {
            return false;
        }
        if (n4 == null) {
            return true;
        }
        int n6 = n4;
        return n <= n6 - n3;
    }

    public boolean syncCheckState(SystemEnvironment systemEnvironment, SDMSResourceRequirement sDMSResourceRequirement) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            return this.getBase(systemEnvironment).syncCheckState(systemEnvironment, sDMSResourceRequirement);
        }
        Long l2 = this.getRsdId(systemEnvironment);
        Vector vector = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, sDMSResourceRequirement.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceReqStates sDMSResourceReqStates = (SDMSResourceReqStates)vector.get(i);
            if (!sDMSResourceReqStates.getRsdId(systemEnvironment).equals(l2)) continue;
            return true;
        }
        return vector.size() == 0;
    }

    public boolean syncCheckLockmode(SystemEnvironment systemEnvironment, SDMSResourceRequirement sDMSResourceRequirement, Long l, Lockmode lockmode) throws SDMSException {
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 != null) {
            return this.getBase(systemEnvironment).syncCheckLockmode(systemEnvironment, sDMSResourceRequirement, l, lockmode);
        }
        String string = sDMSResourceRequirement.getStickyName(systemEnvironment);
        Vector vector = SDMSResourceAllocationTable.idx_rId.getVector(systemEnvironment, this.getId(systemEnvironment));
        Integer n = sDMSResourceRequirement.getLockmode(systemEnvironment);
        boolean bl = false;
        if (n == null) {
            n = SDMSConstants.RR_N;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(i);
            int n2 = sDMSResourceAllocation.getAllocationType(systemEnvironment);
            if (n2 == 1 || n2 == 6 || n2 == 5) continue;
            if (l != null && sDMSResourceAllocation.getSmeId(systemEnvironment) == -l.longValue()) {
                String string2 = sDMSResourceAllocation.getStickyName(systemEnvironment);
                if (string == null && string2 == null || string != null && string.equals(string2)) {
                    bl = true;
                    continue;
                }
            }
            if (Lockmode.isCompatible(n, sDMSResourceAllocation.getLockmode(systemEnvironment))) continue;
            return false;
        }
        return Lockmode.isCompatible(lockmode, n) || bl;
    }

    public boolean syncCheckLockmode(SystemEnvironment systemEnvironment, int n, Lockmode lockmode) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            return this.getBase(systemEnvironment).syncCheckLockmode(systemEnvironment, n, lockmode);
        }
        Vector vector = SDMSResourceAllocationTable.idx_rId.getVector(systemEnvironment, this.getId(systemEnvironment));
        Integer n2 = n;
        if (!Lockmode.isCompatible(lockmode, n2)) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(i);
            int n3 = sDMSResourceAllocation.getAllocationType(systemEnvironment);
            if (n3 == 1 || n3 == 6 || n3 == 5 || Lockmode.isCompatible(n2, sDMSResourceAllocation.getLockmode(systemEnvironment))) continue;
            return false;
        }
        return true;
    }

    public boolean syncCheckExpired(SystemEnvironment systemEnvironment, SDMSResourceRequirement sDMSResourceRequirement, SDMSNamedResource sDMSNamedResource, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        boolean bl;
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            return this.getBase(systemEnvironment).syncCheckExpired(systemEnvironment, sDMSResourceRequirement, sDMSNamedResource, sDMSSubmittedEntity);
        }
        Integer n = sDMSResourceRequirement.getExpiredBase(systemEnvironment);
        if (!(n == null || sDMSNamedResource.getRspId(systemEnvironment) == null || (bl = sDMSResourceRequirement.getIgnoreOnRerun(systemEnvironment).booleanValue()) && sDMSSubmittedEntity.getRerunSeq(systemEnvironment) > 0)) {
            long l2 = this.getRsdTime(systemEnvironment);
            long l3 = sDMSResourceRequirement.getExpiredAmount(systemEnvironment).longValue();
            switch (n) {
                case 0: {
                    l3 *= 60000L;
                    break;
                }
                case 1: {
                    l3 *= 3600000L;
                    break;
                }
                case 2: {
                    l3 *= 86400000L;
                    break;
                }
                case 3: {
                    l3 *= 604800000L;
                    break;
                }
                case 4: {
                    l3 *= 2592000000L;
                    break;
                }
                case 5: {
                    l3 *= 31536000000L;
                }
            }
            long l4 = new Date().getTime();
            long l5 = l3 == 0L ? sDMSSubmittedEntity.getSyncTs(systemEnvironment) - l2 : (l3 > 0L ? l4 - l3 - l2 : l2 - l3 - l4);
            if (l5 > 0L) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            this.getBase(systemEnvironment).setAmount(systemEnvironment, n);
            return;
        }
        Integer n2 = this.getAmount(systemEnvironment);
        if (n2 == null && n == null) {
            return;
        }
        if (n2 != null && n2.equals(n)) {
            return;
        }
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.getNrId(systemEnvironment));
        if (sDMSNamedResource.getUsage(systemEnvironment) == 1 && n != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202211141", "A static resource cannot have an amount other than infinite"));
        }
        super.setAmount(systemEnvironment, n);
        if (n != null) {
            Integer n3;
            int n4 = n;
            if (n2 == null) {
                Vector vector = SDMSResourceAllocationTable.idx_rId.getVector(systemEnvironment, this.getId(systemEnvironment));
                int n5 = vector.size();
                int n6 = 0;
                for (int i = 0; i < n5; ++i) {
                    SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(i);
                    Integer n7 = sDMSResourceAllocation.getAmount(systemEnvironment);
                    if (n7 == null || n7 <= 0) continue;
                    n6 += n7.intValue();
                }
                n3 = n4 - n6;
            } else {
                n3 = this.getFreeAmount(systemEnvironment);
                n3 = n3 + n4 - n2;
            }
            this.setFreeAmount(systemEnvironment, n3, n2);
        } else {
            this.setFreeAmount(systemEnvironment, null, n2);
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, this, this.getScopeId(systemEnvironment), 2);
    }

    @Override
    public void setRequestableAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            this.getBase(systemEnvironment).setRequestableAmount(systemEnvironment, n);
            return;
        }
        Integer n2 = this.getRequestableAmount(systemEnvironment);
        if (n2 == null && n == null) {
            return;
        }
        if (n2 != null && n2.equals(n)) {
            return;
        }
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.getNrId(systemEnvironment));
        if (sDMSNamedResource.getUsage(systemEnvironment) == 1 && n != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202211142", "A static resource cannot have a requestable amount other than infinite"));
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, this, this.getScopeId(systemEnvironment), 15);
        super.setRequestableAmount(systemEnvironment, n);
    }

    @Override
    public void setRsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.getBase(systemEnvironment).setRsdId(systemEnvironment, l, null);
    }

    public void setRsdId(SystemEnvironment systemEnvironment, Long l, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Object object;
        Comparable<Long> comparable;
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 != null) {
            this.getBase(systemEnvironment).setRsdId(systemEnvironment, l, sDMSSubmittedEntity);
            return;
        }
        Long l3 = this.getNrId(systemEnvironment);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l3);
        Long l4 = sDMSNamedResource.getRspId(systemEnvironment);
        if (l4 == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202211133", "Named Resource $1 is stateless", sDMSNamedResource.pathVector(systemEnvironment).toString()));
        }
        if (!SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l, l4))) {
            SDMSResourceStateProfile sDMSResourceStateProfile = SDMSResourceStateProfileTable.getObject(systemEnvironment, l4);
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202211222", "Resource state is not defined in the profile $1", sDMSResourceStateProfile.getName(systemEnvironment)));
        }
        Vector vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, this.getId(systemEnvironment));
        vector.addAll(SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l3));
        for (int i = 0; i < vector.size(); ++i) {
            comparable = this.getRsdId(systemEnvironment);
            object = (SDMSTrigger)vector.get(i);
            ((SDMSTrigger)object).trigger(systemEnvironment, this, (Long)comparable, l, sDMSSubmittedEntity);
        }
        SDMSResourceStateDefinition sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, this.getRsdId(systemEnvironment));
        comparable = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l);
        if (sDMSSubmittedEntity != null) {
            object = ", caused by submitted entity " + sDMSSubmittedEntity.getId(systemEnvironment);
        } else {
            SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
            object = ", by user " + sDMSUser.getName(systemEnvironment);
        }
        SDMSThread.doTrace(systemEnvironment.cEnv, "Set Resource State of Resource " + this.getName(systemEnvironment) + "(" + this.getId(systemEnvironment) + ") from " + sDMSResourceStateDefinition.getName(systemEnvironment) + " to " + ((SDMSResourceStateDefinitionProxyGeneric)comparable).getName(systemEnvironment) + (String)object, 0);
        super.setRsdId(systemEnvironment, l);
    }

    private int collectChildren(SystemEnvironment systemEnvironment, Vector vector, SDMSScope sDMSScope, Long l) throws SDMSException {
        int n = 0;
        Vector vector2 = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, sDMSScope.getId(systemEnvironment));
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSScope sDMSScope2 = (SDMSScope)vector2.get(i);
            if (SDMSResourceTable.idx_nrId_scopeId.containsKey(systemEnvironment, new SDMSKey(l, sDMSScope2.getId(systemEnvironment)))) continue;
            int n2 = this.collectChildren(systemEnvironment, vector, sDMSScope2, l);
            if (n2 == 0) {
                vector.add(sDMSScope2);
                ++n;
                continue;
            }
            n += n2;
        }
        return n;
    }

    private boolean isStaticAndJobsActive(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getUsage(systemEnvironment) != 1) {
            return false;
        }
        Long l = this.getNrId(systemEnvironment);
        Vector<SDMSScope> vector = new Vector<SDMSScope>();
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, this.getScopeId(systemEnvironment));
        if (this.collectChildren(systemEnvironment, vector, sDMSScope, l) == 0) {
            vector.add(sDMSScope);
        }
        for (int i = 0; i < vector.size(); ++i) {
            SDMSScope sDMSScope2 = (SDMSScope)vector.get(i);
            if (!sDMSScope.hasActiveJobs(systemEnvironment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.delete(systemEnvironment, false);
    }

    public void delete(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        Long l = this.getScopeId(systemEnvironment);
        Long l2 = this.getId(systemEnvironment);
        if (this.getManagerId(systemEnvironment) != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603151436", "Resource is member in an active pool"));
        }
        Vector vector = SDMSResourceAllocationTable.idx_rId.getVector(systemEnvironment, l2);
        int n = vector.size();
        if (n > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206242252", "Resource is in use"));
        }
        if (this.isStaticAndJobsActive(systemEnvironment)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202101013", "Resource is in use"));
        }
        Vector vector2 = SDMSResourceTable.idx_linkId.getVector(systemEnvironment, l2);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSResource sDMSResource = (SDMSResource)vector2.get(i);
            sDMSResource.delete(systemEnvironment, bl);
        }
        Vector vector3 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l2);
        for (int i = 0; i < vector3.size(); ++i) {
            SDMSTrigger sDMSTrigger = (SDMSTrigger)vector3.get(i);
            sDMSTrigger.delete(systemEnvironment);
        }
        this.killVariables(systemEnvironment);
        super.delete(systemEnvironment);
        try {
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
        }
        catch (NotFoundException notFoundException) {
            SystemEnvironment.sched.notifyChange(systemEnvironment, null, l, 3);
        }
    }

    public Vector getAllocations(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSResourceAllocationTable.idx_rId.getVector(systemEnvironment, l);
        Vector vector2 = SDMSResourceTable.idx_linkId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSResource sDMSResource = (SDMSResource)vector2.get(i);
            vector.addAll(sDMSResource.getAllocations(systemEnvironment));
        }
        return vector;
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 != null) {
            return this.getBase(systemEnvironment).getPrivileges(systemEnvironment, l, bl, vector);
        }
        long l3 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if ((l3 & l) == l) {
            return l;
        }
        if (systemEnvironment.cEnv.isUser() && (l & 1L) == 1L && (l3 & 1L) == 0L) {
            SDMSProxy sDMSProxy;
            Long l4 = this.getNrId(systemEnvironment);
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l4);
            long l5 = sDMSNamedResource.getPrivileges(systemEnvironment, 8L, bl, vector);
            Long l6 = this.getScopeId(systemEnvironment);
            try {
                sDMSProxy = SDMSScopeTable.getObject(systemEnvironment, l6);
            }
            catch (NotFoundException notFoundException) {
                try {
                    sDMSProxy = SDMSFolderTable.getObject(systemEnvironment, l6);
                }
                catch (NotFoundException notFoundException2) {
                    sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, l6);
                }
            }
            if (((l5 &= ((SDMSProxy)sDMSProxy).getPrivileges(systemEnvironment, 8L, bl, vector)) & 8L) == 8L) {
                l3 |= 1L;
            }
        } else if (systemEnvironment.cEnv.isJob() || systemEnvironment.cEnv.isJobServer()) {
            return l;
        }
        return l3 & l;
    }

    @Override
    public void releaseAmount(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            this.getBase(systemEnvironment).releaseAmount(systemEnvironment, n);
            return;
        }
        Integer n2 = this.getFreeAmount(systemEnvironment);
        if (n2 != null) {
            n2 = n2 + n;
            this.setFreeAmount(systemEnvironment, n2, this.getAmount(systemEnvironment));
        }
    }

    @Override
    public void setFreeAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.getBase(systemEnvironment).setFreeAmount(systemEnvironment, n, this.getAmount(systemEnvironment));
    }

    public void setFreeAmount(SystemEnvironment systemEnvironment, Integer n, Integer n2) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            this.getBase(systemEnvironment).setFreeAmount(systemEnvironment, n, n2);
            return;
        }
        super.setFreeAmount(systemEnvironment, n);
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        String string;
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.getNrId(systemEnvironment));
        Long l = this.getScopeId(systemEnvironment);
        try {
            SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
            string = sDMSScope.pathString(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            try {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l);
                string = sDMSFolder.pathString(systemEnvironment);
            }
            catch (NotFoundException notFoundException2) {
                return this.getId(systemEnvironment).toString();
            }
        }
        return sDMSNamedResource.pathString(systemEnvironment) + " in " + string;
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "resource " + this.getURLName(systemEnvironment);
    }

    protected final SDMSParameterDefinition getParameterDefinition(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSParameterDefinition sDMSParameterDefinition = null;
        Long l = this.getNrId(systemEnvironment);
        try {
            sDMSParameterDefinition = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409111747", "Parameter $1 not defined for this resource", string));
        }
        return sDMSParameterDefinition;
    }

    public final void createVariables(SystemEnvironment systemEnvironment, WithHash withHash) throws SDMSException {
        if (withHash == null) {
            return;
        }
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            this.getBase(systemEnvironment).createVariables(systemEnvironment, withHash);
            return;
        }
        Long l2 = this.getId(systemEnvironment);
        Vector vector = new Vector(withHash.keySet());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            Vector vector2 = (Vector)withHash.get(string);
            String string2 = (String)vector2.get(1);
            SDMSParameterDefinition sDMSParameterDefinition = this.getParameterDefinition(systemEnvironment, string);
            int n2 = sDMSParameterDefinition.getType(systemEnvironment);
            if (n2 == 30) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409111750", "Parameter $1 is defined as a $2 for this resource", string, sDMSParameterDefinition.getTypeAsString(systemEnvironment)));
            }
            if (string2 == null) continue;
            Object object = string2 == null ? string2 : "=" + string2;
            SDMSResourceVariableTable.table.create(systemEnvironment, sDMSParameterDefinition.getId(systemEnvironment), l2, (String)object);
        }
    }

    public final void killVariables(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getLinkId(systemEnvironment);
        if (l != null) {
            this.getBase(systemEnvironment).killVariables(systemEnvironment);
            return;
        }
        Long l2 = this.getId(systemEnvironment);
        Vector vector = SDMSResourceVariableTable.idx_rId.getVector(systemEnvironment, l2);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSResourceVariable sDMSResourceVariable = (SDMSResourceVariable)vector.get(i);
            sDMSResourceVariable.delete(systemEnvironment);
        }
    }

    public final void copyVariables(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 != null) {
            this.getBase(systemEnvironment).copyVariables(systemEnvironment, l);
            return;
        }
        Long l3 = this.getId(systemEnvironment);
        Vector vector = SDMSResourceVariableTable.idx_rId.getVector(systemEnvironment, l3);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSResourceVariable sDMSResourceVariable = (SDMSResourceVariable)vector.get(i);
            SDMSResourceVariableTable.table.create(systemEnvironment, sDMSResourceVariable.getPdId(systemEnvironment), l, sDMSResourceVariable.getValue(systemEnvironment));
        }
    }

    public final void alterVariables(SystemEnvironment systemEnvironment, WithHash withHash, long l) throws SDMSException {
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 != null) {
            this.getBase(systemEnvironment).alterVariables(systemEnvironment, withHash, l);
            return;
        }
        Long l3 = this.getId(systemEnvironment);
        Vector vector = SDMSResourceVariableTable.idx_rId.getVector(systemEnvironment, l3);
        if (withHash != null) {
            Set set = withHash.keySet();
            for (String string : set) {
                int n;
                Vector vector2 = (Vector)withHash.get(string);
                String string2 = (String)vector2.get(1);
                SDMSParameterDefinition sDMSParameterDefinition = this.getParameterDefinition(systemEnvironment, string);
                if (sDMSParameterDefinition.getType(systemEnvironment) == 30) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409131150", "Parameter $1 is defined as a $2 for this resource", string, sDMSParameterDefinition.getTypeAsString(systemEnvironment)));
                }
                Long l4 = sDMSParameterDefinition.getId(systemEnvironment);
                String string3 = null;
                if (string2 != null) {
                    string3 = "=" + string2;
                }
                for (n = 0; n < vector.size(); ++n) {
                    SDMSResourceVariable sDMSResourceVariable = (SDMSResourceVariable)vector.get(n);
                    if (!l4.equals(sDMSResourceVariable.getPdId(systemEnvironment))) continue;
                    vector.removeElementAt(n);
                    n = -1;
                    if (string3 == null) {
                        sDMSResourceVariable.delete(systemEnvironment);
                        break;
                    }
                    sDMSResourceVariable.setValue(systemEnvironment, string3);
                    break;
                }
                if (n < vector.size() || string3 == null) continue;
                SDMSResourceVariableTable.table.create(systemEnvironment, l4, l3, string3);
            }
        }
    }

    public final SDMSOutputContainer getVariables(SystemEnvironment systemEnvironment) throws SDMSException {
        String string;
        SDMSObjectComment sDMSObjectComment;
        int n;
        String string2;
        StringBuffer stringBuffer;
        Vector vector;
        String string3;
        Long l;
        Object object;
        String string4;
        Object object2;
        Long l2 = this.getLinkId(systemEnvironment);
        if (l2 != null) {
            return this.getBase(systemEnvironment).getVariables(systemEnvironment);
        }
        Vector<String> vector2 = new Vector<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Long l3 = this.getId(systemEnvironment);
        vector2.add("ID");
        vector2.add("NAME");
        vector2.add("TYPE");
        vector2.add("VALUE");
        vector2.add("IS_DEFAULT");
        vector2.add("COMMENT");
        vector2.add("COMMENTTYPE");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector2);
        Vector vector3 = SDMSResourceVariableTable.idx_rId.getVector(systemEnvironment, l3);
        Long l4 = this.getNrId(systemEnvironment);
        for (int i = 0; i < vector3.size(); ++i) {
            SDMSResourceVariable sDMSResourceVariable = (SDMSResourceVariable)vector3.get(i);
            try {
                object2 = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSResourceVariable.getPdId(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            string4 = ((SDMSParameterDefinitionProxyGeneric)object2).getName(systemEnvironment);
            object = new Vector();
            ((Vector)object).add(sDMSResourceVariable.getId(systemEnvironment));
            ((Vector)object).add(string4);
            ((Vector)object).add(((SDMSParameterDefinitionProxyGeneric)object2).getTypeAsString(systemEnvironment));
            l = ((SDMSProxy)object2).getId(systemEnvironment);
            string3 = sDMSResourceVariable.getValue(systemEnvironment);
            ((Vector)object).add(string3 == null ? null : string3.substring(1));
            ((Vector)object).add(Boolean.FALSE);
            vector = SDMSObjectCommentTable.idx_objectId.getVector(systemEnvironment, l);
            if (vector.size() != 0) {
                stringBuffer = new StringBuffer();
                string2 = null;
                for (n = 0; n < vector.size(); ++n) {
                    sDMSObjectComment = (SDMSObjectComment)vector.get(n);
                    string = sDMSObjectComment.getTag(systemEnvironment);
                    if (string != null) {
                        if (n != 0) {
                            stringBuffer.append("\n");
                        }
                        stringBuffer.append(string);
                        stringBuffer.append("\n\n");
                    }
                    stringBuffer.append(sDMSObjectComment.getDescription(systemEnvironment));
                    stringBuffer.append("\n");
                    if (n != 0) continue;
                    string2 = sDMSObjectComment.getInfoTypeAsString(systemEnvironment);
                }
                ((Vector)object).add(stringBuffer.toString());
                ((Vector)object).add(string2);
            } else {
                ((Vector)object).add(null);
                ((Vector)object).add(null);
            }
            hashSet.add(string4);
            sDMSOutputContainer.addData(systemEnvironment, (Vector)object);
        }
        Vector vector4 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l4);
        for (int i = 0; i < vector4.size(); ++i) {
            object = (SDMSParameterDefinition)vector4.get(i);
            string4 = ((SDMSParameterDefinitionProxyGeneric)object).getName(systemEnvironment);
            l = ((SDMSProxy)object).getId(systemEnvironment);
            if (hashSet.contains(string4)) continue;
            object2 = new Vector();
            ((Vector)object2).add(((SDMSProxy)object).getId(systemEnvironment));
            ((Vector)object2).add(string4);
            ((Vector)object2).add(((SDMSParameterDefinitionProxyGeneric)object).getTypeAsString(systemEnvironment));
            string3 = ((SDMSParameterDefinition)object).getDefaultValue(systemEnvironment);
            ((Vector)object2).add(string3 == null ? null : string3.substring(1));
            ((Vector)object2).add(Boolean.TRUE);
            vector = SDMSObjectCommentTable.idx_objectId.getVector(systemEnvironment, l);
            if (vector.size() != 0) {
                stringBuffer = new StringBuffer();
                string2 = null;
                for (n = 0; n < vector.size(); ++n) {
                    sDMSObjectComment = (SDMSObjectComment)vector.get(n);
                    string = sDMSObjectComment.getTag(systemEnvironment);
                    if (string != null) {
                        if (n != 0) {
                            stringBuffer.append("\n");
                        }
                        stringBuffer.append(string);
                        stringBuffer.append("\n\n");
                    }
                    stringBuffer.append(sDMSObjectComment.getDescription(systemEnvironment));
                    stringBuffer.append("\n");
                    if (n != 0) continue;
                    string2 = sDMSObjectComment.getInfoTypeAsString(systemEnvironment);
                }
                ((Vector)object2).add(stringBuffer.toString());
                ((Vector)object2).add(string2);
            } else {
                ((Vector)object2).add(null);
                ((Vector)object2).add(null);
            }
            sDMSOutputContainer.addData(systemEnvironment, (Vector)object2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, boolean bl) throws SDMSException {
        return RVR.getVariableValue(systemEnvironment, (SDMSProxy)this.getBase(systemEnvironment), string, null, bl);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, SDMSSubmittedEntity sDMSSubmittedEntity, boolean bl) throws SDMSException {
        return RVR.getVariableValue(systemEnvironment, (SDMSProxy)this.getBase(systemEnvironment), string, sDMSSubmittedEntity, bl);
    }

    public void setVariableValue(SystemEnvironment systemEnvironment, String string, Long l, String string2) throws SDMSException {
        Long l2 = this.getId(systemEnvironment);
        Vector vector = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(l, this.getNrId(systemEnvironment)));
        if (vector.size() == 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409221436", "Resource not allocated"));
        }
        SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(0);
        if (sDMSResourceAllocation.getAllocationType(systemEnvironment) != 4) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409221438", "Resource not allocated"));
        }
        if (sDMSResourceAllocation.getLockmode(systemEnvironment) != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409221440", "Resource not exclusively locked"));
        }
        SDMSParameterDefinition sDMSParameterDefinition = this.getParameterDefinition(systemEnvironment, string);
        if (sDMSParameterDefinition.getType(systemEnvironment) != 50) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "0309221536", "Parameter $1 is non mutable", string));
        }
        Long l3 = sDMSParameterDefinition.getId(systemEnvironment);
        try {
            SDMSResourceVariable sDMSResourceVariable = SDMSResourceVariableTable.idx_pdId_rId_getUnique(systemEnvironment, new SDMSKey(l3, l2));
            sDMSResourceVariable.setValue(systemEnvironment, "=" + string2);
        }
        catch (NotFoundException notFoundException) {
            SDMSResourceVariableTable.table.create(systemEnvironment, sDMSParameterDefinition.getId(systemEnvironment), l2, "=" + string2);
        }
    }

    @Override
    public String getSubtypeName(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.getNrId(systemEnvironment));
        return sDMSNamedResource.getUsageAsString(systemEnvironment);
    }
}

