/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSResourceAllocationGeneric
extends SDMSObject
implements Cloneable {
    public static final int N = 255;
    public static final int X = 0;
    public static final int SX = 2;
    public static final int S = 4;
    public static final int SC = 6;
    public static final int NOKEEP = 0;
    public static final int KEEP = 1;
    public static final int KEEP_FINAL = 2;
    public static final int REQUEST = 1;
    public static final int RESERVATION = 2;
    public static final int MASTER_RESERVATION = 3;
    public static final int ALLOCATION = 4;
    public static final int IGNORE = 5;
    public static final int MASTER_REQUEST = 6;
    public static final int nr_id = 1;
    public static final int nr_rId = 2;
    public static final int nr_smeId = 3;
    public static final int nr_nrId = 4;
    public static final int nr_amount = 5;
    public static final int nr_origAmount = 6;
    public static final int nr_keepMode = 7;
    public static final int nr_isSticky = 8;
    public static final int nr_stickyName = 9;
    public static final int nr_stickyParent = 10;
    public static final int nr_allocationType = 11;
    public static final int nr_rsmpId = 12;
    public static final int nr_lockmode = 13;
    public static final int nr_refcount = 14;
    public static final int nr_creatorUId = 15;
    public static final int nr_createTs = 16;
    public static final int nr_changerUId = 17;
    public static final int nr_changeTs = 18;
    public static String tableName = "RESOURCE_ALLOCATION";
    protected Long rId;
    protected Long smeId;
    protected Long nrId;
    protected Integer amount;
    protected Integer origAmount;
    protected Integer keepMode;
    protected Boolean isSticky;
    protected String stickyName;
    protected Long stickyParent;
    protected Integer allocationType;
    protected Long rsmpId;
    protected Integer lockmode;
    protected Integer refcount;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSResourceAllocationGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Integer n2, Integer n3, Boolean bl, String string, Long l4, Integer n4, Long l5, Integer n5, Integer n6, Long l6, Long l7, Long l8, Long l9) throws SDMSException {
        super(systemEnvironment, SDMSResourceAllocationTableGeneric.table);
        this.rId = l;
        this.smeId = l2;
        this.nrId = l3;
        this.amount = n;
        this.origAmount = n2;
        this.keepMode = n3;
        this.isSticky = bl;
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ResourceAllocation) Length of $1 exceeds maximum length $2", "stickyName", "64"));
        }
        this.stickyName = string;
        this.stickyParent = l4;
        this.allocationType = n4;
        this.rsmpId = l5;
        this.lockmode = n5;
        this.refcount = n6;
        this.creatorUId = l6;
        this.createTs = l7;
        this.changerUId = l8;
        this.changeTs = l9;
    }

    public Long getRId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rId;
    }

    public void setRId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.rId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
            }
            SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
            sDMSResourceAllocationGeneric.rId = l;
            sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 25L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.smeId;
    }

    public void setSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.smeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
            }
            SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
            sDMSResourceAllocationGeneric.smeId = l;
            sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 42L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getNrId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.nrId;
    }

    public void setNrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.nrId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
            }
            SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
            sDMSResourceAllocationGeneric.nrId = l;
            sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 36L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.amount;
    }

    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.amount)) {
            return;
        }
        if (n == null && this.amount == null) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.amount = n;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Integer getOrigAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.origAmount;
    }

    public void setOrigAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.origAmount)) {
            return;
        }
        if (n == null && this.origAmount == null) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.origAmount = n;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Integer getKeepMode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.keepMode;
    }

    public String getKeepModeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getKeepMode(systemEnvironment);
        switch (n) {
            case 0: {
                return "NOKEEP";
            }
            case 1: {
                return "KEEP";
            }
            case 2: {
                return "KEEP_FINAL";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ResourceAllocation.keepMode: $1", this.getKeepMode(systemEnvironment)));
    }

    public void setKeepMode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.keepMode.equals(n)) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.keepMode = n;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Boolean getIsSticky(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isSticky;
    }

    public void setIsSticky(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isSticky.equals(bl)) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.isSticky = bl;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public String getStickyName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.stickyName;
    }

    public void setStickyName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.stickyName)) {
            return;
        }
        if (string == null && this.stickyName == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
            }
            SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ResourceAllocation) Length of $1 exceeds maximum length $2", "stickyName", "64"));
            }
            sDMSResourceAllocationGeneric.stickyName = string;
            sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 24L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getStickyParent(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.stickyParent;
    }

    public void setStickyParent(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.stickyParent)) {
            return;
        }
        if (l == null && this.stickyParent == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
            }
            SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
            sDMSResourceAllocationGeneric.stickyParent = l;
            sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 16L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getAllocationType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.allocationType;
    }

    public String getAllocationTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getAllocationType(systemEnvironment);
        switch (n) {
            case 1: {
                return "REQUEST";
            }
            case 6: {
                return "MASTER_REQUEST";
            }
            case 2: {
                return "RESERVATION";
            }
            case 3: {
                return "MASTER_RESERVATION";
            }
            case 4: {
                return "ALLOCATION";
            }
            case 5: {
                return "IGNORE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ResourceAllocation.allocationType: $1", this.getAllocationType(systemEnvironment)));
    }

    public void setAllocationType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.allocationType.equals(n)) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.allocationType = n;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Long getRsmpId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rsmpId;
    }

    public void setRsmpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.rsmpId)) {
            return;
        }
        if (l == null && this.rsmpId == null) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.rsmpId = l;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Integer getLockmode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lockmode;
    }

    public String getLockmodeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getLockmode(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 255: {
                return "N";
            }
            case 0: {
                return "X";
            }
            case 2: {
                return "SX";
            }
            case 4: {
                return "S";
            }
            case 6: {
                return "SC";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ResourceAllocation.lockmode: $1", this.getLockmode(systemEnvironment)));
    }

    public void setLockmode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.lockmode)) {
            return;
        }
        if (n == null && this.lockmode == null) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.lockmode = n;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Integer getRefcount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.refcount;
    }

    public void setRefcount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.refcount.equals(n)) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.refcount = n;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.creatorUId = l;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceAllocation) Change of system object not allowed"));
        }
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.createTs = l;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.changerUId = l;
        sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric = this;
        if (sDMSResourceAllocationGeneric.versions.o_v == null || sDMSResourceAllocationGeneric.versions.o_v.size() == 0 || sDMSResourceAllocationGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
        }
        sDMSResourceAllocationGeneric.changeTs = l;
        sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSResourceAllocationGeneric != this) {
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric, 0L);
        }
    }

    public SDMSResourceAllocationGeneric set_SmeIdRIdStickyName(SystemEnvironment systemEnvironment, Long l, Long l2, String string) throws SDMSException {
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ResourceAllocation) Change of system object not allowed"));
            }
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
            sDMSResourceAllocationGeneric.smeId = l;
            sDMSResourceAllocationGeneric.rId = l2;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290025", "(ResourceAllocation) Length of $1 exceeds maximum length $2", "changeTs", "64"));
            }
            sDMSResourceAllocationGeneric.stickyName = string;
            sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSResourceAllocationGeneric;
    }

    public SDMSResourceAllocationGeneric set_StickyParentRIdStickyName(SystemEnvironment systemEnvironment, Long l, Long l2, String string) throws SDMSException {
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ResourceAllocation) Change of system object not allowed"));
            }
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
            sDMSResourceAllocationGeneric.stickyParent = l;
            sDMSResourceAllocationGeneric.rId = l2;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290025", "(ResourceAllocation) Length of $1 exceeds maximum length $2", "changeTs", "64"));
            }
            sDMSResourceAllocationGeneric.stickyName = string;
            sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSResourceAllocationGeneric;
    }

    public SDMSResourceAllocationGeneric set_SmeIdNrId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSResourceAllocationGeneric sDMSResourceAllocationGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ResourceAllocation) Change of system object not allowed"));
            }
            sDMSResourceAllocationGeneric = (SDMSResourceAllocationGeneric)this.change(systemEnvironment);
            sDMSResourceAllocationGeneric.smeId = l;
            sDMSResourceAllocationGeneric.nrId = l2;
            sDMSResourceAllocationGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceAllocationGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceAllocationGeneric.versions.table.index(systemEnvironment, sDMSResourceAllocationGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSResourceAllocationGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSResourceAllocation(this);
    }

    protected SDMSResourceAllocationGeneric(Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, Integer n3, Boolean bl, String string, Long l5, Integer n4, Long l6, Integer n5, Integer n6, Long l7, Long l8, Long l9, Long l10, long l11, long l12) {
        this.id = l;
        this.rId = l2;
        this.smeId = l3;
        this.nrId = l4;
        this.amount = n;
        this.origAmount = n2;
        this.keepMode = n3;
        this.isSticky = bl;
        this.stickyName = string;
        this.stickyParent = l5;
        this.allocationType = n4;
        this.rsmpId = l6;
        this.lockmode = n5;
        this.refcount = n6;
        this.creatorUId = l7;
        this.createTs = l8;
        this.changerUId = l9;
        this.changeTs = l10;
        this.validFrom = l11;
        this.validTo = l12;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = SystemEnvironment.SQUOTE;
                String string2 = SystemEnvironment.EQUOTE;
                object = "INSERT INTO " + string + "RESOURCE_ALLOCATION" + string2 + " (ID, " + string + "R_ID" + string2 + ", " + string + "SME_ID" + string2 + ", " + string + "NR_ID" + string2 + ", " + string + "AMOUNT" + string2 + ", " + string + "ORIG_AMOUNT" + string2 + ", " + string + "KEEP_MODE" + string2 + ", " + string + "IS_STICKY" + string2 + ", " + string + "STICKY_NAME" + string2 + ", " + string + "STICKY_PARENT" + string2 + ", " + string + "ALLOCATION_TYPE" + string2 + ", " + string + "RSMP_ID" + string2 + ", " + string + "LOCKMODE" + string2 + ", " + string + "REFCOUNT" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSResourceAllocationGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ResourceAllocation: $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.rId);
            preparedStatement.setLong(3, this.smeId);
            preparedStatement.setLong(4, this.nrId);
            if (this.amount == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setInt(5, this.amount);
            }
            if (this.origAmount == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setInt(6, this.origAmount);
            }
            preparedStatement.setInt(7, this.keepMode);
            preparedStatement.setInt(8, this.isSticky != false ? 1 : 0);
            if (this.stickyName == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.stickyName);
            }
            if (this.stickyParent == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setLong(10, this.stickyParent);
            }
            preparedStatement.setInt(11, this.allocationType);
            if (this.rsmpId == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setLong(12, this.rsmpId);
            }
            if (this.lockmode == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setInt(13, this.lockmode);
            }
            preparedStatement.setInt(14, this.refcount);
            preparedStatement.setLong(15, this.creatorUId);
            preparedStatement.setLong(16, this.createTs);
            preparedStatement.setLong(17, this.changerUId);
            preparedStatement.setLong(18, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ResourceAllocation: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = SystemEnvironment.SQUOTE;
                String string2 = SystemEnvironment.EQUOTE;
                object = "DELETE FROM " + string + "RESOURCE_ALLOCATION" + string2 + " WHERE ID = ?";
                SDMSResourceAllocationGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "ResourceAllocation: $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "ResourceAllocation: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = SystemEnvironment.SQUOTE;
                String string2 = SystemEnvironment.EQUOTE;
                object = "UPDATE " + string + "RESOURCE_ALLOCATION" + string2 + " SET " + string + "R_ID" + string2 + " = ? , " + string + "SME_ID" + string2 + " = ? , " + string + "NR_ID" + string2 + " = ? , " + string + "AMOUNT" + string2 + " = ? , " + string + "ORIG_AMOUNT" + string2 + " = ? , " + string + "KEEP_MODE" + string2 + " = ? , " + string + "IS_STICKY" + string2 + " = ? , " + string + "STICKY_NAME" + string2 + " = ? , " + string + "STICKY_PARENT" + string2 + " = ? , " + string + "ALLOCATION_TYPE" + string2 + " = ? , " + string + "RSMP_ID" + string2 + " = ? , " + string + "LOCKMODE" + string2 + " = ? , " + string + "REFCOUNT" + string2 + " = ? , " + string + "CREATOR_U_ID" + string2 + " = ? , " + string + "CREATE_TS" + string2 + " = ? , " + string + "CHANGER_U_ID" + string2 + " = ? , " + string + "CHANGE_TS" + string2 + " = ? WHERE ID = ?";
                SDMSResourceAllocationGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "ResourceAllocation: $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.rId);
            preparedStatement.setLong(2, this.smeId);
            preparedStatement.setLong(3, this.nrId);
            if (this.amount == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setInt(4, this.amount);
            }
            if (this.origAmount == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setInt(5, this.origAmount);
            }
            preparedStatement.setInt(6, this.keepMode);
            preparedStatement.setInt(7, this.isSticky != false ? 1 : 0);
            if (this.stickyName == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.stickyName);
            }
            if (this.stickyParent == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.stickyParent);
            }
            preparedStatement.setInt(10, this.allocationType);
            if (this.rsmpId == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setLong(11, this.rsmpId);
            }
            if (this.lockmode == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setInt(12, this.lockmode);
            }
            preparedStatement.setInt(13, this.refcount);
            preparedStatement.setLong(14, this.creatorUId);
            preparedStatement.setLong(15, this.createTs);
            preparedStatement.setLong(16, this.changerUId);
            preparedStatement.setLong(17, this.changeTs);
            preparedStatement.setLong(18, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "ResourceAllocation: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkKeepMode(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkAllocationType(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkLockmode(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 255: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ResourceAllocation", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "rId : " + this.rId, 2);
        SDMSThread.doTrace(null, "smeId : " + this.smeId, 2);
        SDMSThread.doTrace(null, "nrId : " + this.nrId, 2);
        SDMSThread.doTrace(null, "amount : " + this.amount, 2);
        SDMSThread.doTrace(null, "origAmount : " + this.origAmount, 2);
        SDMSThread.doTrace(null, "keepMode : " + this.keepMode, 2);
        SDMSThread.doTrace(null, "isSticky : " + this.isSticky, 2);
        SDMSThread.doTrace(null, "stickyName : " + this.stickyName, 2);
        SDMSThread.doTrace(null, "stickyParent : " + this.stickyParent, 2);
        SDMSThread.doTrace(null, "allocationType : " + this.allocationType, 2);
        SDMSThread.doTrace(null, "rsmpId : " + this.rsmpId, 2);
        SDMSThread.doTrace(null, "lockmode : " + this.lockmode, 2);
        SDMSThread.doTrace(null, "refcount : " + this.refcount, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "rId            : " + this.rId + "\n" + string + "smeId          : " + this.smeId + "\n" + string + "nrId           : " + this.nrId + "\n" + string + "amount         : " + this.amount + "\n" + string + "origAmount     : " + this.origAmount + "\n" + string + "keepMode       : " + this.keepMode + "\n" + string + "isSticky       : " + this.isSticky + "\n" + string + "stickyName     : " + this.stickyName + "\n" + string + "stickyParent   : " + this.stickyParent + "\n" + string + "allocationType : " + this.allocationType + "\n" + string + "rsmpId         : " + this.rsmpId + "\n" + string + "lockmode       : " + this.lockmode + "\n" + string + "refcount       : " + this.refcount + "\n" + string + "creatorUId     : " + this.creatorUId + "\n" + string + "createTs       : " + this.createTs + "\n" + string + "changerUId     : " + this.changerUId + "\n" + string + "changeTs       : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

