/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesGeneric;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSResourceReqStatesTableGeneric
extends SDMSTable {
    public static final String tableName = "RESOURCE_REQ_STATES";
    public static SDMSResourceReqStatesTable table = null;
    public static final String[] columnNames = new String[]{"ID", "RR_ID", "RSD_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_rrId;
    public static SDMSIndex idx_rsdId;
    public static SDMSIndex idx_rr_rsd_pk;

    public SDMSResourceReqStatesTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ResourceReqStates"));
        }
        table = (SDMSResourceReqStatesTable)this;
        table = (SDMSResourceReqStatesTable)this;
        this.isVersioned = true;
        idx_rrId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rrId");
        idx_rsdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rsdId");
        idx_rr_rsd_pk = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "rr_rsd_pk");
    }

    public SDMSResourceReqStates create(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSResourceReqStates sDMSResourceReqStates;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ResourceReqStates"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSResourceReqStatesGeneric sDMSResourceReqStatesGeneric = new SDMSResourceReqStatesGeneric(systemEnvironment, l, l2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSResourceReqStatesGeneric.versions, true);
            table.put(systemEnvironment, sDMSResourceReqStatesGeneric.id, sDMSResourceReqStatesGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSResourceReqStates = (SDMSResourceReqStates)sDMSResourceReqStatesGeneric.toProxy(systemEnvironment);
            sDMSResourceReqStates.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSResourceReqStates sDMSResourceReqStates2 = (SDMSResourceReqStates)sDMSResourceReqStatesGeneric.toProxy(systemEnvironment);
            sDMSResourceReqStates2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSResourceReqStates)) {
            throw new AccessViolationException(sDMSResourceReqStates.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSResourceReqStates.touchMaster(systemEnvironment);
        return sDMSResourceReqStates;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSResourceReqStates sDMSResourceReqStates) throws SDMSException {
        return sDMSResourceReqStates.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            l7 = resultSet.getLong(3);
            l6 = resultSet.getLong(4);
            l5 = resultSet.getLong(5);
            l4 = resultSet.getLong(6);
            l3 = resultSet.getLong(7);
            l2 = resultSet.getLong(8);
            l = resultSet.getLong(9);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ResourceReqStates: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSResourceReqStatesGeneric(l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "RR_ID" + string2 + ", " + string + "RSD_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion));
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_rrId.check(((SDMSResourceReqStatesGeneric)sDMSObject).rrId, sDMSObject);
        object = (String)object + "idx_rrId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_rsdId.check(((SDMSResourceReqStatesGeneric)sDMSObject).rsdId, sDMSObject);
        object = (String)object + "idx_rsdId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceReqStatesGeneric)sDMSObject).rrId);
        sDMSKey.add(((SDMSResourceReqStatesGeneric)sDMSObject).rsdId);
        bl = idx_rr_rsd_pk.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_rr_rsd_pk: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_rrId.put(systemEnvironment, ((SDMSResourceReqStatesGeneric)sDMSObject).rrId, sDMSObject, (1L & l) != 0L);
        idx_rsdId.put(systemEnvironment, ((SDMSResourceReqStatesGeneric)sDMSObject).rsdId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceReqStatesGeneric)sDMSObject).rrId);
        sDMSKey.add(((SDMSResourceReqStatesGeneric)sDMSObject).rsdId);
        idx_rr_rsd_pk.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_rrId.remove(systemEnvironment, ((SDMSResourceReqStatesGeneric)sDMSObject).rrId, sDMSObject);
        idx_rsdId.remove(systemEnvironment, ((SDMSResourceReqStatesGeneric)sDMSObject).rsdId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceReqStatesGeneric)sDMSObject).rrId);
        sDMSKey.add(((SDMSResourceReqStatesGeneric)sDMSObject).rsdId);
        idx_rr_rsd_pk.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSResourceReqStates getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceReqStates)table.get(systemEnvironment, l);
    }

    public static SDMSResourceReqStates getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceReqStates)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSResourceReqStates getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSResourceReqStates)table.get(systemEnvironment, l, l2);
    }

    public static SDMSResourceReqStates idx_rr_rsd_pk_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceReqStates)idx_rr_rsd_pk.getUnique(systemEnvironment, object);
    }

    public static SDMSResourceReqStates idx_rr_rsd_pk_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceReqStates)idx_rr_rsd_pk.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSResourceReqStates idx_rr_rsd_pk_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSResourceReqStates)idx_rr_rsd_pk.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

