/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSResourceTableGeneric
extends SDMSTable {
    public static final String tableName = "RESSOURCE";
    public static SDMSResourceTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NR_ID", "SCOPE_ID", "MASTER_ID", "OWNER_ID", "LINK_ID", "MANAGER_ID", "TAG", "RSD_ID", "RSD_TIME", "DEFINED_AMOUNT", "REQUESTABLE_AMOUNT", "AMOUNT", "FREE_AMOUNT", "IS_ONLINE", "FACTOR", "TRACE_INTERVAL", "TRACE_BASE", "TRACE_BASE_MULTIPLIER", "TD0_AVG", "TD1_AVG", "TD2_AVG", "LW_AVG", "LAST_EVAL", "LAST_WRITE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_nrId;
    public static SDMSIndex idx_scopeId;
    public static SDMSIndex idx_masterId;
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_linkId;
    public static SDMSIndex idx_managerId;
    public static SDMSIndex idx_tag;
    public static SDMSIndex idx_rsdId;
    public static SDMSIndex idx_nrId_scopeId;

    public SDMSResourceTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Resource"));
        }
        table = (SDMSResourceTable)this;
        table = (SDMSResourceTable)this;
        this.isVersioned = false;
        idx_nrId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "nrId");
        idx_scopeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "scopeId");
        idx_masterId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "masterId");
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_linkId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "linkId");
        idx_managerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "managerId");
        idx_tag = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "tag");
        idx_rsdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rsdId");
        idx_nrId_scopeId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "nrId_scopeId");
    }

    public SDMSResource create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, String string, Long l7, Long l8, Integer n, Integer n2, Integer n3, Integer n4, Boolean bl, Float f, Integer n5, Integer n6, Integer n7, Float f2, Float f3, Float f4, Float f5, Long l9, Long l10) throws SDMSException {
        SDMSResource sDMSResource;
        Long l11 = systemEnvironment.cEnv.uid();
        Long l12 = systemEnvironment.txTime();
        Long l13 = systemEnvironment.cEnv.uid();
        Long l14 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Resource"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, l6, string, l7, l8, n, n2, n3, n4, bl, f, n5, n6, n7, f2, f3, f4, f5, l9, l10, l11, l12, l13, l14);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSResourceGeneric sDMSResourceGeneric = new SDMSResourceGeneric(systemEnvironment, l, l2, l3, l4, l5, l6, string, l7, l8, n, n2, n3, n4, bl, f, n5, n6, n7, f2, f3, f4, f5, l9, l10, l11, l12, l13, l14);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSResourceGeneric.versions, true);
            table.put(systemEnvironment, sDMSResourceGeneric.id, sDMSResourceGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSResource = (SDMSResource)sDMSResourceGeneric.toProxy(systemEnvironment);
            sDMSResource.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSResource sDMSResource2 = (SDMSResource)sDMSResourceGeneric.toProxy(systemEnvironment);
            sDMSResource2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSResource)) {
            throw new AccessViolationException(sDMSResource.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSResource;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSResource sDMSResource) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, String string, Long l7, Long l8, Integer n, Integer n2, Integer n3, Integer n4, Boolean bl, Float f, Integer n5, Integer n6, Integer n7, Float f2, Float f3, Float f4, Float f5, Long l9, Long l10, Long l11, Long l12, Long l13, Long l14) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Float f;
        Float f2;
        Float f3;
        Float f4;
        Integer n;
        Integer n2;
        Integer n3;
        Float f5;
        Boolean bl;
        Integer n4;
        Integer n5;
        Integer n6;
        Integer n7;
        Long l9;
        Long l10;
        String string;
        Long l11;
        Long l12;
        Long l13;
        Long l14;
        Long l15;
        Long l16;
        Long l17;
        try {
            l17 = resultSet.getLong(1);
            l16 = resultSet.getLong(2);
            l15 = resultSet.getLong(3);
            if (resultSet.wasNull()) {
                l15 = null;
            }
            l14 = resultSet.getLong(4);
            if (resultSet.wasNull()) {
                l14 = null;
            }
            l13 = resultSet.getLong(5);
            l12 = resultSet.getLong(6);
            if (resultSet.wasNull()) {
                l12 = null;
            }
            l11 = resultSet.getLong(7);
            if (resultSet.wasNull()) {
                l11 = null;
            }
            string = resultSet.getString(8);
            if (resultSet.wasNull()) {
                string = null;
            }
            l10 = resultSet.getLong(9);
            if (resultSet.wasNull()) {
                l10 = null;
            }
            l9 = resultSet.getLong(10);
            if (resultSet.wasNull()) {
                l9 = null;
            }
            n7 = resultSet.getInt(11);
            if (resultSet.wasNull()) {
                n7 = null;
            }
            n6 = resultSet.getInt(12);
            if (resultSet.wasNull()) {
                n6 = null;
            }
            n5 = resultSet.getInt(13);
            if (resultSet.wasNull()) {
                n5 = null;
            }
            n4 = resultSet.getInt(14);
            if (resultSet.wasNull()) {
                n4 = null;
            }
            bl = resultSet.getInt(15) != 0;
            if (resultSet.wasNull()) {
                bl = null;
            }
            f5 = Float.valueOf(resultSet.getFloat(16));
            if (resultSet.wasNull()) {
                f5 = null;
            }
            n3 = resultSet.getInt(17);
            if (resultSet.wasNull()) {
                n3 = null;
            }
            n2 = resultSet.getInt(18);
            if (resultSet.wasNull()) {
                n2 = null;
            }
            n = resultSet.getInt(19);
            f4 = Float.valueOf(resultSet.getFloat(20));
            f3 = Float.valueOf(resultSet.getFloat(21));
            f2 = Float.valueOf(resultSet.getFloat(22));
            f = Float.valueOf(resultSet.getFloat(23));
            l8 = resultSet.getLong(24);
            l7 = resultSet.getLong(25);
            l6 = resultSet.getLong(26);
            l5 = resultSet.getLong(27);
            l4 = resultSet.getLong(28);
            l3 = resultSet.getLong(29);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Resource: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSResourceGeneric(l17, l16, l15, l14, l13, l12, l11, string, l10, l9, n7, n6, n5, n4, bl, f5, n3, n2, n, f4, f3, f2, f, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NR_ID" + string2 + ", " + string + "SCOPE_ID" + string2 + ", " + string + "MASTER_ID" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "LINK_ID" + string2 + ", " + string + "MANAGER_ID" + string2 + ", " + string + "TAG" + string2 + ", " + string + "RSD_ID" + string2 + ", " + string + "RSD_TIME" + string2 + ", " + string + "DEFINED_AMOUNT" + string2 + ", " + string + "REQUESTABLE_AMOUNT" + string2 + ", " + string + "AMOUNT" + string2 + ", " + string + "FREE_AMOUNT" + string2 + ", " + string + "IS_ONLINE" + string2 + ", " + string + "FACTOR" + string2 + ", " + string + "TRACE_INTERVAL" + string2 + ", " + string + "TRACE_BASE" + string2 + ", " + string + "TRACE_BASE_MULTIPLIER" + string2 + ", " + string + "TD0_AVG" + string2 + ", " + string + "TD1_AVG" + string2 + ", " + string + "TD2_AVG" + string2 + ", " + string + "LW_AVG" + string2 + ", " + string + "LAST_EVAL" + string2 + ", " + string + "LAST_WRITE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2);
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_nrId.check(((SDMSResourceGeneric)sDMSObject).nrId, sDMSObject);
        object = (String)object + "idx_nrId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_scopeId.check(((SDMSResourceGeneric)sDMSObject).scopeId, sDMSObject);
        object = (String)object + "idx_scopeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_masterId.check(((SDMSResourceGeneric)sDMSObject).masterId, sDMSObject);
        object = (String)object + "idx_masterId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_ownerId.check(((SDMSResourceGeneric)sDMSObject).ownerId, sDMSObject);
        object = (String)object + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_linkId.check(((SDMSResourceGeneric)sDMSObject).linkId, sDMSObject);
        object = (String)object + "idx_linkId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_managerId.check(((SDMSResourceGeneric)sDMSObject).managerId, sDMSObject);
        object = (String)object + "idx_managerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_tag.check(((SDMSResourceGeneric)sDMSObject).tag, sDMSObject);
        object = (String)object + "idx_tag: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_rsdId.check(((SDMSResourceGeneric)sDMSObject).rsdId, sDMSObject);
        object = (String)object + "idx_rsdId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceGeneric)sDMSObject).nrId);
        sDMSKey.add(((SDMSResourceGeneric)sDMSObject).scopeId);
        bl = idx_nrId_scopeId.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_nrId_scopeId: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_nrId.put(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).nrId, sDMSObject, (1L & l) != 0L);
        idx_scopeId.put(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).scopeId, sDMSObject, (2L & l) != 0L);
        idx_masterId.put(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).masterId, sDMSObject, (4L & l) != 0L);
        idx_ownerId.put(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).ownerId, sDMSObject, (8L & l) != 0L);
        idx_linkId.put(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).linkId, sDMSObject, (0x10L & l) != 0L);
        idx_managerId.put(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).managerId, sDMSObject, (0x20L & l) != 0L);
        idx_tag.put(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).tag, sDMSObject, (0x40L & l) != 0L);
        idx_rsdId.put(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).rsdId, sDMSObject, (0x80L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceGeneric)sDMSObject).nrId);
        sDMSKey.add(((SDMSResourceGeneric)sDMSObject).scopeId);
        idx_nrId_scopeId.put(systemEnvironment, sDMSKey, sDMSObject, (0x100L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_nrId.remove(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).nrId, sDMSObject);
        idx_scopeId.remove(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).scopeId, sDMSObject);
        idx_masterId.remove(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).masterId, sDMSObject);
        idx_ownerId.remove(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).ownerId, sDMSObject);
        idx_linkId.remove(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).linkId, sDMSObject);
        idx_managerId.remove(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).managerId, sDMSObject);
        idx_tag.remove(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).tag, sDMSObject);
        idx_rsdId.remove(systemEnvironment, ((SDMSResourceGeneric)sDMSObject).rsdId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceGeneric)sDMSObject).nrId);
        sDMSKey.add(((SDMSResourceGeneric)sDMSObject).scopeId);
        idx_nrId_scopeId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSResource getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResource)table.get(systemEnvironment, l);
    }

    public static SDMSResource getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResource)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSResource getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSResource)table.get(systemEnvironment, l, l2);
    }

    public static SDMSResource idx_nrId_scopeId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResource)idx_nrId_scopeId.getUnique(systemEnvironment, object);
    }

    public static SDMSResource idx_nrId_scopeId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResource)idx_nrId_scopeId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSResource idx_nrId_scopeId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSResource)idx_nrId_scopeId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

