/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventGeneric;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSScheduledEventTableGeneric
extends SDMSTable {
    public static final String tableName = "SCHEDULED_EVENT";
    public static SDMSScheduledEventTable table = null;
    public static final String[] columnNames = new String[]{"ID", "OWNER_ID", "SCE_ID", "EVT_ID", "ACTIVE", "BROKEN", "ERROR_CODE", "ERROR_MSG", "LAST_START_TIME", "NEXT_START_TIME", "NEXT_IS_TRIGGER", "BACKLOG_HANDLING", "SUSPEND_LIMIT", "SUSPEND_LIMIT_MULTIPLIER", "IS_CALENDAR", "CALENDAR_HORIZON", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_sceId;
    public static SDMSIndex idx_evtId;
    public static SDMSIndex idx_sceId_evtId;

    public SDMSScheduledEventTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ScheduledEvent"));
        }
        table = (SDMSScheduledEventTable)this;
        table = (SDMSScheduledEventTable)this;
        this.isVersioned = false;
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_sceId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "sceId");
        idx_evtId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "evtId");
        idx_sceId_evtId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "sceId_evtId");
    }

    public SDMSScheduledEvent create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Boolean bl, Boolean bl2, String string, String string2, Long l4, Long l5, Boolean bl3, Integer n, Integer n2, Integer n3, Boolean bl4, Integer n4) throws SDMSException {
        SDMSScheduledEvent sDMSScheduledEvent;
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        Long l8 = systemEnvironment.cEnv.uid();
        Long l9 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ScheduledEvent"));
        }
        this.validate(systemEnvironment, l, l2, l3, bl, bl2, string, string2, l4, l5, bl3, n, n2, n3, bl4, n4, l6, l7, l8, l9);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSScheduledEventGeneric sDMSScheduledEventGeneric = new SDMSScheduledEventGeneric(systemEnvironment, l, l2, l3, bl, bl2, string, string2, l4, l5, bl3, n, n2, n3, bl4, n4, l6, l7, l8, l9);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSScheduledEventGeneric.versions, true);
            table.put(systemEnvironment, sDMSScheduledEventGeneric.id, sDMSScheduledEventGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSScheduledEvent = (SDMSScheduledEvent)sDMSScheduledEventGeneric.toProxy(systemEnvironment);
            sDMSScheduledEvent.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSScheduledEvent sDMSScheduledEvent2 = (SDMSScheduledEvent)sDMSScheduledEventGeneric.toProxy(systemEnvironment);
            sDMSScheduledEvent2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSScheduledEvent)) {
            throw new AccessViolationException(sDMSScheduledEvent.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSScheduledEvent;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSScheduledEvent sDMSScheduledEvent) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Boolean bl, Boolean bl2, String string, String string2, Long l4, Long l5, Boolean bl3, Integer n, Integer n2, Integer n3, Boolean bl4, Integer n4, Long l6, Long l7, Long l8, Long l9) throws SDMSException {
        if (!SDMSScheduledEventGeneric.checkIsActive(bl)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ScheduledEvent: $1 $2", "isActive", bl));
        }
        if (!SDMSScheduledEventGeneric.checkIsBroken(bl2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ScheduledEvent: $1 $2", "isBroken", bl2));
        }
        if (!SDMSScheduledEventGeneric.checkBacklogHandling(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ScheduledEvent: $1 $2", "backlogHandling", n));
        }
        if (!SDMSScheduledEventGeneric.checkSuspendLimit(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ScheduledEvent: $1 $2", "suspendLimit", n2));
        }
        if (!SDMSScheduledEventGeneric.checkIsCalendar(bl4)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ScheduledEvent: $1 $2", "isCalendar", bl4));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Boolean bl;
        Integer n2;
        Integer n3;
        Integer n4;
        Boolean bl2;
        Long l7;
        Long l8;
        String string;
        String string2;
        Boolean bl3;
        Boolean bl4;
        Long l9;
        Long l10;
        Long l11;
        Long l12;
        try {
            l12 = resultSet.getLong(1);
            l11 = resultSet.getLong(2);
            l10 = resultSet.getLong(3);
            l9 = resultSet.getLong(4);
            bl4 = resultSet.getInt(5) != 0;
            bl3 = resultSet.getInt(6) != 0;
            string2 = resultSet.getString(7);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            string = resultSet.getString(8);
            if (resultSet.wasNull()) {
                string = null;
            }
            l8 = resultSet.getLong(9);
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = resultSet.getLong(10);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            bl2 = resultSet.getInt(11) != 0;
            if (resultSet.wasNull()) {
                bl2 = null;
            }
            n4 = resultSet.getInt(12);
            n3 = resultSet.getInt(13);
            if (resultSet.wasNull()) {
                n3 = null;
            }
            n2 = resultSet.getInt(14);
            if (resultSet.wasNull()) {
                n2 = null;
            }
            bl = resultSet.getInt(15) != 0;
            n = resultSet.getInt(16);
            if (resultSet.wasNull()) {
                n = null;
            }
            l6 = resultSet.getLong(17);
            l5 = resultSet.getLong(18);
            l4 = resultSet.getLong(19);
            l3 = resultSet.getLong(20);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ScheduledEvent: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSScheduledEventGeneric(l12, l11, l10, l9, bl4, bl3, string2, string, l8, l7, bl2, n4, n3, n2, bl, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "OWNER_ID" + string2 + ", " + string + "SCE_ID" + string2 + ", " + string + "EVT_ID" + string2 + ", " + string + "ACTIVE" + string2 + ", " + string + "BROKEN" + string2 + ", " + string + "ERROR_CODE" + string2 + ", " + string + "ERROR_MSG" + string2 + ", " + string + "LAST_START_TIME" + string2 + ", " + string + "NEXT_START_TIME" + string2 + ", " + string + "NEXT_IS_TRIGGER" + string2 + ", " + string + "BACKLOG_HANDLING" + string2 + ", " + string + "SUSPEND_LIMIT" + string2 + ", " + string + "SUSPEND_LIMIT_MULTIPLIER" + string2 + ", " + string + "IS_CALENDAR" + string2 + ", " + string + "CALENDAR_HORIZON" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2);
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_ownerId.check(((SDMSScheduledEventGeneric)sDMSObject).ownerId, sDMSObject);
        object = (String)object + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_sceId.check(((SDMSScheduledEventGeneric)sDMSObject).sceId, sDMSObject);
        object = (String)object + "idx_sceId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_evtId.check(((SDMSScheduledEventGeneric)sDMSObject).evtId, sDMSObject);
        object = (String)object + "idx_evtId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScheduledEventGeneric)sDMSObject).sceId);
        sDMSKey.add(((SDMSScheduledEventGeneric)sDMSObject).evtId);
        bl = idx_sceId_evtId.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_sceId_evtId: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_ownerId.put(systemEnvironment, ((SDMSScheduledEventGeneric)sDMSObject).ownerId, sDMSObject, (1L & l) != 0L);
        idx_sceId.put(systemEnvironment, ((SDMSScheduledEventGeneric)sDMSObject).sceId, sDMSObject, (2L & l) != 0L);
        idx_evtId.put(systemEnvironment, ((SDMSScheduledEventGeneric)sDMSObject).evtId, sDMSObject, (4L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScheduledEventGeneric)sDMSObject).sceId);
        sDMSKey.add(((SDMSScheduledEventGeneric)sDMSObject).evtId);
        idx_sceId_evtId.put(systemEnvironment, sDMSKey, sDMSObject, (8L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_ownerId.remove(systemEnvironment, ((SDMSScheduledEventGeneric)sDMSObject).ownerId, sDMSObject);
        idx_sceId.remove(systemEnvironment, ((SDMSScheduledEventGeneric)sDMSObject).sceId, sDMSObject);
        idx_evtId.remove(systemEnvironment, ((SDMSScheduledEventGeneric)sDMSObject).evtId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScheduledEventGeneric)sDMSObject).sceId);
        sDMSKey.add(((SDMSScheduledEventGeneric)sDMSObject).evtId);
        idx_sceId_evtId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSScheduledEvent getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSScheduledEvent)table.get(systemEnvironment, l);
    }

    public static SDMSScheduledEvent getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSScheduledEvent)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSScheduledEvent getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSScheduledEvent)table.get(systemEnvironment, l, l2);
    }

    public static SDMSScheduledEvent idx_sceId_evtId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSScheduledEvent)idx_sceId_evtId.getUnique(systemEnvironment, object);
    }

    public static SDMSScheduledEvent idx_sceId_evtId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSScheduledEvent)idx_sceId_evtId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSScheduledEvent idx_sceId_evtId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSScheduledEvent)idx_sceId_evtId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

