/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.SubmitJob;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSFootprintProxyGeneric;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentProxyGeneric;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTransaction;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerParameter;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerQueueTable;
import de.independit.scheduler.server.repository.SDMSTriggerStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SeVariableResolver;
import de.independit.scheduler.server.repository.VariableResolver;
import de.independit.scheduler.server.util.PathVector;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;

public class SDMSSchedulingEntity
extends SDMSSchedulingEntityProxyGeneric
implements SDMSOwnedObject {
    private static final VariableResolver SEVR = new SeVariableResolver();

    protected SDMSSchedulingEntity(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getFolderId(systemEnvironment);
    }

    @Override
    public SDMSProxy getParent(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getParentId(systemEnvironment);
        if (l == null) {
            return null;
        }
        return SDMSFolderTable.getObject(systemEnvironment, l);
    }

    public String pathString(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment));
        return sDMSFolder.pathString(systemEnvironment) + "." + this.getName(systemEnvironment);
    }

    public String pathString(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment), l);
        return sDMSFolder.pathString(systemEnvironment, l) + "." + this.getName(systemEnvironment);
    }

    @Override
    public PathVector pathVector(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment));
        PathVector pathVector = sDMSFolder.pathVector(systemEnvironment);
        pathVector.add(this.getName(systemEnvironment));
        return pathVector;
    }

    public PathVector idPathVector(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment));
        PathVector pathVector = sDMSFolder.idPathVector(systemEnvironment);
        pathVector.add(this.getId(systemEnvironment));
        return pathVector;
    }

    public PathVector pathVector(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment), l);
        PathVector pathVector = sDMSFolder.pathVector(systemEnvironment, l);
        pathVector.add(this.getName(systemEnvironment));
        return pathVector;
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pathString(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "job definition " + this.getURLName(systemEnvironment);
    }

    @Override
    public String getSubtypeName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getTypeAsString(systemEnvironment);
    }

    public boolean checkParameterRI(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = this.getId(systemEnvironment);
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l2);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(i);
            if (sDMSParameterDefinition.getType(systemEnvironment) != 91 || !(sDMSParameterDefinition = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSParameterDefinition.getLinkPdId(systemEnvironment))).getSeId(systemEnvironment).equals(l)) continue;
            return true;
        }
        return false;
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, boolean bl) throws SDMSException {
        return SEVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, -1L, bl);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, long l, boolean bl) throws SDMSException {
        return SEVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, l, bl);
    }

    public SDMSSubmittedEntity submitMaster(SystemEnvironment systemEnvironment, Vector vector, Integer n, Long l, Long l2, Integer n2, String string, String string2) throws SDMSException {
        return this.submitMaster(systemEnvironment, vector, n, l, l2, n2, string, null, null, string2);
    }

    public SDMSSubmittedEntity submitMaster(SystemEnvironment systemEnvironment, Vector vector, Integer n, Long l, Long l2, Integer n2, String string, String string2, Integer n3, String string3) throws SDMSException {
        return this.submitMaster(systemEnvironment, vector, n, l, l2, n2, string, string2, null, n3, string3);
    }

    public SDMSSubmittedEntity submitMaster(SystemEnvironment systemEnvironment, Vector vector, Integer n, Long l, Long l2, Integer n2, String string, String string2, String string3, Integer n3, String string4) throws SDMSException {
        Comparable comparable;
        Serializable serializable;
        Long l3 = this.getId(systemEnvironment);
        int n4 = 0;
        Date date = new Date();
        Long l4 = date.getTime();
        if (!this.getMasterSubmittable(systemEnvironment).booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02201041040", "$1 $2 cannot be submitted as master", this.getTypeAsString(systemEnvironment), this.getName(systemEnvironment)));
        }
        Long l5 = this.getEspId(systemEnvironment);
        SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l5);
        if (!sDMSExitStateProfile.getIsValid(systemEnvironment).booleanValue()) {
            sDMSExitStateProfile.checkProfile(systemEnvironment);
        }
        if (n == null) {
            Integer n5 = n = this.getSubmitSuspended(systemEnvironment) != false ? SDMSConstants.SME_SUSPEND : SDMSConstants.SME_NOSUSPEND;
            if (n == 1) {
                serializable = null;
                serializable = string4 == null ? TimeZone.getDefault() : TimeZone.getTimeZone(string4);
                l = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), l4, true, (TimeZone)serializable);
            }
        }
        serializable = null;
        if (n != 0) {
            serializable = -l4.longValue();
        }
        long l6 = SDMSTransaction.drawVersion(systemEnvironment);
        Integer n6 = this.getPriority(systemEnvironment);
        Integer n7 = SDMSConstants.iZERO;
        Integer n8 = n2 == null ? SDMSConstants.iZERO : n2;
        switch (this.getType(systemEnvironment)) {
            case 1: {
                if (n6 == null) {
                    n6 = 50 + n8;
                    break;
                }
                if (n6 >= SystemEnvironment.priorityLowerBound && (n6 = Integer.valueOf(n6 + n8)) < SystemEnvironment.priorityLowerBound) {
                    n6 = SystemEnvironment.priorityLowerBound;
                }
                n7 = n6 * 100;
                break;
            }
            case 2: {
                if (n6 == null) break;
                n8 = n6 + n8;
                n6 = SDMSConstants.ST_DEFAULT_PRIORITY;
                break;
            }
            case 3: {
                n6 = SDMSConstants.ST_DEFAULT_PRIORITY;
                if (n8 != null) break;
                n8 = SDMSConstants.iZERO;
            }
        }
        Integer n9 = null;
        n9 = SystemEnvironment.priorityLowerBound;
        Integer n10 = null;
        Integer n11 = null;
        n10 = SystemEnvironment.priorityDelay;
        n11 = SDMSConstants.IV_MINUTE;
        switch (n11) {
            case 0: {
                break;
            }
            case 1: {
                n10 = (int)((long)n10.intValue() * 60L);
                break;
            }
            case 2: {
                n10 = (int)((long)n10.intValue() * 1440L);
                break;
            }
            case 3: {
                n10 = (int)((long)n10.intValue() * 10080L);
                break;
            }
            case 4: {
                n10 = (int)((long)n10.intValue() * 43200L);
                break;
            }
            case 5: {
                n10 = (int)((long)n10.intValue() * 525600L);
            }
        }
        int n12 = this.getCancelApproval(systemEnvironment);
        if (n12 == 5) {
            n4 |= 2;
        }
        if (n12 == 4) {
            n4 |= 1;
        }
        if ((n12 = this.getRerunApproval(systemEnvironment).intValue()) == 5) {
            n4 |= 8;
        }
        if (n12 == 4) {
            n4 |= 4;
        }
        if ((n12 = this.getEnableApproval(systemEnvironment).intValue()) == 5) {
            n4 |= 0x20;
        }
        if (n12 == 4) {
            n4 |= 0x10;
        }
        if ((n12 = this.getSetStateApproval(systemEnvironment).intValue()) == 5) {
            n4 |= 0x80;
        }
        if (n12 == 4) {
            n4 |= 0x40;
        }
        if ((n12 = this.getIgnDepApproval(systemEnvironment).intValue()) == 5) {
            n4 |= 0x200;
        }
        if (n12 == 4) {
            n4 |= 0x100;
        }
        if ((n12 = this.getIgnRssApproval(systemEnvironment).intValue()) == 5) {
            n4 |= 0x800;
        }
        if (n12 == 4) {
            n4 |= 0x400;
        }
        if ((n12 = this.getCloneApproval(systemEnvironment).intValue()) == 5) {
            n4 |= 0x2000;
        }
        if (n12 == 4) {
            n4 |= 0x1000;
        }
        if ((n12 = this.getEditParmApproval(systemEnvironment).intValue()) == 5) {
            n4 |= 0x200000;
        }
        if (n12 == 4) {
            n4 |= 0x100000;
        }
        if ((n12 = this.getKillApproval(systemEnvironment).intValue()) == 5) {
            n4 |= 0x800000;
        }
        if (n12 == 4) {
            n4 |= 0x400000;
        }
        if ((n12 = this.getSetJobStateApproval(systemEnvironment).intValue()) == 5) {
            n4 |= 0x2000000;
        }
        if (n12 == 4) {
            n4 |= 0x1000000;
        }
        n11 = SDMSConstants.IV_MINUTE;
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.table.create(systemEnvironment, systemEnvironment.randomLong(), SDMSConstants.lZERO, string2, n3, l3, string3, l6, l2, null, null, Boolean.TRUE, Boolean.FALSE, null, SDMSConstants.SH_FAILURE, SDMSConstants.SME_SUBMITTED, null, null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, SDMSConstants.iZERO, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null, null, SDMSConstants.iZERO, null, null, null, null, null, null, null, null, n, n6, n7, n8, SDMSConstants.iZERO, n9, n10, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, null, n4, SDMSConstants.iZERO, l4, l, null, null, null, null, null, null, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, null, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, SDMSConstants.iZERO, (Long)serializable, null, string4);
        Long l7 = sDMSSubmittedEntity.getId(systemEnvironment);
        if (vector != null) {
            for (WithItem withItem : vector) {
                sDMSSubmittedEntity.setVariableValue(systemEnvironment, (String)((Object)withItem.key), (String)withItem.value);
            }
        }
        sDMSSubmittedEntity.submitChildren(systemEnvironment, n == 0 ? 0 : 1, l2, null, n8 * 100, false);
        sDMSSubmittedEntity.resolveDependencies(systemEnvironment, true);
        Vector vector2 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l3);
        for (int i = 0; i < vector2.size(); ++i) {
            comparable = (SDMSTrigger)vector2.get(i);
            int n13 = ((SDMSTriggerProxyGeneric)comparable).getType(systemEnvironment);
            if (n13 != 5 && n13 != 6) continue;
            SDMSTriggerQueueTable.table.create(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment), ((SDMSProxy)comparable).getId(systemEnvironment), SDMSConstants.lZERO, SDMSConstants.iZERO, SDMSConstants.iZERO);
        }
        sDMSSubmittedEntity.checkDependencies(systemEnvironment);
        Long l8 = date.getTime();
        comparable = systemEnvironment.cEnv.isUser() ? systemEnvironment.cEnv.uid() : SDMSUserTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)"INTERNAL"), SDMSConstants.lZERO)).getId(systemEnvironment);
        SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSSubmittedEntity, 18);
        return sDMSSubmittedEntity;
    }

    public SDMSSubmittedEntity createErrorMaster(SystemEnvironment systemEnvironment, Long l, String string, String string2) throws SDMSException {
        Long l2 = this.getId(systemEnvironment);
        Date date = new Date();
        long l3 = SDMSTransaction.drawVersion(systemEnvironment);
        Integer n = SDMSConstants.ST_DEFAULT_PRIORITY;
        Integer n2 = SDMSConstants.iZERO;
        Long l4 = this.getEspId(systemEnvironment);
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l4);
        Long l5 = null;
        for (int i = 0; i < vector.size(); ++i) {
            SDMSExitState sDMSExitState = (SDMSExitState)vector.get(i);
            if (!sDMSExitState.getIsBroken(systemEnvironment).booleanValue()) continue;
            l5 = sDMSExitState.getEsdId(systemEnvironment);
            break;
        }
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.table.createErrorMaster(systemEnvironment, l2, l3, l, l5, l5, string2, n, n2, date.getTime());
        Long l6 = sDMSSubmittedEntity.getId(systemEnvironment);
        sDMSSubmittedEntity.setMasterId(systemEnvironment, l6);
        Long l7 = date.getTime();
        if (systemEnvironment.cEnv.isUser()) {
            Long l8 = systemEnvironment.cEnv.uid();
        } else {
            Long l9 = SDMSUserTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)"INTERNAL"), SDMSConstants.lZERO)).getId(systemEnvironment);
        }
        sDMSSubmittedEntity.trigger(systemEnvironment, 0);
        sDMSSubmittedEntity.trigger(systemEnvironment, 1);
        sDMSSubmittedEntity.trigger(systemEnvironment, 4);
        return sDMSSubmittedEntity;
    }

    public SDMSSchedulingEntity copy(SystemEnvironment systemEnvironment, Long l, String string, HashMap hashMap) throws SDMSException {
        Comparable comparable;
        SDMSProxy sDMSProxy;
        Object object;
        Object object22;
        Object object3;
        Object object4;
        Iterator iterator;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object92;
        SDMSProxy sDMSProxy2;
        Comparable comparable2;
        Long l2 = this.getId(systemEnvironment);
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
        Long l3 = this.getNeId(systemEnvironment);
        if (l3 != null && !((SDMSNamedEnvironmentProxyGeneric)(comparable2 = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l3))).checkPrivileges(systemEnvironment, 0x1000000L)) {
            throw new AccessViolationException(((SDMSNamedEnvironmentProxyGeneric)comparable2).accessViolationMessage(systemEnvironment, "03402291147"));
        }
        comparable2 = this.getFpId(systemEnvironment);
        if (comparable2 != null && !((SDMSFootprintProxyGeneric)(sDMSProxy2 = SDMSFootprintTable.getObject(systemEnvironment, (Long)comparable2))).checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(((SDMSFootprintProxyGeneric)sDMSProxy2).accessViolationMessage(systemEnvironment, "03402291151"));
        }
        sDMSProxy2 = SDMSSchedulingEntityTable.table.create(systemEnvironment, string, l, sDMSUser.getDefaultGId(systemEnvironment), this.getType(systemEnvironment), this.getRunProgram(systemEnvironment), this.getRerunProgram(systemEnvironment), this.getKillProgram(systemEnvironment), this.getWorkdir(systemEnvironment), this.getLogfile(systemEnvironment), this.getTruncLog(systemEnvironment), this.getErrlogfile(systemEnvironment), this.getTruncErrlog(systemEnvironment), this.getExpectedRuntime(systemEnvironment), this.getExpectedFinaltime(systemEnvironment), this.getGetExpectedRuntime(systemEnvironment), this.getPriority(systemEnvironment), this.getMinPriority(systemEnvironment), this.getAgingAmount(systemEnvironment), this.getAgingBase(systemEnvironment), this.getSubmitSuspended(systemEnvironment), this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), this.getMasterSubmittable(systemEnvironment), this.getTimeoutAmount(systemEnvironment), this.getTimeoutBase(systemEnvironment), this.getTimeoutStateId(systemEnvironment), this.getSameNode(systemEnvironment), this.getGangSchedule(systemEnvironment), this.getDependencyOperation(systemEnvironment), this.getEsmpId(systemEnvironment), this.getEspId(systemEnvironment), this.getQaId(systemEnvironment), l3, (Long)comparable2, this.getCancelLeadFlag(systemEnvironment), this.getCancelApproval(systemEnvironment), this.getRerunLeadFlag(systemEnvironment), this.getRerunApproval(systemEnvironment), this.getEnableLeadFlag(systemEnvironment), this.getEnableApproval(systemEnvironment), this.getSetStateLeadFlag(systemEnvironment), this.getSetStateApproval(systemEnvironment), this.getIgnDepLeadFlag(systemEnvironment), this.getIgnDepApproval(systemEnvironment), this.getIgnRssLeadFlag(systemEnvironment), this.getIgnRssApproval(systemEnvironment), this.getCloneLeadFlag(systemEnvironment), this.getCloneApproval(systemEnvironment), this.getEditParmLeadFlag(systemEnvironment), this.getEditParmApproval(systemEnvironment), this.getKillLeadFlag(systemEnvironment), this.getKillApproval(systemEnvironment), this.getSetJobStateLeadFlag(systemEnvironment), this.getSetJobStateApproval(systemEnvironment), this.getInheritPrivs(systemEnvironment));
        Long l4 = sDMSProxy2.getId(systemEnvironment);
        Vector vector = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l2);
        for (Object object92 : vector) {
            object8 = ((SDMSResourceRequirementProxyGeneric)object92).getNrId(systemEnvironment);
            object7 = SDMSNamedResourceTable.getObject(systemEnvironment, (Long)object8);
            if (!((SDMSNamedResourceProxyGeneric)object7).checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(((SDMSNamedResourceProxyGeneric)object7).accessViolationMessage(systemEnvironment, "03402291155"));
            }
            object6 = SDMSResourceRequirementTable.table.create(systemEnvironment, (Long)object8, l4, ((SDMSResourceRequirementProxyGeneric)object92).getAmount(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getKeepMode(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getIsSticky(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getStickyName(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getStickyParent(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getRsmpId(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getExpiredAmount(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getExpiredBase(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getIgnoreOnRerun(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getLockmode(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object92).getCondition(systemEnvironment));
            object5 = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, ((SDMSProxy)object92).getId(systemEnvironment));
            iterator = ((Vector)object5).iterator();
            while (iterator.hasNext()) {
                object4 = (SDMSResourceReqStates)iterator.next();
                SDMSResourceReqStatesTable.table.create(systemEnvironment, ((SDMSProxy)object6).getId(systemEnvironment), ((SDMSResourceReqStatesProxyGeneric)object4).getRsdId(systemEnvironment));
            }
        }
        object92 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l2);
        object8 = ((Vector)object92).iterator();
        while (object8.hasNext()) {
            object7 = (SDMSParameterDefinition)object8.next();
            object6 = SDMSParameterDefinitionTable.table.create(systemEnvironment, l4, ((SDMSParameterDefinitionProxyGeneric)object7).getName(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object7).getType(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object7).getAggFunction(systemEnvironment), ((SDMSParameterDefinition)object7).getDefaultValue(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object7).getIsLocal(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object7).getLinkPdId(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object7).getExportName(systemEnvironment));
            object5 = ((SDMSProxy)object6).getId(systemEnvironment);
            if (hashMap != null) {
                hashMap.put(((SDMSProxy)object7).getId(systemEnvironment), object5);
            }
            object4 = SDMSObjectCommentTable.idx_objectId.getVector(systemEnvironment, ((SDMSProxy)object7).getId(systemEnvironment));
            for (int i = 0; i < ((Vector)object4).size(); ++i) {
                iterator = (SDMSObjectComment)((Vector)object4).get(i);
                SDMSObjectCommentTable.table.create(systemEnvironment, (Long)object5, ((SDMSObjectCommentProxyGeneric)((Object)iterator)).getObjectType(systemEnvironment), ((SDMSObjectCommentProxyGeneric)((Object)iterator)).getInfoType(systemEnvironment), ((SDMSObjectCommentProxyGeneric)((Object)iterator)).getSequenceNumber(systemEnvironment), ((SDMSObjectCommentProxyGeneric)((Object)iterator)).getTag(systemEnvironment), ((SDMSObjectCommentProxyGeneric)((Object)iterator)).getDescription(systemEnvironment));
            }
        }
        object7 = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, l2);
        object6 = ((Vector)object7).iterator();
        while (object6.hasNext()) {
            object5 = (SDMSDependencyDefinition)object6.next();
            iterator = SDMSDependencyDefinitionTable.table.create(systemEnvironment, l4, ((SDMSDependencyDefinitionProxyGeneric)object5).getSeRequiredId(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object5).getName(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object5).getUnresolvedHandling(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object5).getMode(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object5).getStateSelection(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object5).getCondition(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object5).getResolveMode(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object5).getExpiredAmount(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object5).getExpiredBase(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object5).getSelectCondition(systemEnvironment));
            object4 = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, ((SDMSProxy)object5).getId(systemEnvironment));
            Iterator iterator2 = ((Vector)object4).iterator();
            while (iterator2.hasNext()) {
                object3 = (SDMSDependencyState)iterator2.next();
                SDMSDependencyStateTable.table.create(systemEnvironment, ((SDMSProxy)((Object)iterator)).getId(systemEnvironment), ((SDMSDependencyStateProxyGeneric)object3).getEsdId(systemEnvironment), ((SDMSDependencyStateProxyGeneric)object3).getCondition(systemEnvironment));
            }
        }
        object5 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l2);
        iterator = ((Vector)object5).iterator();
        while (iterator.hasNext()) {
            object4 = (SDMSSchedulingHierarchy)iterator.next();
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSSchedulingHierarchyProxyGeneric)object4).getSeChildId(systemEnvironment));
            if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(sDMSSchedulingEntity.accessViolationMessage(systemEnvironment, "03402292318"));
            }
            SDMSSchedulingHierarchyTable.table.create(systemEnvironment, l4, ((SDMSSchedulingHierarchyProxyGeneric)object4).getSeChildId(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getAliasName(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getIsStatic(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getIsDisabled(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getPriority(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getSuspend(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getResumeAt(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getResumeIn(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getResumeBase(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getMergeMode(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getEstpId(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getIntId(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getEnableCondition(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object4).getEnableMode(systemEnvironment));
        }
        boolean bl = false;
        Vector vector2 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l2);
        do {
            for (Object object22 : vector2) {
                Object object102;
                object = ((SDMSTriggerProxyGeneric)object22).getIsInverse(systemEnvironment);
                if ((Boolean)object != bl) continue;
                sDMSProxy = SDMSTriggerTable.table.create(systemEnvironment, ((SDMSTriggerProxyGeneric)object22).getName(systemEnvironment), bl ? ((SDMSTriggerProxyGeneric)object22).getFireId(systemEnvironment) : l4, ((SDMSTriggerProxyGeneric)object22).getObjectType(systemEnvironment), bl ? l4 : ((SDMSTriggerProxyGeneric)object22).getSeId(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getMainSeId(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getParentSeId(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getIsActive(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getIsInverse(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getAction(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getType(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getIsMaster(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getIsSuspend(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getIsCreate(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getIsChange(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getIsDelete(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getIsGroup(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getResumeAt(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getResumeIn(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getResumeBase(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getIsWarnOnLimit(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getLimitState(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getMaxRetry(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getSubmitOwnerId(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getCondition(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getCheckAmount(systemEnvironment), ((SDMSTriggerProxyGeneric)object22).getCheckBase(systemEnvironment));
                comparable = sDMSProxy.getId(systemEnvironment);
                Vector vector3 = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, ((SDMSProxy)object22).getId(systemEnvironment));
                for (Object object102 : vector3) {
                    SDMSTriggerStateTable.table.create(systemEnvironment, (Long)comparable, ((SDMSTriggerStateProxyGeneric)object102).getFromStateId(systemEnvironment), ((SDMSTriggerStateProxyGeneric)object102).getToStateId(systemEnvironment));
                }
                object102 = SDMSTriggerParameterTable.idx_triggerId.getVector(systemEnvironment, ((SDMSProxy)object22).getId(systemEnvironment));
                Iterator iterator3 = ((Vector)object102).iterator();
                while (iterator3.hasNext()) {
                    SDMSTriggerParameter sDMSTriggerParameter = (SDMSTriggerParameter)iterator3.next();
                    SDMSTriggerParameterTable.table.create(systemEnvironment, sDMSTriggerParameter.getName(systemEnvironment), sDMSTriggerParameter.getExpression(systemEnvironment), (Long)comparable);
                }
            }
            if (bl) continue;
            vector2 = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, l2);
        } while (bl = !bl);
        object3 = SDMSResourceTemplateTable.idx_seId.getVector(systemEnvironment, l2);
        object22 = ((Vector)object3).iterator();
        while (object22.hasNext()) {
            object = (SDMSResourceTemplate)object22.next();
            sDMSProxy = SDMSResourceTemplateTable.table.create(systemEnvironment, ((SDMSResourceTemplateProxyGeneric)object).getNrId(systemEnvironment), l4, ((SDMSResourceTemplateProxyGeneric)object).getOwnerId(systemEnvironment), ((SDMSResourceTemplateProxyGeneric)object).getRsdId(systemEnvironment), ((SDMSResourceTemplateProxyGeneric)object).getRequestableAmount(systemEnvironment), ((SDMSResourceTemplateProxyGeneric)object).getAmount(systemEnvironment), ((SDMSResourceTemplateProxyGeneric)object).getIsOnline(systemEnvironment));
            ((SDMSResourceTemplate)object).copyVariables(systemEnvironment, sDMSProxy.getId(systemEnvironment));
        }
        object = SDMSObjectCommentTable.idx_objectId.getVector(systemEnvironment, l2);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            comparable = (SDMSObjectComment)((Vector)object).get(i);
            SDMSObjectCommentTable.table.create(systemEnvironment, l4, comparable.getObjectType(systemEnvironment), comparable.getInfoType(systemEnvironment), comparable.getSequenceNumber(systemEnvironment), comparable.getTag(systemEnvironment), comparable.getDescription(systemEnvironment));
        }
        return sDMSProxy2;
    }

    public void relocateDetails(SystemEnvironment systemEnvironment, HashMap hashMap) throws SDMSException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object82;
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, l);
        for (Object object82 : vector) {
            object7 = (Long)hashMap.get(((SDMSDependencyDefinitionProxyGeneric)object82).getSeRequiredId(systemEnvironment));
            if (object7 == null) continue;
            ((SDMSDependencyDefinitionProxyGeneric)object82).setSeRequiredId(systemEnvironment, (Long)object7);
        }
        object82 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l);
        object7 = ((Vector)object82).iterator();
        while (object7.hasNext()) {
            object6 = (SDMSSchedulingHierarchy)object7.next();
            object5 = (Long)hashMap.get(((SDMSSchedulingHierarchyProxyGeneric)object6).getSeChildId(systemEnvironment));
            if (object5 == null) continue;
            ((SDMSSchedulingHierarchyProxyGeneric)object6).setSeChildId(systemEnvironment, (Long)object5);
        }
        object6 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l);
        object5 = ((Vector)object6).iterator();
        while (object5.hasNext()) {
            object4 = (SDMSParameterDefinition)object5.next();
            object3 = (Long)hashMap.get(((SDMSParameterDefinitionProxyGeneric)object4).getLinkPdId(systemEnvironment));
            if (object3 == null) continue;
            ((SDMSParameterDefinition)object4).setLinkPdId(systemEnvironment, (Long)object3);
        }
        object4 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l);
        object3 = ((Vector)object4).iterator();
        while (object3.hasNext()) {
            object2 = (SDMSTrigger)object3.next();
            object = (Long)hashMap.get(((SDMSTriggerProxyGeneric)object2).getSeId(systemEnvironment));
            if (object == null) continue;
            ((SDMSTriggerProxyGeneric)object2).setSeId(systemEnvironment, (Long)object);
        }
        object4 = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, l);
        object3 = ((Vector)object4).iterator();
        while (object3.hasNext()) {
            object2 = (SDMSTrigger)object3.next();
            object = (Long)hashMap.get(((SDMSTriggerProxyGeneric)object2).getFireId(systemEnvironment));
            if (object == null) continue;
            ((SDMSTriggerProxyGeneric)object2).setFireId(systemEnvironment, (Long)object);
        }
        object2 = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l);
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)object.next();
            Long l2 = sDMSResourceRequirement.getStickyParent(systemEnvironment);
            if (l2 == null || (l2 = (Long)hashMap.get(l2)) == null) continue;
            sDMSResourceRequirement.setStickyParent(systemEnvironment, l2);
        }
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if (systemEnvironment.cEnv.isUser() && l2 != l) {
            long l3;
            long l4 = this.getInheritPrivs(systemEnvironment);
            if ((l & 4L) != 0L) {
                l4 |= 4L;
            }
            if ((l2 | (l3 = l & (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l4)) != l && bl) {
                return 0L;
            }
            Long l5 = this.getFolderId(systemEnvironment);
            if (l5 != null && l3 != 0L) {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l5);
                long l6 = (l3 & 4L) != 0L ? l3 & 0xFFFFFFFFFFFFFFFBL | 2L : l3;
                if (((l6 = sDMSFolder.getPrivileges(systemEnvironment, l6, bl, vector)) & 2L) != 0L) {
                    l6 |= 4L;
                }
                l2 |= l6 & l4;
            }
            l2 &= l;
        }
        return l2;
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        long l3 = super.getPrivileges(systemEnvironment, l, bl, vector, l2);
        if (systemEnvironment.cEnv.isUser() && l3 != l) {
            long l4;
            long l5 = 0L;
            try {
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getId(systemEnvironment));
                l5 = sDMSSchedulingEntity.getInheritPrivs(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if ((l & 4L) != 0L) {
                l5 |= 4L;
            }
            if ((l3 | (l4 = l & (l3 ^ 0xFFFFFFFFFFFFFFFFL) & l5)) != l && bl) {
                return 0L;
            }
            Long l6 = this.getFolderId(systemEnvironment);
            if (l6 != null && l4 != 0L) {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l6, l2);
                long l7 = (l4 & 4L) != 0L ? l4 & 0xFFFFFFFFFFFFFFFBL | 2L : l4;
                if (((l7 = sDMSFolder.getPrivileges(systemEnvironment, l7, bl, vector, l2)) & 2L) != 0L) {
                    l7 |= 4L;
                }
                l3 |= l7 & l5;
            }
            if ((l3 & 0x100000L) == 0x100000L) {
                l3 |= 0x10000000L;
            }
            if ((l3 & 0x20000EEEF0200L) != 0L) {
                l3 |= 0x1000L;
            }
            l3 &= l;
        }
        return l3;
    }

    public void checkSubmitForGroup(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = systemEnvironment.cEnv.uid();
        if (systemEnvironment.cEnv.isUser()) {
            if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(SDMSObject.adminGId, l2))) {
                if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(l, l2))) {
                    SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l2);
                    SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402180823", "User $1 does not belong to Group $2", sDMSUser.getName(systemEnvironment), sDMSGroup.getName(systemEnvironment)));
                }
                Long l3 = this.getOwnerId(systemEnvironment);
                if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(l3, l2))) {
                    Vector<Long> vector = new Vector<Long>();
                    vector.add(l);
                    SDMSPrivilege sDMSPrivilege = this.getPrivilegesForGroups(systemEnvironment, vector);
                    if (!sDMSPrivilege.can(0x100000L)) {
                        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l2);
                        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402180938", "User $1 not allowed to submit $2 for group $3", sDMSUser.getName(systemEnvironment), this.pathString(systemEnvironment), sDMSGroup.getName(systemEnvironment)));
                    }
                }
            }
        } else {
            Vector<Long> vector = new Vector<Long>();
            vector.add(l);
            vector.add(SDMSObject.publicGId);
            systemEnvironment.cEnv.setUser();
            try {
                SDMSPrivilege sDMSPrivilege = this.getPrivilegesForGroups(systemEnvironment, vector);
                if (!sDMSPrivilege.can(0x100000L)) {
                    SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03801291413", "Job $1 not allowed to submit $2 from group $3", l2, this.pathString(systemEnvironment), sDMSGroup.getName(systemEnvironment)));
                }
            }
            catch (SDMSException sDMSException) {
                throw sDMSException;
            }
            finally {
                systemEnvironment.cEnv.setJob();
            }
        }
    }

    public void removeFromTimeScheduling(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSEventTable.idx_seId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSEvent sDMSEvent = (SDMSEvent)vector.get(i);
            Vector vector2 = SDMSScheduledEventTable.idx_evtId.getVector(systemEnvironment, sDMSEvent.getId(systemEnvironment));
            for (int j = 0; j < vector2.size(); ++j) {
                comparable = (SDMSScheduledEvent)vector2.get(j);
                ((SDMSScheduledEvent)comparable).delete(systemEnvironment);
            }
            sDMSEvent.delete(systemEnvironment);
        }
        Vector vector3 = null;
        boolean bl = false;
        while (!bl) {
            bl = true;
            vector3 = SDMSScheduleTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector3.size(); ++i) {
                SDMSSchedule sDMSSchedule = (SDMSSchedule)vector3.get(i);
                comparable = sDMSSchedule.getId(systemEnvironment);
                if (SDMSScheduledEventTable.idx_sceId.containsKey(systemEnvironment, comparable) || SDMSScheduleTable.idx_parentId.containsKey(systemEnvironment, comparable)) continue;
                sDMSSchedule.delete(systemEnvironment);
                bl = false;
            }
        }
        if (vector3 != null) {
            for (int i = 0; i < vector3.size(); ++i) {
                SDMSSchedule sDMSSchedule = (SDMSSchedule)vector3.get(i);
                sDMSSchedule.setSeId(systemEnvironment, null);
            }
        }
        Vector vector4 = null;
        bl = false;
        while (!bl) {
            bl = true;
            vector4 = SDMSIntervalTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector4.size(); ++i) {
                comparable = (SDMSInterval)vector4.get(i);
                Long l2 = ((SDMSProxy)comparable).getId(systemEnvironment);
                if (SDMSIntervalTable.idx_embeddedIntervalId.containsKey(systemEnvironment, l2)) continue;
                if (SDMSScheduleTable.idx_intId.containsKey(systemEnvironment, l2)) {
                    ((SDMSIntervalProxyGeneric)comparable).setSeId(systemEnvironment, null);
                    continue;
                }
                if (SDMSIntervalHierarchyTable.idx_childId.containsKey(systemEnvironment, l2)) continue;
                IntervalUtil.killFilter(systemEnvironment, l2);
                IntervalUtil.killSelections(systemEnvironment, l2);
                IntervalUtil.killDispatcher(systemEnvironment, l2);
                ((SDMSInterval)comparable).delete(systemEnvironment);
                bl = false;
            }
        }
        if (vector4 != null) {
            for (int i = 0; i < vector4.size(); ++i) {
                comparable = (SDMSInterval)vector4.get(i);
                ((SDMSIntervalProxyGeneric)comparable).setSeId(systemEnvironment, null);
            }
        }
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.delete(systemEnvironment, false);
    }

    private void doDelete(SystemEnvironment systemEnvironment) throws SDMSException {
        super.delete(systemEnvironment);
    }

    public void delete(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(this.getId(systemEnvironment));
        SDMSSchedulingEntity.delete(systemEnvironment, hashSet, bl);
    }

    public static void delete(SystemEnvironment systemEnvironment, HashSet<Long> hashSet, boolean bl) throws SDMSException {
        for (Long l : hashSet) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
            Vector vector = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector.size(); ++i) {
                ((SDMSDependencyDefinition)vector.get(i)).delete(systemEnvironment);
            }
            Vector vector2 = SDMSDependencyDefinitionTable.idx_seRequiredId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector2.size(); ++i) {
                object7 = (SDMSDependencyDefinition)vector2.get(i);
                if (hashSet.contains(((SDMSDependencyDefinitionProxyGeneric)object7).getSeDependentId(systemEnvironment))) continue;
                if (!bl) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112202113", "$1 is required by $2, specify force to delete anyway", sDMSSchedulingEntity.pathString(systemEnvironment), SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSDependencyDefinitionProxyGeneric)object7).getSeDependentId(systemEnvironment)).pathString(systemEnvironment)));
                }
                ((SDMSDependencyDefinition)object7).delete(systemEnvironment);
            }
            Vector vector3 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector3.size(); ++i) {
                object6 = (SDMSSchedulingHierarchy)vector3.get(i);
                ((SDMSSchedulingHierarchy)object6).delete(systemEnvironment);
            }
            object7 = SDMSSchedulingHierarchyTable.idx_seChildId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object7).size(); ++i) {
                object5 = (SDMSSchedulingHierarchy)((Vector)object7).get(i);
                if (hashSet.contains(((SDMSSchedulingHierarchyProxyGeneric)object5).getSeParentId(systemEnvironment))) continue;
                if (!bl) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207042302", "$1 is used as a child of $2, specify force to delete anyway", sDMSSchedulingEntity.pathString(systemEnvironment), SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSSchedulingHierarchyProxyGeneric)object5).getSeParentId(systemEnvironment)).pathString(systemEnvironment)));
                }
                ((SDMSSchedulingHierarchy)object5).delete(systemEnvironment);
            }
            object6 = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object6).size(); ++i) {
                ((SDMSResourceRequirement)((Vector)object6).get(i)).delete(systemEnvironment);
            }
            object5 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object5).size(); ++i) {
                object4 = (SDMSParameterDefinition)((Vector)object5).get(i);
                ((SDMSParameterDefinition)object4).delete(systemEnvironment, hashSet, bl);
            }
            Vector vector4 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector4.size(); ++i) {
                object3 = (SDMSTrigger)vector4.get(i);
                if (((SDMSTriggerProxyGeneric)object3).getIsInverse(systemEnvironment).booleanValue()) {
                    if (hashSet.contains(((SDMSTriggerProxyGeneric)object3).getSeId(systemEnvironment))) continue;
                    if (!bl) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207042303", "$1 is used as triggering job of $2, specify force to delete anyway", sDMSSchedulingEntity.pathString(systemEnvironment), SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSTriggerProxyGeneric)object3).getSeId(systemEnvironment)).pathString(systemEnvironment)));
                    }
                }
                ((SDMSTrigger)object3).delete(systemEnvironment);
            }
            object4 = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object4).size(); ++i) {
                object2 = (SDMSTrigger)((Vector)object4).get(i);
                if (!((SDMSTriggerProxyGeneric)object2).getIsInverse(systemEnvironment).booleanValue()) {
                    if (hashSet.contains(((SDMSTriggerProxyGeneric)object2).getFireId(systemEnvironment))) continue;
                    if (!bl) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207042304", "$1 triggered by $2, specify force to delete anyway", sDMSSchedulingEntity.pathString(systemEnvironment), SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSTriggerProxyGeneric)object2).getFireId(systemEnvironment)).pathString(systemEnvironment)));
                    }
                }
                ((SDMSTrigger)object2).delete(systemEnvironment);
            }
            object3 = SDMSTriggerTable.idx_mainSeId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                object = (SDMSTrigger)((Vector)object3).get(i);
                ((SDMSTrigger)object).delete(systemEnvironment);
            }
            object2 = SDMSTriggerTable.idx_parentSeId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                SDMSTrigger sDMSTrigger = (SDMSTrigger)((Vector)object2).get(i);
                sDMSTrigger.delete(systemEnvironment);
            }
            object = SDMSResourceTemplateTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                SDMSResourceTemplate sDMSResourceTemplate = (SDMSResourceTemplate)((Vector)object).get(i);
                sDMSResourceTemplate.delete(systemEnvironment);
            }
            sDMSSchedulingEntity.removeFromTimeScheduling(systemEnvironment);
            sDMSSchedulingEntity.doDelete(systemEnvironment);
        }
    }

    public String pathString(SystemEnvironment systemEnvironment, long l, HashMap hashMap) throws SDMSException {
        if (hashMap == null) {
            return this.pathString(systemEnvironment, l);
        }
        Long l2 = this.getId(systemEnvironment);
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment), l);
        String string = sDMSFolder.pathString(systemEnvironment, l, hashMap) + "." + this.getName(systemEnvironment);
        return string;
    }
}

