/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSSchedulingHierarchyTableGeneric
extends SDMSTable {
    public static final String tableName = "SCHEDULING_HIERARCHY";
    public static SDMSSchedulingHierarchyTable table = null;
    public static final String[] columnNames = new String[]{"ID", "SE_PARENT_ID", "SE_CHILD_ID", "ALIAS_NAME", "IS_STATIC", "IS_DISABLED", "PRIORITY", "SUSPEND", "RESUME_AT", "RESUME_IN", "RESUME_BASE", "MERGE_MODE", "ESTP_ID", "INT_ID", "ENABLE_CONDITION", "ENABLE_MODE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_seParentId;
    public static SDMSIndex idx_seChildId;
    public static SDMSIndex idx_estpId;
    public static SDMSIndex idx_intId;
    public static SDMSIndex idx_parentId_childId;
    public static SDMSIndex idx_parentId_aliasName;

    public SDMSSchedulingHierarchyTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "SchedulingHierarchy"));
        }
        table = (SDMSSchedulingHierarchyTable)this;
        table = (SDMSSchedulingHierarchyTable)this;
        this.isVersioned = true;
        idx_seParentId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seParentId");
        idx_seChildId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seChildId");
        idx_estpId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "estpId");
        idx_intId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "intId");
        idx_parentId_childId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "parentId_childId");
        idx_parentId_aliasName = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "parentId_aliasName");
    }

    public SDMSSchedulingHierarchy create(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Boolean bl, Boolean bl2, Integer n, Integer n2, String string2, Integer n3, Integer n4, Integer n5, Long l3, Long l4, String string3, Integer n6) throws SDMSException {
        SDMSSchedulingHierarchy sDMSSchedulingHierarchy;
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "SchedulingHierarchy"));
        }
        this.validate(systemEnvironment, l, l2, string, bl, bl2, n, n2, string2, n3, n4, n5, l3, l4, string3, n6, l5, l6, l7, l8);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSSchedulingHierarchyGeneric sDMSSchedulingHierarchyGeneric = new SDMSSchedulingHierarchyGeneric(systemEnvironment, l, l2, string, bl, bl2, n, n2, string2, n3, n4, n5, l3, l4, string3, n6, l5, l6, l7, l8);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSSchedulingHierarchyGeneric.versions, true);
            table.put(systemEnvironment, sDMSSchedulingHierarchyGeneric.id, sDMSSchedulingHierarchyGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSSchedulingHierarchy = (SDMSSchedulingHierarchy)sDMSSchedulingHierarchyGeneric.toProxy(systemEnvironment);
            sDMSSchedulingHierarchy.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSSchedulingHierarchy sDMSSchedulingHierarchy2 = (SDMSSchedulingHierarchy)sDMSSchedulingHierarchyGeneric.toProxy(systemEnvironment);
            sDMSSchedulingHierarchy2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSSchedulingHierarchy)) {
            throw new AccessViolationException(sDMSSchedulingHierarchy.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSSchedulingHierarchy.touchMaster(systemEnvironment);
        return sDMSSchedulingHierarchy;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSSchedulingHierarchy sDMSSchedulingHierarchy) throws SDMSException {
        return sDMSSchedulingHierarchy.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Boolean bl, Boolean bl2, Integer n, Integer n2, String string2, Integer n3, Integer n4, Integer n5, Long l3, Long l4, String string3, Integer n6, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        if (!SDMSSchedulingHierarchyGeneric.checkIsStatic(bl)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "SchedulingHierarchy: $1 $2", "isStatic", bl));
        }
        if (!SDMSSchedulingHierarchyGeneric.checkIsDisabled(bl2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "SchedulingHierarchy: $1 $2", "isDisabled", bl2));
        }
        if (!SDMSSchedulingHierarchyGeneric.checkSuspend(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "SchedulingHierarchy: $1 $2", "suspend", n2));
        }
        if (!SDMSSchedulingHierarchyGeneric.checkResumeBase(n4)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "SchedulingHierarchy: $1 $2", "resumeBase", n4));
        }
        if (!SDMSSchedulingHierarchyGeneric.checkMergeMode(n5)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "SchedulingHierarchy: $1 $2", "mergeMode", n5));
        }
        if (!SDMSSchedulingHierarchyGeneric.checkEnableMode(n6)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "SchedulingHierarchy: $1 $2", "enableMode", n6));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        String string;
        Long l7;
        Long l8;
        Integer n2;
        Integer n3;
        Integer n4;
        String string2;
        Integer n5;
        Integer n6;
        Boolean bl;
        Boolean bl2;
        String string3;
        Long l9;
        Long l10;
        Long l11;
        try {
            l11 = resultSet.getLong(1);
            l10 = resultSet.getLong(2);
            if (resultSet.wasNull()) {
                l10 = null;
            }
            l9 = resultSet.getLong(3);
            if (resultSet.wasNull()) {
                l9 = null;
            }
            string3 = resultSet.getString(4);
            if (resultSet.wasNull()) {
                string3 = null;
            }
            bl2 = resultSet.getInt(5) != 0;
            bl = resultSet.getInt(6) != 0;
            n6 = resultSet.getInt(7);
            n5 = resultSet.getInt(8);
            string2 = resultSet.getString(9);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            n4 = resultSet.getInt(10);
            if (resultSet.wasNull()) {
                n4 = null;
            }
            n3 = resultSet.getInt(11);
            if (resultSet.wasNull()) {
                n3 = null;
            }
            n2 = resultSet.getInt(12);
            l8 = resultSet.getLong(13);
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = resultSet.getLong(14);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            string = resultSet.getString(15);
            if (resultSet.wasNull()) {
                string = null;
            }
            n = resultSet.getInt(16);
            l6 = resultSet.getLong(17);
            l5 = resultSet.getLong(18);
            l4 = resultSet.getLong(19);
            l3 = resultSet.getLong(20);
            l2 = resultSet.getLong(21);
            l = resultSet.getLong(22);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "SchedulingHierarchy: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSSchedulingHierarchyGeneric(l11, l10, l9, string3, bl2, bl, n6, n5, string2, n4, n3, n2, l8, l7, string, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "SE_PARENT_ID" + string2 + ", " + string + "SE_CHILD_ID" + string2 + ", " + string + "ALIAS_NAME" + string2 + ", " + string + "IS_STATIC" + string2 + ", " + string + "IS_DISABLED" + string2 + ", " + string + "PRIORITY" + string2 + ", " + string + "SUSPEND" + string2 + ", " + string + "RESUME_AT" + string2 + ", " + string + "RESUME_IN" + string2 + ", " + string + "RESUME_BASE" + string2 + ", " + string + "MERGE_MODE" + string2 + ", " + string + "ESTP_ID" + string2 + ", " + string + "INT_ID" + string2 + ", " + string + "ENABLE_CONDITION" + string2 + ", " + string + "ENABLE_MODE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion));
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_seParentId.check(((SDMSSchedulingHierarchyGeneric)sDMSObject).seParentId, sDMSObject);
        object = (String)object + "idx_seParentId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_seChildId.check(((SDMSSchedulingHierarchyGeneric)sDMSObject).seChildId, sDMSObject);
        object = (String)object + "idx_seChildId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_estpId.check(((SDMSSchedulingHierarchyGeneric)sDMSObject).estpId, sDMSObject);
        object = (String)object + "idx_estpId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_intId.check(((SDMSSchedulingHierarchyGeneric)sDMSObject).intId, sDMSObject);
        object = (String)object + "idx_intId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSchedulingHierarchyGeneric)sDMSObject).seParentId);
        sDMSKey.add(((SDMSSchedulingHierarchyGeneric)sDMSObject).seChildId);
        bl = idx_parentId_childId.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_parentId_childId: " + (bl ? "ok" : "missing") + "\n";
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSchedulingHierarchyGeneric)sDMSObject).seParentId);
        sDMSKey.add((Comparable)((Object)((SDMSSchedulingHierarchyGeneric)sDMSObject).aliasName));
        bl = idx_parentId_aliasName.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_parentId_aliasName: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_seParentId.put(systemEnvironment, ((SDMSSchedulingHierarchyGeneric)sDMSObject).seParentId, sDMSObject, (1L & l) != 0L);
        idx_seChildId.put(systemEnvironment, ((SDMSSchedulingHierarchyGeneric)sDMSObject).seChildId, sDMSObject, (2L & l) != 0L);
        idx_estpId.put(systemEnvironment, ((SDMSSchedulingHierarchyGeneric)sDMSObject).estpId, sDMSObject, (4L & l) != 0L);
        idx_intId.put(systemEnvironment, ((SDMSSchedulingHierarchyGeneric)sDMSObject).intId, sDMSObject, (8L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSchedulingHierarchyGeneric)sDMSObject).seParentId);
        sDMSKey.add(((SDMSSchedulingHierarchyGeneric)sDMSObject).seChildId);
        idx_parentId_childId.put(systemEnvironment, sDMSKey, sDMSObject, (0x10L & l) != 0L);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSchedulingHierarchyGeneric)sDMSObject).seParentId);
        sDMSKey.add((Comparable)((Object)((SDMSSchedulingHierarchyGeneric)sDMSObject).aliasName));
        idx_parentId_aliasName.put(systemEnvironment, sDMSKey, sDMSObject, (0x20L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_seParentId.remove(systemEnvironment, ((SDMSSchedulingHierarchyGeneric)sDMSObject).seParentId, sDMSObject);
        idx_seChildId.remove(systemEnvironment, ((SDMSSchedulingHierarchyGeneric)sDMSObject).seChildId, sDMSObject);
        idx_estpId.remove(systemEnvironment, ((SDMSSchedulingHierarchyGeneric)sDMSObject).estpId, sDMSObject);
        idx_intId.remove(systemEnvironment, ((SDMSSchedulingHierarchyGeneric)sDMSObject).intId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSchedulingHierarchyGeneric)sDMSObject).seParentId);
        sDMSKey.add(((SDMSSchedulingHierarchyGeneric)sDMSObject).seChildId);
        idx_parentId_childId.remove(systemEnvironment, sDMSKey, sDMSObject);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSchedulingHierarchyGeneric)sDMSObject).seParentId);
        sDMSKey.add((Comparable)((Object)((SDMSSchedulingHierarchyGeneric)sDMSObject).aliasName));
        idx_parentId_aliasName.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSSchedulingHierarchy getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSchedulingHierarchy)table.get(systemEnvironment, l);
    }

    public static SDMSSchedulingHierarchy getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSchedulingHierarchy)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSSchedulingHierarchy getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSSchedulingHierarchy)table.get(systemEnvironment, l, l2);
    }

    public static SDMSSchedulingHierarchy idx_parentId_childId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSSchedulingHierarchy)idx_parentId_childId.getUnique(systemEnvironment, object);
    }

    public static SDMSSchedulingHierarchy idx_parentId_childId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSSchedulingHierarchy)idx_parentId_childId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSSchedulingHierarchy idx_parentId_childId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSSchedulingHierarchy)idx_parentId_childId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

