/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.ListenThread;
import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.UserConnection;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.parser.ScopeParameter;
import de.independit.scheduler.server.repository.SDMSHierarchicalObject;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSScopeProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserEquiv;
import de.independit.scheduler.server.repository.SDMSUserEquivTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.ScopeVariableResolver;
import de.independit.scheduler.server.repository.VariableResolver;
import de.independit.scheduler.server.util.SDMSFilter;
import de.independit.scheduler.server.util.SDMSThread;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SDMSScope
extends SDMSScopeProxyGeneric
implements SDMSOwnedObject,
SDMSHierarchicalObject {
    public static final String __version = "@(#) $Id: SDMSScope.java,v 2.27.2.4 2013/03/19 17:16:52 ronald Exp $";
    private static final VariableResolver SVR = new ScopeVariableResolver();

    protected SDMSScope(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public SDMSScope getParent(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getParentId(systemEnvironment);
        if (l == null) {
            return null;
        }
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
        return sDMSScope;
    }

    public SDMSScope copy(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        SDMSScope sDMSScope = this.internalCopy(systemEnvironment, l, string, hashMap, hashMap2);
        return sDMSScope;
    }

    private SDMSScope internalCopy(SystemEnvironment systemEnvironment, Long l, String string, HashMap hashMap, HashMap hashMap2) throws SDMSException {
        Object object2;
        Long l2 = this.getId(systemEnvironment);
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
        Long l3 = sDMSUser.getDefaultGId(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "03402291216"));
        }
        Integer n = this.getType(systemEnvironment);
        SDMSScope sDMSScope = n == 1 ? SDMSScopeTable.table.create(systemEnvironment, string, l3, l, this.getType(systemEnvironment), null, null, null, null, null, null, null, null, SDMSConstants.iZERO, null, null, null, null, this.getInheritPrivs(systemEnvironment)) : SDMSScopeTable.table.create(systemEnvironment, string, l3, l, this.getType(systemEnvironment), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.getIsEnabled(systemEnvironment), Boolean.FALSE, SDMSConstants.S_NOMINAL, this.getPasswd(systemEnvironment), this.getSalt(systemEnvironment), this.getMethod(systemEnvironment), null, this.getNode(systemEnvironment), null, null, this.getInheritPrivs(systemEnvironment));
        Long l4 = sDMSScope.getId(systemEnvironment);
        Vector vector = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, l2);
        for (Object object2 : vector) {
            ((SDMSScope)object2).internalCopy(systemEnvironment, l4, ((SDMSScopeProxyGeneric)object2).getName(systemEnvironment), hashMap, hashMap2);
        }
        object2 = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l2);
        Iterator iterator = ((Vector)object2).iterator();
        while (iterator.hasNext()) {
            SDMSResource sDMSResource = (SDMSResource)iterator.next();
            SDMSResource sDMSResource2 = SDMSResourceTable.table.create(systemEnvironment, sDMSResource.getNrId(systemEnvironment), l4, null, l3, null, null, null, sDMSResource.getRsdId(systemEnvironment), null, sDMSResource.getDefinedAmount(systemEnvironment), sDMSResource.getRequestableAmount(systemEnvironment), sDMSResource.getDefinedAmount(systemEnvironment), sDMSResource.getDefinedAmount(systemEnvironment), sDMSResource.getIsOnline(systemEnvironment), sDMSResource.getFactor(systemEnvironment), sDMSResource.getTraceInterval(systemEnvironment), sDMSResource.getTraceBase(systemEnvironment), sDMSResource.getTraceBaseMultiplier(systemEnvironment), SDMSConstants.fZERO, SDMSConstants.fZERO, SDMSConstants.fZERO, SDMSConstants.fZERO, SDMSConstants.lZERO, SDMSConstants.lZERO);
            hashMap.put(sDMSResource.getId(systemEnvironment), sDMSResource2.getId(systemEnvironment));
        }
        ScopeConfig.copy(systemEnvironment, l2, l4);
        ScopeParameter.copy(systemEnvironment, l2, l4);
        if (n == 2) {
            SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSScope, 1);
        }
        return sDMSScope;
    }

    private UserConnection getConnection(SystemEnvironment systemEnvironment) throws SDMSException {
        ThreadGroup threadGroup = SystemEnvironment.utg;
        Thread[] threadArray = new SDMSThread[threadGroup.activeCount()];
        int n = threadGroup.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            ConnectionEnvironment connectionEnvironment;
            UserConnection userConnection;
            if (threadArray[i] instanceof ListenThread || !(userConnection = (UserConnection)threadArray[i]).iAmAlive() || (connectionEnvironment = userConnection.getEnv()) == null || connectionEnvironment.uid() == null || !connectionEnvironment.uid().equals(this.getId(systemEnvironment))) continue;
            return userConnection;
        }
        return null;
    }

    public boolean isConnected(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 2) {
            return this.getConnection(systemEnvironment) != null;
        }
        return false;
    }

    public int getConnectionId(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 2) {
            UserConnection userConnection = this.getConnection(systemEnvironment);
            if (userConnection != null) {
                return userConnection.id();
            }
            return -1;
        }
        return -1;
    }

    public long getIdle(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 2) {
            UserConnection userConnection = this.getConnection(systemEnvironment);
            if (userConnection != null) {
                ConnectionEnvironment connectionEnvironment = userConnection.getEnv();
                return connectionEnvironment.idle();
            }
            Long l = this.getLastActive(systemEnvironment);
            if (l == null) {
                return systemEnvironment.cEnv.last() / 1000L;
            }
            return (systemEnvironment.cEnv.last() - l + 500L) / 1000L;
        }
        return 0L;
    }

    @Override
    public void setIsRegistered(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl.equals(this.getIsRegistered(systemEnvironment))) {
            return;
        }
        super.setIsRegistered(systemEnvironment, bl);
        SystemEnvironment.sched.notifyChange(systemEnvironment, this, bl != false ? 4 : 5);
    }

    @Override
    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l.equals(this.getOwnerId(systemEnvironment))) {
            return;
        }
        super.setOwnerId(systemEnvironment, l);
        SystemEnvironment.sched.notifyChange(systemEnvironment, this, 2);
    }

    public boolean hasActiveJobs(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSSubmittedEntityTable.idx_scopeId.getVector(systemEnvironment, (Object)l, new SDMSFilter(this){

            @Override
            public boolean isValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
                SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
                int n = sDMSSubmittedEntity.getState(systemEnvironment);
                return n != 12 && n != 10 && n != 15;
            }
        }, 2);
        if (vector.size() > 0) {
            return true;
        }
        return SDMSRunnableQueueTable.idx_scopeId.containsKey(systemEnvironment, l);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.delete(systemEnvironment, false);
    }

    public void delete(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        this.myDelete(systemEnvironment, bl);
    }

    public void myDelete(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        Vector vector;
        Long l = this.getId(systemEnvironment);
        if (bl) {
            int n;
            Vector vector2 = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, l);
            for (n = 0; n < vector2.size(); ++n) {
                ((SDMSScope)vector2.get(n)).myDelete(systemEnvironment, bl);
            }
            vector = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l);
            for (n = 0; n < vector.size(); ++n) {
                SDMSResource sDMSResource = (SDMSResource)vector.get(n);
                sDMSResource.delete(systemEnvironment);
            }
        }
        if ((vector = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l)).size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603181720", "Scope not empty (contains resources)"));
        }
        vector = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, l);
        if (vector.size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201301041", "Scope not empty (contains subscopes)"));
        }
        vector = SDMSSubmittedEntityTable.idx_scopeId.getVector(systemEnvironment, l);
        if (vector.size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202231053", "Scope $1 contains Jobs", this.pathString(systemEnvironment)));
        }
        if (this.isConnected(systemEnvironment)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209162133", "Server still connected"));
        }
        ScopeConfig.kill(systemEnvironment, this);
        ScopeParameter.kill(systemEnvironment, this.getId(systemEnvironment));
        if (this.getType(systemEnvironment) == 2) {
            vector = SDMSUserEquivTable.idx_altUId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector.size(); ++i) {
                SDMSUserEquiv sDMSUserEquiv = (SDMSUserEquiv)vector.get(i);
                sDMSUserEquiv.delete(systemEnvironment);
            }
            SystemEnvironment.sched.notifyChange(systemEnvironment, this, 3);
        }
        super.delete(systemEnvironment);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, boolean bl) throws SDMSException {
        return SVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, -1L, bl);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, long l, boolean bl) throws SDMSException {
        return SVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, l, bl);
    }

    @Override
    public long addImplicitPrivs(long l) {
        if (((l = super.addImplicitPrivs(l)) & 0x100L) != 0L) {
            l |= 8L;
        }
        return l;
    }

    public boolean canExecute(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        SDMSPrivilege sDMSPrivilege = null;
        HashSet<Long> hashSet = new HashSet<Long>();
        Long l = sDMSSubmittedEntity.getOwnerId(systemEnvironment);
        hashSet.add(l);
        hashSet.add(SDMSObject.publicGId);
        systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
        try {
            sDMSPrivilege = new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x100000000L, true, null));
        }
        finally {
            systemEnvironment.cEnv.popGid(systemEnvironment);
        }
        return sDMSPrivilege.can(0x100000000L);
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pathString(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 1) {
            return "scope " + this.getURLName(systemEnvironment);
        }
        return "jobserver " + this.getURLName(systemEnvironment);
    }

    @Override
    public String getSubtypeName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getTypeAsString(systemEnvironment);
    }

    public void notify(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getType(systemEnvironment) == 2) {
            int n;
            InetAddress inetAddress;
            String string = ScopeConfig.getItem(systemEnvironment, this, "NOTIFYPORT");
            if (string == null) {
                return;
            }
            UserConnection userConnection = this.getConnection(systemEnvironment);
            if (userConnection == null) {
                var5_6 = ScopeConfig.getItem(systemEnvironment, this, "HTTPHOST");
                if (var5_6 == null || ((String)var5_6).equals("")) {
                    return;
                }
                try {
                    inetAddress = InetAddress.getByName((String)var5_6);
                }
                catch (Exception exception) {
                    return;
                }
            } else {
                var5_6 = userConnection.getEnv();
                inetAddress = ((ConnectionEnvironment)var5_6).getAddress();
            }
            if (inetAddress == null) {
                return;
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            byte[] byArray = this.getId(systemEnvironment).toString().getBytes();
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 0, byArray.length, inetAddress, n);
                if (SystemEnvironment.notifySocket == null) {
                    SystemEnvironment.notifySocket = new DatagramSocket();
                }
                SystemEnvironment.notifySocket.send(datagramPacket);
            }
            catch (Exception exception) {
                System.out.println("Something went wrong : " + exception.toString());
            }
        } else {
            Vector vector = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
            for (int i = 0; i < vector.size(); ++i) {
                SDMSScope sDMSScope = (SDMSScope)vector.get(i);
                sDMSScope.notify(systemEnvironment);
            }
        }
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if (systemEnvironment.cEnv.isUser() && this.getParentId(systemEnvironment) == null) {
            l2 |= 0x10000000L;
        }
        return l2 & l;
    }
}

