/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSScopeConfig;
import de.independit.scheduler.server.repository.SDMSScopeConfigGeneric;
import de.independit.scheduler.server.repository.SDMSScopeConfigTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSScopeConfigTableGeneric
extends SDMSTable {
    public static final String tableName = "SCOPE_CONFIG";
    public static SDMSScopeConfigTable table = null;
    public static final String[] columnNames = new String[]{"ID", "KEY", "VALUE", "S_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_sId;
    public static SDMSIndex idx_scopeId_key;

    public SDMSScopeConfigTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ScopeConfig"));
        }
        table = (SDMSScopeConfigTable)this;
        table = (SDMSScopeConfigTable)this;
        this.isVersioned = false;
        idx_sId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "sId");
        idx_scopeId_key = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "scopeId_key");
    }

    public SDMSScopeConfig create(SystemEnvironment systemEnvironment, String string, String string2, Long l) throws SDMSException {
        SDMSScopeConfig sDMSScopeConfig;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ScopeConfig"));
        }
        this.validate(systemEnvironment, string, string2, l, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSScopeConfigGeneric sDMSScopeConfigGeneric = new SDMSScopeConfigGeneric(systemEnvironment, string, string2, l, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSScopeConfigGeneric.versions, true);
            table.put(systemEnvironment, sDMSScopeConfigGeneric.id, sDMSScopeConfigGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSScopeConfig = (SDMSScopeConfig)sDMSScopeConfigGeneric.toProxy(systemEnvironment);
            sDMSScopeConfig.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSScopeConfig sDMSScopeConfig2 = (SDMSScopeConfig)sDMSScopeConfigGeneric.toProxy(systemEnvironment);
            sDMSScopeConfig2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSScopeConfig)) {
            throw new AccessViolationException(sDMSScopeConfig.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSScopeConfig.touchMaster(systemEnvironment);
        return sDMSScopeConfig;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSScopeConfig sDMSScopeConfig) throws SDMSException {
        return sDMSScopeConfig.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, String string2, Long l, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        String string;
        String string2;
        Long l8;
        try {
            l8 = resultSet.getLong(1);
            string2 = resultSet.getString(2);
            string = resultSet.getString(3);
            l7 = resultSet.getLong(4);
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ScopeConfig: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSScopeConfigGeneric(l8, string2, string, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "KEY" + string2 + ", " + string + "VALUE" + string2 + ", " + string + "S_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2);
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_sId.check(((SDMSScopeConfigGeneric)sDMSObject).sId, sDMSObject);
        object = (String)object + "idx_sId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScopeConfigGeneric)sDMSObject).sId);
        sDMSKey.add((Comparable)((Object)((SDMSScopeConfigGeneric)sDMSObject).key));
        bl = idx_scopeId_key.check(sDMSKey, sDMSObject);
        object = (String)object + "idx_scopeId_key: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_sId.put(systemEnvironment, ((SDMSScopeConfigGeneric)sDMSObject).sId, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScopeConfigGeneric)sDMSObject).sId);
        sDMSKey.add((Comparable)((Object)((SDMSScopeConfigGeneric)sDMSObject).key));
        idx_scopeId_key.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_sId.remove(systemEnvironment, ((SDMSScopeConfigGeneric)sDMSObject).sId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScopeConfigGeneric)sDMSObject).sId);
        sDMSKey.add((Comparable)((Object)((SDMSScopeConfigGeneric)sDMSObject).key));
        idx_scopeId_key.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSScopeConfig getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSScopeConfig)table.get(systemEnvironment, l);
    }

    public static SDMSScopeConfig getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSScopeConfig)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSScopeConfig getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSScopeConfig)table.get(systemEnvironment, l, l2);
    }

    public static SDMSScopeConfig idx_scopeId_key_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSScopeConfig)idx_scopeId_key.getUnique(systemEnvironment, object);
    }

    public static SDMSScopeConfig idx_scopeId_key_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSScopeConfig)idx_scopeId_key.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSScopeConfig idx_scopeId_key_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSScopeConfig)idx_scopeId_key.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

