/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSVersions;
import de.independit.scheduler.server.util.SDMSFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class SDMSTable {
    public static final String __version = "@(#) $Id: SDMSTable.java,v 2.15.2.1 2013/03/14 10:25:26 ronald Exp $";
    private HashMap hashMap = null;
    protected boolean hashMapTrace = false;
    protected int tableIndex;
    protected boolean isVersioned;
    public static final String STAT_ID_COUNT = "ID_COUNT";
    public static final String STAT_VERSION_COUNT = "VERSION_COUNT";
    public static final String STAT_LOW_VERSION = "LOW_VERSION";
    public static final String STAT_MAX_VERSIONS = "MAX_VERSIONS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hashMapRemove(Object object) {
        if (this.hashMapTrace) {
            System.out.println(this.tableName() + ":hashMapRemove(" + String.valueOf(object) + ")");
        }
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            this.hashMap.remove(object);
        }
    }

    protected SDMSTable(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.hashMap != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110251129", "Tried to initialize table twice"));
        }
        this.hashMap = new HashMap();
        this.isVersioned = true;
        this.tableIndex = SDMSRepository.getTableIndex();
    }

    public Iterator iterator(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.iterator(systemEnvironment, null, false);
    }

    public Iterator iteratorForUpdate(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.iterator(systemEnvironment, null, false);
    }

    public Iterator iterator(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        return this.iterator(systemEnvironment, null, bl);
    }

    public Iterator iteratorForUpdate(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.iterator(systemEnvironment, null, bl);
    }

    public Iterator iterator(SystemEnvironment systemEnvironment, SDMSFilter sDMSFilter) throws SDMSException {
        return this.iterator(systemEnvironment, sDMSFilter, false);
    }

    public Iterator iteratorForUpdate(SystemEnvironment systemEnvironment, SDMSFilter sDMSFilter) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.iterator(systemEnvironment, sDMSFilter, false);
    }

    public Iterator iteratorForUpdate(SystemEnvironment systemEnvironment, SDMSFilter sDMSFilter, boolean bl) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.iterator(systemEnvironment, sDMSFilter, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(SystemEnvironment systemEnvironment, SDMSFilter sDMSFilter, boolean bl) throws SDMSException {
        Object[] objectArray;
        int n = systemEnvironment.thread.readLock;
        systemEnvironment.thread.readLock = 0;
        Vector<SDMSProxy> vector = new Vector<SDMSProxy>();
        SDMSProxy sDMSProxy = null;
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            objectArray = this.hashMap.values().toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            SDMSObject sDMSObject;
            SDMSVersions sDMSVersions = (SDMSVersions)objectArray[i];
            if (systemEnvironment.tx.mode == 2) {
                if (SystemEnvironment.maxWriter > 1 && !bl) {
                    LockingSystem.lock(systemEnvironment, sDMSVersions, n);
                }
            }
            if ((sDMSObject = sDMSVersions.getRaw(systemEnvironment, bl)) == null) continue;
            if (sDMSProxy == null) {
                sDMSProxy = sDMSObject.toProxy(systemEnvironment);
                sDMSProxy.current = true;
            } else {
                sDMSProxy.object = sDMSObject;
            }
            if (sDMSFilter != null && !sDMSFilter.isValid(systemEnvironment, sDMSProxy)) continue;
            vector.add(sDMSProxy);
            sDMSProxy = null;
        }
        return vector.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rawSize() {
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            return this.hashMap.size();
        }
    }

    public void clearTableUnlocked(SystemEnvironment systemEnvironment) throws SDMSException {
        Iterator iterator = this.iterator(systemEnvironment, true);
        while (iterator.hasNext()) {
            SDMSProxy sDMSProxy = (SDMSProxy)iterator.next();
            sDMSProxy.delete(systemEnvironment);
        }
    }

    protected abstract void loadTable(SystemEnvironment var1) throws SQLException, SDMSException;

    protected abstract SDMSObject rowToObject(SystemEnvironment var1, ResultSet var2) throws SDMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        SDMSVersions sDMSVersions;
        SDMSObject sDMSObject = this.rowToObject(systemEnvironment, resultSet);
        if (sDMSObject == null) {
            return false;
        }
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            sDMSVersions = (SDMSVersions)this.hashMap.get(sDMSObject.id);
        }
        if (sDMSVersions == null) {
            sDMSVersions = new SDMSVersions(this, sDMSObject.id);
            hashMap = this.hashMap;
            synchronized (hashMap) {
                this.hashMap.put(sDMSObject.id, sDMSVersions);
            }
        }
        sDMSObject.versions = sDMSVersions;
        sDMSVersions.add(systemEnvironment, sDMSObject);
        try {
            this.index(systemEnvironment, sDMSObject);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181537", "Duplicate id during load Object"));
        }
        if (this.getIsVersioned() && ((l = (long)sDMSVersions.versions.size()) > 1L || l == 1L && ((SDMSObject)sDMSVersions.versions.lastElement()).validTo != Long.MAX_VALUE)) {
            systemEnvironment.vPurgeSet.add(systemEnvironment, sDMSVersions);
        }
        return true;
    }

    protected void remove(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        throw new FatalException(new SDMSMessage(systemEnvironment, "02110271229", "cannot remove id from an SDMSTables hashMap"));
    }

    public abstract String tableName();

    public abstract String[] columnNames();

    public abstract String checkIndex(SDMSObject var1) throws SDMSException;

    protected abstract void index(SystemEnvironment var1, SDMSObject var2) throws SDMSException;

    protected abstract void index(SystemEnvironment var1, SDMSObject var2, long var3) throws SDMSException;

    protected abstract void unIndex(SystemEnvironment var1, SDMSObject var2) throws SDMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDMSProxy get(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSVersions sDMSVersions;
        int n = systemEnvironment.thread.readLock;
        systemEnvironment.thread.readLock = 0;
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            sDMSVersions = (SDMSVersions)this.hashMap.get(l);
        }
        if (sDMSVersions == null) {
            throw new NotFoundException(new SDMSMessage(systemEnvironment, "03110251037", "Key $1 not found (" + this.getClass().getName() + ")", l));
        }
        if (systemEnvironment.tx.mode == 2) {
            if (SystemEnvironment.maxWriter > 1) {
                LockingSystem.lock(systemEnvironment, sDMSVersions, n);
            }
        }
        SDMSProxy sDMSProxy = sDMSVersions.get(systemEnvironment).toProxy(systemEnvironment);
        sDMSProxy.current = true;
        return sDMSProxy;
    }

    public SDMSProxy getForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.get(systemEnvironment, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDMSVersions getVersions(Long l) {
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            return (SDMSVersions)this.hashMap.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Long l) {
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            return this.hashMap.containsKey(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDMSProxy get(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        SDMSVersions sDMSVersions;
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            sDMSVersions = (SDMSVersions)this.hashMap.get(l);
        }
        if (sDMSVersions == null) {
            throw new NotFoundException(new SDMSMessage(systemEnvironment, "03110251039", "Key $1 not found", l));
        }
        return sDMSVersions.get(systemEnvironment, l2).toProxy(systemEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSVersions sDMSVersions;
        int n = systemEnvironment.thread.readLock;
        systemEnvironment.thread.readLock = 0;
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            sDMSVersions = (SDMSVersions)this.hashMap.get(l);
        }
        if (sDMSVersions == null) {
            return false;
        }
        if (systemEnvironment.tx.mode == 2) {
            if (SystemEnvironment.maxWriter > 1) {
                LockingSystem.lock(systemEnvironment, sDMSVersions, n);
            }
        }
        return sDMSVersions.getRaw(systemEnvironment, false) != null;
    }

    public boolean existsForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        systemEnvironment.thread.readLock = 1;
        return this.exists(systemEnvironment, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(SystemEnvironment systemEnvironment, Long l, SDMSVersions sDMSVersions) throws SDMSException {
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            if (this.hashMapTrace) {
                System.out.println(this.tableName() + ":hashMap.put(" + l + ")");
            }
            this.hashMap.put(l, sDMSVersions);
        }
        try {
            this.index(systemEnvironment, (SDMSObject)sDMSVersions.o_v.getLast());
        }
        catch (SDMSException sDMSException) {
            HashMap hashMap2 = this.hashMap;
            synchronized (hashMap2) {
                this.hashMapRemove(l);
            }
            throw sDMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(SystemEnvironment systemEnvironment) throws SDMSException {
        HashMap hashMap = this.hashMap;
        synchronized (hashMap) {
            for (SDMSVersions sDMSVersions : this.hashMap.values()) {
                sDMSVersions.dump();
            }
        }
    }

    public boolean getIsVersioned() {
        return this.isVersioned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap stat(SystemEnvironment systemEnvironment) throws SDMSException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        long l = Long.MAX_VALUE;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        HashMap hashMap2 = this.hashMap;
        synchronized (hashMap2) {
            Iterator iterator = this.hashMap.values().iterator();
            while (iterator.hasNext()) {
                long l5;
                ++l2;
                SDMSVersions sDMSVersions = (SDMSVersions)iterator.next();
                HashMap hashMap3 = sDMSVersions.stat(systemEnvironment);
                long l6 = (Long)hashMap3.get(STAT_VERSION_COUNT);
                l4 += l6;
                if (l6 > l3) {
                    l3 = l6;
                }
                if ((l5 = ((Long)hashMap3.get(STAT_LOW_VERSION)).longValue()) >= l) continue;
                l = l5;
            }
        }
        hashMap.put(STAT_ID_COUNT, l2);
        hashMap.put(STAT_VERSION_COUNT, l4);
        hashMap.put(STAT_LOW_VERSION, l);
        hashMap.put(STAT_MAX_VERSIONS, l3);
        return hashMap;
    }
}

