/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NonRecoverableException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.SubmitJob;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSTriggerParameter;
import de.independit.scheduler.server.repository.SDMSTriggerParameterProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerQueue;
import de.independit.scheduler.server.repository.SDMSTriggerQueueTable;
import de.independit.scheduler.server.repository.SDMSTriggerState;
import de.independit.scheduler.server.repository.SDMSTriggerStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.util.BoolExpr;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SDMSTrigger
extends SDMSTriggerProxyGeneric {
    public static final String __version = "@(#) $Id: SDMSTrigger.java,v 2.42.2.4 2013/03/22 14:01:55 dieter Exp $";
    private static final HashMap mapper = new HashMap();

    protected SDMSTrigger(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public static Integer map(Integer n) {
        return (Integer)mapper.get(n);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSTriggerState sDMSTriggerState = (SDMSTriggerState)vector.get(i);
            sDMSTriggerState.delete(systemEnvironment);
        }
        Vector vector2 = SDMSTriggerParameterTable.idx_triggerId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSTriggerParameter sDMSTriggerParameter = (SDMSTriggerParameter)vector2.get(i);
            sDMSTriggerParameter.delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    public boolean checkCondition(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSTriggerQueue sDMSTriggerQueue) throws SDMSException {
        return this.checkCondition(systemEnvironment, null, sDMSSubmittedEntity, sDMSTriggerQueue);
    }

    public boolean checkCondition(SystemEnvironment systemEnvironment, SDMSResource sDMSResource) throws SDMSException {
        return this.checkCondition(systemEnvironment, sDMSResource, null, null);
    }

    private boolean checkCondition(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSTriggerQueue sDMSTriggerQueue) throws SDMSException {
        String string = this.getCondition(systemEnvironment);
        if (string == null) {
            return true;
        }
        BoolExpr boolExpr = new BoolExpr(string);
        return boolExpr.checkCondition(systemEnvironment, sDMSResource, sDMSSubmittedEntity, sDMSSubmittedEntity, this, sDMSTriggerQueue, null);
    }

    public void checkConditionSyntax(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.getCondition(systemEnvironment);
        if (string == null) {
            return;
        }
        BoolExpr boolExpr = new BoolExpr(string);
        boolExpr.checkConditionSyntax(systemEnvironment);
    }

    public String checkParameterExpressionSyntax(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string == null) {
            return null;
        }
        BoolExpr boolExpr = new BoolExpr(string);
        try {
            boolExpr.checkConditionSyntax(systemEnvironment);
        }
        catch (Exception exception) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public String evalExpression(SystemEnvironment systemEnvironment, String string, SDMSResource sDMSResource, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSTriggerQueue sDMSTriggerQueue) throws SDMSException {
        if (string == null || string.equals("")) {
            return "";
        }
        BoolExpr boolExpr = new BoolExpr(string);
        Object object = boolExpr.evalExpression(systemEnvironment, sDMSResource, sDMSSubmittedEntity, sDMSSubmittedEntity, this, sDMSTriggerQueue, null);
        return object.toString();
    }

    public boolean trigger(SystemEnvironment systemEnvironment, Long l, Long l2, SDMSTriggerQueue sDMSTriggerQueue, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Long l3;
        Comparable<Date> comparable;
        Number number;
        Long l4;
        SDMSProxy sDMSProxy;
        Object object;
        if (!this.getIsActive(systemEnvironment).booleanValue()) {
            return false;
        }
        if (sDMSSubmittedEntity.getIsDisabled(systemEnvironment).booleanValue()) {
            return false;
        }
        long l5 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        boolean bl = false;
        Long l6 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        Long l7 = sDMSSubmittedEntity.getId(systemEnvironment);
        int n = this.getType(systemEnvironment);
        Long l8 = this.getId(systemEnvironment);
        long l9 = System.currentTimeMillis();
        int n2 = this.getAction(systemEnvironment);
        HashSet<Object> hashSet = (HashSet<Object>)systemEnvironment.tx.txData.get("TRIGGER_HASH_SET");
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            systemEnvironment.tx.txData.put("TRIGGER_HASH_SET", hashSet);
        }
        boolean bl2 = this.getIsMaster(systemEnvironment);
        Long l10 = null;
        Vector vector = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, (Object)l8, l5);
        if (vector.size() > 0) {
            object = vector.iterator();
            boolean bl3 = false;
            while (object.hasNext()) {
                sDMSProxy = (SDMSTriggerState)object.next();
                if (!((SDMSTriggerStateProxyGeneric)sDMSProxy).getToStateId(systemEnvironment).equals(l)) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                return bl;
            }
        }
        if (n == 4 && !hashSet.add(object = new SDMSKey(l2, l7, l8))) {
            return bl;
        }
        if (n == 5 || n == 6) {
            if (sDMSTriggerQueue == null) {
                sDMSTriggerQueue = SDMSTriggerQueueTable.idx_smeId_trId_getUnique(systemEnvironment, new SDMSKey(l7, l8));
            }
            long l11 = this.getCheckAmount(systemEnvironment).longValue();
            int n3 = this.getCheckBase(systemEnvironment);
            switch (n3) {
                case 0: {
                    l11 *= 60000L;
                    break;
                }
                case 1: {
                    l11 *= 3600000L;
                    break;
                }
                case 2: {
                    l11 *= 86400000L;
                    break;
                }
                case 3: {
                    l11 *= 604800000L;
                }
            }
            sDMSTriggerQueue.setNextTriggerTime(systemEnvironment, l9 + l11);
        }
        int n4 = 0;
        if (n != 3) {
            if (n == 5 || n == 6) {
                n4 = sDMSTriggerQueue.getTimesTriggered(systemEnvironment);
            } else if (n2 != 1) {
                Vector vector2 = SDMSSubmittedEntityTable.idx_fireSmeId_trId.getVector(systemEnvironment, new SDMSKey(l7, l8));
                n4 = vector2.size();
            } else {
                n4 = sDMSSubmittedEntity.getRerunSeq(systemEnvironment);
            }
        } else if (!bl2) {
            sDMSProxy = sDMSSubmittedEntity;
            l4 = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getFireSmeId(systemEnvironment);
            number = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getTrId(systemEnvironment);
            while (l4 != null && l8.equals(number)) {
                ++n4;
                sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, l4);
                l4 = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getFireSmeId(systemEnvironment);
                number = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getTrId(systemEnvironment);
            }
        } else {
            n4 = 0;
        }
        int n5 = this.getMaxRetry(systemEnvironment);
        if (n2 != 1 || !this.getIsSuspend(systemEnvironment).booleanValue()) {
            if (n5 == 0) {
                n5 = SystemEnvironment.triggerSoftLimit;
            }
            if (n5 > SystemEnvironment.triggerHardLimit) {
                n5 = SystemEnvironment.triggerHardLimit;
            }
        }
        if (n4 >= n5 && n5 != 0) {
            l4 = this.getLimitState(systemEnvironment);
            if (l4 != null) {
                SDMSExitState sDMSExitState;
                number = sDMSSubmittedEntity.getSeId(systemEnvironment);
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, number, l5);
                Long l12 = sDMSSchedulingEntity.getEspId(systemEnvironment);
                try {
                    sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l12, l4), l5);
                }
                catch (NotFoundException notFoundException) {
                    SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l4);
                    String string = "The limit state " + sDMSExitStateDefinition.getName(systemEnvironment) + " of trigger " + this.getName(systemEnvironment) + " isn't contained in the job's exit state profile";
                    HashSet<Long> hashSet2 = (HashSet<Long>)systemEnvironment.tx.txData.get("TRIGGER_BROKEN_ESD_ID");
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<Long>();
                        systemEnvironment.tx.txData.put("TRIGGER_BROKEN_ESD_ID", hashSet2);
                    }
                    hashSet2.add(sDMSSubmittedEntity.getId(systemEnvironment));
                    sDMSSubmittedEntity.setToError(systemEnvironment, string);
                    SDMSThread.doTrace(systemEnvironment.cEnv, "Definition error in job definition " + sDMSSchedulingEntity.pathString(systemEnvironment) + ": " + string, 1);
                    return bl;
                }
                sDMSSubmittedEntity.changeState(systemEnvironment, l4, sDMSExitState, null, null, null, false);
            }
            return bl;
        }
        boolean bl4 = false;
        try {
            bl4 = this.checkCondition(systemEnvironment, sDMSSubmittedEntity, sDMSTriggerQueue);
        }
        catch (CommonErrorException commonErrorException) {
            comparable = new Date();
            l3 = comparable.getTime();
            boolean bl5 = true;
        }
        if (sDMSTriggerQueue != null) {
            sDMSTriggerQueue.setTimesChecked(systemEnvironment, sDMSTriggerQueue.getTimesChecked(systemEnvironment) + 1);
        }
        if (bl4) {
            number = n4 + 1;
            if (n2 == 0) {
                SDMSSubmittedEntity sDMSSubmittedEntity2 = this.triggerSubmit(systemEnvironment, sDMSSubmittedEntity, (Integer)number, n);
                if (sDMSSubmittedEntity2 == null) {
                    return bl;
                }
                bl = true;
                comparable = (Long)systemEnvironment.tx.txData.get("BASE_SME_ID");
                if (comparable == null) {
                    comparable = l2;
                }
                sDMSSubmittedEntity2.setBaseSmeId(systemEnvironment, (Long)comparable);
                sDMSSubmittedEntity2.setReasonSmeId(systemEnvironment, l2);
                sDMSSubmittedEntity2.setFireSmeId(systemEnvironment, l7);
                sDMSSubmittedEntity2.setFireSeId(systemEnvironment, l6);
                sDMSSubmittedEntity2.setTrId(systemEnvironment, l8);
                sDMSSubmittedEntity2.setTrSdIdNew(systemEnvironment, l);
                sDMSSubmittedEntity2.setTrSeq(systemEnvironment, (Integer)number);
                sDMSSubmittedEntity2.setWarnLink(systemEnvironment, l10);
                if (sDMSTriggerQueue != null) {
                    sDMSTriggerQueue.setTimesTriggered(systemEnvironment, (Integer)number);
                }
                l3 = null;
                if (this.getIsSuspend(systemEnvironment).booleanValue()) {
                    Long l13 = sDMSSubmittedEntity2.getSubmitTs(systemEnvironment);
                    l3 = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), l13, true, sDMSSubmittedEntity2.getEffectiveTimeZone(systemEnvironment));
                    sDMSSubmittedEntity2.setResumeTs(systemEnvironment, l3);
                }
            } else {
                sDMSSubmittedEntity.rerun(systemEnvironment);
                comparable = null;
                if (this.getIsSuspend(systemEnvironment).booleanValue()) {
                    sDMSSubmittedEntity.suspend(systemEnvironment, true, false);
                    l3 = sDMSSubmittedEntity.getFinishTs(systemEnvironment);
                    comparable = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), l3, true, sDMSSubmittedEntity.getEffectiveTimeZone(systemEnvironment));
                    sDMSSubmittedEntity.setResumeTs(systemEnvironment, (Long)comparable);
                }
            }
        }
        return bl;
    }

    public SDMSSubmittedEntity triggerSubmit(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Integer n, int n2) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity2;
        Serializable serializable;
        SDMSSchedulingEntity sDMSSchedulingEntity;
        Date date = new Date();
        Long l = date.getTime();
        Long l2 = this.getId(systemEnvironment);
        SDMSSubmittedEntity sDMSSubmittedEntity3 = null;
        Long l3 = this.getSeId(systemEnvironment);
        Long l4 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        long l5 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        boolean bl = this.getIsMaster(systemEnvironment);
        String string = null;
        HashSet<Long> hashSet = (HashSet<Long>)systemEnvironment.tx.txData.get("MASTERTRIGGER_HASHSET");
        if (hashSet == null) {
            hashSet = new HashSet<Long>();
            systemEnvironment.tx.txData.put("MASTERTRIGGER_HASHSET", hashSet);
        }
        if (bl) {
            try {
                sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3);
            }
            catch (NotFoundException notFoundException) {
                return null;
            }
        } else {
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3, l5);
            boolean bl2 = false;
            bl2 = true;
            if (n2 == 3) {
                serializable = sDMSSubmittedEntity.getParentId(systemEnvironment);
                if (serializable == null) {
                    return null;
                }
                sDMSSubmittedEntity3 = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getParentId(systemEnvironment));
            } else {
                sDMSSubmittedEntity3 = sDMSSubmittedEntity;
            }
            string = sDMSSubmittedEntity.getId(systemEnvironment).toString() + "." + this.getId(systemEnvironment).toString() + ":" + n.toString();
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            Comparable comparable;
            Object object;
            Object object2;
            Comparable comparable2;
            if (!hashSet.add(l2)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03305141915", "Cannot fire Trigger $1 recursively in same Transaction", this.getName(systemEnvironment)));
            }
            Vector<Comparable> vector = new Vector<Comparable>();
            serializable = SDMSTriggerParameterTable.idx_triggerId.getVector(systemEnvironment, (Object)l2, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
            Iterator iterator = ((Vector)serializable).iterator();
            while (iterator.hasNext()) {
                comparable2 = (SDMSTriggerParameter)iterator.next();
                object2 = ((SDMSTriggerParameter)comparable2).getExpression(systemEnvironment);
                object = this.evalExpression(systemEnvironment, (String)object2, null, sDMSSubmittedEntity, null);
                comparable = new WithItem((Comparable)((Object)((SDMSTriggerParameterProxyGeneric)comparable2).getName(systemEnvironment)), object);
                vector.add(comparable);
            }
            comparable2 = this.getIsSuspend(systemEnvironment);
            object2 = !((Boolean)comparable2).booleanValue() ? null : SDMSConstants.SME_SUSPEND;
            if (bl) {
                object = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l5);
                comparable = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getMasterId(systemEnvironment));
                sDMSSubmittedEntity2 = sDMSSchedulingEntity.submitMaster(systemEnvironment, vector, (Integer)object2, null, this.getSubmitOwnerId(systemEnvironment), SDMSConstants.iZERO, "Triggered by " + ((SDMSSchedulingEntity)object).pathString(systemEnvironment, l5) + "(" + this.getName(systemEnvironment) + "), Job " + sDMSSubmittedEntity.getId(systemEnvironment).toString(), ((SDMSSubmittedEntityProxyGeneric)comparable).getTimeZone(systemEnvironment));
            } else {
                object = null;
                if (l3.equals(l4)) {
                    object = sDMSSubmittedEntity.getId(systemEnvironment);
                }
                boolean bl3 = n2 == 3;
                sDMSSubmittedEntity2 = sDMSSubmittedEntity3.submitChild(systemEnvironment, vector, (Integer)object2, null, l3, string, (Long)object, null, bl3, true);
            }
            sDMSSubmittedEntity2.setBaseSmeId(systemEnvironment, (Long)systemEnvironment.tx.txData.get("BASE_SME_ID"));
        }
        catch (NonRecoverableException nonRecoverableException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            if (!nonRecoverableException.errNumber().equals("03305141915") && bl) {
                sDMSSchedulingEntity.createErrorMaster(systemEnvironment, this.getSubmitOwnerId(systemEnvironment), "Triggered by " + sDMSSubmittedEntity.getId(systemEnvironment).toString() + "(" + this.getName(systemEnvironment) + ")", nonRecoverableException.toString());
            }
            sDMSSubmittedEntity2 = null;
        }
        if (sDMSSubmittedEntity2 != null) {
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        hashSet.remove(l2);
        return sDMSSubmittedEntity2;
    }

    public void trigger(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, Long l, Long l2, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Comparable comparable;
        if (!this.getIsActive(systemEnvironment).booleanValue()) {
            return;
        }
        Long l3 = null;
        Long l4 = null;
        if (sDMSSubmittedEntity != null) {
            l3 = sDMSSubmittedEntity.getId(systemEnvironment);
            l4 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        }
        Vector vector = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, this.getId(systemEnvironment));
        boolean bl = false;
        if (vector.size() == 0) {
            bl = true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            comparable = (SDMSTriggerState)vector.get(i);
            Long l5 = comparable.getFromStateId(systemEnvironment);
            Long l6 = comparable.getToStateId(systemEnvironment);
            if (l5 != null && !l5.equals(l) || l6 != null && !l6.equals(l2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            try {
                bl = this.checkCondition(systemEnvironment, sDMSResource);
            }
            catch (CommonErrorException commonErrorException) {
                bl = false;
            }
        }
        if (bl) {
            Comparable comparable2;
            SDMSSubmittedEntityProxyGeneric sDMSSubmittedEntityProxyGeneric = null;
            systemEnvironment.tx.beginSubTransaction(systemEnvironment);
            try {
                comparable2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment));
                sDMSSubmittedEntityProxyGeneric = comparable2.submitMaster(systemEnvironment, null, this.getIsSuspend(systemEnvironment) != false ? SDMSConstants.SME_SUSPEND : SDMSConstants.SME_NOSUSPEND, null, this.getSubmitOwnerId(systemEnvironment), SDMSConstants.iZERO, "Triggered by Resource " + sDMSResource.getId(systemEnvironment).toString() + "(" + this.getName(systemEnvironment) + ")", null);
            }
            catch (NonRecoverableException nonRecoverableException) {
                systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            }
            if (sDMSSubmittedEntityProxyGeneric != null) {
                systemEnvironment.tx.commitSubTransaction(systemEnvironment);
                sDMSSubmittedEntityProxyGeneric.setBaseSmeId(systemEnvironment, l3);
                sDMSSubmittedEntityProxyGeneric.setReasonSmeId(systemEnvironment, l3);
                sDMSSubmittedEntityProxyGeneric.setFireSmeId(systemEnvironment, l3);
                sDMSSubmittedEntityProxyGeneric.setFireSeId(systemEnvironment, l4);
                sDMSSubmittedEntityProxyGeneric.setTrId(systemEnvironment, this.getId(systemEnvironment));
                sDMSSubmittedEntityProxyGeneric.setTrSdIdOld(systemEnvironment, l);
                sDMSSubmittedEntityProxyGeneric.setTrSdIdNew(systemEnvironment, l2);
                sDMSSubmittedEntityProxyGeneric.setTrSeq(systemEnvironment, SDMSConstants.iZERO);
                comparable2 = null;
                if (this.getIsSuspend(systemEnvironment).booleanValue()) {
                    comparable = sDMSSubmittedEntityProxyGeneric.getSubmitTs(systemEnvironment);
                    comparable2 = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), (Long)comparable, true, ((SDMSSubmittedEntity)sDMSSubmittedEntityProxyGeneric).getEffectiveTimeZone(systemEnvironment));
                    ((SDMSSubmittedEntity)sDMSSubmittedEntityProxyGeneric).setResumeTs(systemEnvironment, (Long)comparable2);
                }
            }
        }
    }

    private void updateTriggeredSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        sDMSSubmittedEntity.setBaseSmeId(systemEnvironment, null);
        sDMSSubmittedEntity.setReasonSmeId(systemEnvironment, null);
        sDMSSubmittedEntity.setFireSmeId(systemEnvironment, null);
        sDMSSubmittedEntity.setFireSeId(systemEnvironment, null);
        sDMSSubmittedEntity.setTrId(systemEnvironment, this.getId(systemEnvironment));
        sDMSSubmittedEntity.setTrSdIdOld(systemEnvironment, null);
        sDMSSubmittedEntity.setTrSdIdNew(systemEnvironment, null);
        sDMSSubmittedEntity.setTrSeq(systemEnvironment, SDMSConstants.iZERO);
        Long l = null;
        if (this.getIsSuspend(systemEnvironment).booleanValue()) {
            Long l2 = sDMSSubmittedEntity.getSubmitTs(systemEnvironment);
            l = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), l2, true, sDMSSubmittedEntity.getEffectiveTimeZone(systemEnvironment));
            sDMSSubmittedEntity.setResumeTs(systemEnvironment, l);
        }
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy = null;
        int n = this.getObjectType(systemEnvironment);
        switch (n) {
            case 0: {
                sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getFireId(systemEnvironment));
                break;
            }
            case 2: {
                sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, this.getFireId(systemEnvironment));
                break;
            }
            case 1: {
                sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, this.getFireId(systemEnvironment));
                break;
            }
            default: {
                throw new FatalException(new SDMSMessage(systemEnvironment, "0330603241133", "Unknown Objecttype in Trigger $1", this.getName(systemEnvironment)));
            }
        }
        return this.getName(systemEnvironment) + " on " + sDMSProxy.getURL(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "trigger " + this.getURLName(systemEnvironment);
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l2 = 0L;
        l2 = l;
        int n = this.getObjectType(systemEnvironment);
        boolean bl2 = false;
        switch (n) {
            case 0: {
                boolean bl3 = this.getIsInverse(systemEnvironment);
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, bl3 ? this.getSeId(systemEnvironment) : this.getFireId(systemEnvironment));
                    long l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l3 & 0x100L) == 256L) {
                        l3 |= 0x10000011L;
                    }
                    l2 &= l3;
                    bl2 = true;
                }
                catch (NotFoundException notFoundException) {
                    l2 = 0L;
                }
                break;
            }
            case 1: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESSOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    long l4 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l4 & 0x100L) == 256L) {
                        l4 |= 0x10000011L;
                    }
                    l2 &= l4;
                    bl2 = true;
                }
                catch (NotFoundException notFoundException) {
                    l2 = 0L;
                }
                break;
            }
            case 2: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    long l5 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l5 & 0x100L) == 256L) {
                        l5 |= 0x10000011L;
                    }
                    l2 &= l5;
                    bl2 = true;
                    break;
                }
                catch (NotFoundException notFoundException) {
                    l2 = 0L;
                }
            }
        }
        if (!bl2) {
            if (systemEnvironment.tx.mode == 1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03809050935", "Orphan Trigger found, as ADMIN use 'drop trigger $1' to solve this problem", this.getId(systemEnvironment).toString()));
            }
            if (systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                l2 = l;
            }
        }
        return l2;
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l3 = 0L;
        int n = this.getObjectType(systemEnvironment);
        l3 = l;
        switch (n) {
            case 0: {
                boolean bl2 = this.getIsInverse(systemEnvironment);
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, bl2 ? this.getSeId(systemEnvironment) : this.getFireId(systemEnvironment), l2);
                    long l4 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l4 & 0x100L) == 256L) {
                        l4 |= 0x10000011L;
                    }
                    l3 &= l4;
                }
                catch (NotFoundException notFoundException) {
                    l3 = 0L;
                }
                break;
            }
            case 1: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESSOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment), l2);
                    long l5 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l5 & 0x100L) == 256L) {
                        l5 |= 0x10000011L;
                    }
                    l3 &= l5;
                }
                catch (NotFoundException notFoundException) {
                    l3 = 0L;
                }
                break;
            }
            case 2: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment), l2);
                    long l6 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l6 & 0x100L) == 256L) {
                        l6 |= 0x10000011L;
                    }
                    l3 &= l6;
                    break;
                }
                catch (NotFoundException notFoundException) {
                    l3 = 0L;
                }
            }
        }
        return l3;
    }

    @Override
    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = this.getObjectType(systemEnvironment);
        switch (n) {
            case 0: {
                boolean bl = this.getIsInverse(systemEnvironment);
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, bl ? this.getSeId(systemEnvironment) : this.getFireId(systemEnvironment));
                    sDMSProxy.touch(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {}
                break;
            }
            case 1: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESSOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    sDMSProxy.touch(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {}
                break;
            }
            case 2: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    sDMSProxy.touch(systemEnvironment);
                    break;
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        mapper.put(405, SDMSConstants.TR_IMMEDIATE_LOCAL);
        mapper.put(406, SDMSConstants.TR_IMMEDIATE_MERGE);
        mapper.put(285, SDMSConstants.TR_BEFORE_FINAL);
        mapper.put(265, SDMSConstants.TR_AFTER_FINAL);
        mapper.put(380, SDMSConstants.TR_FINISH_CHILD);
        mapper.put(625, SDMSConstants.TR_UNTIL_FINISHED);
        mapper.put(624, SDMSConstants.TR_UNTIL_FINAL);
        mapper.put(635, SDMSConstants.TR_WARNING);
        mapper.put(320, SDMSConstants.TR_CREATE);
        mapper.put(299, SDMSConstants.TR_CHANGE);
        mapper.put(329, SDMSConstants.TR_DELETE);
    }
}

