/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSTriggerGeneric
extends SDMSObject
implements Cloneable {
    public static final int JOB_DEFINITION = 0;
    public static final int RESOURCE = 1;
    public static final int NAMED_RESOURCE = 2;
    public static final int OBJECT_MONITOR = 3;
    public static final int CREATE = 0;
    public static final int CHANGE = 1;
    public static final int DELETE = 2;
    public static final int SUBMIT = 0;
    public static final int RERUN = 1;
    public static final int IMMEDIATE_LOCAL = 0;
    public static final int IMMEDIATE_MERGE = 1;
    public static final int BEFORE_FINAL = 2;
    public static final int AFTER_FINAL = 3;
    public static final int FINISH_CHILD = 4;
    public static final int UNTIL_FINISHED = 5;
    public static final int UNTIL_FINAL = 6;
    public static final int WARNING = 7;
    public static final boolean MASTER = true;
    public static final boolean NOMASTER = false;
    public static final boolean SUSPEND = true;
    public static final boolean NOSUSPEND = false;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_fireId = 3;
    public static final int nr_objectType = 4;
    public static final int nr_seId = 5;
    public static final int nr_mainSeId = 6;
    public static final int nr_parentSeId = 7;
    public static final int nr_isActive = 8;
    public static final int nr_isInverse = 9;
    public static final int nr_action = 10;
    public static final int nr_type = 11;
    public static final int nr_isMaster = 12;
    public static final int nr_isSuspend = 13;
    public static final int nr_isCreate = 14;
    public static final int nr_isChange = 15;
    public static final int nr_isDelete = 16;
    public static final int nr_isGroup = 17;
    public static final int nr_resumeAt = 18;
    public static final int nr_resumeIn = 19;
    public static final int nr_resumeBase = 20;
    public static final int nr_isWarnOnLimit = 21;
    public static final int nr_limitState = 22;
    public static final int nr_maxRetry = 23;
    public static final int nr_submitOwnerId = 24;
    public static final int nr_condition = 25;
    public static final int nr_checkAmount = 26;
    public static final int nr_checkBase = 27;
    public static final int nr_creatorUId = 28;
    public static final int nr_createTs = 29;
    public static final int nr_changerUId = 30;
    public static final int nr_changeTs = 31;
    public static String tableName = "TRIGGER_DEFINITION";
    protected String name;
    protected Long fireId;
    protected Integer objectType;
    protected Long seId;
    protected Long mainSeId;
    protected Long parentSeId;
    protected Boolean isActive;
    protected Boolean isInverse;
    protected Integer action;
    protected Integer type;
    protected Boolean isMaster;
    protected Boolean isSuspend;
    protected Boolean isCreate;
    protected Boolean isChange;
    protected Boolean isDelete;
    protected Boolean isGroup;
    protected String resumeAt;
    protected Integer resumeIn;
    protected Integer resumeBase;
    protected Boolean isWarnOnLimit;
    protected Long limitState;
    protected Integer maxRetry;
    protected Long submitOwnerId;
    protected String condition;
    protected Integer checkAmount;
    protected Integer checkBase;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSTriggerGeneric(SystemEnvironment systemEnvironment, String string, Long l, Integer n, Long l2, Long l3, Long l4, Boolean bl, Boolean bl2, Integer n2, Integer n3, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Boolean bl7, Boolean bl8, String string2, Integer n4, Integer n5, Boolean bl9, Long l5, Integer n6, Long l6, String string3, Integer n7, Integer n8, Long l7, Long l8, Long l9, Long l10) throws SDMSException {
        super(systemEnvironment, SDMSTriggerTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Trigger) Length of $1 exceeds maximum length $2", "name", "64"));
        }
        this.name = string;
        this.fireId = l;
        this.objectType = n;
        this.seId = l2;
        this.mainSeId = l3;
        this.parentSeId = l4;
        this.isActive = bl;
        this.isInverse = bl2;
        this.action = n2;
        this.type = n3;
        this.isMaster = bl3;
        this.isSuspend = bl4;
        this.isCreate = bl5;
        this.isChange = bl6;
        this.isDelete = bl7;
        this.isGroup = bl8;
        if (string2 != null && string2.length() > 20) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Trigger) Length of $1 exceeds maximum length $2", "resumeAt", "20"));
        }
        this.resumeAt = string2;
        this.resumeIn = n4;
        this.resumeBase = n5;
        this.isWarnOnLimit = bl9;
        this.limitState = l5;
        this.maxRetry = n6;
        this.submitOwnerId = l6;
        if (string3 != null && string3.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Trigger) Length of $1 exceeds maximum length $2", "condition", "1024"));
        }
        this.condition = string3;
        this.checkAmount = n7;
        this.checkBase = n8;
        this.creatorUId = l7;
        this.createTs = l8;
        this.changerUId = l9;
        this.changeTs = l10;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
            }
            SDMSTriggerGeneric sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Trigger) Length of $1 exceeds maximum length $2", "name", "64"));
            }
            sDMSTriggerGeneric.name = string;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 448L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getFireId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.fireId;
    }

    public void setFireId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.fireId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
            }
            SDMSTriggerGeneric sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.fireId = l;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 353L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getObjectType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.objectType;
    }

    public String getObjectTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getObjectType(systemEnvironment);
        switch (n) {
            case 0: {
                return "JOB_DEFINITION";
            }
            case 1: {
                return "RESOURCE";
            }
            case 2: {
                return "NAMED_RESOURCE";
            }
            case 3: {
                return "OBJECT_MONITOR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Trigger.objectType: $1", this.getObjectType(systemEnvironment)));
    }

    public void setObjectType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.objectType.equals(n)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.objectType = n;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seId;
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
            }
            SDMSTriggerGeneric sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.seId = l;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 386L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getMainSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.mainSeId;
    }

    public void setMainSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.mainSeId)) {
            return;
        }
        if (l == null && this.mainSeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
            }
            SDMSTriggerGeneric sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.mainSeId = l;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getParentSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.parentSeId;
    }

    public void setParentSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.parentSeId)) {
            return;
        }
        if (l == null && this.parentSeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
            }
            SDMSTriggerGeneric sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.parentSeId = l;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getIsActive(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isActive;
    }

    public void setIsActive(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isActive.equals(bl)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.isActive = bl;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Boolean getIsInverse(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isInverse;
    }

    public void setIsInverse(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isInverse.equals(bl)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
            }
            SDMSTriggerGeneric sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.isInverse = bl;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 256L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getAction(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.action;
    }

    public String getActionAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getAction(systemEnvironment);
        switch (n) {
            case 0: {
                return "SUBMIT";
            }
            case 1: {
                return "RERUN";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Trigger.action: $1", this.getAction(systemEnvironment)));
    }

    public void setAction(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.action.equals(n)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.action = n;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Integer getType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.type;
    }

    public String getTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getType(systemEnvironment);
        switch (n) {
            case 0: {
                return "IMMEDIATE_LOCAL";
            }
            case 2: {
                return "BEFORE_FINAL";
            }
            case 3: {
                return "AFTER_FINAL";
            }
            case 1: {
                return "IMMEDIATE_MERGE";
            }
            case 4: {
                return "FINISH_CHILD";
            }
            case 5: {
                return "UNTIL_FINISHED";
            }
            case 6: {
                return "UNTIL_FINAL";
            }
            case 7: {
                return "WARNING";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Trigger.type: $1", this.getType(systemEnvironment)));
    }

    public void setType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.type.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
            }
            SDMSTriggerGeneric sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.type = n;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 32L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getIsMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isMaster;
    }

    public String getIsMasterAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getIsMaster(systemEnvironment);
        boolean bl2 = bl;
        if (bl2) {
            return "MASTER";
        }
        if (!bl2) {
            return "NOMASTER";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Trigger.isMaster: $1", this.getIsMaster(systemEnvironment)));
    }

    public void setIsMaster(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isMaster.equals(bl)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.isMaster = bl;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Boolean getIsSuspend(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isSuspend;
    }

    public String getIsSuspendAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getIsSuspend(systemEnvironment);
        boolean bl2 = bl;
        if (bl2) {
            return "SUSPEND";
        }
        if (!bl2) {
            return "NOSUSPEND";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Trigger.isSuspend: $1", this.getIsSuspend(systemEnvironment)));
    }

    public void setIsSuspend(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isSuspend.equals(bl)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.isSuspend = bl;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Boolean getIsCreate(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isCreate;
    }

    public void setIsCreate(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isCreate)) {
            return;
        }
        if (bl == null && this.isCreate == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.isCreate = bl;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Boolean getIsChange(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isChange;
    }

    public void setIsChange(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isChange)) {
            return;
        }
        if (bl == null && this.isChange == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.isChange = bl;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Boolean getIsDelete(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isDelete;
    }

    public void setIsDelete(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isDelete)) {
            return;
        }
        if (bl == null && this.isDelete == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.isDelete = bl;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Boolean getIsGroup(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isGroup;
    }

    public void setIsGroup(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isGroup)) {
            return;
        }
        if (bl == null && this.isGroup == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.isGroup = bl;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public String getResumeAt(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeAt;
    }

    public void setResumeAt(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.resumeAt)) {
            return;
        }
        if (string == null && this.resumeAt == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 20) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Trigger) Length of $1 exceeds maximum length $2", "resumeAt", "20"));
        }
        sDMSTriggerGeneric.resumeAt = string;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Integer getResumeIn(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeIn;
    }

    public void setResumeIn(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.resumeIn)) {
            return;
        }
        if (n == null && this.resumeIn == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.resumeIn = n;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Integer getResumeBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resumeBase;
    }

    public String getResumeBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getResumeBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Trigger.resumeBase: $1", this.getResumeBase(systemEnvironment)));
    }

    public void setResumeBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.resumeBase)) {
            return;
        }
        if (n == null && this.resumeBase == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.resumeBase = n;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Boolean getIsWarnOnLimit(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isWarnOnLimit;
    }

    public void setIsWarnOnLimit(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isWarnOnLimit.equals(bl)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.isWarnOnLimit = bl;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Long getLimitState(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.limitState;
    }

    public void setLimitState(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.limitState)) {
            return;
        }
        if (l == null && this.limitState == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.limitState = l;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Integer getMaxRetry(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.maxRetry;
    }

    public void setMaxRetry(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.maxRetry.equals(n)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.maxRetry = n;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Long getSubmitOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.submitOwnerId;
    }

    public void setSubmitOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.submitOwnerId)) {
            return;
        }
        if (l == null && this.submitOwnerId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
            }
            SDMSTriggerGeneric sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.submitOwnerId = l;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 16L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getCondition(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.condition;
    }

    public void setCondition(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.condition)) {
            return;
        }
        if (string == null && this.condition == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Trigger) Length of $1 exceeds maximum length $2", "condition", "1024"));
        }
        sDMSTriggerGeneric.condition = string;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Integer getCheckAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.checkAmount;
    }

    public void setCheckAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.checkAmount)) {
            return;
        }
        if (n == null && this.checkAmount == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.checkAmount = n;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Integer getCheckBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.checkBase;
    }

    public String getCheckBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getCheckBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Trigger.checkBase: $1", this.getCheckBase(systemEnvironment)));
    }

    public void setCheckBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.checkBase)) {
            return;
        }
        if (n == null && this.checkBase == null) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.checkBase = n;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.creatorUId = l;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Trigger) Change of system object not allowed"));
        }
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.createTs = l;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.changerUId = l;
        sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSTriggerGeneric sDMSTriggerGeneric = this;
        if (sDMSTriggerGeneric.versions.o_v == null || sDMSTriggerGeneric.versions.o_v.size() == 0 || sDMSTriggerGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerGeneric.changeTs = l;
        sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSTriggerGeneric != this) {
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric, 0L);
        }
    }

    public SDMSTriggerGeneric set_FireIdType(SystemEnvironment systemEnvironment, Long l, Integer n) throws SDMSException {
        SDMSTriggerGeneric sDMSTriggerGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Trigger) Change of system object not allowed"));
            }
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.fireId = l;
            sDMSTriggerGeneric.type = n;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSTriggerGeneric;
    }

    public SDMSTriggerGeneric set_FireIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSTriggerGeneric sDMSTriggerGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Trigger) Change of system object not allowed"));
            }
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.fireId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290025", "(Trigger) Length of $1 exceeds maximum length $2", "changeTs", "64"));
            }
            sDMSTriggerGeneric.name = string;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSTriggerGeneric;
    }

    public SDMSTriggerGeneric set_SeIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSTriggerGeneric sDMSTriggerGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Trigger) Change of system object not allowed"));
            }
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.seId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290025", "(Trigger) Length of $1 exceeds maximum length $2", "changeTs", "64"));
            }
            sDMSTriggerGeneric.name = string;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSTriggerGeneric;
    }

    public SDMSTriggerGeneric set_FireIdSeIdNameIsInverse(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Boolean bl) throws SDMSException {
        SDMSTriggerGeneric sDMSTriggerGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Trigger) Change of system object not allowed"));
            }
            sDMSTriggerGeneric = (SDMSTriggerGeneric)this.change(systemEnvironment);
            sDMSTriggerGeneric.fireId = l;
            sDMSTriggerGeneric.seId = l2;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290025", "(Trigger) Length of $1 exceeds maximum length $2", "changeTs", "64"));
            }
            sDMSTriggerGeneric.name = string;
            sDMSTriggerGeneric.isInverse = bl;
            sDMSTriggerGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerGeneric.versions.table.index(systemEnvironment, sDMSTriggerGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSTriggerGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSTrigger(this);
    }

    protected SDMSTriggerGeneric(Long l, String string, Long l2, Integer n, Long l3, Long l4, Long l5, Boolean bl, Boolean bl2, Integer n2, Integer n3, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Boolean bl7, Boolean bl8, String string2, Integer n4, Integer n5, Boolean bl9, Long l6, Integer n6, Long l7, String string3, Integer n7, Integer n8, Long l8, Long l9, Long l10, Long l11, long l12, long l13) {
        this.id = l;
        this.name = string;
        this.fireId = l2;
        this.objectType = n;
        this.seId = l3;
        this.mainSeId = l4;
        this.parentSeId = l5;
        this.isActive = bl;
        this.isInverse = bl2;
        this.action = n2;
        this.type = n3;
        this.isMaster = bl3;
        this.isSuspend = bl4;
        this.isCreate = bl5;
        this.isChange = bl6;
        this.isDelete = bl7;
        this.isGroup = bl8;
        this.resumeAt = string2;
        this.resumeIn = n4;
        this.resumeBase = n5;
        this.isWarnOnLimit = bl9;
        this.limitState = l6;
        this.maxRetry = n6;
        this.submitOwnerId = l7;
        this.condition = string3;
        this.checkAmount = n7;
        this.checkBase = n8;
        this.creatorUId = l8;
        this.createTs = l9;
        this.changerUId = l10;
        this.changeTs = l11;
        this.validFrom = l12;
        this.validTo = l13;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = SystemEnvironment.SQUOTE;
                String string2 = SystemEnvironment.EQUOTE;
                object = "INSERT INTO " + string + "TRIGGER_DEFINITION" + string2 + " (ID, " + string + "NAME" + string2 + ", " + string + "FIRE_ID" + string2 + ", " + string + "OBJECT_TYPE" + string2 + ", " + string + "SE_ID" + string2 + ", " + string + "MAIN_SE_ID" + string2 + ", " + string + "PARENT_SE_ID" + string2 + ", " + string + "IS_ACTIVE" + string2 + ", " + string + "IS_INVERSE" + string2 + ", " + string + "ACTION" + string2 + ", " + string + "TYPE" + string2 + ", " + string + "IS_MASTER" + string2 + ", " + string + "IS_SUSPEND" + string2 + ", " + string + "IS_CREATE" + string2 + ", " + string + "IS_CHANGE" + string2 + ", " + string + "IS_DELETE" + string2 + ", " + string + "IS_GROUP" + string2 + ", " + string + "RESUME_AT" + string2 + ", " + string + "RESUME_IN" + string2 + ", " + string + "RESUME_BASE" + string2 + ", " + string + "IS_WARN_ON_LIMIT" + string2 + ", " + string + "LIMIT_STATE" + string2 + ", " + string + "MAX_RETRY" + string2 + ", " + string + "SUBMIT_OWNER_ID" + string2 + ", " + string + "CONDITION" + string2 + ", " + string + "CHECK_AMOUNT" + string2 + ", " + string + "CHECK_BASE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSTriggerGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Trigger: $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.fireId);
            preparedStatement.setInt(4, this.objectType);
            preparedStatement.setLong(5, this.seId);
            if (this.mainSeId == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.mainSeId);
            }
            if (this.parentSeId == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setLong(7, this.parentSeId);
            }
            preparedStatement.setInt(8, this.isActive != false ? 1 : 0);
            preparedStatement.setInt(9, this.isInverse != false ? 1 : 0);
            preparedStatement.setInt(10, this.action);
            preparedStatement.setInt(11, this.type);
            preparedStatement.setInt(12, this.isMaster != false ? 1 : 0);
            preparedStatement.setInt(13, this.isSuspend != false ? 1 : 0);
            if (this.isCreate == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setInt(14, this.isCreate != false ? 1 : 0);
            }
            if (this.isChange == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setInt(15, this.isChange != false ? 1 : 0);
            }
            if (this.isDelete == null) {
                preparedStatement.setNull(16, 4);
            } else {
                preparedStatement.setInt(16, this.isDelete != false ? 1 : 0);
            }
            if (this.isGroup == null) {
                preparedStatement.setNull(17, 4);
            } else {
                preparedStatement.setInt(17, this.isGroup != false ? 1 : 0);
            }
            if (this.resumeAt == null) {
                preparedStatement.setNull(18, 12);
            } else {
                preparedStatement.setString(18, this.resumeAt);
            }
            if (this.resumeIn == null) {
                preparedStatement.setNull(19, 4);
            } else {
                preparedStatement.setInt(19, this.resumeIn);
            }
            if (this.resumeBase == null) {
                preparedStatement.setNull(20, 4);
            } else {
                preparedStatement.setInt(20, this.resumeBase);
            }
            preparedStatement.setInt(21, this.isWarnOnLimit != false ? 1 : 0);
            if (this.limitState == null) {
                preparedStatement.setNull(22, 4);
            } else {
                preparedStatement.setLong(22, this.limitState);
            }
            preparedStatement.setInt(23, this.maxRetry);
            if (this.submitOwnerId == null) {
                preparedStatement.setNull(24, 4);
            } else {
                preparedStatement.setLong(24, this.submitOwnerId);
            }
            if (this.condition == null) {
                preparedStatement.setNull(25, 12);
            } else {
                preparedStatement.setString(25, this.condition);
            }
            if (this.checkAmount == null) {
                preparedStatement.setNull(26, 4);
            } else {
                preparedStatement.setInt(26, this.checkAmount);
            }
            if (this.checkBase == null) {
                preparedStatement.setNull(27, 4);
            } else {
                preparedStatement.setInt(27, this.checkBase);
            }
            preparedStatement.setLong(28, this.creatorUId);
            preparedStatement.setLong(29, this.createTs);
            preparedStatement.setLong(30, this.changerUId);
            preparedStatement.setLong(31, this.changeTs);
            preparedStatement.setLong(32, systemEnvironment.tx.versionId);
            preparedStatement.setLong(33, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Trigger: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string.startsWith("PostgreSQL");
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                object = "UPDATE " + string2 + "TRIGGER_DEFINITION" + string3 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSTriggerGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "Trigger : $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "Trigger: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkObjectType(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkAction(Integer n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkType(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIsMaster(Boolean bl) {
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    public static boolean checkIsSuspend(Boolean bl) {
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    public static boolean checkResumeBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkCheckBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Trigger", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "fireId : " + this.fireId, 2);
        SDMSThread.doTrace(null, "objectType : " + this.objectType, 2);
        SDMSThread.doTrace(null, "seId : " + this.seId, 2);
        SDMSThread.doTrace(null, "mainSeId : " + this.mainSeId, 2);
        SDMSThread.doTrace(null, "parentSeId : " + this.parentSeId, 2);
        SDMSThread.doTrace(null, "isActive : " + this.isActive, 2);
        SDMSThread.doTrace(null, "isInverse : " + this.isInverse, 2);
        SDMSThread.doTrace(null, "action : " + this.action, 2);
        SDMSThread.doTrace(null, "type : " + this.type, 2);
        SDMSThread.doTrace(null, "isMaster : " + this.isMaster, 2);
        SDMSThread.doTrace(null, "isSuspend : " + this.isSuspend, 2);
        SDMSThread.doTrace(null, "isCreate : " + this.isCreate, 2);
        SDMSThread.doTrace(null, "isChange : " + this.isChange, 2);
        SDMSThread.doTrace(null, "isDelete : " + this.isDelete, 2);
        SDMSThread.doTrace(null, "isGroup : " + this.isGroup, 2);
        SDMSThread.doTrace(null, "resumeAt : " + this.resumeAt, 2);
        SDMSThread.doTrace(null, "resumeIn : " + this.resumeIn, 2);
        SDMSThread.doTrace(null, "resumeBase : " + this.resumeBase, 2);
        SDMSThread.doTrace(null, "isWarnOnLimit : " + this.isWarnOnLimit, 2);
        SDMSThread.doTrace(null, "limitState : " + this.limitState, 2);
        SDMSThread.doTrace(null, "maxRetry : " + this.maxRetry, 2);
        SDMSThread.doTrace(null, "submitOwnerId : " + this.submitOwnerId, 2);
        SDMSThread.doTrace(null, "condition : " + this.condition, 2);
        SDMSThread.doTrace(null, "checkAmount : " + this.checkAmount, 2);
        SDMSThread.doTrace(null, "checkBase : " + this.checkBase, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name          : " + this.name + "\n" + string + "fireId        : " + this.fireId + "\n" + string + "objectType    : " + this.objectType + "\n" + string + "seId          : " + this.seId + "\n" + string + "mainSeId      : " + this.mainSeId + "\n" + string + "parentSeId    : " + this.parentSeId + "\n" + string + "isActive      : " + this.isActive + "\n" + string + "isInverse     : " + this.isInverse + "\n" + string + "action        : " + this.action + "\n" + string + "type          : " + this.type + "\n" + string + "isMaster      : " + this.isMaster + "\n" + string + "isSuspend     : " + this.isSuspend + "\n" + string + "isCreate      : " + this.isCreate + "\n" + string + "isChange      : " + this.isChange + "\n" + string + "isDelete      : " + this.isDelete + "\n" + string + "isGroup       : " + this.isGroup + "\n" + string + "resumeAt      : " + this.resumeAt + "\n" + string + "resumeIn      : " + this.resumeIn + "\n" + string + "resumeBase    : " + this.resumeBase + "\n" + string + "isWarnOnLimit : " + this.isWarnOnLimit + "\n" + string + "limitState    : " + this.limitState + "\n" + string + "maxRetry      : " + this.maxRetry + "\n" + string + "submitOwnerId : " + this.submitOwnerId + "\n" + string + "condition     : " + this.condition + "\n" + string + "checkAmount   : " + this.checkAmount + "\n" + string + "checkBase     : " + this.checkBase + "\n" + string + "creatorUId    : " + this.creatorUId + "\n" + string + "createTs      : " + this.createTs + "\n" + string + "changerUId    : " + this.changerUId + "\n" + string + "changeTs      : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

