/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSTriggerState;
import de.independit.scheduler.server.repository.SDMSTriggerStateTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSTriggerStateGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_triggerId = 2;
    public static final int nr_fromStateId = 3;
    public static final int nr_toStateId = 4;
    public static final int nr_creatorUId = 5;
    public static final int nr_createTs = 6;
    public static final int nr_changerUId = 7;
    public static final int nr_changeTs = 8;
    public static String tableName = "TRIGGER_STATE";
    protected Long triggerId;
    protected Long fromStateId;
    protected Long toStateId;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSTriggerStateGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
        super(systemEnvironment, SDMSTriggerStateTableGeneric.table);
        this.triggerId = l;
        this.fromStateId = l2;
        this.toStateId = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
    }

    public Long getTriggerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.triggerId;
    }

    public void setTriggerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.triggerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(TriggerState) Change of system object not allowed"));
            }
            SDMSTriggerStateGeneric sDMSTriggerStateGeneric = (SDMSTriggerStateGeneric)this.change(systemEnvironment);
            sDMSTriggerStateGeneric.triggerId = l;
            sDMSTriggerStateGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerStateGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerStateGeneric.versions.table.index(systemEnvironment, sDMSTriggerStateGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getFromStateId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.fromStateId;
    }

    public void setFromStateId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.fromStateId)) {
            return;
        }
        if (l == null && this.fromStateId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(TriggerState) Change of system object not allowed"));
            }
            SDMSTriggerStateGeneric sDMSTriggerStateGeneric = (SDMSTriggerStateGeneric)this.change(systemEnvironment);
            sDMSTriggerStateGeneric.fromStateId = l;
            sDMSTriggerStateGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerStateGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerStateGeneric.versions.table.index(systemEnvironment, sDMSTriggerStateGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getToStateId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.toStateId;
    }

    public void setToStateId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.toStateId)) {
            return;
        }
        if (l == null && this.toStateId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(TriggerState) Change of system object not allowed"));
            }
            SDMSTriggerStateGeneric sDMSTriggerStateGeneric = (SDMSTriggerStateGeneric)this.change(systemEnvironment);
            sDMSTriggerStateGeneric.toStateId = l;
            sDMSTriggerStateGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSTriggerStateGeneric.changeTs = systemEnvironment.txTime();
            sDMSTriggerStateGeneric.versions.table.index(systemEnvironment, sDMSTriggerStateGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSTriggerStateGeneric sDMSTriggerStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(TriggerState) Change of system object not allowed"));
        }
        if (sDMSTriggerStateGeneric.versions.o_v == null || sDMSTriggerStateGeneric.versions.o_v.size() == 0 || sDMSTriggerStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerStateGeneric = (SDMSTriggerStateGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerStateGeneric.creatorUId = l;
        sDMSTriggerStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerStateGeneric != this) {
            sDMSTriggerStateGeneric.versions.table.index(systemEnvironment, sDMSTriggerStateGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSTriggerStateGeneric sDMSTriggerStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(TriggerState) Change of system object not allowed"));
        }
        if (sDMSTriggerStateGeneric.versions.o_v == null || sDMSTriggerStateGeneric.versions.o_v.size() == 0 || sDMSTriggerStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerStateGeneric = (SDMSTriggerStateGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerStateGeneric.createTs = l;
        sDMSTriggerStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSTriggerStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerStateGeneric != this) {
            sDMSTriggerStateGeneric.versions.table.index(systemEnvironment, sDMSTriggerStateGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSTriggerStateGeneric sDMSTriggerStateGeneric = this;
        if (sDMSTriggerStateGeneric.versions.o_v == null || sDMSTriggerStateGeneric.versions.o_v.size() == 0 || sDMSTriggerStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerStateGeneric = (SDMSTriggerStateGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerStateGeneric.changerUId = l;
        sDMSTriggerStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSTriggerStateGeneric != this) {
            sDMSTriggerStateGeneric.versions.table.index(systemEnvironment, sDMSTriggerStateGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSTriggerStateGeneric sDMSTriggerStateGeneric = this;
        if (sDMSTriggerStateGeneric.versions.o_v == null || sDMSTriggerStateGeneric.versions.o_v.size() == 0 || sDMSTriggerStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSTriggerStateGeneric = (SDMSTriggerStateGeneric)this.change(systemEnvironment);
        }
        sDMSTriggerStateGeneric.changeTs = l;
        sDMSTriggerStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSTriggerStateGeneric != this) {
            sDMSTriggerStateGeneric.versions.table.index(systemEnvironment, sDMSTriggerStateGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSTriggerState(this);
    }

    protected SDMSTriggerStateGeneric(Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8, long l9, long l10) {
        this.id = l;
        this.triggerId = l2;
        this.fromStateId = l3;
        this.toStateId = l4;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
        this.validFrom = l9;
        this.validTo = l10;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = SystemEnvironment.SQUOTE;
                String string2 = SystemEnvironment.EQUOTE;
                object = "INSERT INTO " + string + "TRIGGER_STATE" + string2 + " (ID, " + string + "TRIGGER_ID" + string2 + ", " + string + "FROM_STATE_ID" + string2 + ", " + string + "TO_STATE_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSTriggerStateGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "TriggerState: $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.triggerId);
            if (this.fromStateId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.fromStateId);
            }
            if (this.toStateId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.toStateId);
            }
            preparedStatement.setLong(5, this.creatorUId);
            preparedStatement.setLong(6, this.createTs);
            preparedStatement.setLong(7, this.changerUId);
            preparedStatement.setLong(8, this.changeTs);
            preparedStatement.setLong(9, systemEnvironment.tx.versionId);
            preparedStatement.setLong(10, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "TriggerState: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string.startsWith("PostgreSQL");
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                object = "UPDATE " + string2 + "TRIGGER_STATE" + string3 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSTriggerStateGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement((String)object);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "TriggerState : $1\n$2", object, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "TriggerState: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : TriggerState", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "triggerId : " + this.triggerId, 2);
        SDMSThread.doTrace(null, "fromStateId : " + this.fromStateId, 2);
        SDMSThread.doTrace(null, "toStateId : " + this.toStateId, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "triggerId   : " + this.triggerId + "\n" + string + "fromStateId : " + this.fromStateId + "\n" + string + "toStateId   : " + this.toStateId + "\n" + string + "creatorUId  : " + this.creatorUId + "\n" + string + "createTs    : " + this.createTs + "\n" + string + "changerUId  : " + this.changerUId + "\n" + string + "changeTs    : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

