/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSTriggerState;
import de.independit.scheduler.server.repository.SDMSTriggerStateGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSTriggerStateTableGeneric
extends SDMSTable {
    public static final String tableName = "TRIGGER_STATE";
    public static SDMSTriggerStateTable table = null;
    public static final String[] columnNames = new String[]{"ID", "TRIGGER_ID", "FROM_STATE_ID", "TO_STATE_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_triggerId;
    public static SDMSIndex idx_fromStateId;
    public static SDMSIndex idx_toStateId;

    public SDMSTriggerStateTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "TriggerState"));
        }
        table = (SDMSTriggerStateTable)this;
        table = (SDMSTriggerStateTable)this;
        this.isVersioned = true;
        idx_triggerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "triggerId");
        idx_fromStateId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "fromStateId");
        idx_toStateId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "toStateId");
    }

    public SDMSTriggerState create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3) throws SDMSException {
        SDMSTriggerState sDMSTriggerState;
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "TriggerState"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, l6, l7);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSTriggerStateGeneric sDMSTriggerStateGeneric = new SDMSTriggerStateGeneric(systemEnvironment, l, l2, l3, l4, l5, l6, l7);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSTriggerStateGeneric.versions, true);
            table.put(systemEnvironment, sDMSTriggerStateGeneric.id, sDMSTriggerStateGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSTriggerState = (SDMSTriggerState)sDMSTriggerStateGeneric.toProxy(systemEnvironment);
            sDMSTriggerState.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSTriggerState sDMSTriggerState2 = (SDMSTriggerState)sDMSTriggerStateGeneric.toProxy(systemEnvironment);
            sDMSTriggerState2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSTriggerState)) {
            throw new AccessViolationException(sDMSTriggerState.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSTriggerState.touchMaster(systemEnvironment);
        return sDMSTriggerState;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSTriggerState sDMSTriggerState) throws SDMSException {
        return sDMSTriggerState.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        Long l10;
        try {
            l10 = resultSet.getLong(1);
            l9 = resultSet.getLong(2);
            l8 = resultSet.getLong(3);
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = resultSet.getLong(4);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = resultSet.getLong(9);
            l = resultSet.getLong(10);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "TriggerState: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSTriggerStateGeneric(l10, l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "TRIGGER_ID" + string2 + ", " + string + "FROM_STATE_ID" + string2 + ", " + string + "TO_STATE_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion));
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        Object object = "";
        boolean bl = idx_triggerId.check(((SDMSTriggerStateGeneric)sDMSObject).triggerId, sDMSObject);
        object = (String)object + "idx_triggerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_fromStateId.check(((SDMSTriggerStateGeneric)sDMSObject).fromStateId, sDMSObject);
        object = (String)object + "idx_fromStateId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_toStateId.check(((SDMSTriggerStateGeneric)sDMSObject).toStateId, sDMSObject);
        object = (String)object + "idx_toStateId: " + (bl ? "ok" : "missing") + "\n";
        return object;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_triggerId.put(systemEnvironment, ((SDMSTriggerStateGeneric)sDMSObject).triggerId, sDMSObject, (1L & l) != 0L);
        idx_fromStateId.put(systemEnvironment, ((SDMSTriggerStateGeneric)sDMSObject).fromStateId, sDMSObject, (2L & l) != 0L);
        idx_toStateId.put(systemEnvironment, ((SDMSTriggerStateGeneric)sDMSObject).toStateId, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_triggerId.remove(systemEnvironment, ((SDMSTriggerStateGeneric)sDMSObject).triggerId, sDMSObject);
        idx_fromStateId.remove(systemEnvironment, ((SDMSTriggerStateGeneric)sDMSObject).fromStateId, sDMSObject);
        idx_toStateId.remove(systemEnvironment, ((SDMSTriggerStateGeneric)sDMSObject).toStateId, sDMSObject);
    }

    public static SDMSTriggerState getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSTriggerState)table.get(systemEnvironment, l);
    }

    public static SDMSTriggerState getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSTriggerState)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSTriggerState getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSTriggerState)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

