/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.util;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.triggerexpr.ExprParser;
import de.independit.scheduler.server.parser.triggerexpr.ExprScanner;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerQueue;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.IOException;
import java.io.StringReader;

public class BoolExpr {
    public static final String __version = "@(#) $Id: BoolExpr.java,v 2.4.8.1 2013/03/14 10:25:28 ronald Exp $";
    final String condition;
    final StringReader sr;
    ExprScanner exprs;
    ExprParser exprp;

    public BoolExpr(String string) {
        this.condition = string;
        this.sr = this.condition != null ? new StringReader(this.condition) : null;
        this.exprs = null;
        this.exprp = null;
    }

    private void initParser(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSubmittedEntity sDMSSubmittedEntity2, SDMSResource sDMSResource, SDMSTrigger sDMSTrigger, SDMSTriggerQueue sDMSTriggerQueue, SDMSScope sDMSScope, boolean bl) throws SDMSException, IOException {
        if (this.exprs == null) {
            this.exprs = new ExprScanner(this.sr);
            this.exprp = new ExprParser();
        } else {
            this.sr.reset();
            this.exprs.yyreset(this.sr);
        }
        this.exprp.set(systemEnvironment, sDMSSubmittedEntity, sDMSSubmittedEntity2, sDMSResource, sDMSTrigger, sDMSTriggerQueue, sDMSScope);
        this.exprp.checkOnly = bl;
    }

    public void checkConditionSyntax(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSMessage sDMSMessage = null;
        if (this.condition == null) {
            return;
        }
        try {
            this.initParser(systemEnvironment, null, null, null, null, null, null, true);
            this.exprp.yyparse(this.exprs);
        }
        catch (Exception exception) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03602151611", "Syntax Error ($1) while parsing '$2'", exception.toString(), this.condition);
        }
        catch (Error error) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03602151612", "Unexpected Error ($1) while parsing '$2'", error.toString(), this.condition);
        }
        if (sDMSMessage != null) {
            throw new CommonErrorException(sDMSMessage);
        }
    }

    public boolean checkCondition(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSubmittedEntity sDMSSubmittedEntity2, SDMSTrigger sDMSTrigger, SDMSTriggerQueue sDMSTriggerQueue, SDMSScope sDMSScope) throws SDMSException {
        boolean bl = false;
        if (this.condition == null) {
            return true;
        }
        Object object = this.evalExpression(systemEnvironment, sDMSResource, sDMSSubmittedEntity, sDMSSubmittedEntity2, sDMSTrigger, sDMSTriggerQueue, sDMSScope);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else {
            String string = "The condition '" + this.condition + "' didn't return a boolean value";
            SDMSThread.doTrace(systemEnvironment.cEnv, string, -1);
            if (sDMSResource != null) {
                SDMSThread.doTrace(systemEnvironment.cEnv, "Id of involved Resource = " + sDMSResource.getId(systemEnvironment), -1);
            }
            if (sDMSSubmittedEntity != null) {
                SDMSThread.doTrace(systemEnvironment.cEnv, "Id of involved Submitted Entity = " + sDMSSubmittedEntity.getId(systemEnvironment), -1);
            }
            if (sDMSTrigger != null) {
                SDMSThread.doTrace(systemEnvironment.cEnv, "Id of involved Trigger = " + sDMSTrigger.getId(systemEnvironment), -1);
            }
            bl = false;
        }
        return bl;
    }

    public Object evalExpression(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSubmittedEntity sDMSSubmittedEntity2, SDMSTrigger sDMSTrigger, SDMSTriggerQueue sDMSTriggerQueue, SDMSScope sDMSScope) throws SDMSException {
        Object object = null;
        SDMSMessage sDMSMessage = null;
        if (this.condition == null) {
            return null;
        }
        try {
            this.initParser(systemEnvironment, sDMSSubmittedEntity, sDMSSubmittedEntity2, sDMSResource, sDMSTrigger, sDMSTriggerQueue, sDMSScope, false);
            object = this.exprp.yyparse(this.exprs);
        }
        catch (IOException iOException) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03506171435", "I/O Error parsing '$1'", this.condition);
        }
        catch (NotFoundException notFoundException) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03506171436", "Error resolving Parameter: $1", notFoundException);
        }
        catch (CommonErrorException commonErrorException) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03506171437", "Error parsing '$1': $2", this.condition, commonErrorException);
        }
        catch (ExprParser.yyException yyException2) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03506171438", "Parse error while parsing '$1'", this.condition);
        }
        catch (Exception exception) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03506171439", "Exception ($1) occurred while calculating '$2'", exception.toString(), this.condition);
        }
        catch (Error error) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03506171440", "Error Exception parsing '$1'", this.condition);
        }
        if (sDMSMessage != null) {
            SDMSThread.doTrace(systemEnvironment.cEnv, sDMSMessage.toString(), 1);
            throw new CommonErrorException(sDMSMessage);
        }
        return object;
    }
}

