/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.shell;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.shell.MiniParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import java.util.Vector;

public class MiniScanner
implements MiniParser.yyInput {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int STRING = 2;
    public static final int COMMENT = 4;
    public static final int FILESPEC = 6;
    public static final int FSSTR = 8;
    public static final int SHELL = 10;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
    private static final String ZZ_CMAP_PACKED = "\b\u0000\u0001\u0006\u0001!\u0001\u0002\u0001\u0004\u0001\u0004\u0001\u0003\u0012\u0000\u0001!\u0001\u001f\u0005\u0000\u0001$\u0001'\u0001(\u0001%\u0002\u0000\u0001\u0005\u0001\u0000\u0001\u0001\n\"\u0001\u0000\u0001)\u0005\u0000\u0001\u001d\u0001\u0012\u0001\n\u0001\u0007\u0001\r\u0001\u0019\u0001\u0018\u0001\u0014\u0001\b\u0001&\u0001\u001e\u0001\u0015\u0001\u0017\u0001\f\u0001\u000b\u0001\u0016\u0001\u0010\u0001\u001c\u0001\t\u0001\u000e\u0001\u0011\u0001\u001b\u0001\u001a\u0001\u000f\u0001\u0013\u0001&\u0001\u0000\u0001#\u0002\u0000\u0001 \u0001\u0000\u0001\u001d\u0001\u0012\u0001\n\u0001\u0007\u0001\r\u0001\u0019\u0001\u0018\u0001\u0014\u0001\b\u0001&\u0001\u001e\u0001\u0015\u0001\u0017\u0001\f\u0001\u000b\u0001\u0016\u0001\u0010\u0001\u001c\u0001\t\u0001\u000e\u0001\u0011\u0001\u001b\u0001\u001a\u0001\u000f\u0001\u0013\u0001&\n\u0000\u0001\u0004\u1fa2\u0000\u0001\u0004\u0001\u0004\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000";
    private static final char[] ZZ_CMAP = MiniScanner.zzUnpackCMap("\b\u0000\u0001\u0006\u0001!\u0001\u0002\u0001\u0004\u0001\u0004\u0001\u0003\u0012\u0000\u0001!\u0001\u001f\u0005\u0000\u0001$\u0001'\u0001(\u0001%\u0002\u0000\u0001\u0005\u0001\u0000\u0001\u0001\n\"\u0001\u0000\u0001)\u0005\u0000\u0001\u001d\u0001\u0012\u0001\n\u0001\u0007\u0001\r\u0001\u0019\u0001\u0018\u0001\u0014\u0001\b\u0001&\u0001\u001e\u0001\u0015\u0001\u0017\u0001\f\u0001\u000b\u0001\u0016\u0001\u0010\u0001\u001c\u0001\t\u0001\u000e\u0001\u0011\u0001\u001b\u0001\u001a\u0001\u000f\u0001\u0013\u0001&\u0001\u0000\u0001#\u0002\u0000\u0001 \u0001\u0000\u0001\u001d\u0001\u0012\u0001\n\u0001\u0007\u0001\r\u0001\u0019\u0001\u0018\u0001\u0014\u0001\b\u0001&\u0001\u001e\u0001\u0015\u0001\u0017\u0001\f\u0001\u000b\u0001\u0016\u0001\u0010\u0001\u001c\u0001\t\u0001\u000e\u0001\u0011\u0001\u001b\u0001\u001a\u0001\u000f\u0001\u0013\u0001&\n\u0000\u0001\u0004\u1fa2\u0000\u0001\u0004\u0001\u0004\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000");
    private static final int[] ZZ_ACTION = MiniScanner.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0006\u0000\u0002\u0001\u0002\u0002\u0001\u0001\u0001\u0002\f\u0001\u0001\u0003\u0001\u0002\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0002\t\u0001\n\u0002\u0002\u0001\u000b\u0004\f\u0001\r\u0002\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0002\u0001\u0012\u000e\u0001\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\t\u0001\u0001\u0018\b\u0001\u0002\u0000\u0003\u0001\u0001\u0019\u0006\u0001\u0003\u0000\u0001\u001a\b\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0001\u001b\u0003\u0001\u0001\u001c\u0001\u0001\u0001\u001d\u0005\u0000\u0003\u0001\u0001\u001e\u0001\u001f\u0003\u0000\u0001 \u0001!\u0001\u0000\u0001\"\u0003\u0000\u0001#\u000b\u0000\u0001$\u0002\u0000\u0001%";
    private static final int[] ZZ_ROWMAP = MiniScanner.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000*\u0000T\u0000~\u0000\u00a8\u0000\u00d2\u0000\u00fc\u0000\u0126\u0000\u0150\u0000\u017a\u0000\u01a4\u0000\u01ce\u0000\u01f8\u0000\u0222\u0000\u024c\u0000\u0276\u0000\u02a0\u0000\u02ca\u0000\u02f4\u0000\u031e\u0000\u0348\u0000\u0372\u0000\u039c\u0000\u03c6\u0000\u03f0\u0000\u041a\u0000\u0444\u0000\u03f0\u0000\u03f0\u0000\u03f0\u0000\u03f0\u0000\u046e\u0000\u0498\u0000\u03f0\u0000\u04c2\u0000\u04ec\u0000\u0516\u0000\u0540\u0000\u056a\u0000\u0594\u0000\u05be\u0000\u03f0\u0000\u05e8\u0000\u0612\u0000\u03f0\u0000\u063c\u0000\u03f0\u0000\u0666\u0000\u03f0\u0000\u0690\u0000\u06ba\u0000\u06e4\u0000\u070e\u0000\u0738\u0000\u0762\u0000\u078c\u0000\u07b6\u0000\u07e0\u0000\u080a\u0000\u0834\u0000\u085e\u0000\u0888\u0000\u08b2\u0000\u03f0\u0000\u03f0\u0000\u03f0\u0000\u03f0\u0000\u03f0\u0000\u08dc\u0000\u0906\u0000\u0930\u0000\u095a\u0000\u0984\u0000\u09ae\u0000\u09d8\u0000\u0a02\u0000\u0a2c\u0000\u024c\u0000\u0a56\u0000\u0a80\u0000\u0aaa\u0000\u0ad4\u0000\u0afe\u0000\u0b28\u0000\u0b52\u0000\u0b7c\u0000\u0ba6\u0000\u0bd0\u0000\u0bfa\u0000\u0c24\u0000\u0c4e\u0000\u024c\u0000\u0c78\u0000\u0ca2\u0000\u0ccc\u0000\u0cf6\u0000\u0d20\u0000\u0d4a\u0000\u0d74\u0000\u0d9e\u0000\u0dc8\u0000\u024c\u0000\u0df2\u0000\u0e1c\u0000\u0e46\u0000\u0e70\u0000\u0e9a\u0000\u0ec4\u0000\u0eee\u0000\u0f18\u0000\u0f42\u0000\u0f6c\u0000\u0f96\u0000\u0fc0\u0000\u0fea\u0000\u024c\u0000\u1014\u0000\u103e\u0000\u1068\u0000\u024c\u0000\u1092\u0000\u03f0\u0000\u10bc\u0000\u10e6\u0000\u1110\u0000\u113a\u0000\u1164\u0000\u118e\u0000\u11b8\u0000\u11e2\u0000\u024c\u0000\u03f0\u0000\u120c\u0000\u1236\u0000\u1260\u0000\u024c\u0000\u024c\u0000\u128a\u0000\u03f0\u0000\u12b4\u0000\u12de\u0000\u1308\u0000\u03f0\u0000\u1332\u0000\u135c\u0000\u1386\u0000\u13b0\u0000\u13da\u0000\u1404\u0000\u142e\u0000\u1458\u0000\u1482\u0000\u14ac\u0000\u14d6\u0000\u03f0\u0000\u1500\u0000\u152a\u0000\u03f0";
    private static final int[] ZZ_TRANS = MiniScanner.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u0007\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0002\u000f\u0001\u0011\u0001\u0012\u0001\u000f\u0001\u0013\u0001\u000f\u0001\u0014\u0001\u000f\u0001\u0015\u0001\u000f\u0001\u0016\u0003\u000f\u0001\u0017\u0001\u000f\u0001\u0018\u0002\u000f\u0001\u0019\u0001\u0007\u0001\u001a\u0001\u001b\u0001\u0007\u0001\u001c\u0001\u0007\u0001\u000f\u0001\u001d\u0001\u001e\u0001\u001f# \u0001!\u0001\"\u0005 %#\u0001$\u0004#\u0002%\u0001&\u0001'\u0002%\u0001(\u001a%\u0001)\u0002%\u0001*\u0005%#+\u0001,\u0001-\u0005+\u0002.\u0002/\u0001\u0000%.\u0001\u0007\u0001\u0000\u0003\u0007\u0001\u0000\u0001\u0007\u0019\u0000\u0001\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0001\u0007\u0005\u0000\u00010#\u0000\u00011\u0004\u0000\u0001\u0007\u0001\u0000\u0002\t\u0001\u0007\u0001\u0000\u0001\u0007\u0019\u0000\u0001\u0007\u0002\u0000\u0001\u0007\u0001\u0000\u0001\u0007\u0004\u0000\u0001\u0007\u0001\u0000\u0001\t\u0001\n\u0001\u0007\u0001\u0000\u0001\f\u0019\u0000\u0001\u0007\u0001\u001a\u0001\u0000\u0001\u0007\u0001\u0000\u0001\u0007\t\u0000\u00010$\u0000\u0001\u0007\u0001\u0000\u0001\u0007\u0001\f\u0001\u0007\u0001\u0000\u0001\f\u0019\u0000\u0001\u0007\u0001\u001a\u0001\u0000\u0001\u0007\u0001\u0000\u0001\u0007\u000b\u0000\u0001\u000f\u00012\u0016\u000f\u0007\u0000\u0001\u000f\n\u0000\u0005\u000f\u00013\u0012\u000f\u0007\u0000\u0001\u000f\n\u0000\u0018\u000f\u0007\u0000\u0001\u000f\n\u0000\u0004\u000f\u00014\u0013\u000f\u0007\u0000\u0001\u000f\n\u0000\u0003\u000f\u00015\u0001\u000f\u00016\u0002\u000f\u00017\f\u000f\u00018\u0002\u000f\u0007\u0000\u0001\u000f\n\u0000\u0001\u000f\u00019\u0016\u000f\u0007\u0000\u0001\u000f\n\u0000\n\u000f\u00017\r\u000f\u0007\u0000\u0001\u000f\n\u0000\u0006\u000f\u0001:\u0005\u000f\u0001;\u000b\u000f\u0007\u0000\u0001\u000f\n\u0000\u0006\u000f\u0001<\u0011\u000f\u0007\u0000\u0001\u000f\n\u0000\u0015\u000f\u0001=\u0002\u000f\u0007\u0000\u0001\u000f\n\u0000\r\u000f\u0001>\n\u000f\u0007\u0000\u0001\u000f\n\u0000\u0004\u000f\u0001?\u0013\u000f\u0007\u0000\u0001\u000f0\u0000\u0001\u001a\u0002\u0000\u0001\u001a\u001a\u0000\u0001\u001a*\u0000\u0001\u001b\u0007\u0000# \u0002\u0000\u0005 #\u0000\u0001@\u0001A\u0005\u0000%#\u0001\u0000\u0004#\u0001\u0000\u0001B(\u0000\u0002%\u0002\u0000\u001d%\u0001\u0000\u0002%\u0001\u0000\u0005%\u0002\u0000\u0002&(\u0000\u0001&\u0001'\u0002\u0000\u0001)\u001a\u0000\u0001)\b\u0000\u0002%\u0001\u0000\u0001)\u0002%\u0001(\u001a%\u0001)\u0002%\u0001\u0000\u0005%\u0003\u0000\u0001)\u0002\u0000\u0001)\u001a\u0000\u0001)\b\u0000#+\u0002\u0000\u0005+#\u0000\u0001C\u0001D\u0005\u0000\u0002.\u0003\u0000%.\u00020\u0003\u0000%0\u0007\u0000\u0002\u000f\u0001E\u0015\u000f\u0007\u0000\u0001\u000f\n\u0000\u0003\u000f\u0001F\u0014\u000f\u0007\u0000\u0001\u000f\n\u0000\u0005\u000f\u0001G\u0012\u000f\u0007\u0000\u0001\u000f\n\u0000\r\u000f\u0001H\n\u000f\u0007\u0000\u0001\u000f\n\u0000\u0001I\u0017\u000f\u0007\u0000\u0001\u000f\n\u0000\u0001\u000f\u0001J\u0016\u000f\u0007\u0000\u0001\u000f\n\u0000\u0015\u000f\u0001K\u0002\u000f\u0007\u0000\u0001\u000f\n\u0000\u0010\u000f\u0001L\u0007\u000f\u0007\u0000\u0001\u000f\n\u0000\u0011\u000f\u0001M\u0006\u000f\u0007\u0000\u0001\u000f\n\u0000\u0006\u000f\u0001N\u0011\u000f\u0007\u0000\u0001\u000f\n\u0000\u000e\u000f\u0001O\t\u000f\u0007\u0000\u0001\u000f\n\u0000\u0004\u000f\u0001P\u0013\u000f\u0007\u0000\u0001\u000f\n\u0000\u0006\u000f\u0001Q\u0011\u000f\u0007\u0000\u0001\u000f\n\u0000\u000e\u000f\u0001R\t\u000f\u0007\u0000\u0001\u000f\n\u0000\u0003\u000f\u0001S\u0014\u000f\u0007\u0000\u0001\u000f\n\u0000\u000e\u000f\u0001T\t\u000f\u0007\u0000\u0001\u000f\n\u0000\u0007\u000f\u0001U\u0010\u000f\u0007\u0000\u0001\u000f\n\u0000\u0004\u000f\u0001V\u0013\u000f\u0007\u0000\u0001\u000f\u0005\u0000\u0002W\u0003\u0000\u0018\u000f\u0001\u0000\u0001X\u0001W\u0004\u0000\u0001\u000f\n\u0000\u0007\u000f\u0001N\u0010\u000f\u0007\u0000\u0001\u000f\n\u0000\u0004\u000f\u0001Y\u0013\u000f\u0007\u0000\u0001\u000f\n\u0000\u0001\u000f\u0001Z\u0016\u000f\u0007\u0000\u0001\u000f\n\u0000\u0001\u000f\u0001[\u0016\u000f\u0007\u0000\u0001\u000f\n\u0000\u000f\u000f\u0001\\\b\u000f\u0007\u0000\u0001\u000f\n\u0000\u0010\u000f\u0001]\u0007\u000f\u0007\u0000\u0001\u000f\n\u0000\u0005\u000f\u0001^\u0012\u000f\u0007\u0000\u0001\u000f\n\u0000\u000e\u000f\u0001_\t\u000f\u0007\u0000\u0001\u000f\n\u0000\u0004\u000f\u0001`\u0013\u000f\u0007\u0000\u0001\u000f\n\u0000\n\u000f\u0001a\r\u000f\u0007\u0000\u0001\u000f\n\u0000\u0001\u000f\u0001b\u0016\u000f\u0007\u0000\u0001\u000f\u0005\u0000\u0002c\u0003\u0000\u0018\u000f\u0001\u0000\u0001d\u0001c\u0004\u0000\u0001\u000f\u0005\u0000\u0002W\u0013\u0000\u0001e\t\u0000\u0001W\u001f\u0000\u0001e\u0019\u0000\u0015\u000f\u0001f\u0002\u000f\u0007\u0000\u0001\u000f\n\u0000\u0005\u000f\u0001g\u0012\u000f\u0007\u0000\u0001\u000f\n\u0000\u0005\u000f\u0001h\u0012\u000f\u0007\u0000\u0001\u000f\n\u0000\u000f\u000f\u0001i\b\u000f\u0007\u0000\u0001\u000f\n\u0000\u0006\u000f\u0001j\u0011\u000f\u0007\u0000\u0001\u000f\n\u0000\u000b\u000f\u0001k\f\u000f\u0007\u0000\u0001\u000f\n\u0000\u0005\u000f\u0001l\u0012\u000f\u0007\u0000\u0001\u000f\n\u0000\u0001m\u0017\u000f\u0007\u0000\u0001\u000f\n\u0000\u0005\u000f\u0001n\u0012\u000f\u0007\u0000\u0001\u000f\u0005\u0000\u0002c\u0007\u0000\u0001o\u0015\u0000\u0001c\u0013\u0000\u0001o/\u0000\u0001p\u001f\u0000\u0011\u000f\u0001q\u0006\u000f\u0007\u0000\u0001\u000f\u0005\u0000\u0002r\u0003\u0000\u0018\u000f\u0001\u0000\u0001s\u0001r\u0004\u0000\u0001\u000f\n\u0000\u0007\u000f\u0001t\u0010\u000f\u0007\u0000\u0001\u000f\n\u0000\u0014\u000f\u0001u\u0003\u000f\u0007\u0000\u0001\u000f\n\u0000\u0016\u000f\u0001v\u0001\u000f\u0007\u0000\u0001\u000f\n\u0000\u0005\u000f\u0001w\u0012\u000f\u0007\u0000\u0001\u000f\n\u0000\u0006\u000f\u0001x\u0011\u000f\u0007\u0000\u0001\u000f\n\u0000\n\u000f\u0001y\r\u000f\u0007\u0000\u0001\u000f\u000f\u0000\u0001z\f\u0000\u0001{%\u0000\u0001|\u0016\u0000\u0002}\u0003\u0000\u0018\u000f\u0001\u0000\u0001~\u0001}\u0004\u0000\u0001\u000f\u0005\u0000\u0002r\u0013\u0000\u0001\u007f\t\u0000\u0001r\u001f\u0000\u0001\u007f\u0019\u0000\u0006\u000f\u0001\u0080\u0011\u000f\u0007\u0000\u0001\u000f\n\u0000\u0003\u000f\u0001\u0081\u0014\u000f\u0007\u0000\u0001\u000f\n\u0000\u0006\u000f\u0001\u0082\u0011\u000f\u0007\u0000\u0001\u000f\n\u0000\u0006\u000f\u0001\u0083\u0011\u000f\u0007\u0000\u0001\u000f\u001c\u0000\u0001\u0084\u001e\u0000\u0001\u0085\u001d\u0000\u0002}\u0007\u0000\u0001\u0086\u0015\u0000\u0001}\u0013\u0000\u0001\u0086/\u0000\u0001\u0087\u001f\u0000\u0015\u000f\u0001\u0088\u0002\u000f\u0007\u0000\u0001\u000f\n\u0000\u0017\u000f\u0001\u0089\u0007\u0000\u0001\u000f\n\u0000\u0003\u000f\u0001J\u0014\u000f\u0007\u0000\u0001\u000f\u000b\u0000\u0001\u008a-\u0000\u0001\u008b\f\u0000\u0001\u008c%\u0000\u0001\u008d\u001e\u0000\u0001\u008e8\u0000\u0001\u008f\u001e\u0000\u0001\u0090&\u0000\u0001\u0091&\u0000\u0001\u00928\u0000\u0001\u0093\u001c\u0000\u0001\u00946\u0000\u0001\u0095\u001d\u0000\u0001\u0096;\u0000\u0001\u0097#\u0000\u0001\u0098\u001e\u0000\u0001\u00994\u0000\u0001\u009a\u0019\u0000\u0001\u009b?\u0000\u0001\u009c\u0018\u0000\u0001\u009d$\u0000\u0001\u009e\"\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = MiniScanner.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0006\u0000\u0012\u0001\u0001\t\u0002\u0001\u0004\t\u0002\u0001\u0001\t\u0007\u0001\u0001\t\u0002\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u000e\u0001\u0005\t\u0012\u0001\u0002\u0000\n\u0001\u0003\u0000\t\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0006\u0001\u0001\t\u0005\u0000\u0004\u0001\u0001\t\u0003\u0000\u0002\u0001\u0001\u0000\u0001\t\u0003\u0000\u0001\t\u000b\u0000\u0001\t\u0002\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;
    private Stack<ZzFlexStreamInfo> zzStreams = new Stack();
    private static boolean debug = false;
    private boolean inStatement = false;
    private boolean inMultiCmd = false;
    private boolean eatSemiColon = false;
    private int token;
    private int pos = 0;
    private int brctr = 0;
    private Object value = new String("");
    private Vector dirStack = new Vector();

    private static int[] zzUnpackAction() {
        int[] nArray = new int[158];
        int n = 0;
        n = MiniScanner.zzUnpackAction(ZZ_ACTION_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAction(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackRowMap() {
        int[] nArray = new int[158];
        int n = 0;
        n = MiniScanner.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackRowMap(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++) << 16;
            nArray[n3++] = n5 | string.charAt(n2++);
        }
        return n3;
    }

    private static int[] zzUnpackTrans() {
        int[] nArray = new int[5460];
        int n = 0;
        n = MiniScanner.zzUnpackTrans(ZZ_TRANS_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackTrans(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            int n6 = string.charAt(n2++);
            do {
                nArray[n3++] = --n6;
            } while (--n5 > 0);
        }
        return n3;
    }

    private static int[] zzUnpackAttribute() {
        int[] nArray = new int[158];
        int n = 0;
        n = MiniScanner.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, n, nArray);
        return nArray;
    }

    private static int zzUnpackAttribute(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    public int yyline() {
        return this.yyline + 1;
    }

    @Override
    public boolean advance() throws IOException {
        this.value = new String("");
        this.token = this.yylex();
        return this.token != -1;
    }

    @Override
    public int token() {
        return this.token;
    }

    @Override
    public Object value() {
        if (this.value instanceof StringBuffer) {
            return this.value.toString();
        }
        return this.value;
    }

    public int pos() {
        return this.pos;
    }

    private void addVal() {
        if (this.value instanceof StringBuffer) {
            ((StringBuffer)this.value).append(this.yytext());
        } else {
            this.value = new StringBuffer(this.value.toString() + this.yytext());
        }
        this.pos += this.yytext().length();
    }

    private void addVal(String string) {
        if (!(this.value instanceof StringBuffer)) {
            this.value = new StringBuffer(this.value.toString());
        }
        ((StringBuffer)this.value).append(string);
        this.pos += string.length();
    }

    private void startInclude(File file) {
        try {
            File file2 = file.getAbsoluteFile().getParentFile();
            this.dirStack.add(file2.getCanonicalPath());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Exception in stack bookkeeping : " + exception.toString());
            Runtime.getRuntime().halt(1);
        }
    }

    private void endInclude() {
        this.dirStack.remove(this.dirStack.size() - 1);
    }

    public MiniScanner(Reader reader) {
        this.zzReader = reader;
    }

    private static char[] zzUnpackCMap(String string) {
        char[] cArray = new char[0x110000];
        int n = 0;
        int n2 = 0;
        while (n < 204) {
            int n3 = string.charAt(n++);
            char c = string.charAt(n++);
            do {
                cArray[n2++] = c;
            } while (--n3 > 0);
        }
        return cArray;
    }

    private boolean zzRefill() throws IOException {
        int n;
        int n2;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] cArray = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, cArray, 0, this.zzBuffer.length);
            this.zzBuffer = cArray;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((n2 = this.zzReader.read(this.zzBuffer, this.zzEndRead, n = this.zzBuffer.length - this.zzEndRead)) == 0) {
            n2 = this.zzReader.read(this.zzBuffer, this.zzEndRead, n);
        }
        if (n2 > 0) {
            this.zzEndRead += n2;
            if (n2 == n && Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                --this.zzEndRead;
                this.zzFinalHighSurrogate = 1;
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yypushStream(Reader reader) {
        this.zzStreams.push(new ZzFlexStreamInfo(this.zzReader, this.zzEndRead, this.zzStartRead, this.zzCurrentPos, this.zzMarkedPos, this.zzBuffer, this.zzAtBOL, this.zzAtEOF, this.zzEOFDone, this.zzFinalHighSurrogate, this.yyline, this.yychar, this.yycolumn));
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzBuffer = new char[16384];
        this.zzReader = reader;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
    }

    public final void yypopStream() throws IOException {
        this.zzReader.close();
        ZzFlexStreamInfo zzFlexStreamInfo = this.zzStreams.pop();
        this.zzBuffer = zzFlexStreamInfo.zzBuffer;
        this.zzReader = zzFlexStreamInfo.zzReader;
        this.zzEndRead = zzFlexStreamInfo.zzEndRead;
        this.zzStartRead = zzFlexStreamInfo.zzStartRead;
        this.zzCurrentPos = zzFlexStreamInfo.zzCurrentPos;
        this.zzMarkedPos = zzFlexStreamInfo.zzMarkedPos;
        this.zzAtBOL = zzFlexStreamInfo.zzAtBOL;
        this.zzAtEOF = zzFlexStreamInfo.zzAtEOF;
        this.zzEOFDone = zzFlexStreamInfo.zzEOFDone;
        this.zzFinalHighSurrogate = zzFlexStreamInfo.zzFinalHighSurrogate;
        this.yyline = zzFlexStreamInfo.yyline;
        this.yychar = zzFlexStreamInfo.yychar;
        this.yycolumn = zzFlexStreamInfo.yycolumn;
    }

    public final boolean yymoreStreams() {
        return !this.zzStreams.isEmpty();
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int n) {
        this.zzLexicalState = n;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int n) {
        return this.zzBuffer[this.zzStartRead + n];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int n) {
        String string;
        try {
            string = ZZ_ERROR_MSG[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = ZZ_ERROR_MSG[0];
        }
        throw new Error(string);
    }

    public void yypushback(int n) {
        if (n > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= n;
    }

    public int yylex() throws IOException {
        int[] nArray = ZZ_TRANS;
        int[] nArray2 = ZZ_ROWMAP;
        int[] nArray3 = ZZ_ATTRIBUTE;
        block85: while (true) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = this.zzMarkedPos;
            int n7 = this.zzEndRead;
            char[] cArray = this.zzBuffer;
            char[] cArray2 = ZZ_CMAP;
            boolean bl = false;
            block86: for (n4 = this.zzStartRead; n4 < n6; n4 += n5) {
                int n8 = Character.codePointAt(cArray, n4, n6);
                n5 = Character.charCount(n8);
                switch (n8) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        bl = false;
                        continue block86;
                    }
                    case 13: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        bl = true;
                        continue block86;
                    }
                    case 10: {
                        if (bl) {
                            bl = false;
                            continue block86;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block86;
                    }
                    default: {
                        bl = false;
                        this.yycolumn += n5;
                    }
                }
            }
            if (bl) {
                if (n6 < n7) {
                    n3 = cArray[n6] == '\n' ? 1 : 0;
                } else if (this.zzAtEOF) {
                    n3 = 0;
                } else {
                    n2 = this.zzRefill();
                    n7 = this.zzEndRead;
                    n6 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    if (n2 != 0) {
                        n3 = 0;
                    } else {
                        int n9 = n3 = cArray[n6] == '\n' ? 1 : 0;
                    }
                }
                if (n3 != 0) {
                    --this.yyline;
                }
            }
            int n10 = -1;
            this.zzCurrentPos = this.zzStartRead = n6;
            n4 = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            n3 = nArray3[this.zzState];
            if ((n3 & 1) == 1) {
                n10 = this.zzState;
            }
            while (true) {
                if (n4 < n7) {
                    n = Character.codePointAt(cArray, n4, n7);
                    n4 += Character.charCount(n);
                } else {
                    if (this.zzAtEOF) {
                        n = -1;
                        break;
                    }
                    this.zzCurrentPos = n4;
                    this.zzMarkedPos = n6;
                    n2 = this.zzRefill();
                    n4 = this.zzCurrentPos;
                    n6 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    n7 = this.zzEndRead;
                    if (n2 != 0) {
                        n = -1;
                        break;
                    }
                    n = Character.codePointAt(cArray, n4, n7);
                    n4 += Character.charCount(n);
                }
                n2 = nArray[nArray2[this.zzState] + (n >= 0 && n < cArray2.length ? cArray2[n] : 0)];
                if (n2 == -1) break;
                this.zzState = n2;
                n3 = nArray3[this.zzState];
                if ((n3 & 1) != 1) continue;
                n10 = this.zzState;
                n6 = n4;
                if ((n3 & 8) == 8) break;
            }
            this.zzMarkedPos = n6;
            if (n == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                if (this.yymoreStreams()) {
                    this.endInclude();
                    this.yypopStream();
                    continue;
                }
                return -1;
            }
            switch (n10 < 0 ? n10 : ZZ_ACTION[n10]) {
                case 1: {
                    this.addVal();
                    this.inStatement = true;
                    break;
                }
                case 38: {
                    break;
                }
                case 2: {
                    if (!this.inStatement) continue block85;
                    this.addVal();
                    break;
                }
                case 39: {
                    break;
                }
                case 3: {
                    if (!this.inStatement) {
                        this.value = new String("");
                        this.yybegin(10);
                        break;
                    }
                    this.addVal();
                    break;
                }
                case 40: {
                    break;
                }
                case 4: {
                    if (!this.inStatement) {
                        try {
                            this.value = Long.valueOf(this.yytext());
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.value = SDMSConstants.lZERO;
                            return 265;
                        }
                        return 264;
                    }
                    this.addVal();
                    break;
                }
                case 41: {
                    break;
                }
                case 5: {
                    this.addVal("'");
                    this.yybegin(2);
                    break;
                }
                case 42: {
                    break;
                }
                case 6: {
                    this.addVal();
                    ++this.brctr;
                    break;
                }
                case 43: {
                    break;
                }
                case 7: {
                    this.addVal();
                    --this.brctr;
                    break;
                }
                case 44: {
                    break;
                }
                case 8: {
                    if (!this.inMultiCmd) {
                        this.addVal(";");
                        if (this.brctr != 0) continue block85;
                        this.inStatement = false;
                        return 275;
                    }
                    if (this.eatSemiColon) {
                        this.eatSemiColon = false;
                        this.inMultiCmd = false;
                        this.inStatement = false;
                        return 263;
                    }
                    this.addVal(";");
                    return 275;
                }
                case 45: {
                    break;
                }
                case 9: {
                    this.addVal();
                    break;
                }
                case 46: {
                    break;
                }
                case 10: {
                    this.addVal("'");
                    this.yybegin(0);
                    if (this.inStatement) continue block85;
                    return 276;
                }
                case 47: {
                    break;
                }
                case 11: {
                    this.addVal();
                    return 272;
                }
                case 48: {
                    break;
                }
                case 12: {
                    break;
                }
                case 49: {
                    break;
                }
                case 13: {
                    this.yybegin(8);
                    this.value = new String("");
                    break;
                }
                case 50: {
                    break;
                }
                case 14: {
                    this.addVal();
                    break;
                }
                case 51: {
                    break;
                }
                case 15: {
                    this.yybegin(0);
                    String string = this.value.toString();
                    File file = new File(string);
                    if (!file.isAbsolute()) {
                        file = new File((String)(this.dirStack.size() > 0 ? (String)this.dirStack.get(this.dirStack.size() - 1) + File.separatorChar + string : string));
                    }
                    this.startInclude(file);
                    try {
                        FileReader fileReader = new FileReader(file);
                        this.yypushStream(fileReader);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return 270;
                    }
                    this.value = new String("");
                    break;
                }
                case 52: {
                    break;
                }
                case 16: {
                    this.addVal();
                    break;
                }
                case 53: {
                    break;
                }
                case 17: {
                    this.yybegin(0);
                    return 274;
                }
                case 54: {
                    break;
                }
                case 18: {
                    if (this.inStatement) {
                        this.addVal();
                    }
                    this.yybegin(4);
                    break;
                }
                case 55: {
                    break;
                }
                case 19: {
                    this.addVal("\\\\");
                    break;
                }
                case 56: {
                    break;
                }
                case 20: {
                    this.addVal("\\'");
                    break;
                }
                case 57: {
                    break;
                }
                case 21: {
                    if (this.inStatement) {
                        this.addVal();
                    }
                    this.yybegin(0);
                    break;
                }
                case 58: {
                    break;
                }
                case 22: {
                    this.addVal("\\\\");
                    break;
                }
                case 59: {
                    break;
                }
                case 23: {
                    this.addVal("\\'");
                    break;
                }
                case 60: {
                    break;
                }
                case 24: {
                    if (!this.inStatement) {
                        return 257;
                    }
                    this.addVal();
                    break;
                }
                case 61: {
                    break;
                }
                case 25: {
                    if (!this.inStatement) {
                        return 261;
                    }
                    this.addVal();
                    break;
                }
                case 62: {
                    break;
                }
                case 26: {
                    if (!this.inStatement) {
                        return 258;
                    }
                    this.addVal();
                    break;
                }
                case 63: {
                    break;
                }
                case 27: {
                    if (!this.inStatement) {
                        return 262;
                    }
                    this.addVal();
                    break;
                }
                case 64: {
                    break;
                }
                case 28: {
                    if (!this.inStatement) {
                        this.yybegin(6);
                        break;
                    }
                    this.addVal();
                    break;
                }
                case 65: {
                    break;
                }
                case 29: {
                    if (!this.inStatement) {
                        return 269;
                    }
                    this.addVal();
                    break;
                }
                case 66: {
                    break;
                }
                case 30: {
                    if (!this.inStatement) {
                        return 260;
                    }
                    this.addVal();
                    break;
                }
                case 67: {
                    break;
                }
                case 31: {
                    if (!this.inStatement) {
                        return 268;
                    }
                    this.addVal();
                    break;
                }
                case 68: {
                    break;
                }
                case 32: {
                    if (!this.inStatement) {
                        return 259;
                    }
                    this.addVal();
                    break;
                }
                case 69: {
                    break;
                }
                case 33: {
                    this.addVal();
                    if (this.inMultiCmd) {
                        this.eatSemiColon = true;
                    }
                    this.inStatement = true;
                    return 273;
                }
                case 70: {
                    break;
                }
                case 34: {
                    if (!this.inStatement) {
                        return 277;
                    }
                    this.addVal();
                    break;
                }
                case 71: {
                    break;
                }
                case 35: {
                    if (!this.inStatement) {
                        return 278;
                    }
                    this.addVal();
                    break;
                }
                case 72: {
                    break;
                }
                case 36: {
                    if (this.inStatement) {
                        this.addVal(";");
                        this.inStatement = false;
                        this.yypushback(this.yytext().length());
                        return 275;
                    }
                    this.addVal();
                    this.eatSemiColon = true;
                    return 267;
                }
                case 73: {
                    break;
                }
                case 37: {
                    this.addVal();
                    this.inStatement = true;
                    this.inMultiCmd = true;
                    return 266;
                }
                case 74: {
                    break;
                }
                default: {
                    this.zzScanError(1);
                }
            }
        }
    }

    private static final class ZzFlexStreamInfo {
        Reader zzReader;
        int zzEndRead;
        int zzStartRead;
        int zzCurrentPos;
        int zzMarkedPos;
        int yyline;
        int yychar;
        int yycolumn;
        char[] zzBuffer;
        boolean zzAtBOL;
        boolean zzAtEOF;
        boolean zzEOFDone;
        int zzFinalHighSurrogate;

        ZzFlexStreamInfo(Reader reader, int n, int n2, int n3, int n4, char[] cArray, boolean bl, boolean bl2, boolean bl3, int n5, int n6, int n7, int n8) {
            this.zzReader = reader;
            this.zzEndRead = n;
            this.zzStartRead = n2;
            this.zzCurrentPos = n3;
            this.zzMarkedPos = n4;
            this.zzBuffer = cArray;
            this.zzAtBOL = bl;
            this.zzAtEOF = bl2;
            this.zzEOFDone = bl3;
            this.zzFinalHighSurrogate = n5;
            this.yyline = n6;
            this.yychar = n7;
            this.yycolumn = n8;
        }
    }
}

