/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.tools;

import de.independit.scheduler.SDMSApp.App;
import de.independit.scheduler.SDMSApp.RetryException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputUtil;
import java.util.Iterator;

class submit
extends App {
    public static final String __version = "@(#) $Id: submit.java,v 2.7.6.1 2013/03/14 10:25:32 ronald Exp $";
    public static final String JOB = "JOB";
    public static final String TAG = "TAG";
    public static final String MASTER = "MASTER";
    public static final String SUSPEND = "SUSPEND";
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static final String DELAY = "DELAY";
    public static final String UNIT = "UNIT";
    public static final String AT = "AT";
    public static final String GROUP = "GROUP";
    public static final String NICE = "NICE";
    private String submitTag = null;

    @Override
    public void addOptions() {
        this.addOption("J", "job", null, JOB, null, "jobname", true, "Name or alias of job to submit");
        this.addOption("T", "tag", null, TAG, null, "tag", false, "Child tag for dynamic child submits");
        this.addOption("m", "master", null, MASTER, null, null, false, "The job will be submitted as master (job option only)");
        this.addOption("N", "nice", null, NICE, null, "nice", false, "Nice value of the job or batch");
        this.addOption("S", "suspend", null, SUSPEND, null, null, false, "Submit job [not] suspended");
        this.addOption("D", "delay", null, DELAY, null, "delay", false, "Delay after Job will be resumed (only valid with suspend option)");
        this.addOption("U", "unit", null, UNIT, null, "unit", false, "Delay Unit (MINUTE, HOUR or DAY) defaults to MINUTE");
        this.addOption("A", "at", null, AT, null, "at", false, "Timestamp (YYYY-MM-DDTHH:MM) when job should be resumed (only valid with suspend option)");
        this.addOption("g", "group", null, GROUP, null, "groupname", false, "Group to own the submitted job (not allows with jid option)");
        this.addOption("d", "disable", null, DISABLE, null, null, false, "The disable option can be used in dynamic child submits and will cause the child to be submitted disabled");
    }

    @Override
    public String getName() {
        return "submit";
    }

    @Override
    public boolean canRetry() {
        return true;
    }

    @Override
    public String getUsageArguments() {
        return "{ parameter value }";
    }

    @Override
    public boolean validateOptions() {
        if (this.options.isSet(GROUP) && !this.options.isSet("USER")) {
            if (!this.silent) {
                System.err.println("group option only allowed with user option !");
            }
            return false;
        }
        if (this.options.isSet(MASTER)) {
            if (this.options.isSet("USER") && !this.silent) {
                System.err.println("WARNING: master option has no effect for submits by user");
            }
            if (this.options.isSet(DISABLE)) {
                if (!this.silent) {
                    System.err.println("disable option not allowed for master submits !");
                }
                return false;
            }
        }
        if (this.options.isSet(NICE)) {
            int n;
            try {
                n = Integer.parseInt(this.options.getValue(NICE));
            }
            catch (Exception exception) {
                if (!this.silent) {
                    System.err.println("nicevalue be an integer !");
                }
                return false;
            }
            if (n < -100 || n > 100) {
                if (!this.silent) {
                    System.err.println("nicevalue must be >= -100 and <= 100 !");
                }
                return false;
            }
        }
        if (!this.options.isSet(SUSPEND) || !this.options.getOption(SUSPEND).getBValue()) {
            if (this.options.isSet(DELAY)) {
                System.err.println("delay option only valid with suspend option");
                return false;
            }
            if (this.options.isSet(AT)) {
                System.err.println("at option only valid with suspend option");
                return false;
            }
        } else {
            if (this.options.isSet(DELAY) && this.options.isSet(AT)) {
                System.err.println("combination of delay and at option not allowed");
                return false;
            }
            if (this.options.isSet(DELAY) && !this.options.isSet(UNIT)) {
                System.err.println("delay option requires unit option");
                return false;
            }
            if (this.options.isSet(UNIT) && !this.options.getValue(UNIT).equals("MINUTE") && !this.options.getValue(UNIT).equals("HOUR") && !this.options.getValue(UNIT).equals("DAY")) {
                System.err.println("unit must be MINUTE, HOUR or DAY");
                return false;
            }
        }
        if (this.options.isSet(UNIT) && !this.options.isSet(DELAY)) {
            System.err.println("unit option only valid with delay option");
            return false;
        }
        if (this.options.rest.size() % 2 != 0) {
            if (!this.silent) {
                System.err.println("Incomplete parameter value pairs !");
            }
            return false;
        }
        return true;
    }

    @Override
    public int go() throws RetryException {
        SDMSOutput sDMSOutput;
        Object object;
        if (this.submitTag == null) {
            object = "GET SUBMITTAG";
            sDMSOutput = this.execute((String)object);
            this.submitTag = SDMSOutputUtil.getFromRecord(sDMSOutput, "VALUE");
        }
        object = "SUBMIT " + this.options.getValue(JOB) + "\nWITH\n    SUBMITTAG = '" + this.submitTag + "'";
        if (this.options.isSet(SUSPEND) && this.options.getOption(SUSPEND).getBValue()) {
            object = (String)object + ",\n    SUSPEND";
        }
        if (this.options.isSet(DELAY) || this.options.isSet(AT)) {
            object = (String)object + ",\n    RESUME";
        }
        if (this.options.isSet(DELAY)) {
            object = (String)object + " IN " + this.options.getValue(DELAY) + " " + this.options.getValue(UNIT);
        }
        if (this.options.isSet(AT)) {
            object = (String)object + " AT '" + this.options.getValue(AT) + "'";
        }
        if (this.options.isSet(DISABLE) && this.options.getOption(DISABLE).getBValue()) {
            object = (String)object + ",\n    DISABLE";
        }
        if (this.options.isSet(NICE)) {
            object = (String)object + ",\n    NICEVALUE = " + this.options.getValue(NICE);
        }
        if (this.options.isSet(TAG)) {
            object = (String)object + ",\n    CHILDTAG = '" + this.options.getValue(TAG) + "'";
        }
        if (this.options.isSet(MASTER) && !this.options.isSet("USER")) {
            object = (String)object + ",\n    MASTER";
        }
        if (this.options.rest.size() > 0) {
            object = (String)object + ",\n    PARAMETERS = (\n";
            String string = "";
            Iterator iterator = this.options.rest.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)iterator.next();
                string3 = string3.replaceAll("\\\\", "\\\\\\\\");
                string3 = string3.replaceAll("'", "\\\\'");
                object = (String)object + string + "        '" + string2 + "' = '" + string3 + "'";
                string = ",\n";
            }
            object = (String)object + "\n    )";
        }
        sDMSOutput = this.execute((String)object);
        if (sDMSOutput.error != null) {
            if (sDMSOutput.error.code.equals("03406031553")) {
                return 0;
            }
            this.printError(sDMSOutput.error);
            return 1;
        }
        System.out.println(SDMSOutputUtil.getFromRecord(sDMSOutput, "ID"));
        return 0;
    }

    public static void main(String[] stringArray) {
        System.exit(new submit().run(stringArray));
    }
}

