## How to contribute to schedulix

#### **Important contributions**

There are a few things that definitely require a review by others.
Most important is:

* Testing
  Especially the testing of our unstable branch will enable us to eliminate bugs shortly after they were introduced.
  Though we do a lot of testing ourselves, an unbiased person will be able to find the things we have never thought of.

* Documentation
  We're not native speakers in most languages. It is very well possible we made mistakes or forgot to document things.
  Any proposals to enhance the documentation is more than welcome.
  The documentation itself is created by pdflatex and requires quite a bit of environment to be able to compile it,
  which is the reason that the "sources" aren't published in GitHub. But any improvements can be sent in plain text form
  and we will take care of updating the documentation.

* Feature requests
  We're always looking for new features and possibilities to enhance the system.
  This means that feature requests are indeed a huge help to get schedulix better.
  The better the description of the feature is, the higher the probability of being accepted.

#### **Did you find a bug?**

* **Do not open up a GitHub issue if the bug is a security vulnerability**, and instead send a mail to [ronald.jeninga@schedulix.org]

* Although we pay attention to any issues raised on GitHub, we prefer bug reports to be posted in our Google group [https://groups.google.com/forum/#!forum/schedulix].
  Be sure to include a **title and clear description**, as much relevant information as possible, and if possible some **test case** demonstrating the expected behavior that is not occurring.

#### **Did you write a patch that fixes a bug?**

* In that case please contact us directly, explaining the bug and your proposed solution.

#### **Do you intend to add a new feature or change an existing one?**

* Please discuss the new or changing feature with us first; we're fans of new features, but we like to get the most out of them.

#### **Do you have questions about the source code?**

* Ask any question about the source code in our Google group.

Thanks!

schedulix Team
