/*
Copyright (c) 2000-2013 "independIT Integrative Technologies GmbH",
Authors: Ronald Jeninga, Dieter Stubler

schedulix Enterprise Job Scheduling System

independIT Integrative Technologies GmbH [http://www.independit.de]
mailto:contact@independit.de

This file is part of schedulix

schedulix is free software:
you can redistribute it and/or modify it under the terms of the
GNU Affero General Public License as published by the
Free Software Foundation, either version 3 of the License,
or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

package de.independit.scheduler.server.parser;

import java.util.*;
import de.independit.scheduler.server.util.*;
import de.independit.scheduler.server.repository.*;

public class ParseStr
{

	public static final String __version = "@(#) $Id: ParseStr.java,v 2.41.2.1 2013/03/14 10:24:42 ronald Exp $";

	public static final String S_ACTION		= "ACTION";
	public static final String S_ACTIVATE		= "ACTIVATE";
	public static final String S_ACTIVE		= "ACTIVE";
	public static final String S_ADD		= "ADD";
	public static final String S_ADDCHILD		= "ADDCHILD";
	public static final String S_ADDGROUP		= "ADDGROUP";
	public static final String S_ADDPARM		= "ADDPARM";
	public static final String S_ADDREQ		= "ADDREQ";
	public static final String S_ADDRES		= "ADDRES";
	public static final String S_ADDUSER		= "ADDUSER";
	public static final String S_AFTER		= "AFTER";
	public static final String S_AFTER_FINAL	= "AFTER_FINAL";
	public static final String S_AGING		= "AGING";
	public static final String S_ALIAS		= "ALIAS";
	public static final String S_ALL_FINAL		= "ALL_FINAL";
	public static final String S_ALTCHILD		= "ALTCHILD";
	public static final String S_ALTER		= "ALTER";
	public static final String S_ALTPARM		= "ALTPARM";
	public static final String S_ALTREQ		= "ALTREQ";
	public static final String S_ALTRES		= "ALTRES";
	public static final String S_AMOUNT		= "AMOUNT";
	public static final String S_AND		= "AND";
	public static final String S_ANY		= "ANY";
	public static final String S_APPROVE		= "APPROVE";
	public static final String S_AVG		= "AVG";
	public static final String S_BACKLOG_HANDLING	= "BACKLOG_HANDLING";
	public static final String S_BACKUP		= "BACKUP";
	public static final String S_BASE		= "BASE";
	public static final String S_BATCH		= "BATCH";
	public static final String S_BEFORE		= "BEFORE";
	public static final String S_BEFORE_FINAL	= "BEFORE_FINAL";
	public static final String S_BMULTICMD		= "BEGIN MULTICOMMAND";
	public static final String S_BOTH		= "BOTH";
	public static final String S_BROKEN		= "BROKEN";
	public static final String S_BROKEN_ACTIVE	= "BROKEN_ACTIVE";
	public static final String S_BROKEN_FINISHED	= "BROKEN_FINISHED";
	public static final String S_BY			= "BY";
	public static final String S_CALENDAR		= "CALENDAR";
	public static final String S_CANCEL		= "CANCEL";
	public static final String S_CANCELLED		= "CANCELLED";
	public static final String S_CASCADE		= "CASCADE";
	public static final String S_CATEGORY		= "CATEGORY";
	public static final String S_CHANGE_STATUS	= "CHANGE_STATUS";
	public static final String S_CHANGE		= "CHANGE";
	public static final String S_CHECK		= "CHECK";
	public static final String S_CHECK_ONLY		= "CHECK_ONLY";
	public static final String S_CHILD		= "CHILD";
	public static final String S_CHILDREN		= "CHILDREN";
	public static final String S_CHILDSUSPEND	= "CHILDSUSPEND";
	public static final String S_CHILDTAG		= "CHILDTAG";
	public static final String S_CLEANUP		= "CLEANUP";
	public static final String S_CLEAR		= "CLEAR";
	public static final String S_CLEAR_WARN		= "CLEAR_WARN";
	public static final String S_CLONE		= "CLONE";
	public static final String S_CMPOP		= "CMPOP";
	public static final String S_COMMAND		= "COMMAND";
	public static final String S_COMMENT		= "COMMENT";
	public static final String S_CONDENSED		= "CONDENSED";
	public static final String S_CONDITION		= "CONDITION";
	public static final String S_CONSTANT		= "CONSTANT";
	public static final String S_CONFIG		= "CONFIG";
	public static final String S_CONNECT		= "CONNECT";
	public static final String S_CONTENT		= "CONTENT";
	public static final String S_CONTINUE		= "CONTINUE";
	public static final String S_COPY		= "COPY";
	public static final String S_COUNT		= "COUNT";
	public static final String S_CREATE		= "CREATE";
	public static final String S_CYCLE		= "CYCLE";
	public static final String S_DAY		= "DAY";
	public static final String S_DEFAULT		= "DEFAULT";
	public static final String S_DEFAULTGROUP	= "DEFAULTGROUP";
	public static final String S_DEFAULT_MAPPING	= "DEFAULT_MAPPING";
	public static final String S_DEFAULT_WORKDIR	= "DEFAULT_WORKDIR";
	public static final String S_DEFER		= "DEFER";
	public static final String S_DEFERRED		= "DEFERRED";
	public static final String S_DEFINITION		= "DEFINITION";
	public static final String S_DELAY		= "DELAY";
	public static final String S_DELCHILD		= "DELCHILD";
	public static final String S_DELETE		= "DELETE";
	public static final String S_DELGROUP		= "DELGROUP";
	public static final String S_DELPARM		= "DELPARM";
	public static final String S_DELREQ		= "DELREQ";
	public static final String S_DELRES		= "DELRES";
	public static final String S_DELUSER		= "DELUSER";
	public static final String S_DEPENDENCY		= "DEPENDENCY";
	public static final String S_DEPENDENCY_DEFINITION	= "DEPENDENCY_DEFINITION";
	public static final String S_DEPENDENCY_HIERARCHY	= "DEPENDENCY_HIERARCHY";
	public static final String S_DEPENDENCY_MODE	= "DEPENDENCY_MODE";
	public static final String S_DEPENDENCY_WAIT	= "DEPENDENCY_WAIT";
	public static final String S_DEPLOY		= "DEPLOY";
	public static final String S_DEREGISTER		= "DEREGISTER";
	public static final String S_DIR		= "DIR";
	public static final String S_DISABLE		= "DISABLE";
	public static final String S_DISCONNECT		= "DISCONNECT";
	public static final String S_DISPATCH		= "DISPATCH";
	public static final String S_DISTRIBUTION	= "DISTRIBUTION";
	public static final String S_DROP		= "DROP";
	public static final String S_DUMP		= "DUMP";
	public static final String S_DURATION		= "DURATION";
	public static final String S_DYNAMIC		= "DYNAMIC";
	public static final String S_EDIT		= "EDIT";
	public static final String S_EMBEDDED		= "EMBEDDED";
	public static final String S_EMULTICMD		= "END MULTICOMMAND";
	public static final String S_ENABLE		= "ENABLE";
	public static final String S_ENABLED		= "ENABLED";
	public static final String S_ENDTIME		= "ENDTIME";
	public static final String S_ENVIRONMENT	= "ENVIRONMENT";
	public static final String S_ERRLOG		= "ERRLOG";
	public static final String S_ERROR_TEXT		= "ERROR_TEXT";
	public static final String S_ERROR_TOKEN	= "ERROR";
	public static final String S_EQUIVALENT		= "EQUIVALENT";
	public static final String S_EVENT		= "EVENT";
	public static final String S_EXEC_PID		= "EXEC_PID";
	public static final String S_EXECUTE		= "EXECUTE";
	public static final String S_EXISTING		= "EXISTING";
	public static final String S_EXIT_CODE		= "EXIT_CODE";
	public static final String S_EXIT_STATUS	= "EXIT_STATUS";
	public static final String S_EXIT_STATUS_DEFINITION = "EXIT_STATUS_DEFINITION";
	public static final String S_EXIT_STATUS_MAPPING = "EXIT_STATUS_MAPPING";
	public static final String S_EXIT_STATUS_PROFILE = "EXIT_STATUS_PROFILE";
	public static final String S_EXIT_STATUS_TRANSLATION = "EXIT_STATUS_TRANSLATION";
	public static final String S_EXPAND		= "EXPAND";
	public static final String S_EXPIRED		= "EXPIRED";
	public static final String S_EXPORT		= "EXPORT";
	public static final String S_EXPR		= "EXPR";
	public static final String S_EXTERNAL		= "EXTERNAL";
	public static final String S_EXT_PID		= "EXT_PID";
	public static final String S_FACTOR		= "FACTOR";
	public static final String S_FAIL		= "FAIL";
	public static final String S_FAILURE		= "FAILURE";
	public static final String S_FATAL		= "FATAL";
	public static final String S_FILENAME		= "FILENAME";
	public static final String S_FILTER		= "FILTER";
	public static final String S_FINAL		= "FINAL";
	public static final String S_FINISH		= "FINISH";
	public static final String S_FINISH_CHILD	= "FINISH_CHILD";
	public static final String S_FINISHED		= "FINISHED";
	public static final String S_FOLDER		= "FOLDER";
	public static final String S_FOOTPRINT		= "FOOTPRINT";
	public static final String S_FOR		= "FOR";
	public static final String S_FORCE		= "FORCE";
	public static final String S_FORCED_EOC		= "FORCED_EOC";
	public static final String S_FREE_AMOUNT	= "FREE_AMOUNT";
	public static final String S_FREEPCT		= "FREEPCT";
	public static final String S_FROM		= "FROM";
	public static final String S_FUTURE		= "FUTURE";
	public static final String S_FULLNAME		= "FULLNAME";
	public static final String S_GET		= "GET";
	public static final String S_GET_NEXT_JOB	= "GET_NEXT_JOB";
	public static final String S_GETRUNTIME		= "GETRUNTIME";
	public static final String S_GLOBAL		= "GLOBAL";
	public static final String S_GRAB_DELAY		= "GRAB_DELAY";
	public static final String S_GRANT		= "GRANT";
	public static final String S_GROUP		= "GROUP";
	public static final String S_GROUP_CASCADE	= "GROUP_CASCADE";
	public static final String S_GROUPLIST		= "GROUPLIST";
	public static final String S_HEADER		= "HEADER";
	public static final String S_HISTORY		= "HISTORY";
	public static final String S_HORIZON		= "HORIZON";
	public static final String S_HOUR		= "HOUR";
	public static final String S_IDENTIFIED		= "IDENTIFIED";
	public static final String S_IDENTIFIER		= "IDENTIFIER";
	public static final String S_IGNORE		= "IGNORE";
	public static final String S_IGNORE_DEPENDENCY	= "IGNORE_DEPENDENCY";
	public static final String S_IGNORE_RESOURCE	= "IGNORE_RESOURCE";
	public static final String S_IGNORE_NAMED_RESOURCE = "IGNORE_NAMED_RESOURCE";
	public static final String S_IMMEDIATE		= "IMMEDIATE";
	public static final String S_IMMEDIATE_LOCAL	= "IMMEDIATE_LOCAL";
	public static final String S_IMMEDIATE_MERGE	= "IMMEDIATE_MERGE";
	public static final String S_IMPORT		= "IMPORT";
	public static final String S_IN			= "IN";
	public static final String S_INACTIVE		= "INACTIVE";
	public static final String S_INFINITE		= "INFINITE";
	public static final String S_INHERIT		= "INHERIT";
	public static final String S_INFO		= "INFO";
	public static final String S_INITIAL_STATUS	= "INITIAL_STATUS";
	public static final String S_INSTANCE		= "INSTANCE";
	public static final String S_INTERNAL		= "INTERNAL";
	public static final String S_INTERVAL		= "INTERVAL";
	public static final String S_INVERSE		= "INVERSE";
	public static final String S_IS			= "IS";
	public static final String S_ISGROUPED		= "ISGROUPED";
	public static final String S_ISX		= "ISX";
	public static final String S_IX			= "IX";
	public static final String S_JOB		= "JOB";
	public static final String S_JOB_DEFINITION	= "JOB_DEFINITION";
	public static final String S_JOB_DEFINITION_HIERARCHY	= "JOB_DEFINITION_HIERARCHY";
	public static final String S_JOBID		= "JOBID";
	public static final String S_JOB_EXECUTOR	= "JOB_EXECUTOR";
	public static final String S_JOB_FILE_PREFIX	= "JOB_FILE_PREFIX";
	public static final String S_JOB_FINAL		= "JOB_FINAL";
	public static final String S_JOB_SERVER		= "JOB_SERVER";
	public static final String S_JOB_STATUS		= "JOB_STATUS";
	public static final String S_JSON		= "JSON";
	public static final String S_KEEP		= "KEEP";
	public static final String S_KEEP_FINAL		= "KEEP_FINAL";
	public static final String S_KILL		= "KILL";
	public static final String S_KILLED		= "KILLED";
	public static final String S_KILL_PROGRAM	= "KILL_PROGRAM";
	public static final String S_LANGUAGE		= "LANGUAGE";
	public static final String S_LAST		= "LAST";
	public static final String S_LEVEL		= "LEVEL";
	public static final String S_LIBERAL		= "LIBERAL";
	public static final String S_LIKE		= "LIKE";
	public static final String S_LIMIT		= "LIMIT";
	public static final String S_LINE		= "LINE";
	public static final String S_LIST		= "LIST";
	public static final String S_LOCAL		= "LOCAL";
	public static final String S_LOCAL_CONSTANT	= "LOCAL_CONSTANT";
	public static final String S_LOCK		= "LOCK";
	public static final String S_LOCKMODE		= "LOCKMODE";
	public static final String S_LOGFILE		= "LOGFILE";
	public static final String S_LOOPS		= "LOOPS";
	public static final String S_MAIN		= "MAIN";
	public static final String S_MANAGED		= "MANAGED";
	public static final String S_MAP		= "MAP";
	public static final String S_MAPPING		= "MAPPING";
	public static final String S_MAPS		= "MAPS";
	public static final String S_MAP_STATUS		= "MAP_STATUS";
	public static final String S_MASTER		= "MASTER";
	public static final String S_MASTER_ID		= "MASTER_ID";
	public static final String S_MAX		= "MAX";
	public static final String S_MAXPCT		= "MAXPCT";
	public static final String S_MERGE		= "MERGE";
	public static final String S_MERGED		= "MERGED";
	public static final String S_MERGE_GLOBAL	= "MERGE_GLOBAL";
	public static final String S_MERGE_LOCAL	= "MERGE_LOCAL";
	public static final String S_MERGE_MODE		= "MERGE_MODE";
	public static final String S_METHOD		= "METHOD";
	public static final String S_MILESTONE		= "MILESTONE";
	public static final String S_MIN		= "MIN";
	public static final String S_MINPCT		= "MINPCT";
	public static final String S_MINUTE		= "MINUTE";
	public static final String S_MODE		= "MODE";
	public static final String S_MONITOR		= "MONITOR";
	public static final String S_MONTH		= "MONTH";
	public static final String S_MOVE		= "MOVE";
	public static final String S_MPRIORITY		= "MPRIORITY";
	public static final String S_MULT		= "MULT";
	public static final String S_MULTICOMMAND	= "MULTICOMMAND";
	public static final String S_MULTIPLIER		= "MULTIPLIER";
	public static final String S_N			= "N";
	public static final String S_NAME		= "NAME";
	public static final String S_NAMED_RESOURCE	= "NAMED_RESOURCE";
	public static final String S_NAMELIST		= "NAMELIST";
	public static final String S_NEGFILTER		= "NEGFILTER";
	public static final String S_NICE		= "NICE";
	public static final String S_NICEVALUE		= "NICEVALUE";
	public static final String S_NODE		= "NODE";
	public static final String S_NOINVERSE		= "NOINVERSE";
	public static final String S_NOKEEP		= "NOKEEP";
	public static final String S_NOMASTER		= "NOMASTER";
	public static final String S_NOMERGE		= "NOMERGE";
	public static final String S_NOMINALPCT		= "NOMINALPCT";
	public static final String S_NONE		= "NONE";
	public static final String S_NONFATAL		= "NONFATAL";
	public static final String S_NOP_DELAY		= "NOP_DELAY";
	public static final String S_NOSTICKY		= "NOSTICKY";
	public static final String S_NOSUSPEND		= "NOSUSPEND";
	public static final String S_NOT		= "NOT";
	public static final String S_NOTLIKE		= "NOTLIKE";
	public static final String S_NOTRACE		= "NOTRACE";
	public static final String S_NOTRUNC		= "NOTRUNC";
	public static final String S_NRNAME		= "NRNAME";
	public static final String S_OBJECT		= "OBJECT";
	public static final String S_OF			= "OF";
	public static final String S_OFFLINE		= "OFFLINE";
	public static final String S_ON			= "ON";
	public static final String S_ONLINE		= "ONLINE";
	public static final String S_ONLY		= "ONLY";
	public static final String S_OPERATE		= "OPERATE";
	public static final String S_OR			= "OR";
	public static final String S_OWNER		= "OWNER";
	public static final String S_PARENT		= "PARENT";
	public static final String S_PARAMETERS		= "PARAMETERS";
	public static final String S_PASSWORD		= "PASSWORD";
	public static final String S_PATH		= "PATH";
	public static final String S_PENDING		= "PENDING";
	public static final String S_PERL		= "PERL";
	public static final String S_PID		= "PID";
	public static final String S_PIPELINE		= "PIPELINE";
	public static final String S_PRIORITY		= "PRIORITY";
	public static final String S_PROFILE		= "PROFILE";
	public static final String S_PROTOCOL		= "PROTOCOL";
	public static final String S_PUBLIC		= "PUBLIC";
	public static final String S_PYTHON		= "PYTHON";
	public static final String S_RAWPASSWORD	= "RAWPASSWORD";
	public static final String S_REACHABLE		= "REACHABLE";
	public static final String S_READ		= "READ";
	public static final String S_REASSURE		= "REASSURE";
	public static final String S_RECONNECT_DELAY	= "RECONNECT_DELAY";
	public static final String S_RECREATE		= "RECREATE";
	public static final String S_RECURSIVE		= "RECURSIVE";
	public static final String S_REFERENCE		= "REFERENCE";
	public static final String S_REGISTER		= "REGISTER";
	public static final String S_REJECT		= "REJECT";
	public static final String S_RENAME		= "RENAME";
	public static final String S_RENICE		= "RENICE";
	public static final String S_REQUESTABLE_AMOUNT	= "REQUESTABLE_AMOUNT";
	public static final String S_REQUIRED		= "REQUIRED";
	public static final String S_RERUN		= "RERUN";
	public static final String S_RERUN_PROGRAM	= "RERUN_PROGRAM";
	public static final String S_RERUN_RECURSIVE	= "RERUN_RECURSIVE";
	public static final String S_RESOURCE		= "RESOURCE";
	public static final String S_RESOLVE		= "RESOLVE";
	public static final String S_RESOURCE_STATUS	= "RESOURCE_STATUS";
	public static final String S_RESOURCE_STATUS_DEFINITION = "RESOURCE_STATUS_DEFINITION";
	public static final String S_RESOURCE_STATUS_MAPPING = "RESOURCE_STATUS_MAPPING";
	public static final String S_RESOURCE_STATUS_PROFILE = "RESOURCE_STATUS_PROFILE";
	public static final String S_RESOURCE_TEMPLATE  = "RESOURCE_TEMPLATE";
	public static final String S_RESOURCE_WAIT	= "RESOURCE_WAIT";
	public static final String S_RESTARTABLE	= "RESTARTABLE";
	public static final String S_RESTRICT		= "RESTRICT";
	public static final String S_RESULT		= "RESULT";
	public static final String S_RESUME		= "RESUME";
	public static final String S_REVOKE		= "REVOKE";
	public static final String S_ROOT		= "ROOT";
	public static final String S_RSCSTATUS		= "RSCSTATUS";
	public static final String S_RUN		= "RUN";
	public static final String S_RUNNABLE		= "RUNNABLE";
	public static final String S_RUNNING		= "RUNNING";
	public static final String S_RUNTIME		= "RUNTIME";
	public static final String S_RUN_PROGRAM	= "RUN_PROGRAM";
	public static final String S_S			= "S";
	public static final String S_SC			= "SC";
	public static final String S_SCALAR		= "SCALAR";
	public static final String S_SCHEDULE		= "SCHEDULE";
	public static final String S_SCHEDULED_EVENT	= "SCHEDULED_EVENT";
	public static final String S_SCOPE		= "SCOPE";
	public static final String S_SELECT		= "SELECT";
	public static final String S_SELECT_CONDITION	= "SELECT_CONDIION";
	public static final String S_SELECTION		= "SELECTION";
	public static final String S_SELECT_FROM	= "FROM";
	public static final String S_SELECT_NUM		= "NUM";
	public static final String S_SELECT_RANGE	= "RANGE";
	public static final String S_SELECT_TO		= "TO";
	public static final String S_SERIAL		= "SERIAL";
	public static final String S_SERVER		= "SERVER";
	public static final String S_SESSION		= "SESSION";
	public static final String S_SET		= "SET";
	public static final String S_SHOW		= "SHOW";
	public static final String S_SHUTDOWN		= "SHUTDOWN";
	public static final String S_SORT		= "%%SORT%%";
	public static final String S_STARTED		= "STARTED";
	public static final String S_STARTING		= "STARTING";
	public static final String S_STARTTIME		= "STARTTIME";
	public static final String S_STATIC		= "STATIC";
	public static final String S_STATUS		= "STATUS";
	public static final String S_STATUS_PROFILE	= "STATUS_PROFILE";
	public static final String S_STATUS_MAPPING	= "STATUS_MAPPING";
	public static final String S_STICKY		= "STICKY";
	public static final String S_STOP		= "STOP";
	public static final String S_STRICT		= "STRICT";
	public static final String S_STRING		= "STRING";
	public static final String S_SUBMIT		= "SUBMIT";
	public static final String S_SUBMITCOUNT	= "SUBMITCOUNT";
	public static final String S_SUBMITTAG		= "SUBMITTAG";
	public static final String S_SUBMITTED		= "SUBMITTED";
	public static final String S_SUBMITTING		= "SUBMITTING";
	public static final String S_SUBMITTING_USER	= "SUBMITTING_USER";
	public static final String S_SUM		= "SUM";
	public static final String S_SUSPEND		= "SUSPEND";
	public static final String S_SUSPEND_LIMIT	= "SUSPEND_LIMIT";
	public static final String S_SUSPENDED		= "SUSPENDED";
	public static final String S_SX			= "SX";
	public static final String S_SYNCHRONIZE_WAIT	= "SYNCHRONIZE_WAIT";
	public static final String S_SYNCHRONIZING	= "SYNCHRONIZING";
	public static final String S_SYNCTIME		= "SYNCTIME";
	public static final String S_SYSTEM		= "SYSTEM";
	public static final String S_TAG		= "TAG";
	public static final String S_TEST		= "TEST";
	public static final String S_TEXT		= "TEXT";
	public static final String S_TIME		= "TIME";
	public static final String S_TIMEOUT		= "TIMEOUT";
	public static final String S_TIMESTAMP		= "TIMESTAMP";
	public static final String S_TO			= "TO";
	public static final String S_TO_KILL		= "TO_KILL";
	public static final String S_TOKEN		= "TOKEN";
	public static final String S_TOUCH		= "TOUCH";
	public static final String S_TRACE		= "TRACE";
	public static final String S_TRACE_LEVEL	= "TRACE_LEVEL";
	public static final String S_TRANSLATION	= "TRANSLATION";
	public static final String S_TREE		= "TREE";
	public static final String S_TRIGGER		= "TRIGGER";
	public static final String S_TRIGGERTYPE	= "TRIGGERTYPE";
	public static final String S_TRUNC		= "TRUNC";
	public static final String S_TYPE		= "TYPE";
	public static final String S_UNREACHABLE	= "UNREACHABLE";
	public static final String S_UNRESOLVED		= "UNRESOLVED";
	public static final String S_UNTIL_FINAL	= "UNTIL_FINAL";
	public static final String S_UNTIL_FINISHED	= "UNTIL_FINISHED";
	public static final String S_UPDATE		= "UPDATE";
	public static final String S_URL		= "URL";
	public static final String S_USERLIST		= "USERLIST";
	public static final String S_USE_PATH		= "USE_PATH";
	public static final String S_USE		= "USE";
	public static final String S_USER		= "USER";
	public static final String S_USAGE		= "USAGE";
	public static final String S_VALUE		= "VALUE";
	public static final String S_VERSION		= "VERSION";
	public static final String S_VIEW		= "VIEW";
	public static final String S_WARN		= "WARN";
	public static final String S_WATCHER		= "WATCHER";
	public static final String S_WATCHTYPE		= "WATCHTYPE";
	public static final String S_WARNING		= "WARNING";
	public static final String S_WEEK		= "WEEK";
	public static final String S_WITH		= "WITH";
	public static final String S_WORKDIR		= "WORKDIR";
	public static final String S_X			= "X";
	public static final String S_XADDCHILD		= "XADDCHILD";
	public static final String S_XADDPARM		= "XADDPARM";
	public static final String S_XADDREQ		= "XADDREQ";
	public static final String S_XADDRES		= "XADDRES";
	public static final String S_XALTCHILD		= "XALTCHILD";
	public static final String S_XALTPARM		= "XALTPARM";
	public static final String S_XALTREQ		= "XALTREQ";
	public static final String S_XALTRES		= "XALTRES";
	public static final String S_XDELCHILD		= "XDELCHILD";
	public static final String S_XDELPARM		= "XDELPARM";
	public static final String S_XDELREQ		= "XDELREQ";
	public static final String S_XDELRES		= "XDELRES";
	public static final String S_XML		= "XML";
	public static final String S_YEAR		= "YEAR";

	public static final String S_ALL		= "ALL";

	public static final String S_SYNTAX_ERROR	= "syntax error";

	public final static Integer I_STATIC		= Integer.valueOf(SDMSNamedResource.STATIC);
	public final static Integer I_SYSTEM		= Integer.valueOf(SDMSNamedResource.SYSTEM);
	public final static Integer I_SYNCHRONIZING	= Integer.valueOf(SDMSNamedResource.SYNCHRONIZING);
	public final static Integer I_CATEGORY		= Integer.valueOf(SDMSNamedResource.CATEGORY);
	public final static Integer I_POOL		= Integer.valueOf(SDMSNamedResource.POOL);

	public final static Integer I_MINUTE		= Integer.valueOf(SDMSInterval.MINUTE);
	public final static Integer I_HOUR		= Integer.valueOf(SDMSInterval.HOUR);
	public final static Integer I_DAY		= Integer.valueOf(SDMSInterval.DAY);
	public final static Integer I_WEEK		= Integer.valueOf(SDMSInterval.WEEK);
	public final static Integer I_MONTH		= Integer.valueOf(SDMSInterval.MONTH);
	public final static Integer I_YEAR		= Integer.valueOf(SDMSInterval.YEAR);

	public final static Integer I_AVG		= Integer.valueOf(SDMSParameterDefinition.AVG);
	public final static Integer I_COUNT		= Integer.valueOf(SDMSParameterDefinition.COUNT);
	public final static Integer I_MAX		= Integer.valueOf(SDMSParameterDefinition.MAX);
	public final static Integer I_MIN		= Integer.valueOf(SDMSParameterDefinition.MIN);
	public final static Integer I_SUM		= Integer.valueOf(SDMSParameterDefinition.SUM);

	public final static Integer I_CONSTANT		= Integer.valueOf(SDMSParameterDefinition.CONSTANT);
	public final static Integer I_LOCAL_CONSTANT	= Integer.valueOf(SDMSParameterDefinition.LOCAL_CONSTANT);
	public final static Integer I_PARAMETER		= Integer.valueOf(SDMSParameterDefinition.PARAMETER);
	public final static Integer I_REFERENCE		= Integer.valueOf(SDMSParameterDefinition.REFERENCE);
	public final static Integer I_RESOURCEREFERENCE	= Integer.valueOf(SDMSParameterDefinition.RESOURCEREFERENCE);
	public final static Integer I_CHILDREFERENCE	= Integer.valueOf(SDMSParameterDefinition.CHILDREFERENCE);
	public final static Integer I_RESULT		= Integer.valueOf(SDMSParameterDefinition.RESULT);
	public final static Integer I_IMPORT		= Integer.valueOf(SDMSParameterDefinition.IMPORT);
	public final static Integer I_IMPORT_UNRESOLVED	= Integer.valueOf(SDMSParameterDefinition.IMPORT_UNRESOLVED);
	public final static Integer I_EXPRESSION	= Integer.valueOf(SDMSParameterDefinition.EXPRESSION);

	public final static Integer I_PLAIN		= Integer.valueOf(SDMSUser.PLAIN);
	public final static Integer I_SSL		= Integer.valueOf(SDMSUser.SSL);
	public final static Integer I_SSL_AUTH		= Integer.valueOf(SDMSUser.SSL_AUTH);

	public final static Integer I_FOLDER		= Integer.valueOf(Parser.FOLDER);
	public final static Integer I_SCOPE		= Integer.valueOf(Parser.SCOPE);

	public final static Integer I_FINAL		= Integer.valueOf(SDMSExitState.FINAL);
	public final static Integer I_RESTARTABLE	= Integer.valueOf(SDMSExitState.RESTARTABLE);
	public final static Integer I_PENDING		= Integer.valueOf(SDMSExitState.PENDING);

	public final static Integer I_NP_SUSPEND	= Integer.valueOf(SDMSNiceProfileEntry.SUSPEND);
	public final static Integer I_NP_NOSUSPEND	= Integer.valueOf(SDMSNiceProfileEntry.NOSUSPEND);
	public final static Integer I_NP_ADMINSUSPEND	= Integer.valueOf(SDMSNiceProfileEntry.ADMINSUSPEND);

	public final static Integer I_JOB		= Integer.valueOf(SDMSSchedulingEntity.JOB);
	public final static Integer I_MILESTONE		= Integer.valueOf(SDMSSchedulingEntity.MILESTONE);
	public final static Integer I_BATCH		= Integer.valueOf(SDMSSchedulingEntity.BATCH);

	public final static Integer I_ALL		= Integer.valueOf(SDMSSchedulingEntity.AND);
	public final static Integer I_ANY		= Integer.valueOf(SDMSSchedulingEntity.OR);

	public final static Integer I_SH_CHILDSUSPEND	= Integer.valueOf(SDMSSchedulingHierarchy.CHILDSUSPEND);
	public final static Integer I_SH_SUSPEND	= Integer.valueOf(SDMSSchedulingHierarchy.SUSPEND);
	public final static Integer I_SH_NOSUSPEND	= Integer.valueOf(SDMSSchedulingHierarchy.NOSUSPEND);

	public final static Integer I_MERGE_LOCAL	= Integer.valueOf(SDMSSchedulingHierarchy.MERGE_LOCAL);
	public final static Integer I_MERGE_GLOBAL	= Integer.valueOf(SDMSSchedulingHierarchy.MERGE_GLOBAL);
	public final static Integer I_NOMERGE		= Integer.valueOf(SDMSSchedulingHierarchy.NOMERGE);
	public final static Integer I_FAILURE		= Integer.valueOf(SDMSSchedulingHierarchy.FAILURE);

	public final static Integer I_DD_ERROR		= Integer.valueOf(SDMSDependencyDefinition.ERROR);
	public final static Integer I_DD_IGNORE		= Integer.valueOf(SDMSDependencyDefinition.IGNORE);
	public final static Integer I_DD_INTERNAL	= Integer.valueOf(SDMSDependencyDefinition.INTERNAL);
	public final static Integer I_DD_EXTERNAL	= Integer.valueOf(SDMSDependencyDefinition.EXTERNAL);
	public final static Integer I_DD_BOTH		= Integer.valueOf(SDMSDependencyDefinition.BOTH);
	public final static Integer I_DD_SUSPEND	= Integer.valueOf(SDMSDependencyDefinition.SUSPEND);
	public final static Integer I_DD_DEFER		= Integer.valueOf(SDMSDependencyDefinition.DEFER);
	public final static Integer I_DD_DEFER_IGNORE	= Integer.valueOf(SDMSDependencyDefinition.DEFER_IGNORE);
	public final static Integer I_DD_ALL_FINAL	= Integer.valueOf(SDMSDependencyDefinition.ALL_FINAL);
	public final static Integer I_DD_JOB_FINAL	= Integer.valueOf(SDMSDependencyDefinition.JOB_FINAL);

	public final static Integer I_KEEP		= Integer.valueOf(SDMSResourceRequirement.KEEP);
	public final static Integer I_NOKEEP		= Integer.valueOf(SDMSResourceRequirement.NOKEEP);
	public final static Integer I_KEEP_FINAL	= Integer.valueOf(SDMSResourceRequirement.KEEP_FINAL);

	public final static Integer I_ADMINSUSPEND	= Integer.valueOf(SDMSSubmittedEntity.ADMINSUSPEND);
	public final static Integer I_LOCALSUSPEND	= Integer.valueOf(AlterJob.LOCALSUSPEND);
	public final static Integer I_LOCALADMINSUSPEND	= Integer.valueOf(AlterJob.LOCALADMINSUSPEND);

	public final static Integer I_TREE		= Integer.valueOf(ListSubmitted.TREE);
	public final static Integer I_LIST		= Integer.valueOf(ListSubmitted.LIST);

	public final static Integer I_SCE_LAST		= Integer.valueOf(SDMSScheduledEvent.LAST);
	public final static Integer I_SCE_ALL		= Integer.valueOf(SDMSScheduledEvent.ALL);
	public final static Integer I_SCE_NONE		= Integer.valueOf(SDMSScheduledEvent.NONE);

	public final static Integer I_LM_N		= Integer.valueOf(Lockmode.N);
	public final static Integer I_LM_S		= Integer.valueOf(Lockmode.S);
	public final static Integer I_LM_SX		= Integer.valueOf(Lockmode.SX);
	public final static Integer I_LM_SC		= Integer.valueOf(Lockmode.SC);
	public final static Integer I_LM_X		= Integer.valueOf(Lockmode.X);

	private static final HashMap mapper = new HashMap();

	static
	{
		mapper.put(Integer.valueOf(Parser.ACTION),			ParseStr.S_ACTION);
		mapper.put(Integer.valueOf(Parser.ACTIVE),			ParseStr.S_ACTIVE);
		mapper.put(Integer.valueOf(Parser.ADD),				ParseStr.S_ADD);
		mapper.put(Integer.valueOf(Parser.AFTER),			ParseStr.S_AFTER);
		mapper.put(Integer.valueOf(Parser.AFTER_FINAL),			ParseStr.S_AFTER_FINAL);
		mapper.put(Integer.valueOf(Parser.AGING),			ParseStr.S_AGING);
		mapper.put(Integer.valueOf(Parser.ALIAS),			ParseStr.S_ALIAS);
		mapper.put(Integer.valueOf(Parser.ALL),				ParseStr.S_ALL);
		mapper.put(Integer.valueOf(Parser.ALL_FINAL),			ParseStr.S_ALL_FINAL);
		mapper.put(Integer.valueOf(Parser.ALTER),			ParseStr.S_ALTER);
		mapper.put(Integer.valueOf(Parser.AMOUNT),			ParseStr.S_AMOUNT);
		mapper.put(Integer.valueOf(Parser.AND),				ParseStr.S_AND);
		mapper.put(Integer.valueOf(Parser.ANY),				ParseStr.S_ANY);
		mapper.put(Integer.valueOf(Parser.APPROVE),			ParseStr.S_APPROVE);
		mapper.put(Integer.valueOf(Parser.AVG),				ParseStr.S_AVG);
		mapper.put(Integer.valueOf(Parser.BACKLOG_HANDLING),		ParseStr.S_BACKLOG_HANDLING);
		mapper.put(Integer.valueOf(Parser.BACKUP),			ParseStr.S_BACKUP);
		mapper.put(Integer.valueOf(Parser.BASE),			ParseStr.S_BASE);
		mapper.put(Integer.valueOf(Parser.BATCH),			ParseStr.S_BATCH);
		mapper.put(Integer.valueOf(Parser.BEFORE),			ParseStr.S_BEFORE);
		mapper.put(Integer.valueOf(Parser.BEFORE_FINAL),		ParseStr.S_BEFORE_FINAL);
		mapper.put(Integer.valueOf(Parser.BMULTICMD),			ParseStr.S_BMULTICMD);
		mapper.put(Integer.valueOf(Parser.BROKEN),			ParseStr.S_BROKEN);
		mapper.put(Integer.valueOf(Parser.BROKEN_ACTIVE),		ParseStr.S_BROKEN_ACTIVE);
		mapper.put(Integer.valueOf(Parser.BROKEN_FINISHED),		ParseStr.S_BROKEN_FINISHED);
		mapper.put(Integer.valueOf(Parser.BY),				ParseStr.S_BY);
		mapper.put(Integer.valueOf(Parser.CALENDAR),			ParseStr.S_CALENDAR);
		mapper.put(Integer.valueOf(Parser.CANCEL),			ParseStr.S_CANCEL);
		mapper.put(Integer.valueOf(Parser.CANCELLED),			ParseStr.S_CANCELLED);
		mapper.put(Integer.valueOf(Parser.CASCADE),			ParseStr.S_CASCADE);
		mapper.put(Integer.valueOf(Parser.CATEGORY),			ParseStr.S_CATEGORY);
		mapper.put(Integer.valueOf(Parser.CHANGE),			ParseStr.S_CHANGE);
		mapper.put(Integer.valueOf(Parser.CHANGE_STATUS),		ParseStr.S_CHANGE_STATUS);
		mapper.put(Integer.valueOf(Parser.CHILD),			ParseStr.S_CHILD);
		mapper.put(Integer.valueOf(Parser.CHECK),			ParseStr.S_CHECK);
		mapper.put(Integer.valueOf(Parser.CHILDREN),			ParseStr.S_CHILDREN);
		mapper.put(Integer.valueOf(Parser.CHILDSUSPEND),		ParseStr.S_CHILDSUSPEND);
		mapper.put(Integer.valueOf(Parser.CHILDTAG),			ParseStr.S_CHILDTAG);
		mapper.put(Integer.valueOf(Parser.CLEANUP),			ParseStr.S_CLEANUP);
		mapper.put(Integer.valueOf(Parser.CLEAR),			ParseStr.S_CLEAR);
		mapper.put(Integer.valueOf(Parser.CLONE),			ParseStr.S_CLONE);
		mapper.put(Integer.valueOf(Parser.CMPOP),			ParseStr.S_CMPOP);
		mapper.put(Integer.valueOf(Parser.COMMAND),			ParseStr.S_COMMAND);
		mapper.put(Integer.valueOf(Parser.COMMENT),			ParseStr.S_COMMENT);
		mapper.put(Integer.valueOf(Parser.CONDENSED),			ParseStr.S_CONDENSED);
		mapper.put(Integer.valueOf(Parser.CONDITION),			ParseStr.S_CONDITION);
		mapper.put(Integer.valueOf(Parser.CONFIG),			ParseStr.S_CONFIG);
		mapper.put(Integer.valueOf(Parser.CONNECT),			ParseStr.S_CONNECT);
		mapper.put(Integer.valueOf(Parser.CONSTANT),			ParseStr.S_CONSTANT);
		mapper.put(Integer.valueOf(Parser.CONTENT),			ParseStr.S_CONTENT);
		mapper.put(Integer.valueOf(Parser.COPY),			ParseStr.S_COPY);
		mapper.put(Integer.valueOf(Parser.COUNT),			ParseStr.S_COUNT);
		mapper.put(Integer.valueOf(Parser.CREATE),			ParseStr.S_CREATE);
		mapper.put(Integer.valueOf(Parser.CYCLE),			ParseStr.S_CYCLE);
		mapper.put(Integer.valueOf(Parser.DAY),				ParseStr.S_DAY);
		mapper.put(Integer.valueOf(Parser.DEFAULT),			ParseStr.S_DEFAULT);
		mapper.put(Integer.valueOf(Parser.DEFAULT_MAPPING),		ParseStr.S_DEFAULT_MAPPING);
		mapper.put(Integer.valueOf(Parser.DEFER),			ParseStr.S_DEFER);
		mapper.put(Integer.valueOf(Parser.DEFINITION),			ParseStr.S_DEFINITION);
		mapper.put(Integer.valueOf(Parser.DELAY),			ParseStr.S_DELAY);
		mapper.put(Integer.valueOf(Parser.DELETE),			ParseStr.S_DELETE);
		mapper.put(Integer.valueOf(Parser.DEPENDENCY),			ParseStr.S_DEPENDENCY);
		mapper.put(Integer.valueOf(Parser.DEPENDENCY_DEFINITION),	ParseStr.S_DEPENDENCY_DEFINITION);
		mapper.put(Integer.valueOf(Parser.DEPENDENCY_HIERARCHY),	ParseStr.S_DEPENDENCY_HIERARCHY);
		mapper.put(Integer.valueOf(Parser.DEPENDENCY_MODE),		ParseStr.S_DEPENDENCY_MODE);
		mapper.put(Integer.valueOf(Parser.DEPENDENCY_WAIT),		ParseStr.S_DEPENDENCY_WAIT);
		mapper.put(Integer.valueOf(Parser.DEPLOY),			ParseStr.S_DEPLOY);
		mapper.put(Integer.valueOf(Parser.DEREGISTER),			ParseStr.S_DEREGISTER);
		mapper.put(Integer.valueOf(Parser.DIR),				ParseStr.S_DIR);
		mapper.put(Integer.valueOf(Parser.DISABLE),			ParseStr.S_DISABLE);
		mapper.put(Integer.valueOf(Parser.DISPATCH),			ParseStr.S_DISPATCH);
		mapper.put(Integer.valueOf(Parser.DISCONNECT),			ParseStr.S_DISCONNECT);
		mapper.put(Integer.valueOf(Parser.DROP),			ParseStr.S_DROP);
		mapper.put(Integer.valueOf(Parser.DUMP),			ParseStr.S_DUMP);
		mapper.put(Integer.valueOf(Parser.DURATION),			ParseStr.S_DURATION);
		mapper.put(Integer.valueOf(Parser.DYNAMIC),			ParseStr.S_DYNAMIC);
		mapper.put(Integer.valueOf(Parser.EDIT),			ParseStr.S_EDIT);
		mapper.put(Integer.valueOf(Parser.EMBEDDED),			ParseStr.S_EMBEDDED);
		mapper.put(Integer.valueOf(Parser.EMULTICMD),			ParseStr.S_EMULTICMD);
		mapper.put(Integer.valueOf(Parser.ENABLE),			ParseStr.S_ENABLE);
		mapper.put(Integer.valueOf(Parser.ENABLED),			ParseStr.S_ENABLED);
		mapper.put(Integer.valueOf(Parser.ENDTIME),			ParseStr.S_ENDTIME);
		mapper.put(Integer.valueOf(Parser.ENVIRONMENT),			ParseStr.S_ENVIRONMENT);
		mapper.put(Integer.valueOf(Parser.ERRLOG),			ParseStr.S_ERRLOG);
		mapper.put(Integer.valueOf(Parser.ERROR_TEXT),			ParseStr.S_ERROR_TEXT);
		mapper.put(Integer.valueOf(Parser.ERROR_TOKEN),			ParseStr.S_ERROR_TOKEN);
		mapper.put(Integer.valueOf(Parser.EQUIVALENT),			ParseStr.S_EQUIVALENT);
		mapper.put(Integer.valueOf(Parser.EVENT),			ParseStr.S_EVENT);
		mapper.put(Integer.valueOf(Parser.EXECUTE),			ParseStr.S_EXECUTE);
		mapper.put(Integer.valueOf(Parser.EXEC_PID),			ParseStr.S_EXEC_PID);
		mapper.put(Integer.valueOf(Parser.EXISTING),			ParseStr.S_EXISTING);
		mapper.put(Integer.valueOf(Parser.EXIT_CODE),			ParseStr.S_EXIT_CODE);
		mapper.put(Integer.valueOf(Parser.EXIT_STATUS),			ParseStr.S_EXIT_STATUS);
		mapper.put(Integer.valueOf(Parser.EXIT_STATUS_DEFINITION),	ParseStr.S_EXIT_STATUS_DEFINITION);
		mapper.put(Integer.valueOf(Parser.EXIT_STATUS_MAPPING),		ParseStr.S_EXIT_STATUS_MAPPING);
		mapper.put(Integer.valueOf(Parser.EXIT_STATUS_PROFILE),		ParseStr.S_EXIT_STATUS_PROFILE);
		mapper.put(Integer.valueOf(Parser.EXIT_STATUS_TRANSLATION),	ParseStr.S_EXIT_STATUS_TRANSLATION);
		mapper.put(Integer.valueOf(Parser.EXPAND),			ParseStr.S_EXPAND);
		mapper.put(Integer.valueOf(Parser.EXPIRED),			ParseStr.S_EXPIRED);
		mapper.put(Integer.valueOf(Parser.EXPORT),			ParseStr.S_EXPORT);
		mapper.put(Integer.valueOf(Parser.EXPR),			ParseStr.S_EXPR);
		mapper.put(Integer.valueOf(Parser.EXT_PID),			ParseStr.S_EXT_PID);
		mapper.put(Integer.valueOf(Parser.FACTOR),			ParseStr.S_FACTOR);
		mapper.put(Integer.valueOf(Parser.FAIL),			ParseStr.S_FAIL);
		mapper.put(Integer.valueOf(Parser.FAILURE),			ParseStr.S_FAILURE);
		mapper.put(Integer.valueOf(Parser.FATAL),			ParseStr.S_FATAL);
		mapper.put(Integer.valueOf(Parser.FILTER),			ParseStr.S_FILTER);
		mapper.put(Integer.valueOf(Parser.FINAL),			ParseStr.S_FINAL);
		mapper.put(Integer.valueOf(Parser.FINISH),			ParseStr.S_FINISH);
		mapper.put(Integer.valueOf(Parser.FINISH_CHILD),		ParseStr.S_FINISH_CHILD);
		mapper.put(Integer.valueOf(Parser.FINISHED),			ParseStr.S_FINISHED);
		mapper.put(Integer.valueOf(Parser.FOLDER),			ParseStr.S_FOLDER);
		mapper.put(Integer.valueOf(Parser.FOOTPRINT),			ParseStr.S_FOOTPRINT);
		mapper.put(Integer.valueOf(Parser.FOR),				ParseStr.S_FOR);
		mapper.put(Integer.valueOf(Parser.FORCE),			ParseStr.S_FORCE);
		mapper.put(Integer.valueOf(Parser.FORCED_EOC),			ParseStr.S_FORCED_EOC);
		mapper.put(Integer.valueOf(Parser.FREE_AMOUNT),			ParseStr.S_FREE_AMOUNT);
		mapper.put(Integer.valueOf(Parser.FREEPCT),			ParseStr.S_FREEPCT);
		mapper.put(Integer.valueOf(Parser.FROM),			ParseStr.S_FROM);
		mapper.put(Integer.valueOf(Parser.FUTURE),			ParseStr.S_FUTURE);
		mapper.put(Integer.valueOf(Parser.GET),				ParseStr.S_GET);
		mapper.put(Integer.valueOf(Parser.GET_NEXT_JOB),		ParseStr.S_GET_NEXT_JOB);
		mapper.put(Integer.valueOf(Parser.GLOBAL),			ParseStr.S_GLOBAL);
		mapper.put(Integer.valueOf(Parser.GRANT),			ParseStr.S_GRANT);
		mapper.put(Integer.valueOf(Parser.GROUP),			ParseStr.S_GROUP);
		mapper.put(Integer.valueOf(Parser.HEADER),			ParseStr.S_HEADER);
		mapper.put(Integer.valueOf(Parser.HISTORY),			ParseStr.S_HISTORY);
		mapper.put(Integer.valueOf(Parser.HORIZON),			ParseStr.S_HORIZON);
		mapper.put(Integer.valueOf(Parser.HOUR),			ParseStr.S_HOUR);
		mapper.put(Integer.valueOf(Parser.IDENTIFIED),			ParseStr.S_IDENTIFIED);
		mapper.put(Integer.valueOf(Parser.IDENTIFIER),			ParseStr.S_IDENTIFIER);
		mapper.put(Integer.valueOf(Parser.IGNORE),			ParseStr.S_IGNORE);
		mapper.put(Integer.valueOf(Parser.IGNORE_DEPENDENCY),		ParseStr.S_IGNORE_DEPENDENCY);
		mapper.put(Integer.valueOf(Parser.IMMEDIATE),			ParseStr.S_IMMEDIATE);
		mapper.put(Integer.valueOf(Parser.IMMEDIATE_LOCAL),		ParseStr.S_IMMEDIATE_LOCAL);
		mapper.put(Integer.valueOf(Parser.IMMEDIATE_MERGE),		ParseStr.S_IMMEDIATE_MERGE);
		mapper.put(Integer.valueOf(Parser.IMPORT),			ParseStr.S_IMPORT);
		mapper.put(Integer.valueOf(Parser.IN),				ParseStr.S_IN);
		mapper.put(Integer.valueOf(Parser.INACTIVE),			ParseStr.S_INACTIVE);
		mapper.put(Integer.valueOf(Parser.INFINITE),			ParseStr.S_INFINITE);
		mapper.put(Integer.valueOf(Parser.INFO),			ParseStr.S_INFO);
		mapper.put(Integer.valueOf(Parser.INHERIT),			ParseStr.S_INHERIT);
		mapper.put(Integer.valueOf(Parser.INITIAL_STATUS),		ParseStr.S_INITIAL_STATUS);
		mapper.put(Integer.valueOf(Parser.INSTANCE),			ParseStr.S_INSTANCE);
		mapper.put(Integer.valueOf(Parser.INTERVAL),			ParseStr.S_INTERVAL);
		mapper.put(Integer.valueOf(Parser.INVERSE),			ParseStr.S_INVERSE);
		mapper.put(Integer.valueOf(Parser.IS),				ParseStr.S_IS);
		mapper.put(Integer.valueOf(Parser.ISX),				ParseStr.S_ISX);
		mapper.put(Integer.valueOf(Parser.IX),				ParseStr.S_IX);
		mapper.put(Integer.valueOf(Parser.JOB),				ParseStr.S_JOB);
		mapper.put(Integer.valueOf(Parser.JOB_DEFINITION),		ParseStr.S_JOB_DEFINITION);
		mapper.put(Integer.valueOf(Parser.JOB_DEFINITION_HIERARCHY),	ParseStr.S_JOB_DEFINITION_HIERARCHY);
		mapper.put(Integer.valueOf(Parser.JOB_FINAL),			ParseStr.S_JOB_FINAL);
		mapper.put(Integer.valueOf(Parser.JOB_SERVER),			ParseStr.S_JOB_SERVER);
		mapper.put(Integer.valueOf(Parser.JOB_STATUS),			ParseStr.S_JOB_STATUS);
		mapper.put(Integer.valueOf(Parser.JSON),			ParseStr.S_JSON);
		mapper.put(Integer.valueOf(Parser.KEEP),			ParseStr.S_KEEP);
		mapper.put(Integer.valueOf(Parser.KEEP_FINAL),			ParseStr.S_KEEP_FINAL);
		mapper.put(Integer.valueOf(Parser.KILL),			ParseStr.S_KILL);
		mapper.put(Integer.valueOf(Parser.KILLED),			ParseStr.S_KILLED);
		mapper.put(Integer.valueOf(Parser.KILL_PROGRAM),		ParseStr.S_KILL_PROGRAM);
		mapper.put(Integer.valueOf(Parser.LANGUAGE),			ParseStr.S_LANGUAGE);
		mapper.put(Integer.valueOf(Parser.LAST),			ParseStr.S_LAST);
		mapper.put(Integer.valueOf(Parser.LEVEL),			ParseStr.S_LEVEL);
		mapper.put(Integer.valueOf(Parser.LIBERAL),			ParseStr.S_LIBERAL);
		mapper.put(Integer.valueOf(Parser.LIKE),			ParseStr.S_LIKE);
		mapper.put(Integer.valueOf(Parser.LIMIT),			ParseStr.S_LIMIT);
		mapper.put(Integer.valueOf(Parser.LINE),			ParseStr.S_LINE);
		mapper.put(Integer.valueOf(Parser.LIST),			ParseStr.S_LIST);
		mapper.put(Integer.valueOf(Parser.LOCAL),			ParseStr.S_LOCAL);
		mapper.put(Integer.valueOf(Parser.LOCAL_CONSTANT),		ParseStr.S_LOCAL_CONSTANT);
		mapper.put(Integer.valueOf(Parser.LOCK),			ParseStr.S_LOCK);
		mapper.put(Integer.valueOf(Parser.LOCKMODE),			ParseStr.S_LOCKMODE);
		mapper.put(Integer.valueOf(Parser.LOGFILE),			ParseStr.S_LOGFILE);
		mapper.put(Integer.valueOf(Parser.LOOPS),			ParseStr.S_LOOPS);
		mapper.put(Integer.valueOf(Parser.MAIN),			ParseStr.S_MAIN);
		mapper.put(Integer.valueOf(Parser.MANAGED),			ParseStr.S_MANAGED);
		mapper.put(Integer.valueOf(Parser.MAP),				ParseStr.S_MAP);
		mapper.put(Integer.valueOf(Parser.MAPPING),			ParseStr.S_MAPPING);
		mapper.put(Integer.valueOf(Parser.MAPS),			ParseStr.S_MAPS);
		mapper.put(Integer.valueOf(Parser.MASTER),			ParseStr.S_MASTER);
		mapper.put(Integer.valueOf(Parser.MASTER_ID),			ParseStr.S_MASTER_ID);
		mapper.put(Integer.valueOf(Parser.MAX),				ParseStr.S_MAX);
		mapper.put(Integer.valueOf(Parser.MAXPCT),			ParseStr.S_MAXPCT);
		mapper.put(Integer.valueOf(Parser.MERGE),			ParseStr.S_MERGE);
		mapper.put(Integer.valueOf(Parser.MERGED),			ParseStr.S_MERGED);
		mapper.put(Integer.valueOf(Parser.MERGE_GLOBAL),		ParseStr.S_MERGE_GLOBAL);
		mapper.put(Integer.valueOf(Parser.MERGE_LOCAL),			ParseStr.S_MERGE_LOCAL);
		mapper.put(Integer.valueOf(Parser.MERGE_MODE),			ParseStr.S_MERGE_MODE);
		mapper.put(Integer.valueOf(Parser.MILESTONE),			ParseStr.S_MILESTONE);
		mapper.put(Integer.valueOf(Parser.MIN),				ParseStr.S_MIN);
		mapper.put(Integer.valueOf(Parser.MINPCT),			ParseStr.S_MINPCT);
		mapper.put(Integer.valueOf(Parser.MINUTE),			ParseStr.S_MINUTE);
		mapper.put(Integer.valueOf(Parser.MODE),			ParseStr.S_MODE);
		mapper.put(Integer.valueOf(Parser.MONITOR),			ParseStr.S_MONITOR);
		mapper.put(Integer.valueOf(Parser.MONTH),			ParseStr.S_MONTH);
		mapper.put(Integer.valueOf(Parser.MOVE),			ParseStr.S_MOVE);
		mapper.put(Integer.valueOf(Parser.MULTICOMMAND),		ParseStr.S_MULTICOMMAND);
		mapper.put(Integer.valueOf(Parser.MULTIPLIER),			ParseStr.S_MULTIPLIER);
		mapper.put(Integer.valueOf(Parser.N),				ParseStr.S_N);
		mapper.put(Integer.valueOf(Parser.NAME),			ParseStr.S_NAME);
		mapper.put(Integer.valueOf(Parser.NAMED_RESOURCE),		ParseStr.S_NAMED_RESOURCE);
		mapper.put(Integer.valueOf(Parser.NICEVALUE),			ParseStr.S_NICEVALUE);
		mapper.put(Integer.valueOf(Parser.NODE),			ParseStr.S_NODE);
		mapper.put(Integer.valueOf(Parser.NOINVERSE),			ParseStr.S_NOINVERSE);
		mapper.put(Integer.valueOf(Parser.NOKEEP),			ParseStr.S_NOKEEP);
		mapper.put(Integer.valueOf(Parser.NOMASTER),			ParseStr.S_NOMASTER);
		mapper.put(Integer.valueOf(Parser.NOMERGE),			ParseStr.S_NOMERGE);
		mapper.put(Integer.valueOf(Parser.NOMINALPCT),			ParseStr.S_NOMINALPCT);
		mapper.put(Integer.valueOf(Parser.NONE),			ParseStr.S_NONE);
		mapper.put(Integer.valueOf(Parser.NONFATAL),			ParseStr.S_NONFATAL);
		mapper.put(Integer.valueOf(Parser.NOSTICKY),			ParseStr.S_NOSTICKY);
		mapper.put(Integer.valueOf(Parser.NOSUSPEND),			ParseStr.S_NOSUSPEND);
		mapper.put(Integer.valueOf(Parser.NOT),				ParseStr.S_NOT);
		mapper.put(Integer.valueOf(Parser.NOTRACE),			ParseStr.S_NOTRACE);
		mapper.put(Integer.valueOf(Parser.NOTRUNC),			ParseStr.S_NOTRUNC);
		mapper.put(Integer.valueOf(Parser.OBJECT),			ParseStr.S_OBJECT);
		mapper.put(Integer.valueOf(Parser.OF),				ParseStr.S_OF);
		mapper.put(Integer.valueOf(Parser.OFFLINE),			ParseStr.S_OFFLINE);
		mapper.put(Integer.valueOf(Parser.ON),				ParseStr.S_ON);
		mapper.put(Integer.valueOf(Parser.ONLINE),			ParseStr.S_ONLINE);
		mapper.put(Integer.valueOf(Parser.ONLY),			ParseStr.S_ONLY);
		mapper.put(Integer.valueOf(Parser.OPERATE),			ParseStr.S_OPERATE);
		mapper.put(Integer.valueOf(Parser.OR),				ParseStr.S_OR);
		mapper.put(Integer.valueOf(Parser.OWNER),			ParseStr.S_OWNER);
		mapper.put(Integer.valueOf(Parser.PARENT),			ParseStr.S_PARENT);
		mapper.put(Integer.valueOf(Parser.PARAMETERS),			ParseStr.S_PARAMETERS);
		mapper.put(Integer.valueOf(Parser.PASSWORD),			ParseStr.S_PASSWORD);
		mapper.put(Integer.valueOf(Parser.PATH),			ParseStr.S_PATH);
		mapper.put(Integer.valueOf(Parser.PENDING),			ParseStr.S_PENDING);
		mapper.put(Integer.valueOf(Parser.PERL),			ParseStr.S_PERL);
		mapper.put(Integer.valueOf(Parser.PID),				ParseStr.S_PID);
		mapper.put(Integer.valueOf(Parser.PRIORITY),			ParseStr.S_PRIORITY);
		mapper.put(Integer.valueOf(Parser.PROFILE),			ParseStr.S_PROFILE);
		mapper.put(Integer.valueOf(Parser.PROTOCOL),			ParseStr.S_PROTOCOL);
		mapper.put(Integer.valueOf(Parser.PUBLIC),			ParseStr.S_PUBLIC);
		mapper.put(Integer.valueOf(Parser.PYTHON),			ParseStr.S_PYTHON);
		mapper.put(Integer.valueOf(Parser.RAWPASSWORD),			ParseStr.S_RAWPASSWORD);
		mapper.put(Integer.valueOf(Parser.REACHABLE),			ParseStr.S_REACHABLE);
		mapper.put(Integer.valueOf(Parser.READ),			ParseStr.S_READ);
		mapper.put(Integer.valueOf(Parser.REASSURE),			ParseStr.S_REASSURE);
		mapper.put(Integer.valueOf(Parser.RECREATE),			ParseStr.S_RECREATE);
		mapper.put(Integer.valueOf(Parser.RECURSIVE),			ParseStr.S_RECURSIVE);
		mapper.put(Integer.valueOf(Parser.REFERENCE),			ParseStr.S_REFERENCE);
		mapper.put(Integer.valueOf(Parser.REGISTER),			ParseStr.S_REGISTER);
		mapper.put(Integer.valueOf(Parser.REJECT),			ParseStr.S_REJECT);
		mapper.put(Integer.valueOf(Parser.RENAME),			ParseStr.S_RENAME);
		mapper.put(Integer.valueOf(Parser.RENICE),			ParseStr.S_RENICE);
		mapper.put(Integer.valueOf(Parser.REQUIRED),			ParseStr.S_REQUIRED);
		mapper.put(Integer.valueOf(Parser.REQUESTABLE_AMOUNT),		ParseStr.S_REQUESTABLE_AMOUNT);
		mapper.put(Integer.valueOf(Parser.RERUN),			ParseStr.S_RERUN);
		mapper.put(Integer.valueOf(Parser.RERUN_PROGRAM),		ParseStr.S_RERUN_PROGRAM);
		mapper.put(Integer.valueOf(Parser.RESOLVE),			ParseStr.S_RESOLVE);
		mapper.put(Integer.valueOf(Parser.RESOURCE),			ParseStr.S_RESOURCE);
		mapper.put(Integer.valueOf(Parser.RESOURCE_STATUS),		ParseStr.S_RESOURCE_STATUS);
		mapper.put(Integer.valueOf(Parser.RESOURCE_STATUS_DEFINITION),	ParseStr.S_RESOURCE_STATUS_DEFINITION);
		mapper.put(Integer.valueOf(Parser.RESOURCE_STATUS_MAPPING),	ParseStr.S_RESOURCE_STATUS_MAPPING);
		mapper.put(Integer.valueOf(Parser.RESOURCE_STATUS_PROFILE),	ParseStr.S_RESOURCE_STATUS_PROFILE);
		mapper.put(Integer.valueOf(Parser.RESOURCE_TEMPLATE),		ParseStr.S_RESOURCE_TEMPLATE);
		mapper.put(Integer.valueOf(Parser.RESOURCE_WAIT),		ParseStr.S_RESOURCE_WAIT);
		mapper.put(Integer.valueOf(Parser.RESTARTABLE),			ParseStr.S_RESTARTABLE);
		mapper.put(Integer.valueOf(Parser.RESTRICT),			ParseStr.S_RESTRICT);
		mapper.put(Integer.valueOf(Parser.RESULT),			ParseStr.S_RESULT);
		mapper.put(Integer.valueOf(Parser.RESUME),			ParseStr.S_RESUME);
		mapper.put(Integer.valueOf(Parser.REVOKE),			ParseStr.S_REVOKE);
		mapper.put(Integer.valueOf(Parser.ROOT),			ParseStr.S_ROOT);
		mapper.put(Integer.valueOf(Parser.RUN),				ParseStr.S_RUN);
		mapper.put(Integer.valueOf(Parser.RUNNABLE),			ParseStr.S_RUNNABLE);
		mapper.put(Integer.valueOf(Parser.RUNNING),			ParseStr.S_RUNNING);
		mapper.put(Integer.valueOf(Parser.RUNTIME),			ParseStr.S_RUNTIME);
		mapper.put(Integer.valueOf(Parser.RUN_PROGRAM),			ParseStr.S_RUN_PROGRAM);
		mapper.put(Integer.valueOf(Parser.S),				ParseStr.S_S);
		mapper.put(Integer.valueOf(Parser.SC),				ParseStr.S_SC);
		mapper.put(Integer.valueOf(Parser.SCHEDULE),			ParseStr.S_SCHEDULE);
		mapper.put(Integer.valueOf(Parser.SCHEDULED_EVENT),		ParseStr.S_SCHEDULED_EVENT);
		mapper.put(Integer.valueOf(Parser.SCOPE),			ParseStr.S_SCOPE);
		mapper.put(Integer.valueOf(Parser.SELECT),			ParseStr.S_SELECT);
		mapper.put(Integer.valueOf(Parser.SELECTION),			ParseStr.S_SELECTION);
		mapper.put(Integer.valueOf(Parser.SERIAL),			ParseStr.S_SERIAL);
		mapper.put(Integer.valueOf(Parser.SERVER),			ParseStr.S_SERVER);
		mapper.put(Integer.valueOf(Parser.SESSION),			ParseStr.S_SESSION);
		mapper.put(Integer.valueOf(Parser.SET),				ParseStr.S_SET);
		mapper.put(Integer.valueOf(Parser.SHOW),			ParseStr.S_SHOW);
		mapper.put(Integer.valueOf(Parser.SHUTDOWN),			ParseStr.S_SHUTDOWN);
		mapper.put(Integer.valueOf(Parser.SORT),			ParseStr.S_SORT);
		mapper.put(Integer.valueOf(Parser.STARTED),			ParseStr.S_STARTED);
		mapper.put(Integer.valueOf(Parser.STARTING),			ParseStr.S_STARTING);
		mapper.put(Integer.valueOf(Parser.STARTTIME),			ParseStr.S_STARTTIME);
		mapper.put(Integer.valueOf(Parser.STATIC),			ParseStr.S_STATIC);
		mapper.put(Integer.valueOf(Parser.STATUS),			ParseStr.S_STATUS);
		mapper.put(Integer.valueOf(Parser.STATUS_MAPPING),		ParseStr.S_STATUS_MAPPING);
		mapper.put(Integer.valueOf(Parser.STATUS_PROFILE),		ParseStr.S_STATUS_PROFILE);
		mapper.put(Integer.valueOf(Parser.STICKY),			ParseStr.S_STICKY);
		mapper.put(Integer.valueOf(Parser.STOP),			ParseStr.S_STOP);
		mapper.put(Integer.valueOf(Parser.STRICT),			ParseStr.S_STRICT);
		mapper.put(Integer.valueOf(Parser.STRING),			ParseStr.S_STRING);
		mapper.put(Integer.valueOf(Parser.SUBMIT),			ParseStr.S_SUBMIT);
		mapper.put(Integer.valueOf(Parser.SUBMITCOUNT),			ParseStr.S_SUBMITCOUNT);
		mapper.put(Integer.valueOf(Parser.SUBMITTAG),			ParseStr.S_SUBMITTAG);
		mapper.put(Integer.valueOf(Parser.SUBMITTED),			ParseStr.S_SUBMITTED);
		mapper.put(Integer.valueOf(Parser.SUBMITTING_USER),		ParseStr.S_SUBMITTING_USER);
		mapper.put(Integer.valueOf(Parser.SUM),				ParseStr.S_SUM);
		mapper.put(Integer.valueOf(Parser.SUSPEND),			ParseStr.S_SUSPEND);
		mapper.put(Integer.valueOf(Parser.SUSPEND_LIMIT),		ParseStr.S_SUSPEND_LIMIT);
		mapper.put(Integer.valueOf(Parser.SUSPENDED),			ParseStr.S_SUSPENDED);
		mapper.put(Integer.valueOf(Parser.SX),				ParseStr.S_SX);
		mapper.put(Integer.valueOf(Parser.SYNCHRONIZE_WAIT),		ParseStr.S_SYNCHRONIZE_WAIT);
		mapper.put(Integer.valueOf(Parser.SYNCHRONIZING),		ParseStr.S_SYNCHRONIZING);
		mapper.put(Integer.valueOf(Parser.SYNCTIME),			ParseStr.S_SYNCTIME);
		mapper.put(Integer.valueOf(Parser.SYSTEM),			ParseStr.S_SYSTEM);
		mapper.put(Integer.valueOf(Parser.TAG),				ParseStr.S_TAG);
		mapper.put(Integer.valueOf(Parser.TEST),			ParseStr.S_TEST);
		mapper.put(Integer.valueOf(Parser.TEXT),			ParseStr.S_TEXT);
		mapper.put(Integer.valueOf(Parser.TIME),			ParseStr.S_TIME);
		mapper.put(Integer.valueOf(Parser.TIMEOUT),			ParseStr.S_TIMEOUT);
		mapper.put(Integer.valueOf(Parser.TIMESTAMP),			ParseStr.S_TIMESTAMP);
		mapper.put(Integer.valueOf(Parser.TO),				ParseStr.S_TO);
		mapper.put(Integer.valueOf(Parser.TO_KILL),			ParseStr.S_TO_KILL);
		mapper.put(Integer.valueOf(Parser.TOKEN),			ParseStr.S_TOKEN);
		mapper.put(Integer.valueOf(Parser.TOUCH),			ParseStr.S_TOUCH);
		mapper.put(Integer.valueOf(Parser.TRACE),			ParseStr.S_TRACE);
		mapper.put(Integer.valueOf(Parser.TRANSLATION),			ParseStr.S_TRANSLATION);
		mapper.put(Integer.valueOf(Parser.TREE),			ParseStr.S_TREE);
		mapper.put(Integer.valueOf(Parser.TRIGGER),			ParseStr.S_TRIGGER);
		mapper.put(Integer.valueOf(Parser.TRUNC),			ParseStr.S_TRUNC);
		mapper.put(Integer.valueOf(Parser.TYPE),			ParseStr.S_TYPE);
		mapper.put(Integer.valueOf(Parser.UNREACHABLE),			ParseStr.S_UNREACHABLE);
		mapper.put(Integer.valueOf(Parser.UNRESOLVED),			ParseStr.S_UNRESOLVED);
		mapper.put(Integer.valueOf(Parser.UNTIL_FINAL),			ParseStr.S_UNTIL_FINAL);
		mapper.put(Integer.valueOf(Parser.UNTIL_FINISHED),		ParseStr.S_UNTIL_FINISHED);
		mapper.put(Integer.valueOf(Parser.UPDATE),			ParseStr.S_UPDATE);
		mapper.put(Integer.valueOf(Parser.URL),				ParseStr.S_URL);
		mapper.put(Integer.valueOf(Parser.USAGE),			ParseStr.S_USAGE);
		mapper.put(Integer.valueOf(Parser.USE),				ParseStr.S_USE);
		mapper.put(Integer.valueOf(Parser.USER),			ParseStr.S_USER);
		mapper.put(Integer.valueOf(Parser.VALUE),			ParseStr.S_VALUE);
		mapper.put(Integer.valueOf(Parser.VERSION),			ParseStr.S_VERSION);
		mapper.put(Integer.valueOf(Parser.VIEW),			ParseStr.S_VIEW);
		mapper.put(Integer.valueOf(Parser.WARN),			ParseStr.S_WARN);
		mapper.put(Integer.valueOf(Parser.WARNING),			ParseStr.S_WARNING);
		mapper.put(Integer.valueOf(Parser.WATCHER),			ParseStr.S_WATCHER);
		mapper.put(Integer.valueOf(Parser.WEEK),			ParseStr.S_WEEK);
		mapper.put(Integer.valueOf(Parser.WITH),			ParseStr.S_WITH);
		mapper.put(Integer.valueOf(Parser.WORKDIR),			ParseStr.S_WORKDIR);
		mapper.put(Integer.valueOf(Parser.X),				ParseStr.S_X);
		mapper.put(Integer.valueOf(Parser.XML),				ParseStr.S_XML);
		mapper.put(Integer.valueOf(Parser.YEAR),			ParseStr.S_YEAR);
	}

	private ParseStr() {  }

	public static String map(Integer k)
	{
		String rc = (String) mapper.get(k);
		if (rc == null) {
			System.out.println(Here.at() + "\nCouldn't find a matching string for symbol " + k.toString());
		}
		return rc;
	}
}
