/*
Copyright (c) 2000-2013 "independIT Integrative Technologies GmbH",
Authors: Ronald Jeninga, Dieter Stubler

schedulix Enterprise Job Scheduling System

independIT Integrative Technologies GmbH [http://www.independit.de]
mailto:contact@independit.de

This file is part of schedulix

schedulix is free software:
you can redistribute it and/or modify it under the terms of the
GNU Affero General Public License as published by the
Free Software Foundation, either version 3 of the License,
or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/


package de.independit.scheduler.server.parser.filter;

import java.io.*;
import java.util.*;
import java.lang.*;

import de.independit.scheduler.server.*;
import de.independit.scheduler.server.repository.*;
import de.independit.scheduler.server.exception.*;

public class NodeFilter extends Filter
{
	Vector nodenames;
	HashSet nodes = null;

	public NodeFilter(SystemEnvironment sysEnv, Vector v)
	{
		super();
		nodenames = v;
	}

	public boolean valid(SystemEnvironment sysEnv, SDMSProxy p)
		throws SDMSException
	{
		try {
			SDMSSubmittedEntity sme = (SDMSSubmittedEntity) p;
			if(nodes == null) {
				nodes = new HashSet();
				for(int i = 0; i < nodenames.size(); i++) {
					Vector sv = SDMSScopeTable.idx_node.getVector(sysEnv, nodenames.get(i));
					for(int j = 0; j < sv.size(); j++) {
						nodes.add(((SDMSScope) sv.get(i)).getId(sysEnv));
					}
				}
			}
			if(nodes.contains(sme.getScopeId(sysEnv))) return true;
		} catch (Exception e) { }
		return false;
	}

	public boolean equals(Object o)
	{
		if (o == this) return true;
		if (!(o instanceof NodeFilter)) return false;
		NodeFilter f;
		f = (NodeFilter) o;

		if (nodenames.size() != f.nodenames.size()) return false;
		for (int i = 0; i < nodenames.size(); ++i)
			if (!f.nodenames.contains(nodenames.get(i))) return false;
		return true;
	}
}

