// created by jay 1.1.0 (c) 2002-2006 ats@cs.rit.edu
// skeleton Java tables 1.1.0 (c) 2002-2006 ats@cs.rit.edu

					// line 2 "ExprParser.jay"
//
// $Id: ExprParser.jay,v 1.8.14.1 2013/03/14 10:25:16 ronald Exp $
//
// Copyright (C) 2004 independIT Integrative Technologies GmbH
//
//

package de.independit.scheduler.server.parser.triggerexpr;

import java.io.*;
import java.util.*;
import java.lang.*;
import java.math.*;
import java.text.*;
import de.independit.scheduler.server.repository.*;
import de.independit.scheduler.server.exception.*;
import de.independit.scheduler.server.parser.*;
import de.independit.scheduler.server.output.*;
import de.independit.scheduler.server.util.*;
import de.independit.scheduler.server.*;

public class ExprParser 
{

	private int stop = 0;
	private SDMSSubmittedEntity sme = null;
	private SDMSSubmittedEntity requiredSme = null;
	private SDMSResource r = null;
	private SDMSTrigger t = null;
	private SDMSTriggerQueue tq = null;
	private SystemEnvironment sysEnv = null;
	private SDMSScope evalScope = null;
	public boolean checkOnly = false;
	private static boolean debug = SystemEnvironment.traceExpressions;

	// Names of Trigger Variables
	public static final String S_TIMES_CHECKED = "TIMES_CHECKED";
	public static final String S_TIMES_FIRED   = "TIMES_FIRED";

	private static final String emptyString = "";

	private static Integer I_PLUS = Integer.valueOf(278);
	private static Integer I_MINUS = Integer.valueOf(276);

	private static Integer I_TIMES = Integer.valueOf(279);
	private static Integer I_DIV = Integer.valueOf(275);
	private static Integer I_MOD = Integer.valueOf(277);

	private static Integer I_GT = Integer.valueOf(268);
	private static Integer I_GE = Integer.valueOf(269);
	private static Integer I_LT = Integer.valueOf(270);
	private static Integer I_LE = Integer.valueOf(271);
	private static Integer I_EQ = Integer.valueOf(267);
	private static Integer I_NE = Integer.valueOf(272);
	private static Integer I_MATCHES = Integer.valueOf(273);
	private static Integer I_NOMATCH = Integer.valueOf(274);
					// line 62 "-"
  // %token constants
  public static final int STRING = 257;
  public static final int IDENTIFIER = 258;
  public static final int PARAMETER = 259;
  public static final int JPARAMETER = 260;
  public static final int RPARAMETER = 261;
  public static final int TPARAMETER = 262;
  public static final int RSPARAMETER = 263;
  public static final int DSPARAMETER = 264;
  public static final int NUMBER = 265;
  public static final int BOOLEAN = 266;
  public static final int EQ = 267;
  public static final int GT = 268;
  public static final int GE = 269;
  public static final int LT = 270;
  public static final int LE = 271;
  public static final int NE = 272;
  public static final int MATCHES = 273;
  public static final int NOMATCH = 274;
  public static final int DIV = 275;
  public static final int MINUS = 276;
  public static final int MOD = 277;
  public static final int PLUS = 278;
  public static final int TIMES = 279;
  public static final int ABS = 280;
  public static final int AND = 281;
  public static final int DATE = 282;
  public static final int FIELD = 283;
  public static final int INT = 284;
  public static final int LOWERCASE = 285;
  public static final int NOT = 286;
  public static final int NVL = 287;
  public static final int OR = 288;
  public static final int ROUND = 289;
  public static final int SUBSTR = 290;
  public static final int STR = 291;
  public static final int TRIM = 292;
  public static final int UPPERCASE = 293;
  public static final int yyErrorCode = 256;

  /** number of final states.
  */
  protected static final int yyFinal = 25;

  /** parser tables.
      Cannot be <tt>final</tt> because they are loaded from a resource.
      Order is mandated by <i>jay</i>.
  */
  protected static short[] yyLhs, yyLen, yyDefRed, yyDgoto,
  	yySindex, yyRindex, yyGindex, yyTable, yyCheck;

//yyLhs 54
//yy    -1,     0,     0,     0,     8,     8,     7,     7,     6,     6,
//yy     6,     6,     1,     1,     5,     5,     9,     9,    10,    10,
//yy    10,    11,    11,    11,    11,    11,    11,    11,    11,     4,
//yy     4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
//yy     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
//yy     2,     2,     3,     3,
//yyLen 54
//yy     2,     0,     1,     1,     1,     3,     1,     3,     3,     2,
//yy     3,     1,     1,     3,     1,     3,     1,     1,     1,     1,
//yy     1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
//yy     2,     1,     1,     1,     1,     1,     1,     1,     1,     7,
//yy     4,     4,     6,     4,     4,     6,     4,     4,     8,     6,
//yy     4,     4,     1,     1,
//yyDefRed 112
//yy     0,    53,    31,    32,    33,    34,    35,    36,    52,    11,
//yy    17,    16,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,    38,    37,    14,
//yy     0,     6,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     9,     0,     0,     0,     0,     0,     0,     0,     0,
//yy    25,    21,    22,    23,    24,    26,    27,    28,     0,     0,
//yy    19,    20,    18,     0,     0,     0,     0,    30,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,    29,
//yy     8,     0,     0,     0,    15,     7,     0,     0,    40,     0,
//yy    43,    41,    44,     0,    46,     0,    47,    50,    51,     0,
//yy     0,     0,     0,     0,    42,    45,    49,     0,     0,     0,
//yy    39,    48,
//yyDgoto 12
//yy    25,    40,    27,    28,    29,    30,    31,    32,    33,    34,
//yy    63,    59,
//yySindex 112
//yy   -40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,   -35,   -27,   -26,   -22,   -17,   -40,   -12,    -9,
//yy    -7,    -6,    -5,    -4,   -40,     0,  -152,     0,     0,     0,
//yy  -267,     0,  -272,  -251,    54,    54,    54,  -220,    54,    54,
//yy  -152,     0,    54,    54,    54,    54,    54,    54,   -39,   -34,
//yy     0,     0,     0,     0,     0,     0,     0,     0,    54,    54,
//yy     0,     0,     0,    54,   -40,   -40,   -40,     0,   -20,    44,
//yy    -2,   -15,   -14,    45,   -11,    48,     2,     5,     8,     0,
//yy     0,    54,  -267,  -259,     0,     0,  -272,   -47,     0,    54,
//yy     0,     0,     0,    54,     0,    54,     0,     0,     0,    49,
//yy     9,    12,   -19,    54,     0,     0,     0,    54,    28,    31,
//yy     0,     0,
//yyRindex 112
//yy    40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,    41,     0,     0,     0,
//yy     1,     0,    11,    47,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,    24,    20,     0,     0,    15,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,
//yyGindex 12
//yy     0,    66,     0,     0,   -31,    -3,   -13,   -21,   -18,   103,
//yy     0,     0,
//yyTable 348
//yy    24,    12,    79,    67,    41,    35,    49,    80,    60,    64,
//yy    61,     4,    62,    36,    37,     5,    81,    10,    38,    11,
//yy    10,    88,   106,    39,    13,   107,    91,    92,    42,    81,
//yy    94,    43,    84,    44,    45,    46,    47,    65,    70,    90,
//yy     1,     3,    12,    96,    86,    12,    97,     2,    87,    98,
//yy   104,    85,     4,   105,     0,    82,     5,     0,     0,    12,
//yy     0,    10,     0,     0,    12,    13,    26,     0,    13,   110,
//yy     0,     0,   111,     0,     4,     0,     0,     0,     5,     0,
//yy     0,     0,    13,    10,     0,     0,     0,    13,    89,    93,
//yy    48,     0,    95,     0,    66,     0,     0,     0,     0,     0,
//yy     0,    68,    69,     0,    71,    72,     0,   103,    73,    74,
//yy    75,    76,    77,    78,     0,    50,    51,    52,    53,    54,
//yy    55,    56,    57,     0,    10,    83,    11,     0,     0,    58,
//yy     0,     0,    48,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,     0,    58,     0,     0,     0,    99,     0,     0,
//yy     0,    58,     0,     0,     0,   100,     0,     0,     0,   101,
//yy     0,   102,     0,     0,     0,     0,     0,     0,     0,   108,
//yy     0,    58,    58,   109,    58,    58,    58,    58,    58,    58,
//yy    58,    58,     0,     0,     0,     0,    58,     0,     0,     0,
//yy     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
//yy     0,     0,    58,    58,    58,    58,     0,     0,     0,     0,
//yy     0,    58,    58,     0,     0,     0,     0,     1,     0,     2,
//yy     3,     4,     5,     6,     7,     8,     9,     0,    50,    51,
//yy    52,    53,    54,    55,    56,    57,    10,    10,    11,    11,
//yy    12,    65,    13,    14,    15,    16,    17,    18,     0,    19,
//yy    20,    21,    22,    23,    65,     0,    10,    10,    11,    11,
//yy     0,    10,    10,    11,    11,    10,     0,    11,    12,    12,
//yy    12,    12,    12,    12,    12,    12,     0,    12,    10,    12,
//yy    11,    10,    12,    11,    10,    10,    11,    11,    10,    12,
//yy    11,    13,    13,    13,    13,    13,    13,    13,    13,     4,
//yy    13,    10,    13,     5,    10,    13,    11,    10,    10,    11,
//yy     0,     1,    13,     2,     3,     4,     5,     6,     7,     8,
//yy    10,    10,    11,    11,    10,    10,    11,    11,     0,     0,
//yy    10,     0,    11,     0,    12,     0,    13,    14,    15,    16,
//yy     0,    18,     0,    19,    20,    21,    22,    23,
//yyCheck 348
//yy    40,     0,    41,    34,    17,    40,    24,    41,   275,   281,
//yy   277,     0,   279,    40,    40,     0,    63,   276,    40,   278,
//yy     0,    41,    41,    40,     0,    44,    41,    41,    40,    63,
//yy    41,    40,    63,    40,    40,    40,    40,   288,   258,    41,
//yy     0,     0,    41,    41,    65,    44,    41,     0,    66,    41,
//yy    41,    64,    41,    41,    -1,    58,    41,    -1,    -1,    58,
//yy    -1,    41,    -1,    -1,    63,    41,     0,    -1,    44,    41,
//yy    -1,    -1,    41,    -1,    63,    -1,    -1,    -1,    63,    -1,
//yy    -1,    -1,    58,    63,    -1,    -1,    -1,    63,    44,    44,
//yy    24,    -1,    44,    -1,    40,    -1,    -1,    -1,    -1,    -1,
//yy    -1,    35,    36,    -1,    38,    39,    -1,    58,    42,    43,
//yy    44,    45,    46,    47,    -1,   267,   268,   269,   270,   271,
//yy   272,   273,   274,    -1,   276,    59,   278,    -1,    -1,    26,
//yy    -1,    -1,    66,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
//yy    -1,    -1,    -1,    40,    -1,    -1,    -1,    81,    -1,    -1,
//yy    -1,    48,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,
//yy    -1,    95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   103,
//yy    -1,    68,    69,   107,    71,    72,    73,    74,    75,    76,
//yy    77,    78,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,
//yy    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
//yy    -1,    -1,    99,   100,   101,   102,    -1,    -1,    -1,    -1,
//yy    -1,   108,   109,    -1,    -1,    -1,    -1,   257,    -1,   259,
//yy   260,   261,   262,   263,   264,   265,   266,    -1,   267,   268,
//yy   269,   270,   271,   272,   273,   274,   276,   276,   278,   278,
//yy   280,   288,   282,   283,   284,   285,   286,   287,    -1,   289,
//yy   290,   291,   292,   293,   288,    -1,   276,   276,   278,   278,
//yy    -1,   276,   276,   278,   278,   276,    -1,   278,   267,   268,
//yy   269,   270,   271,   272,   273,   274,    -1,   276,   276,   278,
//yy   278,   276,   281,   278,   276,   276,   278,   278,   276,   288,
//yy   278,   267,   268,   269,   270,   271,   272,   273,   274,   288,
//yy   276,   281,   278,   288,   276,   281,   278,   276,   288,   278,
//yy    -1,   257,   288,   259,   260,   261,   262,   263,   264,   265,
//yy   276,   276,   278,   278,   276,   276,   278,   278,    -1,    -1,
//yy   276,    -1,   278,    -1,   280,    -1,   282,   283,   284,   285,
//yy    -1,   287,    -1,   289,   290,   291,   292,   293,

  /** maps symbol value to printable name.
  		@see #yyExpecting
  	*/
  protected static String[] yyNames;
//yyNames 294 43
//yy 0 end-of-file
//yy 257 STRING
//yy 258 IDENTIFIER
//yy 259 PARAMETER
//yy 260 JPARAMETER
//yy 261 RPARAMETER
//yy 262 TPARAMETER
//yy 263 RSPARAMETER
//yy 264 DSPARAMETER
//yy 265 NUMBER
//yy 266 BOOLEAN
//yy 267 EQ
//yy 268 GT
//yy 269 GE
//yy 270 LT
//yy 271 LE
//yy 272 NE
//yy 273 MATCHES
//yy 274 NOMATCH
//yy 275 DIV
//yy 276 MINUS
//yy 277 MOD
//yy 278 PLUS
//yy 279 TIMES
//yy 280 ABS
//yy 281 AND
//yy 282 DATE
//yy 283 FIELD
//yy 284 INT
//yy 285 LOWERCASE
//yy 286 NOT
//yy 287 NVL
//yy 288 OR
//yy 289 ROUND
//yy 290 SUBSTR
//yy 291 STR
//yy 292 TRIM
//yy 293 UPPERCASE
//yy 40 '('
//yy 41 ')'
//yy 63 '?'
//yy 58 ':'
//yy 44 ','

//t  /** printable rules for debugging.
//t  	*/
//t  protected static String[] yyRule;
//t
//yyRule 54
//yy $accept: triggerexp
//yy triggerexp:
//yy triggerexp: boolexp
//yy triggerexp: expression
//yy boolexp: boolterm
//yy boolexp: boolexp OR boolterm
//yy boolterm: booloperand
//yy boolterm: boolterm AND booloperand
//yy booloperand: '(' boolexp ')'
//yy booloperand: NOT booloperand
//yy booloperand: expression comparison expression
//yy booloperand: BOOLEAN
//yy expression: term
//yy expression: expression addop term
//yy term: operand
//yy term: term multop operand
//yy addop: PLUS
//yy addop: MINUS
//yy multop: TIMES
//yy multop: DIV
//yy multop: MOD
//yy comparison: GT
//yy comparison: GE
//yy comparison: LT
//yy comparison: LE
//yy comparison: EQ
//yy comparison: NE
//yy comparison: MATCHES
//yy comparison: NOMATCH
//yy operand: '(' expression ')'
//yy operand: addop operand
//yy operand: PARAMETER
//yy operand: JPARAMETER
//yy operand: RPARAMETER
//yy operand: TPARAMETER
//yy operand: RSPARAMETER
//yy operand: DSPARAMETER
//yy operand: literal
//yy operand: function
//yy operand: '(' boolexp '?' expression ':' expression ')'
//yy function: ABS '(' expression ')'
//yy function: INT '(' expression ')'
//yy function: DATE '(' expression ',' expression ')'
//yy function: FIELD '(' IDENTIFIER ')'
//yy function: LOWERCASE '(' expression ')'
//yy function: NVL '(' expression ',' expression ')'
//yy function: ROUND '(' expression ')'
//yy function: STR '(' expression ')'
//yy function: SUBSTR '(' expression ',' expression ',' expression ')'
//yy function: SUBSTR '(' expression ',' expression ')'
//yy function: TRIM '(' expression ')'
//yy function: UPPERCASE '(' expression ')'
//yy literal: NUMBER
//yy literal: STRING

  /** loads parser table.
  		Format: name length newline ten-numbers newline ...
  	*/
  protected static short[] loadShort (java.io.BufferedReader in)
  	throws Exception
  {
  	java.util.StringTokenizer st = new java.util.StringTokenizer(in.readLine());
  	st.nextToken();
  	short[] result = new short[Integer.parseInt(st.nextToken())];
  	for (int n = 0; n < result.length; n += 10) {
  		st = new java.util.StringTokenizer(in.readLine(), ", \t\r\n");
  		for (int m = 0; st.hasMoreTokens(); ++ m)
  			result[n+m] = Short.valueOf(st.nextToken()).shortValue();
  	}
  	return result;
  }

  // once-only code to initialize parser tables
  // non-static to name resource after parser class
  // any error is fatal
  {
  	if (yyLhs == null)
  		try {
  			Class myClass = getClass();
  			String resource = myClass.getPackage().getName().replace('.', '/')+"/parser.tables";
//t  			System.out.println("Trying to load tables from " + resource);
  			java.io.InputStream i;
  			try { // full path in jar file
  				i = myClass.getResourceAsStream("/"+resource);
  			} catch (Exception e) { // relative path
  				i = myClass.getResourceAsStream(resource);
  			}
  			java.io.BufferedReader in =
  				new java.io.BufferedReader(new java.io.InputStreamReader(i));
  
  			yyLhs = loadShort(in);
  			yyLen = loadShort(in);
  			yyDefRed = loadShort(in);
  			yyDgoto = loadShort(in);
  			yySindex = loadShort(in);
  			yyRindex = loadShort(in);
  			yyGindex = loadShort(in);
  			yyTable = loadShort(in);
  			yyCheck = loadShort(in);
  
  			// load name table
  			// Format: yyNames length lines newline index space name newline ...for lines
  			{ java.util.StringTokenizer st = new java.util.StringTokenizer(in.readLine());
  				st.nextToken();
  				yyNames = new String[Integer.parseInt(st.nextToken())];
  				int max = Integer.parseInt(st.nextToken());
  				for (int n = 0; n < max; ++ n) {
  					st = new java.util.StringTokenizer(in.readLine());
  					int m = Integer.parseInt(st.nextToken());
  					yyNames[m] = st.nextToken("\n").substring(1);
  				}
  			}
  
//t  			// load rules table for debugging
//t  			// Format: yyRule length newline rule newline ...for length
//t  			{ java.util.StringTokenizer st = new java.util.StringTokenizer(in.readLine());
//t  				st.nextToken();
//t  				yyRule = new String[Integer.parseInt(st.nextToken())];
//t  				for (int n = 0; n < yyRule.length; ++ n)
//t  					yyRule[n] = in.readLine();
//t  			}
  
  			in.close();
  		} catch (Exception e) {
  			throw new Error("cannot load parser tables ["+e+"]");
  		}
  }

//t  /** debugging support, requires the package <tt>jay.yydebug</tt>.
//t      Set to <tt>null</tt> to suppress debugging messages.
//t  */
//t  protected jay.yydebug.yyDebug yydebug;
//t
//t  /** index-checked interface to {@link #yyNames}.
//t      @param token single character or <tt>%token</tt> value.
//t      @return token name or <tt>[illegal]</tt> or <tt>[unknown]</tt>.
//t  */
//t  public static final String yyName (int token)
//t  {
//t  	if (token < 0 || token > yyNames.length) return "[illegal]";
//t  	String name;
//t  	if ((name = yyNames[token]) != null) return name;
//t  	return "[unknown]";
//t  }
//t
  /** thrown for irrecoverable syntax errors and stack overflow.
      Nested for convenience, does not depend on parser class.
  */
  public static class yyException extends java.lang.Exception {
  	public yyException (String message)
  	{
  		super(message);
  	}
  }

  /** must be implemented by a scanner object to supply input to the parser.
      Nested for convenience, does not depend on parser class.
  */
  public interface yyInput {

  	/** move on to next token.
  	    @return <tt>false</tt> if positioned beyond tokens.
  	    @throws IOException on input error.
  	*/
  	boolean advance () throws java.io.IOException, SDMSException;

  	/** classifies current token.
  	    Should not be called if {@link #advance()} returned <tt>false</tt>.
  	    @return current <tt>%token</tt> or single character.
  	*/
  	int token ();

  	/** associated with current token.
  	    Should not be called if {@link #advance()} returned <tt>false</tt>.
  	    @return value for {@link #token()}.
  	*/
  	Object value ();
  }

  /** simplified error message.
      @see #yyerror(java.lang.String, java.lang.String[])
  */
  public void yyerror (String message) {
  	yyerror(message, null);
  }

  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected list of acceptable tokens, if available.
  */
  public void yyerror (String message, String[] expected)
  {
  	if (expected != null && expected.length > 0) {
  		System.err.print(message+", expecting");
  		for (int n = 0; n < expected.length; ++ n)
  			System.err.print(" "+expected[n]);
  		System.err.println();
  	} else
  		System.err.println(message);
  }

  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
  */
  protected String[] yyExpecting (int state)
  {
  	int token, n, len = 0;
  	boolean[] ok = new boolean[yyNames.length];

  	if ((n = yySindex[state]) != 0)
  		for (token = n < 0 ? -n : 0;
  				 token < yyNames.length && n+token < yyTable.length; ++ token)
  			if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
  				++ len;
  				ok[token] = true;
  			}
  	if ((n = yyRindex[state]) != 0)
  		for (token = n < 0 ? -n : 0;
  				 token < yyNames.length && n+token < yyTable.length; ++ token)
  			if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
  				++ len;
  				ok[token] = true;
  			}

  	String result[] = new String[len];
  	for (n = token = 0; n < len;  ++ token)
  		if (ok[token]) result[n++] = yyNames[token];
  	return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a dynamic state and value stack.
      @param yyLex scanner.
      @param yydebug debug message writer implementing <tt>yyDebug</tt>, or <tt>null</tt>.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
  */
  public Object yyparse (yyInput yyLex, Object yydebug)
	throws java.io.IOException, yyException, SDMSException
  {
//t  	this.yydebug = (jay.yydebug.yyDebug)yydebug;
  	return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
  		This is not final so that it can be overwritten outside of invocations
  		of {@link #yyparse}.
  	*/
  protected int yyMax;

  /** executed at the beginning of a reduce action.
  		Used as <tt>$$ = yyDefault($1)</tt>, prior to the user-specified action, if any.
  		Can be overwritten to provide deep copy, etc.
  		@param first value for <tt>$1</tt>, or <tt>null</tt>.
  		@return first.
  	*/
  protected Object yyDefault (Object first)
  {
  	return first;
  }

  /** the generated parser.
  		Maintains a dynamic state and value stack.
  		@param yyLex scanner.
  		@return result of the last reduction, if any.
  		@throws yyException on irrecoverable parse error.
  	*/
  public Object yyparse (yyInput yyLex) throws java.io.IOException, yyException, SDMSException {
  	if (yyMax <= 0) yyMax = 256;			// initial size
  	int yyState = 0, yyStates[] = new int[yyMax];	// state stack
  	Object yyVal = null, yyVals[] = new Object[yyMax];	// value stack
  	int yyToken = -1;					// current input
  	int yyErrorFlag = 0;				// #tokens to shift

  	yyLoop:
  	for (int yyTop = 0;; ++ yyTop) {
  		if (yyTop >= yyStates.length) {			// dynamically increase
  			int[] i = new int[yyStates.length+yyMax];
  			System.arraycopy(yyStates, 0, i, 0, yyStates.length);
  			yyStates = i;
  			Object[] o = new Object[yyVals.length+yyMax];
  			System.arraycopy(yyVals, 0, o, 0, yyVals.length);
  			yyVals = o;
  		}
  		yyStates[yyTop] = yyState;
  		yyVals[yyTop] = yyVal;
//t  		if (yydebug != null) yydebug.push(yyState, yyVal);

  		yyDiscarded:
  		for (;;) {	// discarding a token does not change stack
  			int yyN;
  			if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
  				if (yyToken < 0) {
  					yyToken = yyLex.advance() ? yyLex.token() : 0;
//t  					if (yydebug != null)
//t  						yydebug.lex(yyState, yyToken, yyName(yyToken), yyLex.value());
  				}
  				if ((yyN = yySindex[yyState]) != 0 && (yyN += yyToken) >= 0
  						&& yyN < yyTable.length && yyCheck[yyN] == yyToken) {
//t  					if (yydebug != null)
//t  						yydebug.shift(yyState, yyTable[yyN], yyErrorFlag > 0 ? yyErrorFlag-1 : 0);
  					yyState = yyTable[yyN];		// shift to yyN
  					yyVal = yyLex.value();
  					yyToken = -1;
  					if (yyErrorFlag > 0) -- yyErrorFlag;
  					continue yyLoop;
  				}
  				if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
  						&& yyN < yyTable.length && yyCheck[yyN] == yyToken)
  					yyN = yyTable[yyN];			// reduce (yyN)
  				else
  					switch (yyErrorFlag) {
  
  					case 0:
  						yyerror("syntax error", yyExpecting(yyState));
//t  						if (yydebug != null) yydebug.error("syntax error");
  
  					case 1: case 2:
  						yyErrorFlag = 3;
  						do {
  							if ((yyN = yySindex[yyStates[yyTop]]) != 0
  									&& (yyN += yyErrorCode) >= 0 && yyN < yyTable.length
  									&& yyCheck[yyN] == yyErrorCode) {
//t  								if (yydebug != null)
//t  									yydebug.shift(yyStates[yyTop], yyTable[yyN], 3);
  								yyState = yyTable[yyN];
  								yyVal = yyLex.value();
  								continue yyLoop;
  							}
//t  							if (yydebug != null) yydebug.pop(yyStates[yyTop]);
  						} while (-- yyTop >= 0);
//t  						if (yydebug != null) yydebug.reject();
  						throw new yyException("irrecoverable syntax error");
  
  					case 3:
  						if (yyToken == 0) {
//t  							if (yydebug != null) yydebug.reject();
  							throw new yyException("irrecoverable syntax error at end-of-file");
  						}
//t  						if (yydebug != null)
//t  							yydebug.discard(yyState, yyToken, yyName(yyToken),
//t  							yyLex.value());
  						yyToken = -1;
  						continue yyDiscarded;		// leave stack alone
  					}
  			}
  			int yyV = yyTop + 1-yyLen[yyN];
//t  			if (yydebug != null)
//t  				yydebug.reduce(yyState, yyStates[yyV-1], yyN, yyRule[yyN], yyLen[yyN]);
  			yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
  			switch (yyN) {
case 1:
					// line 75 "ExprParser.jay"
  { debuginfo("triggerexp --> true"); if(stop == 0) return Boolean.TRUE; }
  break;
case 2:
					// line 76 "ExprParser.jay"
  { debuginfo("triggerexp/boolexp --> " + ((Boolean)yyVals[0+yyTop])); if(stop == 0) return(((Boolean)yyVals[0+yyTop])); }
  break;
case 3:
					// line 77 "ExprParser.jay"
  { debuginfo("triggerexp/expression --> " + ((ParseObject)yyVals[0+yyTop]).getValue()); if(stop == 0) return(((ParseObject)yyVals[0+yyTop]).getValue()); }
  break;
case 4:
					// line 79 "ExprParser.jay"
  { debuginfo("boolexp/boolterm"); yyVal = ((Boolean)yyVals[0+yyTop]); }
  break;
case 5:
					// line 80 "ExprParser.jay"
  { debuginfo("boolexp/boolexp OR boolterm"); Boolean b = ((Boolean)yyVals[-2+yyTop]); if (b.booleanValue()) yyVal = b; else yyVal = ((Boolean)yyVals[0+yyTop]); }
  break;
case 6:
					// line 82 "ExprParser.jay"
  { debuginfo("boolterm/booloperand"); yyVal = ((Boolean)yyVals[0+yyTop]); }
  break;
case 7:
					// line 83 "ExprParser.jay"
  { debuginfo("boolterm/boolterm AND booloperand"); Boolean b = ((Boolean)yyVals[-2+yyTop]); if (b.booleanValue()) yyVal = ((Boolean)yyVals[0+yyTop]); else yyVal = b; }
  break;
case 8:
					// line 85 "ExprParser.jay"
  { debuginfo("booloperand/(boolexp)"); yyVal = ((Boolean)yyVals[-1+yyTop]); }
  break;
case 9:
					// line 86 "ExprParser.jay"
  { debuginfo("booloperand/NOT booloperand"); yyVal = Boolean.valueOf(! ((Boolean)yyVals[0+yyTop]).booleanValue()); }
  break;
case 10:
					// line 87 "ExprParser.jay"
  { debuginfo("booloperand/expression (" + ((ParseObject)yyVals[-2+yyTop]).toString() + ") comparison expression (" + ((ParseObject)yyVals[0+yyTop]).toString() + ")"); yyVal = ((ParseObject)yyVals[-2+yyTop]).compare(((ParseObject)yyVals[0+yyTop]), ((Integer)yyVals[-1+yyTop]), checkOnly); }
  break;
case 11:
					// line 88 "ExprParser.jay"
  { debuginfo("booloperand/BOOLEAN"); yyVal = ((Boolean)yyVals[0+yyTop]); }
  break;
case 12:
					// line 90 "ExprParser.jay"
  { debuginfo("expression/term"); yyVal = ((ParseObject)yyVals[0+yyTop]); }
  break;
case 13:
					// line 91 "ExprParser.jay"
  { debuginfo("expression/expression addop term"); yyVal = ((ParseObject)yyVals[-2+yyTop]).add(((ParseObject)yyVals[0+yyTop]), ((Integer)yyVals[-1+yyTop]), checkOnly); }
  break;
case 14:
					// line 93 "ExprParser.jay"
  { debuginfo("term/operand"); yyVal = ((ParseObject)yyVals[0+yyTop]); }
  break;
case 15:
					// line 94 "ExprParser.jay"
  { debuginfo("term/term multop operand"); yyVal = ((ParseObject)yyVals[-2+yyTop]).mult(((ParseObject)yyVals[0+yyTop]), ((Integer)yyVals[-1+yyTop]), checkOnly); }
  break;
case 16:
					// line 96 "ExprParser.jay"
  { debuginfo("addop/PLUS");         yyVal = I_PLUS; }
  break;
case 17:
					// line 97 "ExprParser.jay"
  { debuginfo("addop/MINUS");        yyVal = I_MINUS; }
  break;
case 18:
					// line 99 "ExprParser.jay"
  { debuginfo("multop/TIMES");       yyVal = I_TIMES; }
  break;
case 19:
					// line 100 "ExprParser.jay"
  { debuginfo("multop/DIV");         yyVal = I_DIV; }
  break;
case 20:
					// line 101 "ExprParser.jay"
  { debuginfo("multop/MOD");         yyVal = I_MOD; }
  break;
case 21:
					// line 103 "ExprParser.jay"
  { debuginfo("comparison/GT");      yyVal = I_GT; }
  break;
case 22:
					// line 104 "ExprParser.jay"
  { debuginfo("comparison/GE");      yyVal = I_GE; }
  break;
case 23:
					// line 105 "ExprParser.jay"
  { debuginfo("comparison/LT");      yyVal = I_LT; }
  break;
case 24:
					// line 106 "ExprParser.jay"
  { debuginfo("comparison/LE");      yyVal = I_LE; }
  break;
case 25:
					// line 107 "ExprParser.jay"
  { debuginfo("comparison/EQ");      yyVal = I_EQ; }
  break;
case 26:
					// line 108 "ExprParser.jay"
  { debuginfo("comparison/NE");      yyVal = I_NE; }
  break;
case 27:
					// line 109 "ExprParser.jay"
  { debuginfo("comparison/MATCHES"); yyVal = I_MATCHES; }
  break;
case 28:
					// line 110 "ExprParser.jay"
  { debuginfo("comparison/NOMATCH"); yyVal = I_NOMATCH; }
  break;
case 29:
					// line 112 "ExprParser.jay"
  { debuginfo("operand/(expression)"); yyVal = ((ParseObject)yyVals[-1+yyTop]); }
  break;
case 30:
					// line 113 "ExprParser.jay"
  { debuginfo("operand/addop operand)"); yyVal = ((ParseObject)yyVals[0+yyTop]).changeSign(((Integer)yyVals[-1+yyTop]), checkOnly); }
  break;
case 31:
					// line 114 "ExprParser.jay"
  { debuginfo("operand/PARAMETER"); yyVal = resolve(((String)yyVals[0+yyTop]), PARAMETER); }
  break;
case 32:
					// line 115 "ExprParser.jay"
  { debuginfo("operand/JPARAMETER"); yyVal = resolve(((String)yyVals[0+yyTop]), JPARAMETER); }
  break;
case 33:
					// line 116 "ExprParser.jay"
  { debuginfo("operand/RPARAMETER"); yyVal = resolve(((String)yyVals[0+yyTop]), RPARAMETER); }
  break;
case 34:
					// line 117 "ExprParser.jay"
  { debuginfo("operand/TPARAMETER"); yyVal = resolve(((String)yyVals[0+yyTop]), TPARAMETER); }
  break;
case 35:
					// line 118 "ExprParser.jay"
  { debuginfo("operand/RSPARAMETER"); yyVal = resolve(((String)yyVals[0+yyTop]), RSPARAMETER); }
  break;
case 36:
					// line 119 "ExprParser.jay"
  { debuginfo("operand/DSPARAMETER"); yyVal = resolve(((String)yyVals[0+yyTop]), DSPARAMETER); }
  break;
case 37:
					// line 120 "ExprParser.jay"
  { debuginfo("operand/literal"); yyVal = ((ParseObject)yyVals[0+yyTop]); }
  break;
case 38:
					// line 121 "ExprParser.jay"
  { debuginfo("operand/function"); yyVal = ((ParseObject)yyVals[0+yyTop]); }
  break;
case 39:
					// line 122 "ExprParser.jay"
  { debuginfo("operand/?:"); yyVal = ParseObject.question(((Boolean)yyVals[-5+yyTop]), ((ParseObject)yyVals[-3+yyTop]), ((ParseObject)yyVals[-1+yyTop])); }
  break;
case 40:
					// line 124 "ExprParser.jay"
  { debuginfo("function/ABS(expression)"); yyVal = ((ParseObject)yyVals[-1+yyTop]).abs(checkOnly); }
  break;
case 41:
					// line 125 "ExprParser.jay"
  { debuginfo("function/INT(expression)"); yyVal = ((ParseObject)yyVals[-1+yyTop]).to_int(checkOnly); }
  break;
case 42:
					// line 126 "ExprParser.jay"
  { debuginfo("function/DATE(expression, expression)"); yyVal = ((ParseObject)yyVals[-3+yyTop]).to_date(((ParseObject)yyVals[-1+yyTop]), checkOnly); }
  break;
case 43:
					// line 127 "ExprParser.jay"
  { debuginfo("function/FIELD(expression)"); yyVal = field(new ParseObject(((String)yyVals[-1+yyTop]))); }
  break;
case 44:
					// line 128 "ExprParser.jay"
  { debuginfo("function/LOWERCASE(expression)"); yyVal = ((ParseObject)yyVals[-1+yyTop]).lowercase(checkOnly); }
  break;
case 45:
					// line 129 "ExprParser.jay"
  { debuginfo("function/NVL(expression, expression)"); yyVal = ((ParseObject)yyVals[-3+yyTop]).nvl(((ParseObject)yyVals[-1+yyTop]), checkOnly); }
  break;
case 46:
					// line 130 "ExprParser.jay"
  { debuginfo("function/ROUND(expression)"); yyVal = ((ParseObject)yyVals[-1+yyTop]).round(checkOnly); }
  break;
case 47:
					// line 131 "ExprParser.jay"
  { debuginfo("function/STR(expression)"); yyVal = ((ParseObject)yyVals[-1+yyTop]).adjust(ParseObject.STRING, checkOnly); }
  break;
case 48:
					// line 132 "ExprParser.jay"
  { debuginfo("function/SUBSTR(expression, expression, expression)"); yyVal = ((ParseObject)yyVals[-5+yyTop]).substr(((ParseObject)yyVals[-3+yyTop]), ((ParseObject)yyVals[-1+yyTop]), checkOnly); }
  break;
case 49:
					// line 133 "ExprParser.jay"
  { debuginfo("function/SUBSTR(expression, expression)"); yyVal = ((ParseObject)yyVals[-3+yyTop]).substr(((ParseObject)yyVals[-1+yyTop]), null, checkOnly); }
  break;
case 50:
					// line 134 "ExprParser.jay"
  { debuginfo("function/TRIM(expression)"); yyVal = ((ParseObject)yyVals[-1+yyTop]).trim(checkOnly); }
  break;
case 51:
					// line 135 "ExprParser.jay"
  { debuginfo("function/UPPERCASE(expression)"); yyVal = ((ParseObject)yyVals[-1+yyTop]).uppercase(checkOnly); }
  break;
case 52:
					// line 137 "ExprParser.jay"
  { debuginfo("literal/NUMBER"); yyVal = new ParseObject(((BigDecimal)yyVals[0+yyTop])); }
  break;
case 53:
					// line 138 "ExprParser.jay"
  { debuginfo("literal/STRING"); yyVal = new ParseObject(((String)yyVals[0+yyTop]), ParseObject.STRING); }
  break;
					// line 866 "-"
  			}
  			yyTop -= yyLen[yyN];
  			yyState = yyStates[yyTop];
  			int yyM = yyLhs[yyN];
  			if (yyState == 0 && yyM == 0) {
//t  				if (yydebug != null) yydebug.shift(0, yyFinal);
  				yyState = yyFinal;
  				if (yyToken < 0) {
  					yyToken = yyLex.advance() ? yyLex.token() : 0;
//t  					if (yydebug != null)
//t  						 yydebug.lex(yyState, yyToken,yyName(yyToken), yyLex.value());
  				}
  				if (yyToken == 0) {
//t  					if (yydebug != null) yydebug.accept(yyVal);
  					return yyVal;
  				}
  				continue yyLoop;
  			}
  			if ((yyN = yyGindex[yyM]) != 0 && (yyN += yyState) >= 0
  					&& yyN < yyTable.length && yyCheck[yyN] == yyState)
  				yyState = yyTable[yyN];
  			else
  				yyState = yyDgoto[yyM];
//t  			if (yydebug != null) yydebug.shift(yyStates[yyTop], yyState);
  			continue yyLoop;
  		}
  	}
  }

					// line 140 "ExprParser.jay"

private ParseObject field(ParseObject o)
{
	return o;
}

private void debuginfo(String s)
{
	if (debug)
		System.out.println(s);
}

private ParseObject resolve(String o, int type)
	throws SDMSException
{
	if(checkOnly) return new ParseObject(emptyString);
	String p = emptyString;
	switch (type) {
		case JPARAMETER:
			p = sme.getVariableValue(sysEnv, o, false, ParseStr.S_LIBERAL, true /* triggercontext */, evalScope, true);
			break;
		case RPARAMETER:
			if (r != null)
				p = r.getVariableValue(sysEnv, o, true);
			break;
		case TPARAMETER:
			p = resolveTriggerVariable(o);
			if (p == null) p = emptyString;
			break;
		case RSPARAMETER:
			if (requiredSme != null)
				p = requiredSme.getVariableValue(sysEnv, o, false, ParseStr.S_LIBERAL, true /* triggercontext */, evalScope, true);
			else
				p = sme.getVariableValue(sysEnv, o, false, ParseStr.S_LIBERAL, true /* triggercontext */, evalScope, true);
			break;
		case DSPARAMETER:
			p = sme.getVariableValue(sysEnv, o, false, ParseStr.S_LIBERAL, true /* triggercontext */, evalScope, true);
			break;
		case PARAMETER:
			p = resolveTriggerVariable(o);
			if(p != null) return new ParseObject(p);
			if(sme != null)
				p = sme.getVariableValue(sysEnv, o, false, ParseStr.S_LIBERAL, true /* triggercontext */, evalScope, true);
			else
				if (requiredSme != null) 
					p = requiredSme.getVariableValue(sysEnv, o, false, ParseStr.S_LIBERAL, true /* triggercontext */, evalScope, true);
				else
					if (r != null)
						p = r.getVariableValue(sysEnv, o, true);
					else
						p = emptyString;
			break;
	}
	debuginfo(o + " -> " + p.toString());
	return new ParseObject(p);
}

public void set(SystemEnvironment env, SDMSSubmittedEntity sme, SDMSSubmittedEntity requiredSme, SDMSResource rs, SDMSTrigger tr, SDMSTriggerQueue trq, SDMSScope s)
{
	this.sysEnv = env;
	this.sme = sme;
	this.requiredSme = requiredSme;
	this.r = rs;
	this.t = tr;
	this.tq = trq;
	this.evalScope = s;
}

public String resolveTriggerVariable(String key)
{
	if(tq == null) return null;
	try {
		if(key.equals(S_TIMES_CHECKED)) {
			return tq.getTimesChecked(sysEnv).toString();
		}
		if(key.equals(S_TIMES_FIRED)) {
			return tq.getTimesTriggered(sysEnv).toString();
		}
	} catch(SDMSException e) { /* ignore */ }
	return null;
}

}

class ParseObject {

	private BigDecimal number;
	private String     string;

	private int type;

	public static final int VOID   = 0;
	public static final int STRING = 1;
	public static final int NUMBER = 2;
	public static final int DATE   = 3;
	public static final int INDETERMINED = 99;	// this is stored as string, but hasn't a definite type yet

	public static final BigDecimal one = new BigDecimal("1");


	public ParseObject()
	{
		type = VOID;
		number = null;
		string = null;
	}

	public ParseObject(Object o)
	{
		if(o instanceof BigDecimal) {
			type = NUMBER;
			number = (BigDecimal) o;
			string = null;
		} else
		if(o instanceof String) {
			string = (String) o;
			try {
				number = new BigDecimal(string);
				type = NUMBER;
				string = null;
			} catch (NumberFormatException nfe) {
				number = null;
				type = STRING;
			}
		} else
		if(o.getClass().getName().endsWith("Something date like")) {
			type = DATE;
			string = null;
			number = null;
		} else {
			// Error
			System.err.println("Fatal Exception! Unexpected Object: " + o.toString() + "\n");
			System.exit(1);
		}
	}

	public String toString()
	{
		if (type == VOID) return "VOID";
		if (type == STRING) return string;
		if (type == NUMBER) return number.toString();
		return "Unknown";
	}

	public ParseObject(String s)
	{
		type = INDETERMINED;
		string = s;
		number = null;
	}

	public ParseObject(String s, int t)
	{
		type = t;
		if (type == NUMBER) type = INDETERMINED;
		string = s;
		number = null;
	}

	public ParseObject(BigDecimal d)
	{
		type = NUMBER;
		number = d;
		string = null;
	}

	public ParseObject(ParseObject p)
	{
		type = p.type;
		number = p.number;
		string = p.string;
	}

	public static ParseObject question(Boolean c, ParseObject t, ParseObject f)
	{
		if (c) return t;
		return f;
	}

	public Object getValue()
	{
		if (type == STRING || type == INDETERMINED) return string;
		if (type == NUMBER) {
			if (number == null) return null;
			long v;
			try {
				v = number.longValueExact();
				return Long.valueOf(v);
			} catch (ArithmeticException ae) {
				double d;
				d = number.doubleValue();
				return Double.valueOf(d);
			}
		}
		return null;
	}

	public ParseObject adjust(ParseObject po, boolean checkOnly)
		throws SDMSException
	{
		return adjust(po.type, checkOnly);
	}

	public ParseObject adjust(int t, boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		if(type == t) return new ParseObject(this);
		ParseObject rc = new ParseObject(this);
		try {
			switch(t) {
				case INDETERMINED:
				case STRING:
					rc.type = STRING;
					rc.number = null;
					if(type == NUMBER)	rc.string = number.toString();
					if(type == VOID)	rc.string = new String();
					break;
				case NUMBER:
					rc.type = NUMBER;
					rc.string = null;
					if(type == STRING || type == INDETERMINED)	rc.number = new BigDecimal(string);
					if(type == VOID)	rc.number = new BigDecimal("0");
					break;
			}
		} catch (NumberFormatException nfe) {
			// we'd like to convert into a number, but the format isn't valid :-(
			// throwing an error here isn't exactly what we want, but we have no real alternative
			if (string == null || string.equals("") || string.toUpperCase().equals("NONE")) {
				rc.number = new BigDecimal("0");
			} else {
				throw new SDMSException(new SDMSMessage((SystemEnvironment) null, "03802071626", "Error evaluating expression. Invalid number format of $1", string));
			}
		}
		return rc;
	}

	public ParseObject mult(ParseObject o2, Integer s, boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		int operator = s.intValue();
		ParseObject op1 = adjust(ParseObject.NUMBER, checkOnly);
		ParseObject op2 = o2.adjust(ParseObject.NUMBER, checkOnly);
		switch(operator) {
			case ExprParser.DIV:
				if (op2.number.equals(0))
					throw new SDMSException(new SDMSMessage((SystemEnvironment) null, "03802071627", "Error evaluating expression. Division by zero"));
				op1.number = op1.number.divide(op2.number, RoundingMode.HALF_UP);
				break;
			case ExprParser.TIMES:	op1.number = op1.number.multiply(op2.number); break;
			case ExprParser.MOD:
				BigInteger n1 = op1.number.toBigInteger();
				BigInteger n2 = op2.number.toBigInteger();
				if (n2.equals(0))
					throw new SDMSException(new SDMSMessage((SystemEnvironment) null, "03802071628", "Error evaluating expression. Division by zero"));
				op1.number = new BigDecimal(n1.mod(n2));
				break;
		}
		return op1;
	}

	public ParseObject add(ParseObject o2, Integer s, boolean checkOnly)
		throws SDMSException
	{
		// adding two parameters (operator == PLUS) is an ambiguous operation
		// a. if "this" is a number and the other operand is too, the result will be a number
		// b. if "this" is a number and the other operand can be converted into a number, the result will be a number, else "this" is converted to a string
		// c. if "this" is a string, the result will be a string
		// d. if "this" is indeterminated, it is tried to interpret it as a number first
		//
		ParseObject op1 = this;
		ParseObject op2 = null;

		if(checkOnly) return new ParseObject();
		int operator = s.intValue();
		if (operator == ExprParser.PLUS) {
			if (op1.type == INDETERMINED) {
				// here we try to convert to a number format first.
				// if that fails, it must be a string
				// This is case d.
				try {
					op1 = adjust(NUMBER, checkOnly);
				} catch (CommonErrorException cee) {
					op1 = adjust(STRING, checkOnly);
				}
			}
			if(op1.type == STRING) {
				// Case c. or case d. in case of an invalid number format of "this"
				op2 = o2.adjust(STRING, checkOnly);
				op2.string = op1.string + op2.string;
				return op2;
			} else {
				if (o2.type == NUMBER) {
					// Case a.; nothing to do
				} else {
					// Case b.
					try {
						op2 = o2.adjust(NUMBER, checkOnly);
					} catch (CommonErrorException cee) {
						op1 = op1.adjust(STRING, checkOnly);
						op2.string = op1.string + op2.string;
						return op2;
					}
				}
			}
		}
		if (op1.type != NUMBER)
			op1 = adjust(NUMBER, checkOnly);
		op2 = o2.adjust(NUMBER, checkOnly);
		switch(operator) {
			case ExprParser.PLUS:	op1.number = op1.number.add(op2.number); break;
			case ExprParser.MINUS:	op1.number = op1.number.add(op2.number.negate()); break;
		}
		return op1;
	}

	public int compareTo(ParseObject o2, boolean checkOnly)
		throws SDMSException
	{
		ParseObject op1 = this;
		if (type == INDETERMINED) {
			// we don't know what this is, so we try to adjust to the type of the second operand
			if (o2.type != INDETERMINED) {
				try {
					// this will work if o2 is a String, or "this" has a valid numerical format
					op1 = adjust(o2.type, checkOnly);
				} catch (CommonErrorException cee) {
					// it is pretty certain that both aren't equal, but that doesn't play a role
					// this method is simply not allowed to fail
					op1 = adjust(STRING, checkOnly);
				}
			} else {
				// both are undetermined
				// hence we regard them to be strings
				op1 = adjust(STRING, checkOnly);
			}
		}
		ParseObject op2 = o2.adjust(op1.type, checkOnly);
		int val = 0;
		switch(op1.type) {
			case NUMBER: val = op1.number.compareTo(op2.number); break;
			case STRING: val = op1.string.compareTo(op2.string); break;
		}
		return val;
	}

	public Boolean compare(ParseObject o2, Integer s, boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return Boolean.TRUE;
		int operator = s.intValue();
		if(operator == ExprParser.MATCHES || operator == ExprParser.NOMATCH) {
			ParseObject op1 = adjust(STRING, checkOnly);
			ParseObject op2 = o2.adjust(STRING, checkOnly);
			if(operator == ExprParser.MATCHES && op1.string.matches(op2.string)) return Boolean.TRUE;
			if(operator == ExprParser.NOMATCH && !op1.string.matches(op2.string)) return Boolean.TRUE;
			return Boolean.FALSE;
		} else {
			int val = compareTo(o2, checkOnly);
			switch(operator) {
				case ExprParser.EQ:	return Boolean.valueOf(val == 0);
				case ExprParser.GE:	return Boolean.valueOf(val >= 0);
				case ExprParser.GT:	return Boolean.valueOf(val > 0);
				case ExprParser.LE:	return Boolean.valueOf(val <= 0);
				case ExprParser.LT:	return Boolean.valueOf(val < 0);
				case ExprParser.NE:	return Boolean.valueOf(val != 0);
			}
		}
		return Boolean.TRUE;
	}

	public ParseObject changeSign(Integer s, boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		int operator = s.intValue();
		ParseObject retval = adjust(ParseObject.NUMBER, checkOnly);
		switch(operator) {
			case ExprParser.PLUS:
				// do nothing
				break;
			case ExprParser.MINUS:
				retval.number = retval.number.negate();
				break;
		}
		return retval;
	}

	public ParseObject to_int(boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		ParseObject retval = adjust(ParseObject.NUMBER, checkOnly);
		retval.number = new BigDecimal(retval.number.toBigInteger());
		return retval;
	}

	public ParseObject to_date(ParseObject format, boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		if(type == NUMBER) return this.to_int(false);
		if(type == VOID) return this;
		ParseObject retval;
		if(format.type == STRING) {
			try {
				SimpleDateFormat sdf;
				if (format.string != null)
					sdf = new SimpleDateFormat(format.string);
				else 
					sdf = (SimpleDateFormat) SystemEnvironment.staticSystemDateFormat.clone();
				Date d = sdf.parse(this.string);
				retval = new ParseObject(new BigDecimal(d.getTime()));
			} catch (ParseException pe) {
				retval = new ParseObject(new BigDecimal(0));
			}
		} else {
			retval = new ParseObject(new BigDecimal(0));
		}
		return retval;
	}

	public ParseObject abs(boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		ParseObject retval = adjust(ParseObject.NUMBER, checkOnly);
		retval.number = retval.number.abs();
		return retval;
	}

	public ParseObject round(boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		ParseObject retval = adjust(ParseObject.NUMBER, checkOnly);
		retval.number = retval.number.divide(one, RoundingMode.HALF_UP);
		return retval;
	}

	public ParseObject substr(ParseObject v, ParseObject b, boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		ParseObject retval = adjust(STRING, checkOnly);
		int von = v.adjust(NUMBER, checkOnly).number.intValue();
		if(b != null) {
			int bis = b.adjust(NUMBER, checkOnly).number.intValue();
			retval.string = retval.string.substring(von, bis);
		} else {
			retval.string = retval.string.substring(von);
		}
		return retval;
	}

	public ParseObject trim(boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		ParseObject retval = adjust(STRING, checkOnly);
		retval.string = retval.string.trim();
		return retval;
	}

	public ParseObject uppercase(boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		ParseObject retval = adjust(STRING, checkOnly);
		retval.string = retval.string.toUpperCase();
		return retval;
	}

	public ParseObject lowercase(boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		ParseObject retval = adjust(STRING, checkOnly);
		retval.string = retval.string.toLowerCase();
		return retval;
	}

	public ParseObject nvl(ParseObject replacement, boolean checkOnly)
		throws SDMSException
	{
		if(checkOnly) return new ParseObject();
		if ((type == VOID) ||
		    (type == STRING && (string == null || string.equals(""))) ||
		    (type == NUMBER && number == null) ||
		    (type == DATE && number == null))
			return replacement;
		return this;
	}
}

/*
class DateParser {

	// Special Characters
	//
	// DD   = day numeric (01 - 31)
	// MM   = month numeric (01 - 12)
	// YY   = year numeric (00 - 99) Values > 70 count as 19YY
	// YYYY = year numeric (1970 - 9999)
	// hh   = hour numeric (00 - 23)
	// mm   = minute numeric (00 - 59)
	// ss   = second numeric (00 - 59)
	// ddd  = name of day (is ignored, any 3 character string is accepted)
	//
}
*/
					// line 1409 "-"
