/* The following code was generated by JFlex 1.7.0 */

//
// $Id: ExprScanner.jlex,v 1.4.18.1 2013/03/14 10:25:16 ronald Exp $
//
// Copyright (C) 2004 independIT Integrative Technologies GmbH
//
//

package de.independit.scheduler.server.parser.triggerexpr;

import java.io.*;
import java.math.*;
import de.independit.scheduler.server.util.*;
import de.independit.scheduler.server.exception.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>ExprScanner.jlex</tt>
 */
public class ExprScanner implements de.independit.scheduler.server.parser.triggerexpr.ExprParser.yyInput {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int DQSTRING = 2;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\10\0\2\3\1\53\1\54\1\54\1\53\22\0\1\45\1\21\1\46"+
    "\1\1\1\47\1\25\1\44\1\52\2\44\1\26\1\15\1\44\1\24"+
    "\1\14\1\23\12\2\1\0\1\44\1\20\1\16\1\17\1\44\1\1"+
    "\1\11\1\27\1\36\1\31\1\7\1\10\1\42\1\1\1\32\1\41"+
    "\1\1\1\12\1\34\1\30\1\33\1\35\1\43\1\5\1\13\1\4"+
    "\1\6\1\40\1\37\3\1\1\0\1\55\2\0\1\1\1\0\1\11"+
    "\1\27\1\36\1\31\1\7\1\10\1\42\1\1\1\32\1\41\1\1"+
    "\1\12\1\34\1\30\1\33\1\35\1\43\1\5\1\13\1\4\1\6"+
    "\1\40\1\37\3\1\1\50\1\44\1\51\1\22\6\0\1\54\u1fa2\0"+
    "\1\54\1\54\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\udfe6\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\1\2\1\3\7\1\1\4\1\1\1\5"+
    "\1\6\1\1\1\7\1\10\1\11\1\12\5\1\1\13"+
    "\1\1\1\14\1\15\1\14\1\0\1\2\12\0\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\4\0\1\24\1\0"+
    "\5\25\1\0\1\26\1\27\7\0\1\30\1\31\1\0"+
    "\1\32\1\0\1\33\1\34\1\0\1\35\1\0\4\25"+
    "\6\0\1\2\1\36\1\37\6\0\1\40\1\0\5\25"+
    "\1\0\1\41\5\0\1\2\1\42\1\0\1\43\1\44"+
    "\2\0\1\45\1\0\4\25\10\0\1\2\2\0\1\46"+
    "\1\0\4\25\1\47\5\0\1\50\3\0\1\51\4\25"+
    "\10\0\4\25\5\0\1\52\1\0\1\53\1\54\1\0"+
    "\3\25\6\0\1\55\2\0\1\25\4\0\1\56\1\57"+
    "\1\60\6\0\1\61\1\0\1\62\11\0\1\63\2\0"+
    "\1\64\3\0\1\65\5\0\1\66\1\0\1\67\1\70"+
    "\2\0\1\71";

  private static int [] zzUnpackAction() {
    int [] result = new int[238];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\56\0\134\0\212\0\270\0\346\0\u0114\0\u0142"+
    "\0\u0170\0\u019e\0\u01cc\0\u01fa\0\134\0\u0228\0\u0256\0\u0284"+
    "\0\u02b2\0\134\0\134\0\134\0\134\0\u02e0\0\u030e\0\u033c"+
    "\0\u036a\0\u0398\0\134\0\u03c6\0\134\0\134\0\u03f4\0\u0422"+
    "\0\u0450\0\u047e\0\u04ac\0\u04da\0\u0508\0\u0536\0\u0564\0\u0592"+
    "\0\u05c0\0\u05ee\0\u061c\0\134\0\134\0\134\0\134\0\134"+
    "\0\134\0\u064a\0\u0678\0\u06a6\0\u06d4\0\134\0\u0702\0\u0730"+
    "\0\u075e\0\u078c\0\u07ba\0\u07e8\0\u0816\0\134\0\134\0\u0844"+
    "\0\u0872\0\u08a0\0\u08ce\0\u08fc\0\u092a\0\u0958\0\134\0\134"+
    "\0\u0986\0\134\0\u09b4\0\134\0\134\0\u09e2\0\134\0\u0a10"+
    "\0\u0a3e\0\u0a6c\0\u0a9a\0\u0ac8\0\u0af6\0\u0b24\0\u0b52\0\u0b80"+
    "\0\u0bae\0\u0bdc\0\u0c0a\0\134\0\134\0\u0c38\0\u0c66\0\u0c94"+
    "\0\u0cc2\0\u0cf0\0\u0d1e\0\134\0\u0d4c\0\u0d7a\0\u0da8\0\u0dd6"+
    "\0\u0e04\0\u0e32\0\u0e60\0\134\0\u0e8e\0\u0ebc\0\u0eea\0\u0f18"+
    "\0\u0f46\0\u0f74\0\134\0\u0fa2\0\134\0\134\0\u0fd0\0\u0ffe"+
    "\0\u102c\0\u105a\0\u1088\0\u10b6\0\u10e4\0\u1112\0\u1140\0\u116e"+
    "\0\u119c\0\u11ca\0\u11f8\0\u1226\0\u1254\0\u1282\0\134\0\u12b0"+
    "\0\u12de\0\134\0\u130c\0\u133a\0\u1368\0\u1396\0\u13c4\0\u13f2"+
    "\0\u1420\0\u144e\0\u147c\0\u14aa\0\u14d8\0\134\0\u1506\0\u1534"+
    "\0\u1562\0\134\0\u1590\0\u15be\0\u15ec\0\u161a\0\u1648\0\u1676"+
    "\0\u16a4\0\u16d2\0\u1700\0\u172e\0\u175c\0\u178a\0\u17b8\0\u17e6"+
    "\0\u1814\0\u1842\0\u1870\0\u189e\0\u18cc\0\u18fa\0\u1928\0\134"+
    "\0\u1956\0\134\0\134\0\u1984\0\u19b2\0\u19e0\0\u1a0e\0\u1a3c"+
    "\0\u1a6a\0\u1a98\0\u1ac6\0\u1af4\0\u1b22\0\u1b50\0\u1b7e\0\u1bac"+
    "\0\u1bda\0\u1c08\0\u1c36\0\u1c64\0\u1c92\0\134\0\u1cc0\0\u1cee"+
    "\0\u1d1c\0\u1d4a\0\u1d78\0\u1da6\0\u1dd4\0\u1e02\0\u1e30\0\u1e5e"+
    "\0\134\0\u1e8c\0\u1eba\0\u1ee8\0\u1f16\0\u1f44\0\u1f72\0\u1fa0"+
    "\0\u1fce\0\u1ffc\0\134\0\u202a\0\u2058\0\134\0\u2086\0\u20b4"+
    "\0\u20e2\0\134\0\u2110\0\u213e\0\u216c\0\u219a\0\u21c8\0\134"+
    "\0\u21f6\0\134\0\134\0\u2224\0\u2252\0\134";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[238];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\3\1\4\1\5\1\6\1\7\1\10\1\3\1\11"+
    "\1\12\1\13\1\14\1\3\1\15\1\16\1\17\1\20"+
    "\1\21\1\3\1\22\1\23\1\24\1\25\1\3\1\26"+
    "\1\27\1\30\1\31\5\3\1\32\3\3\1\5\1\33"+
    "\1\34\3\3\1\5\1\0\1\3\46\35\1\36\4\35"+
    "\2\0\1\37\60\0\1\4\4\0\1\40\4\0\1\41"+
    "\44\0\1\5\41\0\1\5\5\0\1\5\7\0\1\42"+
    "\103\0\1\43\57\0\1\44\31\0\1\45\20\0\1\46"+
    "\52\0\1\47\1\50\60\0\1\51\26\0\1\52\1\0"+
    "\1\53\65\0\1\54\3\0\1\55\51\0\1\56\55\0"+
    "\1\57\55\0\1\60\3\0\1\61\66\0\1\62\4\0"+
    "\1\63\26\0\1\64\74\0\1\65\32\0\1\66\103\0"+
    "\1\67\23\0\1\70\2\0\1\71\1\72\6\70\13\0"+
    "\2\70\1\73\7\70\1\74\2\70\4\0\1\75\53\0"+
    "\1\76\6\0\1\77\15\0\1\100\6\0\1\100\33\0"+
    "\1\41\4\0\1\40\54\0\1\101\23\0\1\102\31\0"+
    "\1\103\104\0\1\104\32\0\1\105\52\0\1\106\61\0"+
    "\1\107\73\0\1\110\63\0\1\111\23\0\1\112\77\0"+
    "\1\113\32\0\1\114\63\0\1\115\47\0\1\116\55\0"+
    "\1\117\100\0\1\120\27\0\2\70\1\0\10\70\13\0"+
    "\15\70\13\0\2\70\1\0\1\70\1\121\6\70\13\0"+
    "\15\70\13\0\2\70\1\0\3\70\1\122\4\70\13\0"+
    "\15\70\13\0\2\70\1\0\3\70\1\123\4\70\13\0"+
    "\15\70\13\0\2\70\1\0\10\70\13\0\4\70\1\124"+
    "\10\70\13\0\2\125\1\0\1\126\1\127\6\125\1\0"+
    "\5\125\1\0\6\125\1\130\7\125\1\131\3\125\5\0"+
    "\1\132\5\0\1\133\62\0\1\134\102\0\1\135\51\0"+
    "\1\136\34\0\1\137\61\0\1\140\54\0\1\141\52\0"+
    "\1\142\61\0\1\143\51\0\1\144\62\0\1\145\42\0"+
    "\2\70\1\0\10\70\13\0\3\70\1\146\11\70\13\0"+
    "\2\70\1\0\7\70\1\147\13\0\14\70\1\150\13\0"+
    "\2\70\1\0\10\70\13\0\6\70\1\151\6\70\13\0"+
    "\2\70\1\0\10\70\13\0\1\152\14\70\13\0\2\125"+
    "\1\0\10\125\1\0\5\125\1\0\22\125\1\153\3\0"+
    "\1\154\5\0\2\125\1\0\1\125\1\155\6\125\1\0"+
    "\5\125\1\0\22\125\1\153\3\0\1\154\5\0\2\125"+
    "\1\0\3\125\1\156\4\125\1\0\5\125\1\0\22\125"+
    "\1\153\3\0\1\154\5\0\2\125\1\0\3\125\1\157"+
    "\4\125\1\0\5\125\1\0\22\125\1\153\3\0\1\154"+
    "\5\0\2\125\1\0\10\125\1\0\5\125\1\0\10\125"+
    "\1\160\11\125\1\153\3\0\1\154\5\0\2\161\1\0"+
    "\10\161\1\0\5\161\1\0\22\161\13\0\1\162\104\0"+
    "\1\163\31\0\1\164\57\0\1\165\77\0\1\166\31\0"+
    "\1\167\54\0\1\170\52\0\1\171\2\0\10\171\13\0"+
    "\15\171\6\0\1\172\4\0\2\70\1\0\10\70\13\0"+
    "\13\70\1\173\1\70\13\0\2\70\1\0\10\70\13\0"+
    "\4\70\1\174\10\70\13\0\2\70\1\0\2\70\1\175"+
    "\5\70\13\0\15\70\13\0\2\70\1\0\3\70\1\176"+
    "\4\70\13\0\15\70\13\0\2\70\1\0\10\70\1\177"+
    "\12\0\15\70\13\0\2\125\1\0\10\125\1\0\5\125"+
    "\1\0\22\125\1\153\11\0\2\125\1\0\10\125\1\0"+
    "\5\125\1\0\7\125\1\200\12\125\1\153\3\0\1\154"+
    "\5\0\2\125\1\0\7\125\1\201\1\0\5\125\1\0"+
    "\20\125\1\202\1\125\1\153\3\0\1\154\5\0\2\125"+
    "\1\0\10\125\1\0\5\125\1\0\12\125\1\203\7\125"+
    "\1\153\3\0\1\154\5\0\2\125\1\0\10\125\1\0"+
    "\5\125\1\0\4\125\1\204\15\125\1\153\3\0\1\154"+
    "\5\0\2\161\1\0\10\161\1\0\5\161\1\0\22\161"+
    "\1\205\4\0\1\206\5\0\1\207\111\0\1\210\55\0"+
    "\1\211\24\0\1\212\51\0\2\171\1\0\10\171\13\0"+
    "\15\171\13\0\2\213\1\0\10\213\1\0\5\213\1\0"+
    "\22\213\12\0\2\70\1\0\10\70\13\0\13\70\1\214"+
    "\1\70\13\0\2\70\1\0\2\70\1\215\5\70\13\0"+
    "\15\70\13\0\2\70\1\0\10\70\13\0\3\70\1\216"+
    "\11\70\13\0\2\70\1\0\10\70\13\0\1\70\1\217"+
    "\13\70\13\0\1\220\2\0\10\220\13\0\15\220\13\0"+
    "\2\125\1\0\10\125\1\0\5\125\1\0\17\125\1\221"+
    "\2\125\1\153\3\0\1\154\5\0\2\125\1\0\10\125"+
    "\1\0\5\125\1\0\10\125\1\222\11\125\1\153\3\0"+
    "\1\154\5\0\2\125\1\0\2\125\1\223\5\125\1\0"+
    "\5\125\1\0\22\125\1\153\3\0\1\154\5\0\2\125"+
    "\1\0\3\125\1\224\4\125\1\0\5\125\1\0\22\125"+
    "\1\153\3\0\1\154\5\0\2\125\1\0\10\125\1\225"+
    "\5\125\1\0\22\125\1\153\3\0\1\154\5\0\2\161"+
    "\1\0\10\161\1\0\5\161\1\0\22\161\1\205\61\0"+
    "\1\226\15\0\1\227\55\0\1\230\45\0\2\213\1\0"+
    "\10\213\1\0\5\213\1\0\22\213\1\231\4\0\1\232"+
    "\4\0\2\70\1\0\3\70\1\233\4\70\13\0\15\70"+
    "\13\0\2\70\1\0\1\70\1\234\6\70\13\0\15\70"+
    "\13\0\2\70\1\0\1\70\1\235\6\70\13\0\15\70"+
    "\13\0\2\70\1\0\10\70\13\0\2\70\1\236\12\70"+
    "\13\0\2\220\1\0\10\220\13\0\15\220\13\0\2\125"+
    "\1\0\10\125\1\0\5\125\1\0\17\125\1\237\2\125"+
    "\1\153\3\0\1\154\5\0\2\125\1\0\2\125\1\240"+
    "\5\125\1\0\5\125\1\0\22\125\1\153\3\0\1\154"+
    "\5\0\2\125\1\0\10\125\1\0\5\125\1\0\7\125"+
    "\1\241\12\125\1\153\3\0\1\154\5\0\2\125\1\0"+
    "\10\125\1\0\5\125\1\0\5\125\1\242\14\125\1\153"+
    "\3\0\1\154\5\0\2\243\1\0\10\243\1\0\5\243"+
    "\1\0\22\243\5\0\1\244\16\0\1\245\55\0\1\246"+
    "\43\0\2\213\1\0\10\213\1\0\5\213\1\0\22\213"+
    "\1\231\11\0\2\70\1\0\1\70\1\247\6\70\13\0"+
    "\15\70\13\0\2\70\1\0\10\70\13\0\7\70\1\250"+
    "\5\70\13\0\2\70\1\0\3\70\1\251\4\70\13\0"+
    "\15\70\13\0\2\70\1\0\3\70\1\252\4\70\13\0"+
    "\15\70\13\0\2\125\1\0\3\125\1\253\4\125\1\0"+
    "\5\125\1\0\22\125\1\153\3\0\1\154\5\0\2\125"+
    "\1\0\1\125\1\254\6\125\1\0\5\125\1\0\22\125"+
    "\1\153\3\0\1\154\5\0\2\125\1\0\1\125\1\255"+
    "\6\125\1\0\5\125\1\0\22\125\1\153\3\0\1\154"+
    "\5\0\2\125\1\0\10\125\1\0\5\125\1\0\6\125"+
    "\1\256\13\125\1\153\3\0\1\154\5\0\2\243\1\0"+
    "\10\243\1\0\5\243\1\0\22\243\1\257\3\0\1\260"+
    "\5\0\2\261\1\0\10\261\1\0\5\261\1\0\22\261"+
    "\20\0\1\262\55\0\1\263\47\0\2\70\1\0\10\70"+
    "\1\264\12\0\15\70\13\0\2\70\1\0\3\70\1\265"+
    "\4\70\13\0\15\70\13\0\2\70\1\0\10\70\13\0"+
    "\2\70\1\266\12\70\13\0\2\70\1\0\10\70\13\0"+
    "\1\70\1\267\13\70\13\0\2\125\1\0\1\125\1\270"+
    "\6\125\1\0\5\125\1\0\22\125\1\153\3\0\1\154"+
    "\5\0\2\125\1\0\10\125\1\0\5\125\1\0\13\125"+
    "\1\271\6\125\1\153\3\0\1\154\5\0\2\125\1\0"+
    "\3\125\1\272\4\125\1\0\5\125\1\0\22\125\1\153"+
    "\3\0\1\154\5\0\2\125\1\0\3\125\1\273\4\125"+
    "\1\0\5\125\1\0\22\125\1\153\3\0\1\154\5\0"+
    "\2\243\1\0\10\243\1\0\5\243\1\0\22\243\1\257"+
    "\11\0\2\261\1\0\10\261\1\0\5\261\1\0\22\261"+
    "\1\274\4\0\1\275\4\0\1\276\2\0\10\276\13\0"+
    "\15\276\13\0\2\70\1\0\10\70\1\277\12\0\15\70"+
    "\13\0\2\70\1\0\10\70\1\300\12\0\15\70\13\0"+
    "\2\70\1\0\1\301\7\70\13\0\15\70\13\0\2\125"+
    "\1\0\10\125\1\302\5\125\1\0\22\125\1\153\3\0"+
    "\1\154\5\0\2\125\1\0\3\125\1\303\4\125\1\0"+
    "\5\125\1\0\22\125\1\153\3\0\1\154\5\0\2\125"+
    "\1\0\10\125\1\0\5\125\1\0\6\125\1\304\13\125"+
    "\1\153\3\0\1\154\5\0\2\125\1\0\10\125\1\0"+
    "\5\125\1\0\5\125\1\305\14\125\1\153\3\0\1\154"+
    "\5\0\2\261\1\0\10\261\1\0\5\261\1\0\22\261"+
    "\1\274\61\0\1\306\5\0\2\276\1\0\10\276\13\0"+
    "\15\276\13\0\1\307\2\0\10\307\13\0\15\307\13\0"+
    "\1\310\2\0\10\310\13\0\15\310\13\0\2\70\1\0"+
    "\10\70\1\311\12\0\15\70\13\0\2\312\1\0\10\312"+
    "\1\0\5\312\1\0\22\312\5\0\1\313\4\0\2\125"+
    "\1\0\10\125\1\314\5\125\1\0\22\125\1\153\3\0"+
    "\1\154\5\0\2\125\1\0\10\125\1\315\5\125\1\0"+
    "\22\125\1\153\3\0\1\154\5\0\2\125\1\0\1\316"+
    "\7\125\1\0\5\125\1\0\22\125\1\153\3\0\1\154"+
    "\5\0\2\307\1\0\10\307\13\0\15\307\13\0\2\310"+
    "\1\0\10\310\13\0\15\310\13\0\1\317\2\0\10\317"+
    "\13\0\15\317\13\0\2\312\1\0\10\312\1\0\5\312"+
    "\1\0\22\312\1\320\3\0\1\321\5\0\2\322\1\0"+
    "\10\322\1\0\5\322\1\0\22\322\12\0\2\323\1\0"+
    "\10\323\1\0\5\323\1\0\22\323\5\0\1\324\4\0"+
    "\2\325\1\0\10\325\1\0\5\325\1\0\22\325\5\0"+
    "\1\326\4\0\2\125\1\0\10\125\1\327\5\125\1\0"+
    "\22\125\1\153\3\0\1\154\5\0\2\317\1\0\10\317"+
    "\13\0\15\317\13\0\2\312\1\0\10\312\1\0\5\312"+
    "\1\0\22\312\1\320\11\0\2\322\1\0\10\322\1\0"+
    "\5\322\1\0\22\322\1\330\4\0\1\331\4\0\2\323"+
    "\1\0\10\323\1\0\5\323\1\0\22\323\1\332\3\0"+
    "\1\333\5\0\2\334\1\0\10\334\1\0\5\334\1\0"+
    "\22\334\12\0\2\325\1\0\10\325\1\0\5\325\1\0"+
    "\22\325\1\335\3\0\1\336\5\0\2\337\1\0\10\337"+
    "\1\0\5\337\1\0\22\337\12\0\2\340\1\0\10\340"+
    "\1\0\5\340\1\0\22\340\5\0\1\341\4\0\2\322"+
    "\1\0\10\322\1\0\5\322\1\0\22\322\1\330\61\0"+
    "\1\342\5\0\2\323\1\0\10\323\1\0\5\323\1\0"+
    "\22\323\1\332\11\0\2\334\1\0\10\334\1\0\5\334"+
    "\1\0\22\334\1\343\4\0\1\344\4\0\2\325\1\0"+
    "\10\325\1\0\5\325\1\0\22\325\1\335\11\0\2\337"+
    "\1\0\10\337\1\0\5\337\1\0\22\337\1\345\4\0"+
    "\1\346\4\0\2\340\1\0\10\340\1\0\5\340\1\0"+
    "\22\340\1\347\3\0\1\350\5\0\2\351\1\0\10\351"+
    "\1\0\5\351\1\0\22\351\12\0\2\334\1\0\10\334"+
    "\1\0\5\334\1\0\22\334\1\343\61\0\1\352\5\0"+
    "\2\337\1\0\10\337\1\0\5\337\1\0\22\337\1\345"+
    "\61\0\1\353\5\0\2\340\1\0\10\340\1\0\5\340"+
    "\1\0\22\340\1\347\11\0\2\351\1\0\10\351\1\0"+
    "\5\351\1\0\22\351\1\354\4\0\1\355\4\0\2\351"+
    "\1\0\10\351\1\0\5\351\1\0\22\351\1\354\61\0"+
    "\1\356\4\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[8832];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\11\11\1\1\11\4\1\4\11\5\1\1\11"+
    "\1\1\2\11\1\1\1\0\1\1\12\0\6\11\4\0"+
    "\1\11\1\0\5\1\1\0\2\11\7\0\2\11\1\0"+
    "\1\11\1\0\2\11\1\0\1\11\1\0\4\1\6\0"+
    "\1\1\2\11\6\0\1\11\1\0\5\1\1\0\1\11"+
    "\5\0\1\1\1\11\1\0\2\11\2\0\1\1\1\0"+
    "\4\1\10\0\1\11\2\0\1\11\1\0\5\1\5\0"+
    "\1\11\3\0\1\11\4\1\10\0\4\1\5\0\1\11"+
    "\1\0\2\11\1\0\3\1\6\0\1\1\2\0\1\1"+
    "\4\0\1\11\2\1\6\0\1\1\1\0\1\11\11\0"+
    "\1\11\2\0\1\11\3\0\1\11\5\0\1\11\1\0"+
    "\2\11\2\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[238];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true iff the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true iff the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
private static boolean debug = false;

public int yyline()
{
	return yyline + 1;
}

private int token;
private Object value;
private boolean eofProhibited = false;

/** move to next token
    @return false if positioned beyond tokens (EOF)
    @throws IOException on input error
*/
public boolean advance() throws 
	java.io.IOException, CommonErrorException
{
	token = yylex();
	if(debug) SDMSThread.doTrace(null, "Token : " + token + "\n", SDMSThread.SEVERITY_DEBUG);
	return (token != YYEOF);
}

private void proto(String s)
{
	if(debug) System.out.println(s + "( " + yytext() + " )");
}

/** classifies current token
    should not be called if advance() returned false
    @return current %token or single character
*/
public int token()
{
	return token;
}

/** associated with current token
    should not be called after advance() returned false.
    @return value for token();
*/
public Object value() 
{
	return value;
}


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ExprScanner(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 218) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + (((zzInput >= 0) && (zzInput < zzCMapL.length)) ? zzCMapL[zzInput] : 0) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return YYEOF;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { proto("CHAR ");		return yytext().charAt(0);
            } 
            // fall through
          case 58: break;
          case 2: 
            { proto("NUMBER ");	value = new BigDecimal(yytext());	return ExprParser.NUMBER;
            } 
            // fall through
          case 59: break;
          case 3: 
            { proto("WS "); break;
            } 
            // fall through
          case 60: break;
          case 4: 
            { proto("+ ");			return ExprParser.PLUS;
            } 
            // fall through
          case 61: break;
          case 5: 
            { proto("> ");			return ExprParser.GT;
            } 
            // fall through
          case 62: break;
          case 6: 
            { proto("< ");			return ExprParser.LT;
            } 
            // fall through
          case 63: break;
          case 7: 
            { proto("/ ");			return ExprParser.DIV;
            } 
            // fall through
          case 64: break;
          case 8: 
            { proto("- ");			return ExprParser.MINUS;
            } 
            // fall through
          case 65: break;
          case 9: 
            { proto("% ");			return ExprParser.MOD;
            } 
            // fall through
          case 66: break;
          case 10: 
            { proto("* ");			return ExprParser.TIMES;
            } 
            // fall through
          case 67: break;
          case 11: 
            { proto("DQSTRING_START ");	value = new String(); yybegin(DQSTRING); break;
            } 
            // fall through
          case 68: break;
          case 12: 
            { proto("CHAR ");		value = value + yytext(); break;
            } 
            // fall through
          case 69: break;
          case 13: 
            { proto("DQSTRING_END ");	yybegin(YYINITIAL); return ExprParser.STRING;
            } 
            // fall through
          case 70: break;
          case 14: 
            { proto("== ");			return ExprParser.EQ;
            } 
            // fall through
          case 71: break;
          case 15: 
            { proto("=~ ");			return ExprParser.MATCHES;
            } 
            // fall through
          case 72: break;
          case 16: 
            { proto(">= ");			return ExprParser.GE;
            } 
            // fall through
          case 73: break;
          case 17: 
            { proto("<= ");			return ExprParser.LE;
            } 
            // fall through
          case 74: break;
          case 18: 
            { proto("!= ");			return ExprParser.NE;
            } 
            // fall through
          case 75: break;
          case 19: 
            { proto("!~ ");			return ExprParser.NOMATCH;
            } 
            // fall through
          case 76: break;
          case 20: 
            { proto("OR ");			return ExprParser.OR;
            } 
            // fall through
          case 77: break;
          case 21: 
            { proto("PARAM ");
					value = (yytext().substring(1)).toUpperCase(); 
					return ExprParser.PARAMETER;
            } 
            // fall through
          case 78: break;
          case 22: 
            { proto("\\\" ");		value = value + "\""; break;
            } 
            // fall through
          case 79: break;
          case 23: 
            { proto("\\ ");			value = value + "\\"; break;
            } 
            // fall through
          case 80: break;
          case 24: 
            { proto("ABS ");		return ExprParser.ABS;
            } 
            // fall through
          case 81: break;
          case 25: 
            { proto("AND ");		return ExprParser.AND;
            } 
            // fall through
          case 82: break;
          case 26: 
            { proto("STR ");		return ExprParser.STR;
            } 
            // fall through
          case 83: break;
          case 27: 
            { proto("NOT ");		return ExprParser.NOT;
            } 
            // fall through
          case 84: break;
          case 28: 
            { proto("NVL ");		return ExprParser.NVL;
            } 
            // fall through
          case 85: break;
          case 29: 
            { proto("INT ");		return ExprParser.INT;
            } 
            // fall through
          case 86: break;
          case 30: 
            { proto("TRUE ");	value = Boolean.TRUE;	return ExprParser.BOOLEAN;
            } 
            // fall through
          case 87: break;
          case 31: 
            { proto("TRIM ");		return ExprParser.TRIM;
            } 
            // fall through
          case 88: break;
          case 32: 
            { proto("DATE ");		return ExprParser.DATE;
            } 
            // fall through
          case 89: break;
          case 33: 
            { proto("PARAM ");
					value = yytext().substring(2, yytext().length() - 1).toUpperCase(); 
					return ExprParser.PARAMETER;
            } 
            // fall through
          case 90: break;
          case 34: 
            { proto("ROUND ");		return ExprParser.ROUND;
            } 
            // fall through
          case 91: break;
          case 35: 
            { proto("FALSE ");	value = Boolean.FALSE;	return ExprParser.BOOLEAN;
            } 
            // fall through
          case 92: break;
          case 36: 
            { proto("FIELD ");		return ExprParser.FIELD;
            } 
            // fall through
          case 93: break;
          case 37: 
            { proto("PARAM ");
					value = (yytext().substring(4)).toUpperCase(); /* the name is after "job.", which has length 4 */
					return ExprParser.JPARAMETER;
            } 
            // fall through
          case 94: break;
          case 38: 
            { proto("SUBSTR ");		return ExprParser.SUBSTR;
            } 
            // fall through
          case 95: break;
          case 39: 
            { proto("PARAM ");
					value = (yytext().substring(5)).toUpperCase(); /* the name is after "job.", which has length 4 */
					return ExprParser.JPARAMETER;
            } 
            // fall through
          case 96: break;
          case 40: 
            { proto("PARAM ");
					value = yytext().substring(2+1, yytext().length() - 2); 
					return ExprParser.PARAMETER;
            } 
            // fall through
          case 97: break;
          case 41: 
            { proto("PARAM ");
					value = yytext().substring(4+1, yytext().length() - 1); 
					return ExprParser.JPARAMETER;
            } 
            // fall through
          case 98: break;
          case 42: 
            { proto("PARAM ");
					value = yytext().substring(2+4, yytext().length() - 1).toUpperCase(); 
					return ExprParser.JPARAMETER;
            } 
            // fall through
          case 99: break;
          case 43: 
            { proto("UPPERCASE ");		return ExprParser.UPPERCASE;
            } 
            // fall through
          case 100: break;
          case 44: 
            { proto("LOWERCASE ");		return ExprParser.LOWERCASE;
            } 
            // fall through
          case 101: break;
          case 45: 
            { proto("PARAM ");
					value = (yytext().substring(9)).toUpperCase(); 
					return ExprParser.TPARAMETER;
            } 
            // fall through
          case 102: break;
          case 46: 
            { proto("PARAM ");
					value = yytext().substring(2+4+1, yytext().length() - 2); 
					return ExprParser.JPARAMETER;
            } 
            // fall through
          case 103: break;
          case 47: 
            { proto("PARAM ");
					value = (yytext().substring(10)).toUpperCase(); 
					return ExprParser.RPARAMETER;
            } 
            // fall through
          case 104: break;
          case 48: 
            { proto("PARAM ");
					value = (yytext().substring(10)).toUpperCase(); 
					return ExprParser.RSPARAMETER;
            } 
            // fall through
          case 105: break;
          case 49: 
            { proto("PARAM ");
					value = (yytext().substring(11)).toUpperCase(); 
					return ExprParser.DSPARAMETER;
            } 
            // fall through
          case 106: break;
          case 50: 
            { proto("PARAM ");
					value = yytext().substring(2+8, yytext().length() - 1).toUpperCase(); 
					return ExprParser.TPARAMETER;
            } 
            // fall through
          case 107: break;
          case 51: 
            { proto("PARAM ");
					value = yytext().substring(2 + 9, yytext().length() - 1).toUpperCase(); 
					return ExprParser.RPARAMETER;
            } 
            // fall through
          case 108: break;
          case 52: 
            { proto("PARAM ");
					value = yytext().substring(2 + 9, yytext().length() - 1).toUpperCase(); 
					return ExprParser.RSPARAMETER;
            } 
            // fall through
          case 109: break;
          case 53: 
            { proto("PARAM ");
					value = yytext().substring(2+8+1, yytext().length() - 2); 
					return ExprParser.TPARAMETER;
            } 
            // fall through
          case 110: break;
          case 54: 
            { proto("PARAM ");
					value = yytext().substring(2 + 10, yytext().length() - 1).toUpperCase(); 
					return ExprParser.DSPARAMETER;
            } 
            // fall through
          case 111: break;
          case 55: 
            { proto("PARAM ");
					value = yytext().substring(2 + 9 + 1, yytext().length() - 2); 
					return ExprParser.RPARAMETER;
            } 
            // fall through
          case 112: break;
          case 56: 
            { proto("PARAM ");
					value = yytext().substring(2 + 9 + 1, yytext().length() - 2); 
					return ExprParser.RSPARAMETER;
            } 
            // fall through
          case 113: break;
          case 57: 
            { proto("PARAM ");
					value = yytext().substring(2 + 10 + 1, yytext().length() - 2); 
					return ExprParser.DSPARAMETER;
            } 
            // fall through
          case 114: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
