/*
Copyright (c) 2000-2013 "independIT Integrative Technologies GmbH",
Authors: Ronald Jeninga, Dieter Stubler

schedulix Enterprise Job Scheduling System

independIT Integrative Technologies GmbH [http://www.independit.de]
mailto:contact@independit.de

This file is part of schedulix

schedulix is free software:
you can redistribute it and/or modify it under the terms of the
GNU Affero General Public License as published by the
Free Software Foundation, either version 3 of the License,
or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

package de.independit.scheduler.server.repository;

import java.io.*;
import java.util.*;
import java.lang.*;
import java.sql.*;

import de.independit.scheduler.server.*;
import de.independit.scheduler.server.util.*;
import de.independit.scheduler.server.exception.*;

public class SDMSParameterDefinitionTable extends SDMSParameterDefinitionTableGeneric
{

	public SDMSParameterDefinitionTable(SystemEnvironment env)
	throws SDMSException
	{
		super(env);
	}

	public SDMSParameterDefinition create(SystemEnvironment env
	                                      ,Long p_seId
	                                      ,String p_name
	                                      ,Integer p_type
	                                      ,Integer p_aggFunction
	                                      ,String p_defaultValue
	                                      ,Boolean p_isLocal
	                                      ,Long p_linkPdId
	                                      ,String p_exportName
	                                     )
	throws SDMSException
	{
		SDMSParameterDefinition pd = super.create (env, p_seId, p_name, p_type, p_aggFunction, null, p_isLocal, p_linkPdId, p_exportName, false);
		pd.setDefaultValue(env, p_defaultValue);
		pd.checkRefCycle(env);
		return pd;
	}

}
